/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.target;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.ui.internal.target.NewLaunchTargetWizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class NewLaunchTargetWizardAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private String windowTitle = null;
    private IWorkbenchWindow workbenchWindow;

    public NewLaunchTargetWizardAction() {
        super(WorkbenchMessages.NewWizardAction_text);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setToolTipText(WorkbenchMessages.NewWizardAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.new_action_context");
    }

    public void setWizardWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        NewLaunchTargetWizard wizard = new NewLaunchTargetWizard();
        wizard.setWindowTitle(this.windowTitle);
        wizard.init(this.workbenchWindow.getWorkbench(), null);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        String settingsSection = ((Object)((Object)this)).getClass().getSimpleName();
        IDialogSettings wizardSettings = workbenchSettings.getSection(settingsSection);
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection(settingsSection);
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.workbenchWindow.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_wizard_context");
        dialog.open();
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }
}

