/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.process.Messages;
import org.eclipse.cdt.core.templateengine.process.Process;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class ConditionalProcessGroup {
    private TemplateCore template;
    private Set<String> macros;
    private String conditionString;
    private String lValue;
    private String rValue;
    private Operator operator;
    private List<Process> processes;
    private String id;

    public ConditionalProcessGroup(TemplateCore template, Element conditionElement, int id) {
        this.id = "Condition " + id;
        this.conditionString = conditionElement.getAttribute("condition");
        if (this.conditionString != null) {
            if (this.conditionString.trim().isEmpty()) {
                this.conditionString = null;
            } else {
                int op = this.conditionString.indexOf("==");
                if (op != -1) {
                    this.operator = Operator.EQUALS;
                    this.lValue = this.conditionString.substring(0, op);
                    this.rValue = this.conditionString.substring(op + "==".length());
                } else {
                    op = this.conditionString.indexOf("!=");
                    if (op != -1) {
                        this.operator = Operator.NOT_EQUALS;
                        this.lValue = this.conditionString.substring(0, op);
                        this.rValue = this.conditionString.substring(op + "!=".length());
                    }
                }
                this.collectMacros(this.lValue);
                this.collectMacros(this.rValue);
            }
        }
        this.createProcessObjects(template, TemplateEngine.getChildrenOfElementByTag(conditionElement, "process"));
    }

    private void collectMacros(String value) {
        if (value != null) {
            if (this.macros == null) {
                this.macros = new HashSet<String>();
            }
            this.macros.addAll(ProcessHelper.getReplaceKeys(value));
        }
    }

    public ConditionalProcessGroup(TemplateCore template, Element[] processElements) {
        this.id = "No Condition";
        this.createProcessObjects(template, Arrays.asList(processElements));
    }

    private void createProcessObjects(TemplateCore templateCore, List<Element> processElements) {
        this.template = templateCore;
        this.processes = new ArrayList<Process>(processElements.size());
        int j = 0;
        int l = processElements.size();
        while (j < l) {
            Element processElem = processElements.get(j);
            if (processElem.getNodeName().equals("process")) {
                String processId = String.valueOf(this.id) + "--> Process " + (j + 1) + " (" + processElem.getAttribute("type") + ")";
                this.processes.add(new Process(templateCore, processElem, processId));
            }
            ++j;
        }
    }

    public boolean isReadyToProcess() {
        return this.areMacrosForConditionEvaluationExpandable() && this.isConditionValueTrue() && this.areProcessesReady();
    }

    private boolean areProcessesReady() {
        for (Process process : this.processes) {
            if (process.isReadyToProcess()) continue;
            return false;
        }
        return true;
    }

    private boolean areMacrosForConditionEvaluationExpandable() {
        if (this.macros != null) {
            Map<String, String> valueStore = this.template.getValueStore();
            for (String value : this.macros) {
                if (valueStore.get(value) != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConditionValueTrue() {
        if (this.conditionString == null) {
            return true;
        }
        if (!this.areMacrosForConditionEvaluationExpandable()) {
            return false;
        }
        Map<String, String> valueStore = this.template.getValueStore();
        String processedLValue = ProcessHelper.getValueAfterExpandingMacros(this.lValue, this.macros, valueStore);
        String processedRValue = ProcessHelper.getValueAfterExpandingMacros(this.rValue, this.macros, valueStore);
        if (this.operator.equals(Operator.EQUALS)) {
            return processedLValue.equals(processedRValue);
        }
        if (this.operator.equals(Operator.NOT_EQUALS)) {
            return !processedLValue.equals(processedRValue);
        }
        return false;
    }

    public List<IStatus> process(IProgressMonitor monitor) throws ProcessFailureException {
        if (!this.areMacrosForConditionEvaluationExpandable()) {
            throw new ProcessFailureException(this.getUnexpandableMacroMessage());
        }
        if (!this.isConditionValueTrue()) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>(1);
            statuses.add((IStatus)new Status(4, "org.eclipse.cdt.core", 1, String.valueOf(Messages.getString("ConditionalProcessGroup.notExecuting")) + this.id, null));
            return statuses;
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>(this.processes.size());
        for (Process process : this.processes) {
            try {
                statuses.add(process.process(monitor));
            }
            catch (ProcessFailureException e) {
                throw new ProcessFailureException(e.getMessage(), e, statuses);
            }
        }
        return statuses;
    }

    private String getUnexpandableMacroMessage() {
        if (this.macros != null) {
            Map<String, String> valueStore = this.template.getValueStore();
            for (String value : this.macros) {
                if (valueStore.get(value) != null) continue;
                return String.valueOf(Messages.getString("ConditionalProcessGroup.unexpandableMacro")) + value;
            }
        }
        return null;
    }

    public Set<String> getMacros() {
        return this.macros;
    }

    public Set<String> getAllMacros() {
        HashSet<String> set = null;
        if (this.macros != null) {
            set = new HashSet<String>();
            set.addAll(this.macros);
        }
        for (Process process : this.processes) {
            Set<String> subSet = process.getMacros();
            if (subSet == null) continue;
            if (set == null) {
                set = new HashSet();
            }
            set.addAll(subSet);
        }
        return set;
    }

    private static class Operator {
        static final Operator EQUALS = new Operator("=");
        static final Operator NOT_EQUALS = new Operator("!=");
        String id;

        Operator(String id) {
            this.id = id;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof Operator) {
                return this.id.equals(((Operator)arg0).id);
            }
            return false;
        }
    }
}

