/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalUnaryTypeID
extends CPPDependentEvaluation {
    private final int fOperator;
    private final IType fOrigType;
    private IType fType;

    public EvalUnaryTypeID(int operator, IType type, IASTNode pointOfDefinition) {
        this(operator, type, EvalUnaryTypeID.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalUnaryTypeID(int operator, IType type, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fOrigType = type;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public IType getArgument() {
        return this.fOrigType;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fOperator == 3) {
            return CPPTemplates.isDependentType(this.fOrigType);
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        switch (this.fOperator) {
            case 22: {
                return true;
            }
            case 0: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                return CPPTemplates.isDependentType(this.fOrigType);
            }
            case 1: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return true;
    }

    @Override
    public IType getType(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        switch (this.fOperator) {
            case 0: 
            case 2: 
            case 22: {
                return CPPVisitor.get_SIZE_T(point);
            }
            case 1: {
                return CPPVisitor.get_type_info(point);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                return CPPBasicType.BOOLEAN;
            }
            case 3: {
                if (this.isTypeDependent()) {
                    return new TypeOfDependentExpression(this);
                }
                return this.fOrigType;
            }
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        return ValueFactory.evaluateUnaryTypeIdExpression(this.fOperator, this.fOrigType, point);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return this.fOperator == 1 ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)16);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalType(this.fOrigType);
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        IType arg = buffer.unmarshalType();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalUnaryTypeID(op, arg, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        IType type;
        if (this.fOperator == 22) {
            int packSize = this.determinePackSize(context.getParameterMap());
            if (packSize == -2 || packSize == Integer.MAX_VALUE) {
                return EvalFixed.INCOMPLETE;
            }
            if (packSize != -1) {
                IASTNode point = context.getPoint();
                return new EvalFixed(this.getType(point), this.getValueCategory(point), IntegralValue.create(packSize));
            }
        }
        if ((type = CPPTemplates.instantiateType(this.fOrigType, context)) == this.fOrigType) {
            return this;
        }
        return new EvalUnaryTypeID(this.fOperator, type, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fOrigType, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

