/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMIBackend2;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class GDBBackend
extends AbstractDsfService
implements IGDBBackend,
IMIBackend2 {
    private final ILaunchConfiguration fLaunchConfiguration;
    private SessionType fSessionType;
    private Boolean fAttach;
    private IMIBackend.State fBackendState = IMIBackend.State.NOT_INITIALIZED;
    private final String fBackendId;
    private static int fgInstanceCounter = 0;
    private MonitorJob fMonitorJob;
    private Process fProcess;
    private int fGDBExitValue;
    private int fGDBLaunchTimeout = 30;
    private MonitorInterruptJob fInterruptFailedJob;

    public GDBBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
        this.fBackendId = "gdb[" + Integer.toString(fgInstanceCounter++) + "]";
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBBackend.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getExecutor().execute((Runnable)this.getStartupSequence(requestMonitor));
    }

    protected Sequence getStartupSequence(RequestMonitor requestMonitor) {
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        return new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        this.getExecutor().execute((Runnable)this.getShutdownSequence(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                GDBBackend.super.shutdown(requestMonitor);
            }
        }));
    }

    protected Sequence getShutdownSequence(RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        return new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
    }

    protected GdbLaunch getGDBLaunch() {
        return (GdbLaunch)this.getSession().getModelAdapter(ILaunch.class);
    }

    protected IPath getGDBPath() {
        return this.getGDBLaunch().getGDBPath();
    }

    @Deprecated
    protected String[] getGDBCommandLineArray() {
        String cmd = String.valueOf(this.getGDBPath().toOSString()) + " --interpreter" + " mi2" + " --nx";
        return CommandLineUtil.argumentsToArray((String)cmd);
    }

    protected String[] getDebuggerCommandLine() {
        return this.getGDBCommandLineArray();
    }

    @Override
    public String getGDBInitFile() throws CoreException {
        return this.getGDBLaunch().getGDBInitFile();
    }

    @Override
    public IPath getGDBWorkingDirectory() throws CoreException {
        return this.getGDBLaunch().getGDBWorkingDirectory();
    }

    @Override
    public String getProgramArguments() throws CoreException {
        return this.getGDBLaunch().getProgramArguments();
    }

    @Override
    public IPath getProgramPath() {
        try {
            return new Path(this.getGDBLaunch().getProgramPath());
        }
        catch (CoreException e) {
            return new Path("");
        }
    }

    @Override
    public List<String> getSharedLibraryPaths() throws CoreException {
        return this.getGDBLaunch().getSharedLibraryPaths();
    }

    @Override
    public Properties getEnvironmentVariables() throws CoreException {
        return this.getGDBLaunch().getEnvironmentVariables();
    }

    @Override
    public boolean getClearEnvironment() throws CoreException {
        return this.getGDBLaunch().getClearEnvironment();
    }

    @Override
    public boolean getUpdateThreadListOnSuspend() throws CoreException {
        return this.getGDBLaunch().getUpdateThreadListOnSuspend();
    }

    protected Process launchGDBProcess() throws CoreException {
        return this.launchGDBProcess(this.getDebuggerCommandLine());
    }

    @Deprecated
    protected Process launchGDBProcess(String[] commandLine) throws CoreException {
        Process proc = null;
        try {
            proc = ProcessFactory.getFactory().exec(commandLine, this.getGDBLaunch().getLaunchEnvironment());
        }
        catch (IOException e) {
            String message = "Error while launching command: " + StringUtil.join((String[])commandLine, (String)" ");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, message, (Throwable)e));
        }
        return proc;
    }

    @Override
    public Process getProcess() {
        return this.fProcess;
    }

    @Override
    public OutputStream getMIOutputStream() {
        return this.fProcess.getOutputStream();
    }

    @Override
    public InputStream getMIInputStream() {
        return this.fProcess.getInputStream();
    }

    @Override
    public InputStream getMIErrorStream() {
        return this.fProcess.getErrorStream();
    }

    @Override
    public String getId() {
        return this.fBackendId;
    }

    @Override
    public void interrupt() {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            if (this.getSessionType() == SessionType.REMOTE) {
                gdbSpawner.interrupt();
            } else {
                gdbSpawner.interruptCTRLC();
            }
        }
    }

    @Override
    public void interruptAndWait(int timeout, RequestMonitor rm) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            if (this.getSessionType() == SessionType.REMOTE) {
                gdbSpawner.interrupt();
            } else {
                gdbSpawner.interruptCTRLC();
            }
            this.fInterruptFailedJob = new MonitorInterruptJob(timeout, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot interrupt.", null));
            rm.done();
        }
    }

    @Override
    public void interruptInferiorAndWait(long pid, int timeout, RequestMonitor rm) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.raise((int)pid, gdbSpawner.INT);
            this.fInterruptFailedJob = new MonitorInterruptJob(timeout, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot interrupt.", null));
            rm.done();
        }
    }

    @Override
    public void destroy() {
        if (this.getState() == IMIBackend.State.STARTED) {
            this.fProcess.destroy();
        }
    }

    @Override
    public IMIBackend.State getState() {
        return this.fBackendState;
    }

    @Override
    public int getExitCode() {
        return this.fGDBExitValue;
    }

    @Override
    public SessionType getSessionType() {
        if (this.fSessionType == null) {
            this.fSessionType = LaunchUtils.getSessionType(this.fLaunchConfiguration);
        }
        return this.fSessionType;
    }

    @Override
    public boolean getIsAttachSession() {
        if (this.fAttach == null) {
            this.fAttach = LaunchUtils.getIsAttach(this.fLaunchConfiguration);
        }
        return this.fAttach;
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    protected void doGDBProcessStep(final RequestMonitor requestMonitor) {
        class GDBLaunchMonitor {
            boolean fLaunched = false;
            boolean fTimedOut = false;

            GDBLaunchMonitor() {
            }
        }
        final GDBLaunchMonitor fGDBLaunchMonitor = new GDBLaunchMonitor();
        final RequestMonitor gdbLaunchRequestMonitor = new RequestMonitor((Executor)this.getExecutor(), requestMonitor){
            {
                super($anonymous0, $anonymous1);
            }

            protected void handleCompleted() {
                if (!fGDBLaunchMonitor.fTimedOut) {
                    fGDBLaunchMonitor.fLaunched = true;
                    if (!this.isSuccess()) {
                        requestMonitor.setStatus(this.getStatus());
                    }
                    requestMonitor.done();
                }
            }
        };
        final Job startGdbJob = new Job("Start GDB Process Job"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (gdbLaunchRequestMonitor.isCanceled()) {
                    gdbLaunchRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.cdt.dsf.gdb", -1, "Canceled starting GDB", null));
                    gdbLaunchRequestMonitor.done();
                    return Status.OK_STATUS;
                }
                try {
                    GDBBackend.this.fProcess = GDBBackend.this.launchGDBProcess();
                    GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBBackend.this.fBackendState = IMIBackend.State.STARTED;
                        }
                    });
                }
                catch (CoreException e) {
                    gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, e.getMessage(), (Throwable)e));
                    gdbLaunchRequestMonitor.done();
                    return Status.OK_STATUS;
                }
                BufferedReader inputReader = null;
                BufferedReader errorReader = null;
                boolean success = false;
                try {
                    String line;
                    InputStream inputStream = GDBBackend.this.getMIInputStream();
                    inputReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = inputReader.readLine()) != null) {
                        if (!(line = line.trim()).endsWith("(gdb)")) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        InputStream errorStream = GDBBackend.this.fProcess.getErrorStream();
                        errorReader = new BufferedReader(new InputStreamReader(errorStream));
                        String errorInfo = errorReader.readLine();
                        if (errorInfo == null) {
                            errorInfo = "GDB prompt not read";
                        }
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, errorInfo, null));
                    }
                }
                catch (IOException e) {
                    success = false;
                    gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Error reading GDB output", (Throwable)e));
                }
                if (!success) {
                    if (inputReader != null) {
                        try {
                            inputReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (errorReader != null) {
                        try {
                            errorReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                gdbLaunchRequestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        startGdbJob.schedule();
        this.getExecutor().schedule(new Runnable(){
            {
            }

            @Override
            public void run() {
                if (!fGDBLaunchMonitor.fLaunched) {
                    fGDBLaunchMonitor.fTimedOut = true;
                    Thread jobThread = startGdbJob.getThread();
                    if (jobThread != null) {
                        jobThread.interrupt();
                    }
                    GDBBackend.this.destroy();
                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5010, "Timed out trying to launch GDB.", null));
                    requestMonitor.done();
                }
            }
        }, (long)this.fGDBLaunchTimeout, TimeUnit.SECONDS);
    }

    protected void undoGDBProcessStep(final RequestMonitor requestMonitor) {
        if (this.getState() != IMIBackend.State.STARTED) {
            requestMonitor.done();
            return;
        }
        new Job("Terminating GDB process."){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBBackend.this.destroy();
                            if (((GDBBackend)(this).GDBBackend.this).fMonitorJob.fMonitorExited) {
                                GDBBackend.this.fBackendState = IMIBackend.State.TERMINATED;
                                GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.TERMINATED), GDBBackend.this.getProperties());
                            }
                        }
                    }).get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                int attempts = 0;
                while (attempts < 10) {
                    try {
                        GDBBackend.this.fGDBExitValue = GDBBackend.this.fProcess.exitValue();
                        requestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++attempts;
                    }
                }
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "GDB terminate failed", null));
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void doMonitorJobStep(final RequestMonitor requestMonitor) {
        this.fMonitorJob = new MonitorJob(this.fProcess, new DsfRunnable(){

            public void run() {
                requestMonitor.done();
            }
        });
        this.fMonitorJob.schedule();
    }

    protected void undoMonitorJobStep(RequestMonitor requestMonitor) {
        if (this.fMonitorJob != null) {
            this.fMonitorJob.kill();
        }
        requestMonitor.done();
    }

    protected void doRegisterStep(RequestMonitor requestMonitor) {
        this.register(new String[]{IMIBackend.class.getName(), IMIBackend2.class.getName(), IGDBBackend.class.getName()}, new Hashtable());
        this.getSession().addServiceEventListener((Object)this, null);
        this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(this.getSession().getId(), this.getId(), IMIBackend.State.STARTED), this.getProperties());
        requestMonitor.done();
    }

    protected void undoRegisterStep(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        requestMonitor.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        if (this.fInterruptFailedJob != null) {
            if (this.fInterruptFailedJob.cancel()) {
                this.fInterruptFailedJob.getRequestMonitor().done();
            }
            this.fInterruptFailedJob = null;
        }
    }

    protected class GDBProcessStep
    extends GDBControl.InitializationShutdownStep {
        GDBProcessStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            GDBBackend.this.doGDBProcessStep(requestMonitor);
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBBackend.this.undoGDBProcessStep(requestMonitor);
        }
    }

    protected class MonitorInterruptJob
    extends Job {
        private static final int TIMEOUT_DEFAULT_VALUE = 5000;
        private final RequestMonitor fRequestMonitor;

        public MonitorInterruptJob(int timeout, RequestMonitor rm) {
            super("Interrupt monitor job.");
            this.setSystem(true);
            this.fRequestMonitor = rm;
            if (timeout == 0 || timeout <= 0) {
                timeout = 5000;
            }
            this.schedule(timeout);
        }

        protected IStatus run(IProgressMonitor monitor) {
            GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    GDBBackend.this.fInterruptFailedJob = null;
                    MonitorInterruptJob.this.fRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Interrupt failed.", null));
                    MonitorInterruptJob.this.fRequestMonitor.done();
                }
            });
            return Status.OK_STATUS;
        }

        public RequestMonitor getRequestMonitor() {
            return this.fRequestMonitor;
        }
    }

    private class MonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fMonProcess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fMonProcess;
            synchronized (process) {
                GDBBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                try {
                    this.fMonProcess.waitFor();
                    GDBBackend.this.fGDBExitValue = this.fMonProcess.exitValue();
                    GDBBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBBackend.this.destroy();
                            GDBBackend.this.fBackendState = IMIBackend.State.TERMINATED;
                            GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.TERMINATED), GDBBackend.this.getProperties());
                        }
                    });
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                this.fMonitorExited = true;
            }
            return Status.OK_STATUS;
        }

        MonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB process monitor job.");
            this.fMonitorExited = false;
            this.fMonProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fMonProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class MonitorJobStep
    extends GDBControl.InitializationShutdownStep {
        MonitorJobStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            GDBBackend.this.doMonitorJobStep(requestMonitor);
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBBackend.this.undoMonitorJobStep(requestMonitor);
        }
    }

    protected class RegisterStep
    extends GDBControl.InitializationShutdownStep {
        RegisterStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            GDBBackend.this.doRegisterStep(requestMonitor);
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            GDBBackend.this.undoRegisterStep(requestMonitor);
        }
    }
}

