/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractDebugActionDelegate
implements IViewActionDelegate,
IActionDelegate2 {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection = StructuredSelection.EMPTY;
    private boolean fInitialized = false;
    private boolean fIsShift = false;

    public void dispose() {
        this.fSelection = null;
    }

    public void run(IAction action) {
        if (action.isEnabled()) {
            IStructuredSelection selection = this.getSelection();
            action.setEnabled(false);
            this.runInForeground(selection, false);
        }
    }

    private void runInForeground(final IStructuredSelection selection, boolean isShift) {
        this.fIsShift = isShift;
        final MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, this.getStatusMessage(), null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                for (Object element : selection) {
                    try {
                        if (!AbstractDebugActionDelegate.this.isEnabledFor(element)) continue;
                        AbstractDebugActionDelegate.this.doAction(element);
                    }
                    catch (DebugException e) {
                        status.merge(e.getStatus());
                    }
                }
            }
        });
        this.reportErrors(status);
    }

    private void reportErrors(MultiStatus ms) {
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.AbstractDebugActionDelegate_0, this.getErrorDialogMessage(), (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean wasInitialized = this.initialize(action, s);
        if (!wasInitialized && this.getView() != null) {
            this.update(action, s);
        }
    }

    protected void update(IAction action, ISelection s) {
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = this.getTargetSelection((IStructuredSelection)s);
            action.setEnabled(this.getEnableStateForSelection(ss));
            this.setSelection(ss);
        } else {
            action.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected IStructuredSelection getTargetSelection(IStructuredSelection s) {
        return s;
    }

    protected abstract void doAction(Object var1) throws DebugException;

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public void init(IViewPart view) {
        this.fViewPart = view;
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            this.setAction(action);
            this.update(action, selection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    private void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        for (Object element : selection) {
            if (this.isEnabledFor(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledFor(Object element) {
        return true;
    }

    protected boolean isShift() {
        return this.fIsShift;
    }

    public void runWithEvent(IAction action, Event event) {
        if (action.isEnabled()) {
            IStructuredSelection selection = this.getSelection();
            action.setEnabled(false);
            this.runInForeground(selection, (event.stateMask & 0x20000) > 0);
        }
    }

    public void init(IAction action) {
        this.fAction = action;
    }
}

