/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableExecution;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBreak;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecCase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecContinue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDefault;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.core.runtime.CoreException;

public class ExecSwitch
implements ICPPExecution {
    private final ICPPEvaluation controllerExprEval;
    private final ExecSimpleDeclaration controllerDeclExec;
    private final ICPPExecution[] bodyStmtExecutions;

    public ExecSwitch(ICPPEvaluation controllerExprEval, ExecSimpleDeclaration controllerDeclExec, ICPPExecution[] bodyStmtExecutions) {
        this.controllerExprEval = controllerExprEval;
        this.controllerDeclExec = controllerDeclExec;
        this.bodyStmtExecutions = bodyStmtExecutions;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        int caseIndex;
        int i = caseIndex = this.getMatchingCaseIndex(record, context);
        while (i < this.bodyStmtExecutions.length) {
            ICPPExecution stmtExec = this.bodyStmtExecutions[i];
            ICPPExecution result = EvalUtil.executeStatement(stmtExec, record, context);
            if (result instanceof ExecReturn || result instanceof ExecContinue) {
                return result;
            }
            if (result instanceof ExecBreak) break;
            ++i;
        }
        return null;
    }

    private int getMatchingCaseIndex(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        IValue controllerValue = null;
        if (this.controllerExprEval != null) {
            controllerValue = EvalUtil.getConditionExprValue(this.controllerExprEval, record, context);
        } else if (this.controllerDeclExec != null) {
            controllerValue = EvalUtil.getConditionDeclValue(this.controllerDeclExec, record, context);
        }
        int i = 0;
        while (i < this.bodyStmtExecutions.length) {
            if (this.isSatisfiedCaseStatement(this.bodyStmtExecutions[i], controllerValue, record, context)) {
                return i;
            }
            ++i;
        }
        return this.bodyStmtExecutions.length;
    }

    private boolean isSatisfiedCaseStatement(ICPPExecution stmtExec, IValue controllerValue, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (stmtExec instanceof ExecCase) {
            ExecCase caseStmtExec = (ExecCase)stmtExec;
            caseStmtExec = (ExecCase)caseStmtExec.executeForFunctionCall(record, context);
            Number caseVal = caseStmtExec.getCaseExpressionEvaluation().getValue(context.getPoint()).numberValue();
            Number controllerVal = controllerValue.numberValue();
            return caseVal != null && controllerVal != null && caseVal.equals(controllerVal);
        }
        return stmtExec instanceof ExecDefault;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation newControllerExprEval = this.controllerExprEval != null ? this.controllerExprEval.instantiate(context, maxDepth) : null;
        ExecSimpleDeclaration newControllerDeclExec = this.controllerDeclExec != null ? (ExecSimpleDeclaration)this.controllerDeclExec.instantiate(context, maxDepth) : null;
        ICPPExecution[] newBodyStmtExecutions = new ICPPExecution[this.bodyStmtExecutions.length];
        boolean executionsDidChange = false;
        int i = 0;
        while (i < this.bodyStmtExecutions.length) {
            ICPPExecution bodyStmtExec = this.bodyStmtExecutions[i];
            ICPPExecution newBodyStmtExec = bodyStmtExec.instantiate(context, maxDepth);
            if (newBodyStmtExec != bodyStmtExec) {
                executionsDidChange = true;
            }
            newBodyStmtExecutions[i] = newBodyStmtExec;
            ++i;
        }
        if (newControllerExprEval == this.controllerExprEval && newControllerDeclExec == this.controllerDeclExec && !executionsDidChange) {
            return this;
        }
        return new ExecSwitch(newControllerExprEval, newControllerDeclExec, newBodyStmtExecutions);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)16);
        buffer.marshalEvaluation(this.controllerExprEval, includeValue);
        buffer.marshalExecution(this.controllerDeclExec, includeValue);
        buffer.putInt(this.bodyStmtExecutions.length);
        ICPPExecution[] iCPPExecutionArray = this.bodyStmtExecutions;
        int n = this.bodyStmtExecutions.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPExecution execution = iCPPExecutionArray[n2];
            buffer.marshalExecution(execution, includeValue);
            ++n2;
        }
    }

    public static ISerializableExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation controllerExprEval = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ExecSimpleDeclaration controllerDeclExec = (ExecSimpleDeclaration)buffer.unmarshalExecution();
        int len = buffer.getInt();
        ICPPExecution[] bodyStmtExecutions = new ICPPExecution[len];
        int i = 0;
        while (i < bodyStmtExecutions.length) {
            bodyStmtExecutions[i] = (ICPPExecution)buffer.unmarshalExecution();
            ++i;
        }
        return new ExecSwitch(controllerExprEval, controllerDeclExec, bodyStmtExecutions);
    }
}

