/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.PatternProps;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NFRule;
import com.ibm.icu.text.RuleBasedNumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.LinkedList;

final class NFRuleSet {
    private final String name;
    private NFRule[] rules;
    final NFRule[] nonNumericalRules = new NFRule[6];
    LinkedList<NFRule> fractionRules;
    static final int NEGATIVE_RULE_INDEX = 0;
    static final int IMPROPER_FRACTION_RULE_INDEX = 1;
    static final int PROPER_FRACTION_RULE_INDEX = 2;
    static final int MASTER_RULE_INDEX = 3;
    static final int INFINITY_RULE_INDEX = 4;
    static final int NAN_RULE_INDEX = 5;
    final RuleBasedNumberFormat owner;
    private boolean isFractionRuleSet = false;
    private final boolean isParseable;
    private static final int RECURSION_LIMIT = 64;

    public NFRuleSet(RuleBasedNumberFormat owner, String[] descriptions, int index) throws IllegalArgumentException {
        this.owner = owner;
        String description = descriptions[index];
        if (description.length() == 0) {
            throw new IllegalArgumentException("Empty rule set description");
        }
        if (description.charAt(0) == '%') {
            int pos = description.indexOf(58);
            if (pos == -1) {
                throw new IllegalArgumentException("Rule set name doesn't end in colon");
            }
            String name = description.substring(0, pos);
            boolean bl = this.isParseable = !name.endsWith("@noparse");
            if (!this.isParseable) {
                name = name.substring(0, name.length() - 8);
            }
            this.name = name;
            while (pos < description.length() && PatternProps.isWhiteSpace(description.charAt(++pos))) {
            }
            descriptions[index] = description = description.substring(pos);
        } else {
            this.name = "%default";
            this.isParseable = true;
        }
        if (description.length() == 0) {
            throw new IllegalArgumentException("Empty rule set description");
        }
    }

    public void parseRules(String description) {
        int p;
        ArrayList<NFRule> tempRules = new ArrayList<NFRule>();
        NFRule predecessor = null;
        int oldP = 0;
        int descriptionLen = description.length();
        do {
            if ((p = description.indexOf(59, oldP)) < 0) {
                p = descriptionLen;
            }
            NFRule.makeRules(description.substring(oldP, p), this, predecessor, this.owner, tempRules);
            if (tempRules.isEmpty()) continue;
            predecessor = (NFRule)tempRules.get(tempRules.size() - 1);
        } while ((oldP = p + 1) < descriptionLen);
        long defaultBaseValue = 0L;
        for (NFRule rule : tempRules) {
            long baseValue = rule.getBaseValue();
            if (baseValue == 0L) {
                rule.setBaseValue(defaultBaseValue);
            } else {
                if (baseValue < defaultBaseValue) {
                    throw new IllegalArgumentException("Rules are not in order, base: " + baseValue + " < " + defaultBaseValue);
                }
                defaultBaseValue = baseValue;
            }
            if (this.isFractionRuleSet) continue;
            ++defaultBaseValue;
        }
        this.rules = new NFRule[tempRules.size()];
        tempRules.toArray(this.rules);
    }

    void setNonNumericalRule(NFRule rule) {
        long baseValue = rule.getBaseValue();
        if (baseValue == -1L) {
            this.nonNumericalRules[0] = rule;
        } else if (baseValue == -2L) {
            this.setBestFractionRule(1, rule, true);
        } else if (baseValue == -3L) {
            this.setBestFractionRule(2, rule, true);
        } else if (baseValue == -4L) {
            this.setBestFractionRule(3, rule, true);
        } else if (baseValue == -5L) {
            this.nonNumericalRules[4] = rule;
        } else if (baseValue == -6L) {
            this.nonNumericalRules[5] = rule;
        }
    }

    private void setBestFractionRule(int originalIndex, NFRule newRule, boolean rememberRule) {
        NFRule bestResult;
        if (rememberRule) {
            if (this.fractionRules == null) {
                this.fractionRules = new LinkedList();
            }
            this.fractionRules.add(newRule);
        }
        if ((bestResult = this.nonNumericalRules[originalIndex]) == null) {
            this.nonNumericalRules[originalIndex] = newRule;
        } else {
            DecimalFormatSymbols decimalFormatSymbols = this.owner.getDecimalFormatSymbols();
            if (decimalFormatSymbols.getDecimalSeparator() == newRule.getDecimalPoint()) {
                this.nonNumericalRules[originalIndex] = newRule;
            }
        }
    }

    public void makeIntoFractionRuleSet() {
        this.isFractionRuleSet = true;
    }

    public boolean equals(Object that) {
        if (!(that instanceof NFRuleSet)) {
            return false;
        }
        NFRuleSet that2 = (NFRuleSet)that;
        if (!this.name.equals(that2.name) || this.rules.length != that2.rules.length || this.isFractionRuleSet != that2.isFractionRuleSet) {
            return false;
        }
        int i = 0;
        while (i < this.nonNumericalRules.length) {
            if (!Utility.objectEquals(this.nonNumericalRules[i], that2.nonNumericalRules[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.rules.length) {
            if (!this.rules[i].equals(that2.rules[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        NFRule rule;
        StringBuilder result = new StringBuilder();
        result.append(this.name).append(":\n");
        NFRule[] nFRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            rule = nFRuleArray[n2];
            result.append(rule.toString()).append("\n");
            ++n2;
        }
        nFRuleArray = this.nonNumericalRules;
        n = this.nonNumericalRules.length;
        n2 = 0;
        while (n2 < n) {
            rule = nFRuleArray[n2];
            if (rule != null) {
                if (rule.getBaseValue() == -2L || rule.getBaseValue() == -3L || rule.getBaseValue() == -4L) {
                    for (NFRule fractionRule : this.fractionRules) {
                        if (fractionRule.getBaseValue() != rule.getBaseValue()) continue;
                        result.append(fractionRule.toString()).append("\n");
                    }
                } else {
                    result.append(rule.toString()).append("\n");
                }
            }
            ++n2;
        }
        return result.toString();
    }

    public boolean isFractionSet() {
        return this.isFractionRuleSet;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return !this.name.startsWith("%%");
    }

    public boolean isParseable() {
        return this.isParseable;
    }

    public void format(long number, StringBuffer toInsertInto, int pos, int recursionCount) {
        if (recursionCount >= 64) {
            throw new IllegalStateException("Recursion limit exceeded when applying ruleSet " + this.name);
        }
        NFRule applicableRule = this.findNormalRule(number);
        applicableRule.doFormat(number, toInsertInto, pos, ++recursionCount);
    }

    public void format(double number, StringBuffer toInsertInto, int pos, int recursionCount) {
        if (recursionCount >= 64) {
            throw new IllegalStateException("Recursion limit exceeded when applying ruleSet " + this.name);
        }
        NFRule applicableRule = this.findRule(number);
        applicableRule.doFormat(number, toInsertInto, pos, ++recursionCount);
    }

    NFRule findRule(double number) {
        if (this.isFractionRuleSet) {
            return this.findFractionRuleSetRule(number);
        }
        if (Double.isNaN(number)) {
            NFRule rule = this.nonNumericalRules[5];
            if (rule == null) {
                rule = this.owner.getDefaultNaNRule();
            }
            return rule;
        }
        if (number < 0.0) {
            if (this.nonNumericalRules[0] != null) {
                return this.nonNumericalRules[0];
            }
            number = -number;
        }
        if (Double.isInfinite(number)) {
            NFRule rule = this.nonNumericalRules[4];
            if (rule == null) {
                rule = this.owner.getDefaultInfinityRule();
            }
            return rule;
        }
        if (this.nonNumericalRules != null && number != Math.floor(number)) {
            if (number < 1.0 && this.nonNumericalRules[2] != null) {
                return this.nonNumericalRules[2];
            }
            if (this.nonNumericalRules[1] != null) {
                return this.nonNumericalRules[1];
            }
        }
        if (this.nonNumericalRules != null && this.nonNumericalRules[3] != null) {
            return this.nonNumericalRules[3];
        }
        return this.findNormalRule(Math.round(number));
    }

    private NFRule findNormalRule(long number) {
        if (this.isFractionRuleSet) {
            return this.findFractionRuleSetRule(number);
        }
        if (number < 0L) {
            if (this.nonNumericalRules[0] != null) {
                return this.nonNumericalRules[0];
            }
            number = -number;
        }
        int lo = 0;
        int hi = this.rules.length;
        if (hi > 0) {
            while (lo < hi) {
                int mid = lo + hi >>> 1;
                long ruleBaseValue = this.rules[mid].getBaseValue();
                if (ruleBaseValue == number) {
                    return this.rules[mid];
                }
                if (ruleBaseValue > number) {
                    hi = mid;
                    continue;
                }
                lo = mid + 1;
            }
            if (hi == 0) {
                throw new IllegalStateException("The rule set " + this.name + " cannot format the value " + number);
            }
            NFRule result = this.rules[hi - 1];
            if (result.shouldRollBack(number)) {
                if (hi == 1) {
                    throw new IllegalStateException("The rule set " + this.name + " cannot roll back from the rule '" + result + "'");
                }
                result = this.rules[hi - 2];
            }
            return result;
        }
        return this.nonNumericalRules[3];
    }

    private NFRule findFractionRuleSetRule(double number) {
        long leastCommonMultiple = this.rules[0].getBaseValue();
        int i = 1;
        while (i < this.rules.length) {
            leastCommonMultiple = NFRuleSet.lcm(leastCommonMultiple, this.rules[i].getBaseValue());
            ++i;
        }
        long numerator = Math.round(number * (double)leastCommonMultiple);
        long difference = Long.MAX_VALUE;
        int winner = 0;
        int i2 = 0;
        while (i2 < this.rules.length) {
            long tempDifference = numerator * this.rules[i2].getBaseValue() % leastCommonMultiple;
            if (leastCommonMultiple - tempDifference < tempDifference) {
                tempDifference = leastCommonMultiple - tempDifference;
            }
            if (tempDifference < difference) {
                difference = tempDifference;
                winner = i2;
                if (difference == 0L) break;
            }
            ++i2;
        }
        if (winner + 1 < this.rules.length && this.rules[winner + 1].getBaseValue() == this.rules[winner].getBaseValue() && (Math.round(number * (double)this.rules[winner].getBaseValue()) < 1L || Math.round(number * (double)this.rules[winner].getBaseValue()) >= 2L)) {
            ++winner;
        }
        return this.rules[winner];
    }

    /*
     * Unable to fully structure code
     */
    private static long lcm(long x, long y) {
        x1 = x;
        y1 = y;
        p2 = 0;
        while ((x1 & 1L) == 0L && (y1 & 1L) == 0L) {
            ++p2;
            x1 >>= 1;
            y1 >>= 1;
        }
        t = (x1 & 1L) == 1L ? -y1 : x1;
        ** GOTO lbl19
        {
            t >>= 1;
            do {
                if ((t & 1L) == 0L) continue block1;
                if (t > 0L) {
                    x1 = t;
                } else {
                    y1 = -t;
                }
                t = x1 - y1;
lbl19:
                // 2 sources

            } while (t != 0L);
        }
        gcd = x1 << p2;
        return x / gcd * y;
    }

    public Number parse(String text, ParsePosition parsePosition, double upperBound) {
        Number tempResult;
        ParsePosition highWaterMark = new ParsePosition(0);
        Number result = NFRule.ZERO;
        if (text.length() == 0) {
            return result;
        }
        NFRule[] nFRuleArray = this.nonNumericalRules;
        int n = this.nonNumericalRules.length;
        int n2 = 0;
        while (n2 < n) {
            NFRule fractionRule = nFRuleArray[n2];
            if (fractionRule != null) {
                tempResult = fractionRule.doParse(text, parsePosition, false, upperBound);
                if (parsePosition.getIndex() > highWaterMark.getIndex()) {
                    result = tempResult;
                    highWaterMark.setIndex(parsePosition.getIndex());
                }
                parsePosition.setIndex(0);
            }
            ++n2;
        }
        int i = this.rules.length - 1;
        while (i >= 0 && highWaterMark.getIndex() < text.length()) {
            if (this.isFractionRuleSet || !((double)this.rules[i].getBaseValue() >= upperBound)) {
                tempResult = this.rules[i].doParse(text, parsePosition, this.isFractionRuleSet, upperBound);
                if (parsePosition.getIndex() > highWaterMark.getIndex()) {
                    result = tempResult;
                    highWaterMark.setIndex(parsePosition.getIndex());
                }
                parsePosition.setIndex(0);
            }
            --i;
        }
        parsePosition.setIndex(highWaterMark.getIndex());
        return result;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        NFRule rule;
        NFRule[] nFRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            rule = nFRuleArray[n2];
            rule.setDecimalFormatSymbols(newSymbols);
            ++n2;
        }
        if (this.fractionRules != null) {
            int nonNumericalIdx = 1;
            while (nonNumericalIdx <= 3) {
                if (this.nonNumericalRules[nonNumericalIdx] != null) {
                    for (NFRule rule2 : this.fractionRules) {
                        if (this.nonNumericalRules[nonNumericalIdx].getBaseValue() != rule2.getBaseValue()) continue;
                        this.setBestFractionRule(nonNumericalIdx, rule2, false);
                    }
                }
                ++nonNumericalIdx;
            }
        }
        nFRuleArray = this.nonNumericalRules;
        n = this.nonNumericalRules.length;
        int n3 = 0;
        while (n3 < n) {
            rule = nFRuleArray[n3];
            if (rule != null) {
                rule.setDecimalFormatSymbols(newSymbols);
            }
            ++n3;
        }
    }
}

