/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluationOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;

public class CPPASTReturnStatement
extends CPPASTAttributeOwner
implements IASTReturnStatement,
ICPPExecutionOwner {
    private IASTInitializerClause retValue;

    public CPPASTReturnStatement() {
    }

    public CPPASTReturnStatement(IASTInitializerClause retValue) {
        this.setReturnArgument(retValue);
    }

    @Override
    public CPPASTReturnStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTReturnStatement copy(IASTNode.CopyStyle style) {
        CPPASTReturnStatement copy = new CPPASTReturnStatement(this.retValue == null ? null : this.retValue.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTInitializerClause getReturnArgument() {
        return this.retValue;
    }

    @Override
    public IASTExpression getReturnValue() {
        if (this.retValue instanceof IASTExpression) {
            return (IASTExpression)this.retValue;
        }
        return null;
    }

    @Override
    public void setReturnValue(IASTExpression returnValue) {
        this.setReturnArgument(returnValue);
    }

    @Override
    public void setReturnArgument(IASTInitializerClause arg) {
        this.assertNotFrozen();
        this.retValue = arg;
        if (arg != null) {
            arg.setParent(this);
            arg.setPropertyInParent(RETURNVALUE);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.retValue != null && !this.retValue.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.retValue) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.retValue = (IASTInitializerClause)other;
            return;
        }
        super.replace(child, other);
    }

    @Override
    public ICPPExecution getExecution() {
        if (this.retValue instanceof ICPPEvaluationOwner) {
            ICPPEvaluationOwner evalOwner = (ICPPEvaluationOwner)((Object)this.retValue);
            return new ExecReturn(evalOwner.getEvaluation());
        }
        return ExecIncomplete.INSTANCE;
    }
}

