/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.debuggerconsole;

import java.util.ArrayList;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.DebuggerConsoleView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.progress.WorkbenchJob;

public class DebuggerConsoleManager
implements IDebuggerConsoleManager {
    private ArrayList<IDebuggerConsole> fConsoleList = new ArrayList();
    private ListenerList<IConsoleListener> fConsoleListeners = new ListenerList();
    private OpenDebuggerConsoleViewJob fOpenDebuggerConsoleViewJob = new OpenDebuggerConsoleViewJob();
    private ShowDebuggerConsoleViewJob fShowDebuggerConsoleViewJob = new ShowDebuggerConsoleViewJob();

    @Override
    public void addConsoleListener(IConsoleListener listener) {
        this.fConsoleListeners.add((Object)listener);
    }

    @Override
    public void removeConsoleListener(IConsoleListener listener) {
        this.fConsoleListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDebuggerConsole[] getConsoles() {
        ArrayList<IDebuggerConsole> arrayList = this.fConsoleList;
        synchronized (arrayList) {
            return this.fConsoleList.toArray(new IDebuggerConsole[this.fConsoleList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsole(IDebuggerConsole console) {
        ArrayList<IDebuggerConsole> arrayList = this.fConsoleList;
        synchronized (arrayList) {
            this.fConsoleList.add(console);
        }
        for (IConsoleListener listener : this.fConsoleListeners) {
            listener.consolesAdded(new IConsole[]{console});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsole(IDebuggerConsole console) {
        ArrayList<IDebuggerConsole> arrayList = this.fConsoleList;
        synchronized (arrayList) {
            this.fConsoleList.remove(console);
        }
        for (IConsoleListener listener : this.fConsoleListeners) {
            listener.consolesRemoved(new IConsole[]{console});
        }
    }

    @Override
    public void showConsoleView() {
        this.fShowDebuggerConsoleViewJob.schedule(100L);
    }

    @Override
    public void openConsoleView() {
        this.fOpenDebuggerConsoleViewJob.schedule(100L);
    }

    private class OpenDebuggerConsoleViewJob
    extends WorkbenchJob {
        OpenDebuggerConsoleViewJob() {
            super("Open GDB Console View");
            this.setSystem(true);
            this.setPriority(20);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IViewPart view;
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (!(window == null || (page = window.getActivePage()) == null || (view = page.findView("org.eclipse.cdt.debug.ui.debuggerConsoleView")) != null && page.isPartVisible((IWorkbenchPart)view))) {
                try {
                    page.showView("org.eclipse.cdt.debug.ui.debuggerConsoleView", null, 3);
                }
                catch (PartInitException e) {
                    CDebugUIPlugin.log(e);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class ShowDebuggerConsoleViewJob
    extends WorkbenchJob {
        ShowDebuggerConsoleViewJob() {
            super("Show GDB Console View");
            this.setSystem(true);
            this.setPriority(20);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                DebuggerConsoleView consoleView;
                boolean consoleVisible;
                boolean consoleFound = false;
                IViewPart view = page.findView("org.eclipse.cdt.debug.ui.debuggerConsoleView");
                if (view != null && (consoleVisible = page.isPartVisible((IWorkbenchPart)(consoleView = (DebuggerConsoleView)view)))) {
                    consoleFound = true;
                    page.bringToTop((IWorkbenchPart)consoleView);
                }
                if (!consoleFound) {
                    try {
                        consoleView = (DebuggerConsoleView)page.showView("org.eclipse.cdt.debug.ui.debuggerConsoleView", null, 3);
                        page.bringToTop((IWorkbenchPart)consoleView);
                    }
                    catch (PartInitException e) {
                        CDebugUIPlugin.log(e);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

