/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal.target;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.target.LaunchTargetWorkingCopy;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LaunchTarget
extends PlatformObject
implements ILaunchTarget {
    private final String typeId;
    private final String id;
    final Preferences attributes;

    public LaunchTarget(String typeId, String id) {
        this.typeId = typeId;
        this.id = id;
        this.attributes = null;
    }

    public LaunchTarget(String typeId, String id, Preferences attributes) {
        if (typeId == null || id == null || attributes == null) {
            throw new NullPointerException();
        }
        this.typeId = typeId;
        this.id = id;
        this.attributes = attributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public ILaunchTargetWorkingCopy getWorkingCopy() {
        return new LaunchTargetWorkingCopy(this);
    }

    @Override
    public String getAttribute(String key, String defValue) {
        if (this.attributes != null) {
            return this.attributes.get(key, defValue);
        }
        return defValue;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            String[] stringArray = this.attributes.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = this.attributes.get(key, null);
                if (value != null) {
                    attrs.put(key, value);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
        return attrs;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.typeId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchTarget other = (LaunchTarget)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.typeId.equals(other.typeId);
    }
}

