/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluationOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecFor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;

public class CPPASTForStatement
extends CPPASTAttributeOwner
implements ICPPASTForStatement,
ICPPExecutionOwner {
    private IScope fScope;
    private IASTStatement fInit;
    private IASTExpression fCondition;
    private IASTDeclaration fCondDeclaration;
    private IASTExpression fIterationExpression;
    private IASTStatement fBody;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTForStatement() {
    }

    public CPPASTForStatement(IASTStatement init, IASTDeclaration condDeclaration, IASTExpression iterationExpression, IASTStatement body) {
        this.setInitializerStatement(init);
        this.setConditionDeclaration(condDeclaration);
        this.setIterationExpression(iterationExpression);
        this.setBody(body);
    }

    public CPPASTForStatement(IASTStatement init, IASTExpression condition, IASTExpression iterationExpression, IASTStatement body) {
        this.setInitializerStatement(init);
        this.setConditionExpression(condition);
        this.setIterationExpression(iterationExpression);
        this.setBody(body);
    }

    @Override
    public CPPASTForStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTForStatement copy(IASTNode.CopyStyle style) {
        CPPASTForStatement copy = new CPPASTForStatement();
        copy.setInitializerStatement(this.fInit == null ? null : this.fInit.copy(style));
        copy.setConditionDeclaration(this.fCondDeclaration == null ? null : this.fCondDeclaration.copy(style));
        copy.setConditionExpression(this.fCondition == null ? null : this.fCondition.copy(style));
        copy.setIterationExpression(this.fIterationExpression == null ? null : this.fIterationExpression.copy(style));
        copy.setBody(this.fBody == null ? null : this.fBody.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getConditionExpression() {
        return this.fCondition;
    }

    @Override
    public void setConditionExpression(IASTExpression condition) {
        this.assertNotFrozen();
        this.fCondition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
            this.fCondDeclaration = null;
        }
    }

    @Override
    public IASTExpression getIterationExpression() {
        return this.fIterationExpression;
    }

    @Override
    public void setIterationExpression(IASTExpression iterator) {
        this.assertNotFrozen();
        this.fIterationExpression = iterator;
        if (iterator != null) {
            iterator.setParent(this);
            iterator.setPropertyInParent(ITERATION);
        }
    }

    @Override
    public IASTStatement getBody() {
        return this.fBody;
    }

    @Override
    public void setBody(IASTStatement statement) {
        this.assertNotFrozen();
        this.fBody = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(BODY);
        }
    }

    @Override
    public IScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CPPBlockScope(this);
        }
        return this.fScope;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getLocalVariablesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.fInit != null && !this.fInit.accept(action)) {
            return false;
        }
        if (this.fCondition != null && !this.fCondition.accept(action)) {
            return false;
        }
        if (this.fCondDeclaration != null && !this.fCondDeclaration.accept(action)) {
            return false;
        }
        if (this.fIterationExpression != null && !this.fIterationExpression.accept(action)) {
            return false;
        }
        if (this.fBody != null && !this.fBody.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTForStatement.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.fBody == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fBody = (IASTStatement)other;
            return;
        }
        if (child == this.fCondition || child == this.fCondDeclaration) {
            if (other instanceof IASTExpression) {
                this.setConditionExpression((IASTExpression)other);
            } else if (other instanceof IASTDeclaration) {
                this.setConditionDeclaration((IASTDeclaration)other);
            }
            return;
        }
        if (child == this.fIterationExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fIterationExpression = (IASTExpression)other;
            return;
        }
        if (child == this.fInit) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fInit = (IASTStatement)other;
            return;
        }
        super.replace(child, other);
    }

    @Override
    public IASTStatement getInitializerStatement() {
        return this.fInit;
    }

    @Override
    public void setInitializerStatement(IASTStatement statement) {
        this.assertNotFrozen();
        this.fInit = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public void setConditionDeclaration(IASTDeclaration d) {
        this.assertNotFrozen();
        this.fCondDeclaration = d;
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(CONDITION_DECLARATION);
            this.fCondition = null;
        }
    }

    @Override
    public IASTDeclaration getConditionDeclaration() {
        return this.fCondDeclaration;
    }

    @Override
    public ICPPExecution getExecution() {
        ICPPExecution initializerExec = EvalUtil.getExecutionFromStatement(this.getInitializerStatement());
        ICPPEvaluationOwner conditionExpr = (ICPPEvaluationOwner)((Object)this.getConditionExpression());
        ICPPExecutionOwner conditionDecl = (ICPPExecutionOwner)((Object)this.getConditionDeclaration());
        ICPPEvaluation conditionExprEval = conditionExpr != null ? conditionExpr.getEvaluation() : null;
        ExecSimpleDeclaration conditionDeclExec = conditionDecl != null ? (ExecSimpleDeclaration)conditionDecl.getExecution() : null;
        ICPPEvaluationOwner iterationExpr = (ICPPEvaluationOwner)((Object)this.getIterationExpression());
        ICPPEvaluation iterationEval = iterationExpr != null ? iterationExpr.getEvaluation() : null;
        ICPPExecution bodyExec = EvalUtil.getExecutionFromStatement(this.getBody());
        return new ExecFor(initializerExec, conditionExprEval, conditionDeclExec, iterationEval, bodyExec);
    }
}

