/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.build;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.HierarchicalProperties;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.cdt.arduino.core.internal.board.ToolDependency;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.osgi.framework.Bundle;

public class ArduinoBuildConfiguration
extends CBuildConfiguration
implements TemplateLoader,
IRemoteConnectionChangeListener {
    private static final ArduinoManager manager = Activator.getService(ArduinoManager.class);
    private static final boolean isWindows = Platform.getOS().equals("win32");
    private final ArduinoRemoteConnection target;
    private final String launchMode;
    private ArduinoBoard defaultBoard;
    private Properties boardProperties;
    private Configuration templateConfig;
    private String[] cachedIncludePath;
    private String cachedInfoCommand;
    private IScannerInfo cachedScannerInfo;

    ArduinoBuildConfiguration(IBuildConfiguration config, String name, String launchMode, ArduinoBoard defaultBoard, IToolChain toolChain) throws CoreException {
        super(config, ".default", toolChain);
        this.target = null;
        this.launchMode = launchMode;
        this.defaultBoard = defaultBoard;
    }

    ArduinoBuildConfiguration(IBuildConfiguration config, String name, String launchMode, ArduinoRemoteConnection target, IToolChain toolChain) throws CoreException {
        super(config, name, toolChain);
        this.target = target;
        this.launchMode = launchMode;
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        remoteManager.addRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    public synchronized void connectionChanged(RemoteConnectionChangeEvent event) {
        if (event.getConnection().equals(this.target.getRemoteConnection())) {
            this.boardProperties = null;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(ArduinoBuildConfiguration.class)) {
            return (T)((Object)this);
        }
        return (T)super.getAdapter(adapter);
    }

    public String getLaunchMode() {
        return this.launchMode;
    }

    public ArduinoRemoteConnection getTarget() {
        return this.target;
    }

    public ArduinoBoard getBoard() throws CoreException {
        if (this.target != null) {
            return this.target.getBoard();
        }
        return this.defaultBoard;
    }

    private synchronized Properties getBoardProperties() throws CoreException {
        if (this.boardProperties == null) {
            Object superPlatform;
            String[] segments;
            String core;
            ArduinoBoard board = this.getBoard();
            ArduinoPlatform platform = board.getPlatform();
            this.boardProperties = new Properties();
            this.boardProperties.put("runtime.platform.path", platform.getInstallPath().toString());
            this.boardProperties.put("runtime.ide.version", "10608");
            this.boardProperties.put("software", "ARDUINO");
            this.boardProperties.put("build.arch", platform.getArchitecture().toUpperCase());
            this.boardProperties.put("build.path", ".");
            this.boardProperties.put("build.core.path", platform.getInstallPath().resolve("cores").resolve("{build.core}").toString());
            this.boardProperties.put("build.system.path", platform.getInstallPath().resolve("system").toString());
            this.boardProperties.put("build.variant.path", platform.getInstallPath().resolve("variants").resolve("{build.variant}").toString());
            ArduinoPackage arduinoPackage = manager.getPackage("arduino");
            if (arduinoPackage != null) {
                for (ArduinoTool tool : arduinoPackage.getLatestTools()) {
                    this.boardProperties.put("runtime.tools." + tool.getName() + ".path", tool.getInstallPath().toString());
                }
                for (ArduinoTool tool : arduinoPackage.getTools()) {
                    this.boardProperties.put("runtime.tools." + tool.getName() + '-' + tool.getVersion() + ".path", tool.getInstallPath().toString());
                }
            }
            if ((core = board.getBoardProperties().getProperty("build.core")).contains(":") && (segments = core.split(":")).length == 2 && (superPlatform = manager.getInstalledPlatform(segments[0], platform.getArchitecture())) != null) {
                this.boardProperties.putAll((Map<?, ?>)((ArduinoPlatform)superPlatform).getPlatformProperties());
            }
            this.boardProperties.putAll((Map<?, ?>)platform.getPlatformProperties());
            for (ToolDependency toolDep : platform.getToolsDependencies()) {
                this.boardProperties.putAll((Map<?, ?>)toolDep.getTool().getToolProperties());
            }
            this.boardProperties.putAll((Map<?, ?>)board.getBoardProperties());
            HierarchicalProperties menus = board.getMenus();
            if (menus != null) {
                for (Map.Entry<String, HierarchicalProperties> menuEntry : menus.getChildren().entrySet()) {
                    Iterator<HierarchicalProperties> i;
                    String key = menuEntry.getKey();
                    String value = this.target.getMenuValue(key);
                    if ((value == null || value.isEmpty()) && (i = menuEntry.getValue().getChildren().values().iterator()).hasNext()) {
                        HierarchicalProperties first = i.next();
                        value = first.getValue();
                    }
                    if (value == null || value.isEmpty()) continue;
                    this.boardProperties.putAll((Map<?, ?>)board.getMenuProperties(key, value));
                }
            }
        }
        this.boardProperties.put("build.project_name", this.getProject().getName());
        return this.boardProperties;
    }

    public Map<String, Object> getBuildModel() throws CoreException {
        String[] segments;
        IProject project = this.getProject();
        ArduinoBoard board = this.getBoard();
        ArduinoPlatform platform = board.getPlatform();
        Properties properties = new Properties();
        HashMap<String, Object> buildModel = new HashMap<String, Object>();
        buildModel.put("boardId", board.getId());
        properties.put("object_file", "$@");
        properties.put("source_file", "$<");
        final java.nio.file.Path projectPath = new File(project.getLocationURI()).toPath();
        final ArrayList sourceFiles = new ArrayList();
        ISourceRoot[] iSourceRootArray = CCorePlugin.getDefault().getCoreModel().create(project).getSourceRoots();
        int n = iSourceRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRoot sourceRoot = iSourceRootArray[n2];
            sourceRoot.getResource().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && ArduinoBuildConfiguration.isSource(proxy.getName())) {
                        java.nio.file.Path sourcePath = new File(proxy.requestResource().getLocationURI()).toPath();
                        sourceFiles.add(ArduinoBuildConfiguration.pathString(projectPath.relativize(sourcePath)));
                    }
                    return true;
                }
            }, 0);
            ++n2;
        }
        buildModel.put("project_srcs", sourceFiles);
        ArrayList<String> librarySources = new ArrayList<String>();
        for (ArduinoLibrary lib : manager.getLibraries(project)) {
            librarySources.addAll(lib.getSources());
        }
        buildModel.put("libraries_srcs", librarySources);
        buildModel.put("libraries_path", ArduinoBuildConfiguration.pathString(ArduinoPreferences.getArduinoHome().resolve("libraries")));
        properties.putAll((Map<?, ?>)this.getBoardProperties());
        buildModel.put("build_path", properties.get("build.path"));
        buildModel.put("project_name", project.getName());
        String includes = null;
        for (java.nio.file.Path include : this.getIncludePath(platform, properties)) {
            includes = includes == null ? "-I" : String.valueOf(includes) + " -I";
            includes = String.valueOf(includes) + '\"' + ArduinoBuildConfiguration.pathString(include) + '\"';
        }
        for (ArduinoLibrary lib : manager.getLibraries(project)) {
            for (java.nio.file.Path include : lib.getIncludePath()) {
                includes = String.valueOf(includes) + " -I\"" + ArduinoBuildConfiguration.pathString(include) + '\"';
            }
        }
        properties.put("includes", includes);
        buildModel.put("recipe_cpp_o_pattern_plat", this.resolveProperty("recipe.cpp.o.pattern", properties));
        buildModel.put("recipe_c_o_pattern_plat", this.resolveProperty("recipe.c.o.pattern", properties));
        buildModel.put("recipe_S_o_pattern_plat", this.resolveProperty("recipe.S.o.pattern", properties));
        ArduinoPlatform corePlatform = platform;
        String core = properties.getProperty("build.core");
        if (core.contains(":") && (segments = core.split(":")).length == 2) {
            corePlatform = manager.getInstalledPlatform(segments[0], platform.getArchitecture());
            core = segments[1];
        }
        buildModel.put("platform_path", ArduinoBuildConfiguration.pathString(corePlatform.getInstallPath()));
        java.nio.file.Path corePath = corePlatform.getInstallPath().resolve("cores").resolve(core);
        buildModel.put("platform_core_path", ArduinoBuildConfiguration.pathString(corePath));
        ArrayList<String> coreSources = new ArrayList<String>();
        ArduinoBuildConfiguration.getSources(coreSources, corePath, true);
        buildModel.put("platform_core_srcs", coreSources);
        ArrayList<String> variantSources = new ArrayList<String>();
        String variant = properties.getProperty("build.variant");
        if (variant != null) {
            String[] segments2;
            ArduinoPlatform variantPlatform = platform;
            if (variant.contains(":") && (segments2 = variant.split(":")).length == 2) {
                variantPlatform = manager.getInstalledPlatform(segments2[0], platform.getArchitecture());
                variant = segments2[1];
            }
            java.nio.file.Path variantPath = variantPlatform.getInstallPath().resolve("variants").resolve(variant);
            buildModel.put("platform_variant_path", ArduinoBuildConfiguration.pathString(variantPath));
            ArduinoBuildConfiguration.getSources(variantSources, variantPath, true);
        }
        buildModel.put("platform_variant_srcs", variantSources);
        properties.put("archive_file", "core.a");
        properties.put("archive_file_path", "{build.path}/{archive_file}");
        properties.put("object_files", "$(PROJECT_OBJS) $(LIBRARIES_OBJS)");
        buildModel.put("recipe_cpp_o_pattern", this.resolveProperty("recipe.cpp.o.pattern", properties));
        buildModel.put("recipe_c_o_pattern", this.resolveProperty("recipe.c.o.pattern", properties));
        buildModel.put("recipe_S_o_pattern", this.resolveProperty("recipe.S.o.pattern", properties));
        buildModel.put("recipe_ar_pattern", this.resolveProperty("recipe.ar.pattern", properties));
        buildModel.put("recipe_c_combine_pattern", this.resolveProperty("recipe.c.combine.pattern", properties));
        buildModel.put("recipe_objcopy_eep_pattern", this.resolveProperty("recipe.objcopy.eep.pattern", properties));
        buildModel.put("recipe_objcopy_hex_pattern", this.resolveProperty("recipe.objcopy.hex.pattern", properties));
        buildModel.put("recipe_objcopy_bin_pattern", this.resolveProperty("recipe.objcopy.bin.pattern", properties));
        buildModel.put("recipe_size_pattern", this.resolveProperty("recipe.size.pattern", properties));
        return buildModel;
    }

    private static void getSources(Collection<String> sources, java.nio.file.Path dir, boolean recurse) {
        File[] fileArray = dir.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (recurse) {
                    ArduinoBuildConfiguration.getSources(sources, file.toPath(), recurse);
                }
            } else if (ArduinoBuildConfiguration.isSource(file.getName())) {
                sources.add(ArduinoBuildConfiguration.pathString(file.toPath()));
            }
            ++n2;
        }
    }

    public IFile generateMakeFile(IProgressMonitor monitor) throws CoreException {
        IFolder buildFolder = (IFolder)this.getBuildContainer();
        if (!buildFolder.exists()) {
            buildFolder.create(true, true, monitor);
        }
        IFile makefile = buildFolder.getFile("Makefile");
        Map<String, Object> buildModel = this.getBuildModel();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (StringWriter writer = new StringWriter();){
                if (this.templateConfig == null) {
                    this.templateConfig = new Configuration(Configuration.VERSION_2_3_22);
                    this.templateConfig.setTemplateLoader((TemplateLoader)this);
                }
                Template template = this.templateConfig.getTemplate("templates/Makefile");
                template.process(buildModel, (Writer)writer);
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8));){
                    ArduinoBuildConfiguration.createParent((IResource)makefile, monitor);
                    if (makefile.exists()) {
                        makefile.setContents((InputStream)in, true, true, monitor);
                    } else {
                        makefile.create((InputStream)in, true, monitor);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Error generating makefile", e));
        }
        return makefile;
    }

    protected static void createParent(IResource child, IProgressMonitor monitor) throws CoreException {
        if (child == null) {
            return;
        }
        IContainer container = child.getParent();
        if (container.exists()) {
            return;
        }
        IFolder parent = (IFolder)container.getAdapter(IFolder.class);
        ArduinoBuildConfiguration.createParent((IResource)parent, monitor);
        parent.create(true, true, monitor);
    }

    public static boolean isSource(String filename) {
        String ext;
        int i = filename.lastIndexOf(46);
        switch (ext = filename.substring(i + 1)) {
            case "S": 
            case "c": 
            case "cpp": {
                return true;
            }
        }
        return false;
    }

    private String resolvePropertyValue(String value, Properties dict) throws CoreException {
        String last;
        do {
            last = value;
            int i = value.indexOf(123);
            while (i >= 0) {
                if (value.charAt(++i) == '{') {
                    ++i;
                } else {
                    int n = value.indexOf(125, i);
                    if (n >= 0) {
                        String p2 = value.substring(i, n);
                        String r2 = dict.getProperty(p2);
                        if (r2 != null) {
                            value = value.replace(String.valueOf('{') + p2 + '}', r2);
                        } else {
                            throw Activator.coreException(String.format("Undefined key %s", p2), null);
                        }
                    }
                    i = n;
                }
                i = value.indexOf(123, i);
            }
        } while (!value.equals(last));
        return value.replace("}}", "}").replace("{{", "{");
    }

    private String resolveProperty(String property, Properties dict) throws CoreException {
        String value = dict.getProperty(property);
        return value != null ? this.resolvePropertyValue(value, dict) : null;
    }

    public String getMakeCommand() {
        return isWindows ? ArduinoPreferences.getArduinoHome().resolve("make").toString() : "make";
    }

    public String[] getBuildCommand() throws CoreException {
        return new String[]{this.getMakeCommand()};
    }

    public String[] getCleanCommand() throws CoreException {
        return new String[]{this.getMakeCommand(), "clean"};
    }

    public String[] getSizeCommand() throws CoreException {
        return new String[]{this.getMakeCommand(), "size"};
    }

    public String getCodeSizeRegex() throws CoreException {
        return this.getBoard().getPlatform().getPlatformProperties().getProperty("recipe.size.regex");
    }

    public int getMaxCodeSize() throws CoreException {
        String sizeStr = this.getBoardProperties().getProperty("upload.maximum_size");
        return sizeStr != null ? Integer.parseInt(sizeStr) : -1;
    }

    public String getDataSizeRegex() throws CoreException {
        return this.getBoard().getPlatform().getPlatformProperties().getProperty("recipe.size.regex.data");
    }

    public int getMaxDataSize() throws CoreException {
        String sizeStr = this.getBoardProperties().getProperty("upload.maximum_data_size");
        return sizeStr != null ? Integer.parseInt(sizeStr) : -1;
    }

    public String[] getUploadCommand(String serialPort) throws CoreException {
        String command;
        HierarchicalProperties toolProps;
        ArduinoTool uploadTool;
        String[] segments;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getBoardProperties());
        String toolName = properties.getProperty("upload.tool");
        ArduinoPlatform platform = this.getBoard().getPlatform();
        if (toolName.contains(":") && (segments = toolName.split(":")).length == 2) {
            platform = manager.getInstalledPlatform(segments[0], platform.getArchitecture());
            toolName = segments[1];
        }
        if ((uploadTool = platform.getTool(toolName)) != null) {
            properties.putAll((Map<?, ?>)uploadTool.getToolProperties());
        }
        properties.put("serial.port", serialPort);
        if (serialPort.startsWith("/dev/")) {
            properties.put("serial.port.file", serialPort.substring(5));
        } else {
            properties.put("serial.port.file", serialPort);
        }
        properties.put("path", "{tools." + toolName + ".path}");
        properties.put("cmd.path", "{tools." + toolName + ".cmd.path}");
        properties.put("config.path", "{tools." + toolName + ".config.path}");
        HierarchicalProperties toolsProps = new HierarchicalProperties(platform.getPlatformProperties()).getChild("tools");
        if (toolsProps != null && (toolProps = toolsProps.getChild(toolName)) != null) {
            properties.putAll((Map<?, ?>)toolProps.flatten());
        }
        if (properties.get("upload.protocol") != null) {
            properties.put("upload.verbose", properties.getProperty("upload.params.verbose", ""));
            properties.put("upload.verify", properties.getProperty("upload.params.verify", ""));
            command = this.resolveProperty("upload.pattern", properties);
        } else {
            HierarchicalProperties programmerProps;
            HierarchicalProperties programmers;
            String programmer = this.target.getProgrammer();
            if (programmer != null && (programmers = this.getBoard().getPlatform().getProgrammers()) != null && (programmerProps = programmers.getChild(programmer)) != null) {
                properties.putAll((Map<?, ?>)programmerProps.flatten());
            }
            properties.put("program.verbose", properties.getProperty("program.params.verbose", ""));
            properties.put("program.verify", properties.getProperty("program.params.verify", ""));
            command = this.resolveProperty("program.pattern", properties);
        }
        if (command == null) {
            throw Activator.coreException("Upload command not specified", null);
        }
        if (isWindows) {
            List<String> args = this.splitCommand(command);
            return args.toArray(new String[args.size()]);
        }
        return new String[]{"sh", "-c", command};
    }

    private Collection<java.nio.file.Path> getIncludePath(ArduinoPlatform platform, Properties properties) throws CoreException {
        String[] segments;
        ArduinoPlatform corePlatform = platform;
        String core = properties.getProperty("build.core");
        if (core.contains(":") && (segments = core.split(":")).length == 2) {
            corePlatform = manager.getInstalledPlatform(segments[0], platform.getArchitecture());
            core = segments[1];
        }
        ArduinoPlatform variantPlatform = platform;
        String variant = properties.getProperty("build.variant");
        if (variant != null) {
            String[] segments2;
            if (variant.contains(":") && (segments2 = variant.split(":")).length == 2) {
                variantPlatform = manager.getInstalledPlatform(segments2[0], platform.getArchitecture());
                variant = segments2[1];
            }
        } else {
            return Arrays.asList(corePlatform.getInstallPath().resolve("cores").resolve(core));
        }
        return Arrays.asList(corePlatform.getInstallPath().resolve("cores").resolve(core), variantPlatform.getInstallPath().resolve("variants").resolve(variant));
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        try {
            IContentType contentType = CCorePlugin.getContentType((IProject)resource.getProject(), (String)resource.getName());
            String recipe = contentType != null && (contentType.getId() == "org.eclipse.cdt.core.cSource" || contentType.getId() == "org.eclipse.cdt.core.cSource") ? "recipe.c.o.pattern" : "recipe.cpp.o.pattern";
            ArduinoPlatform platform = this.getBoard().getPlatform();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getBoardProperties());
            properties.put("source_file", "");
            properties.put("object_file", "-");
            properties.put("includes", "");
            String commandString = this.resolveProperty(recipe, properties);
            ArrayList<java.nio.file.Path> includePath = new ArrayList<java.nio.file.Path>();
            includePath.addAll(this.getIncludePath(platform, properties));
            Collection<ArduinoLibrary> libs = manager.getLibraries(this.getProject());
            for (ArduinoLibrary lib : libs) {
                includePath.addAll(lib.getIncludePath());
            }
            String[] includes = null;
            try {
                includes = includePath.stream().map(path -> {
                    try {
                        return this.resolvePropertyValue(path.toString(), properties);
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList()).toArray(new String[includePath.size()]);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
            if (this.cachedScannerInfo != null && this.cachedInfoCommand.equals(commandString) && this.cachedIncludePath.length == includes.length) {
                boolean matches = true;
                int i = 0;
                while (i < includes.length) {
                    if (!includes[i].equals(this.cachedIncludePath[i])) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
                if (matches) {
                    return this.cachedScannerInfo;
                }
            }
            ExtendedScannerInfo baseInfo = new ExtendedScannerInfo(null, includes);
            List<String> command = this.splitCommand(commandString);
            IExtendedScannerInfo info = this.getToolChain().getScannerInfo(this.getBuildConfiguration(), command, (IExtendedScannerInfo)baseInfo, resource, this.getBuildDirectoryURI());
            this.cachedScannerInfo = info;
            this.cachedInfoCommand = commandString;
            this.cachedIncludePath = includes;
            return info;
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    public static String pathString(java.nio.file.Path path) {
        String str = path.toString();
        if (isWindows) {
            str = str.replaceAll("\\\\", "/");
        }
        return str;
    }

    private List<String> splitCommand(String command) {
        boolean inQuotes = false;
        boolean inDouble = false;
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < command.length()) {
            char c = command.charAt(i);
            switch (c) {
                case ' ': {
                    if (inQuotes || inDouble) {
                        builder.append(c);
                        break;
                    }
                    if (builder.length() <= 0) break;
                    args.add(builder.toString());
                    builder = new StringBuilder();
                    break;
                }
                case '\'': {
                    if (inDouble) {
                        builder.append(c);
                        break;
                    }
                    inQuotes = !inQuotes;
                    break;
                }
                case '\"': {
                    if (inQuotes) {
                        builder.append(c);
                        break;
                    }
                    inDouble = !inDouble;
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        if (builder.length() > 0) {
            args.add(builder.toString());
        }
        return args;
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", true, 2);
            ConsoleOutputStream consoleOut = console.getOutputStream();
            consoleOut.write(String.format("\nBuilding %s\n", project.getName()));
            this.generateMakeFile(monitor);
            Throwable throwable = null;
            Object var8_10 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.getBuildCommand()).directory(this.getBuildDirectory().toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                if (this.watchProcess(process, new IConsoleParser[]{epm}, console) == 0) {
                    this.showSizes(console);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.getBuildContainer().refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Build error", (Throwable)e));
        }
        return new IProject[]{project};
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = this.getProject();
            project.deleteMarkers("org.eclipse.cdt.core.problem", true, 2);
            ConsoleOutputStream consoleOut = console.getOutputStream();
            consoleOut.write(String.format("\nCleaning %s\n", project.getName()));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.getCleanCommand()).directory(this.getBuildDirectory().toFile());
            this.setBuildEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            this.watchProcess(process, new IConsoleParser[0], console);
            this.getBuildContainer().refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Build error", (Throwable)e));
        }
    }

    private void showSizes(IConsole console) throws CoreException {
        try {
            Pattern dataSizePattern;
            int codeSize = -1;
            int dataSize = -1;
            String codeSizeRegex = this.getCodeSizeRegex();
            Pattern codeSizePattern = codeSizeRegex != null ? Pattern.compile(codeSizeRegex) : null;
            String dataSizeRegex = this.getDataSizeRegex();
            Pattern pattern = dataSizePattern = dataSizeRegex != null ? Pattern.compile(dataSizeRegex) : null;
            if (codeSizePattern == null && dataSizePattern == null) {
                return;
            }
            int maxCodeSize = this.getMaxCodeSize();
            int maxDataSize = this.getMaxDataSize();
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.getSizeCommand()).directory(this.getBuildDirectory().toFile()).redirectErrorStream(true);
            this.setBuildEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            Throwable throwable = null;
            Object var13_15 = null;
            try (BufferedReader processOut = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = processOut.readLine();
                while (line != null) {
                    Matcher matcher;
                    if (codeSizePattern != null && (matcher = codeSizePattern.matcher(line)).matches()) {
                        codeSize += Integer.parseInt(matcher.group(1));
                    }
                    if (dataSizePattern != null && (matcher = dataSizePattern.matcher(line)).matches()) {
                        dataSize += Integer.parseInt(matcher.group(1));
                    }
                    line = processOut.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ConsoleOutputStream consoleOut = console.getOutputStream();
            consoleOut.write("Program store usage: " + codeSize);
            if (maxCodeSize > 0) {
                consoleOut.write(" of maximum " + maxCodeSize);
            }
            consoleOut.write(" bytes\n");
            if (maxDataSize >= 0) {
                consoleOut.write("Initial RAM usage: " + dataSize);
                if (maxCodeSize > 0) {
                    consoleOut.write(" of maximum " + maxDataSize);
                }
                consoleOut.write(" bytes\n");
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Checking sizes", (Throwable)e));
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        return FileLocator.find((Bundle)Activator.getPlugin().getBundle(), (IPath)new Path(name), null);
    }

    public long getLastModified(Object source) {
        try {
            URL url = (URL)source;
            if (url.getProtocol().equals("file")) {
                File file = new File(url.toURI());
                return file.lastModified();
            }
            return 0L;
        }
        catch (URISyntaxException e) {
            return 0L;
        }
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        URL url = (URL)source;
        return new InputStreamReader(url.openStream(), encoding);
    }

    public void closeTemplateSource(Object arg0) throws IOException {
    }
}

