/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.cmake.ui.internal.Activator;
import org.eclipse.cdt.cmake.ui.internal.Messages;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CMakeBuildTab
extends AbstractLaunchConfigurationTab {
    private Button unixGenButton;
    private Button ninjaGenButton;
    private Text cmakeArgsText;
    private Text buildCommandText;
    private Text cleanCommandText;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.setControl((Control)comp);
        Label label = new Label(comp, 0);
        label.setText(Messages.CMakeBuildTab_Generator);
        Composite genComp = new Composite(comp, 2048);
        genComp.setLayout((Layout)new GridLayout(2, true));
        this.unixGenButton = new Button(genComp, 16);
        this.unixGenButton.setText(Messages.CMakeBuildTab_UnixMakefiles);
        this.unixGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.ninjaGenButton = new Button(genComp, 16);
        this.ninjaGenButton.setText(Messages.CMakeBuildTab_Ninja);
        this.ninjaGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.CMakeBuildTab_CMakeArgs);
        this.cmakeArgsText = new Text(comp, 2048);
        this.cmakeArgsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cmakeArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        label = new Label(comp, 0);
        label.setText(Messages.CMakeBuildTab_BuildCommand);
        this.buildCommandText = new Text(comp, 2048);
        this.buildCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buildCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        label = new Label(comp, 0);
        label.setText(Messages.CMakeBuildTab_CleanCommand);
        this.cleanCommandText = new Text(comp, 2048);
        this.cleanCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cleanCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String mode = this.getLaunchConfigurationDialog().getMode();
        configuration.removeAttribute("COREBUILD_" + mode);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String mode = this.getLaunchConfigurationDialog().getMode();
            Map properties = configuration.getAttribute("COREBUILD_" + mode, new HashMap());
            String generator = (String)properties.get("cmake.generator");
            this.updateGeneratorButtons(generator);
            String cmakeArgs = (String)properties.get("cmake.arguments");
            if (cmakeArgs != null) {
                this.cmakeArgsText.setText(cmakeArgs);
            } else {
                this.cmakeArgsText.setText("");
            }
            String buildCommand = (String)properties.get("cmake.command.build");
            if (buildCommand != null) {
                this.buildCommandText.setText(buildCommand);
            } else {
                this.buildCommandText.setText("");
            }
            String cleanCommand = (String)properties.get("cmake.command.clean");
            if (cleanCommand != null) {
                this.cleanCommandText.setText(buildCommand);
            } else {
                this.cleanCommandText.setText("");
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    private void updateGeneratorButtons(String generator) {
        if (generator != null && generator.equals("Ninja")) {
            this.ninjaGenButton.setSelection(true);
        } else {
            this.unixGenButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String cleanCommand;
        String buildCommand;
        String cmakeArgs;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.ninjaGenButton.getSelection()) {
            properties.put("cmake.generator", "Ninja");
        }
        if (!(cmakeArgs = this.cmakeArgsText.getText().trim()).isEmpty()) {
            properties.put("cmake.arguments", cmakeArgs);
        }
        if (!(buildCommand = this.buildCommandText.getText().trim()).isEmpty()) {
            properties.put("cmake.command.build", buildCommand);
        }
        if (!(cleanCommand = this.cleanCommandText.getText().trim()).isEmpty()) {
            properties.put("cmake.command.clean", cleanCommand);
        }
        String buildAttribute = CoreBuildLaunchConfigDelegate.getBuildAttributeName((String)this.getLaunchConfigurationDialog().getMode());
        if (!properties.isEmpty()) {
            configuration.setAttribute(buildAttribute, properties);
        } else {
            configuration.removeAttribute(buildAttribute);
        }
    }

    public String getName() {
        return Messages.CMakeBuildTab_Cmake;
    }
}

