/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.ISecondaryParser;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.parser.CLanguageKeywords;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ASTPrinter;
import org.eclipse.cdt.core.parser.util.DebugUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkageFactory;
import org.eclipse.core.runtime.CoreException;

public abstract class BaseExtensibleLanguage
extends AbstractLanguage {
    private static final boolean DEBUG_PRINT_GCC_AST = false;
    private static final boolean DEBUG_PRINT_AST = false;
    private long parser_timeout_limit_lowerBoundary = 30000L;
    private long parser_timeout_limit_uppperBoundary = 60000L;
    public static long UNIT_PARSER_TIMEOUT_LIMIT = 10L;
    private static long LONGEST_CORE_RUNTIME;
    private static long LONGEST_LPR_RUNTIME;
    public static boolean CATCH_TEMPLATEID_ERROR;
    private ICLanguageKeywords keywords = null;
    private ICLanguageKeywords cLanguageKeywords = new CLanguageKeywords(this.getParserLanguage(), this.getScannerExtensionConfiguration());

    static {
        CATCH_TEMPLATEID_ERROR = false;
    }

    protected abstract IParser<IASTTranslationUnit> getParser(IScanner var1, IIndex var2, Map<String, String> var3);

    protected IParser<IASTTranslationUnit> getCompleteParser(IScanner scanner, IIndex index, Map<String, String> properties) {
        return this.getParser(scanner, index, properties);
    }

    protected ISecondaryParser<IASTTranslationUnit> getCompleteParser(ITokenStream stream, IScanner scanner, IIndex index, Map<String, String> properties) {
        return (ISecondaryParser)this.getParser(scanner, index, properties);
    }

    protected abstract ParserLanguage getParserLanguage();

    protected abstract IScannerExtensionConfiguration getScannerExtensionConfiguration();

    private <AST_TYPE> AST_TYPE runThreadByLimitedTime(long limitTime, ParseThread<AST_TYPE> parseThread) throws InterruptedException {
        parseThread.start();
        parseThread.join(limitTime);
        return parseThread.getASTUnit();
    }

    @Deprecated
    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory codeReaderFactory, IIndex index, int options, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(FileContent.adapt((CodeReader)reader), scanInfo, IncludeFileContentProvider.adapt((ICodeReaderFactory)codeReaderFactory), index, options, log);
    }

    public void setParser_timeout_limit_lowerBoundary(long parser_timeout_limit_lowerBoundary) {
        this.parser_timeout_limit_lowerBoundary = parser_timeout_limit_lowerBoundary;
    }

    public void setParser_timeout_limit_uppperBoundary(long parser_timeout_limit_uppperBoundary) {
        this.parser_timeout_limit_uppperBoundary = parser_timeout_limit_uppperBoundary;
    }

    public IASTTranslationUnit getASTTranslationUnit(FileContent reader, IScannerInfo scanInfo, IncludeFileContentProvider fileCreator, IIndex index, int options, final IParserLogService log) throws CoreException {
        CATCH_TEMPLATEID_ERROR = false;
        long startTime = 0L;
        Date today = null;
        if (log.isTracing()) {
            today = new Date();
            startTime = today.getTime();
            log.traceLog("^^^^^^ Start parsing " + reader.getFileLocation() + " at " + new Timestamp(startTime));
        }
        Object gtu = null;
        IScannerExtensionConfiguration config = this.getScannerExtensionConfiguration();
        ParserLanguage pl = this.getParserLanguage();
        CPreprocessor preprocessor = new CPreprocessor(reader, scanInfo, pl, log, config, fileCreator);
        preprocessor.setComputeImageLocations((options & 4) == 0);
        HashMap<String, String> parserProperties = new HashMap<String, String>();
        parserProperties.put("org.eclipse.cdt.core.dom.lrparser.translationUnitPath", reader.getFileLocation());
        if ((options & 1) != 0) {
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipFunctionBodies", "true");
        }
        if ((options & 0x10) != 0) {
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipTrivialExpressionsInAggregateInitializers", "true");
        }
        final IParser<IASTTranslationUnit> parser = this.getParser((IScanner)preprocessor, index, parserProperties);
        long parser_timeout_limit = this.parser_timeout_limit_uppperBoundary;
        if (parser instanceof PrsStream) {
            int token_size = ((PrsStream)parser).getSize();
            parser_timeout_limit = (long)token_size * UNIT_PARSER_TIMEOUT_LIMIT;
            if (parser_timeout_limit < this.parser_timeout_limit_lowerBoundary) {
                parser_timeout_limit = this.parser_timeout_limit_lowerBoundary;
            }
            if (parser_timeout_limit > this.parser_timeout_limit_uppperBoundary) {
                parser_timeout_limit = this.parser_timeout_limit_uppperBoundary;
            }
            log.traceLog("^^^^^^ adjusted time out limit with token size: " + token_size + " and the time out limit: " + parser_timeout_limit);
        }
        IASTTranslationUnit tu = null;
        int orgTokenSize = ((PrsStream)parser).getTokens().size();
        ParseThread<IASTTranslationUnit> parseThread = new ParseThread<IASTTranslationUnit>(this){

            @Override
            public void run() {
                block2: {
                    try {
                        this.astUnit = (IASTTranslationUnit)parser.parse();
                    }
                    catch (Exception e) {
                        if (!log.isTracing()) break block2;
                        StringWriter stringW = new StringWriter();
                        PrintWriter printW = new PrintWriter(stringW);
                        e.printStackTrace(printW);
                        log.traceLog("^^^^^^ PARSER_ERR_STACK" + stringW.toString());
                    }
                }
            }
        };
        try {
            tu = this.runThreadByLimitedTime(parser_timeout_limit, parseThread);
        }
        catch (InterruptedException e) {
            StringWriter stringW = new StringWriter();
            PrintWriter printW = new PrintWriter(stringW);
            e.printStackTrace(printW);
            log.traceLog("^^^^^^_ERR_STACK" + stringW.toString());
        }
        parseThread.stop();
        long lprFinishTime = 0L;
        long coreFinishTime = 0L;
        if (log.isTracing()) {
            today = new Date();
            lprFinishTime = today.getTime();
        }
        if (tu == null) {
            long lpr_fail_time = 0L;
            if (log.isTracing()) {
                lpr_fail_time = lprFinishTime;
                log.traceLog("^^^^^^ LR parser fails in parsing " + reader.getFileLocation() + " after running " + (lpr_fail_time - startTime) / 1000L + " seconds");
            }
            GPPLanguage gppLanguage = this.getParserLanguage() == ParserLanguage.CPP ? GPPLanguage.getDefault() : GCCLanguage.getDefault();
            tu = gppLanguage.getASTTranslationUnit(reader, scanInfo, fileCreator, index, options, log);
            if (log.isTracing()) {
                today = new Date();
                coreFinishTime = today.getTime();
                log.traceLog("^^^^^^ core parser parses " + reader.getFileLocation() + " in " + (coreFinishTime - lpr_fail_time) / 1000L + " seconds");
            }
        }
        if (log.isTracing()) {
            long finishTime;
            if (coreFinishTime > 0L) {
                finishTime = coreFinishTime;
                long core_runtime = finishTime - startTime;
                log.traceLog("^^^^^^ Finish parsing with cdt core parser " + reader.getFileLocation() + " at " + new Timestamp(finishTime) + " runtime: " + core_runtime);
                if (core_runtime > LONGEST_CORE_RUNTIME) {
                    LONGEST_CORE_RUNTIME = core_runtime;
                    log.traceLog("^^^^^^ CLCLCLCL so far the longest runtime with core parser is: " + core_runtime / 1000L);
                }
            } else {
                finishTime = lprFinishTime;
                long lpr_runtime = finishTime - startTime;
                log.traceLog("^^^^^^ Finish parsing " + reader.getFileLocation() + " at " + new Timestamp(finishTime) + " runtime: " + lpr_runtime);
                if (lpr_runtime > LONGEST_LPR_RUNTIME) {
                    LONGEST_LPR_RUNTIME = lpr_runtime;
                    log.traceLog("^^^^^^ LLLLLLLL so far the longest runtime by LPR Parser is: " + lpr_runtime / 1000L);
                }
            }
        }
        return tu;
    }

    public void copyTokensToParser(PrsStream parser, List<IToken> tokens) {
        parser.resetTokenStream();
        for (IToken token : tokens) {
            parser.addToken(token);
        }
    }

    public List copyList(List orgList) {
        ArrayList returnList = new ArrayList(orgList.size());
        int i = 0;
        while (i < orgList.size()) {
            returnList.add(orgList.get(i));
            ++i;
        }
        return returnList;
    }

    @Deprecated
    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(reader, scanInfo, fileCreator, index, 0, log);
    }

    @Deprecated
    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        return this.getCompletionNode(FileContent.adapt((CodeReader)reader), scanInfo, IncludeFileContentProvider.adapt((ICodeReaderFactory)fileCreator), index, log, offset);
    }

    public IASTCompletionNode getCompletionNode(FileContent reader, IScannerInfo scanInfo, IncludeFileContentProvider fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IASTCompletionNode completionNode;
        ParseThread<IASTCompletionNode> parseThread;
        block8: {
            IScannerExtensionConfiguration config = this.getScannerExtensionConfiguration();
            ParserLanguage pl = this.getParserLanguage();
            CPreprocessor preprocessor = new CPreprocessor(reader, scanInfo, pl, log, config, fileCreator);
            preprocessor.setContentAssistMode(offset);
            HashMap<String, String> parserProperties = new HashMap<String, String>();
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.translationUnitPath", reader.getFileLocation());
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipFunctionBodies", "true");
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipTrivialExpressionsInAggregateInitializers", "true");
            final IParser<IASTTranslationUnit> parser = this.getParser((IScanner)preprocessor, index, parserProperties);
            long parser_timeout_limit = this.parser_timeout_limit_uppperBoundary;
            if (parser instanceof PrsStream) {
                int token_size = ((PrsStream)parser).getSize();
                parser_timeout_limit = (long)token_size * UNIT_PARSER_TIMEOUT_LIMIT;
                if (parser_timeout_limit < this.parser_timeout_limit_lowerBoundary) {
                    parser_timeout_limit = this.parser_timeout_limit_lowerBoundary;
                }
                if (parser_timeout_limit > this.parser_timeout_limit_uppperBoundary) {
                    parser_timeout_limit = this.parser_timeout_limit_uppperBoundary;
                }
                if (log.isTracing()) {
                    log.traceLog("^^^^^^ adjusted time out limit with token size: " + token_size + " and the time out limit: " + parser_timeout_limit);
                }
            }
            parseThread = new ParseThread<IASTCompletionNode>(this){

                @Override
                public void run() {
                    parser.parse();
                    this.astUnit = parser.getCompletionNode();
                }
            };
            completionNode = null;
            try {
                completionNode = this.runThreadByLimitedTime(parser_timeout_limit * 100L, parseThread);
            }
            catch (InterruptedException e) {
                if (!log.isTracing()) break block8;
                StringWriter stringW = new StringWriter();
                PrintWriter printW = new PrintWriter(stringW);
                e.printStackTrace(printW);
                log.traceLog("^^^^^^_ERR_STACK" + stringW.toString());
            }
        }
        parseThread.stop();
        if (completionNode == null) {
            log.traceLog("LR parser fails in parsing " + reader.getFileLocation());
            if (log.isTracing()) {
                log.traceLog("LR parser fails in parsing " + reader.getFileLocation());
            }
            GPPLanguage gppLanguage = this.getParserLanguage() == ParserLanguage.CPP ? GPPLanguage.getDefault() : GCCLanguage.getDefault();
            completionNode = gppLanguage.getCompletionNode(reader, scanInfo, fileCreator, index, log, offset);
        }
        return completionNode;
    }

    private static void printCompletionNode(IASTCompletionNode cn) {
        if (cn == null) {
            System.out.println("Completion node is null");
            return;
        }
        ASTPrinter.print((IASTNode)cn.getTranslationUnit());
        IASTName[] iASTNameArray = cn.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            ASTNode context = (ASTNode)name.getCompletionContext();
            System.out.printf("Name: %s, Context: %s, At: %d", name, DebugUtil.safeClassName((Object)context), context == null ? null : Integer.valueOf(context.getOffset()));
            if (name.getTranslationUnit() == null) {
                System.out.print(", not hooked up");
            }
            System.out.println();
            ++n2;
        }
        System.out.println();
    }

    @Deprecated
    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        return GCCLanguage.getDefault().getSelectedNames(ast, start, length);
    }

    public Object getAdapter(Class adapter) {
        if (ICLanguageKeywords.class.equals((Object)adapter)) {
            return this.cLanguageKeywords;
        }
        if (IPDOMLinkageFactory.class.equals((Object)adapter)) {
            if (this.getParserLanguage().isCPP()) {
                return new PDOMCPPLinkageFactory();
            }
            return new PDOMCLinkageFactory();
        }
        return super.getAdapter(adapter);
    }

    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        return null;
    }

    private class ParseThread<AST_TYPE>
    extends Thread {
        AST_TYPE astUnit = null;

        ParseThread() {
            super.setName("ParserThread");
        }

        AST_TYPE getASTUnit() {
            return this.astUnit;
        }
    }
}

