/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIAddInferiorInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DebugNewProcessSequence_7_2
extends DebugNewProcessSequence {
    private IGDBControl fGdbControl;
    private IGDBProcesses fProcService;
    private IGDBBackend fBackend;
    private CommandFactory fCommandFactory;
    private String fSessionId;
    private final boolean fInitialProcess;
    private final Map<String, Object> fAttributes;

    public DebugNewProcessSequence_7_2(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        super(executor, isInitial, dmc, file, attributes, rm);
        this.fSessionId = dmc.getSessionId();
        this.fInitialProcess = isInitial;
        this.fAttributes = attributes;
    }

    @Override
    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.add(orderList.indexOf("stepInitializeBaseSequence") + 1, "stepInitializeSequence_7_2");
            orderList.add(orderList.indexOf("stepInitializeSequence_7_2") + 1, "stepAddInferior");
            orderList.add(orderList.indexOf("stepSetExecutable") + 1, "stepSetRemoteExecutable");
            return orderList.toArray(new String[orderList.size()]);
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeSequence_7_2(RequestMonitor rm) {
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSessionId);
        this.fGdbControl = (IGDBControl)tracker.getService(IGDBControl.class);
        this.fProcService = (IGDBProcesses)tracker.getService(IGDBProcesses.class);
        this.fBackend = (IGDBBackend)tracker.getService(IGDBBackend.class);
        tracker.dispose();
        if (this.fGdbControl == null || this.fProcService == null || this.fBackend == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Cannot obtain service", null));
            rm.done();
            return;
        }
        this.fCommandFactory = this.fGdbControl.getCommandFactory();
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepAddInferior(final RequestMonitor rm) {
        if (this.fInitialProcess) {
            this.setContainerContext(this.fProcService.createContainerContextFromGroupId(this.fGdbControl.getContext(), "i1"));
            rm.done();
            return;
        }
        this.fGdbControl.queueCommand(this.fGdbControl.getCommandFactory().createMIAddInferior(this.fGdbControl.getContext()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIAddInferiorInfo>(rm){

            protected void handleSuccess() {
                String groupId = ((MIAddInferiorInfo)this.getData()).getGroupId();
                if (groupId == null || groupId.trim().length() == 0) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Invalid gdb group id.", null));
                    rm.done();
                    return;
                }
                DebugNewProcessSequence_7_2.this.setContainerContext(DebugNewProcessSequence_7_2.this.fProcService.createContainerContextFromGroupId(DebugNewProcessSequence_7_2.this.fGdbControl.getContext(), groupId));
                rm.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetRemoteExecutable(RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.REMOTE && this.fBackend.getIsAttachSession()) {
            String remoteBinary = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.REMOTE_BINARY", (Object)"");
            if (remoteBinary.length() == 0) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Binary on host is not specified"));
                rm.done();
                return;
            }
            this.fGdbControl.queueCommand(this.fCommandFactory.createMIGDBSet((IDMContext)this.getContainerContext(), new String[]{"remote", "exec-file", remoteBinary}), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
        } else {
            rm.done();
        }
    }
}

