/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.boost;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.testsrunner.internal.boost.BoostTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.boost.BoostTestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BoostXmlLogHandler
extends DefaultHandler {
    private static final String XML_NODE_TEST_LOG = "TestLog";
    private static final String XML_NODE_TEST_SUITE = "TestSuite";
    private static final String XML_NODE_TEST_CASE = "TestCase";
    private static final String XML_NODE_TESTING_TIME = "TestingTime";
    private static final String XML_NODE_LAST_CHECKPOINT = "LastCheckpoint";
    private static final String XML_NODE_INFO = "Info";
    private static final String XML_NODE_MESSAGE = "Message";
    private static final String XML_NODE_WARNING = "Warning";
    private static final String XML_NODE_ERROR = "Error";
    private static final String XML_NODE_FATAL_ERROR = "FatalError";
    private static final String XML_NODE_EXCEPTION = "Exception";
    private static final String XML_ATTR_TEST_SUITE_NAME = "name";
    private static final String XML_ATTR_TEST_CASE_NAME = "name";
    private static final String XML_ATTR_MESSAGE_FILE = "file";
    private static final String XML_ATTR_MESSAGE_LINE = "line";
    private static final Map<String, ITestMessage.Level> STRING_TO_MESSAGE_LEVEL;
    private static final String DEFAULT_LOCATION_FILE;
    private static final int DEFAULT_LOCATION_LINE = -1;
    private ITestModelUpdater modelUpdater;
    private Stack<StringBuilder> elementDataStack = new Stack();
    private String fileName;
    private int lineNumber;
    private ITestItem.Status testStatus;
    private String lastTestCaseName = "";
    private static final int SAME_TEST_CASE_NAME_COUNT_START = 2;
    private int sameTestCaseNameCount = 2;

    static {
        HashMap<String, ITestMessage.Level> aMap = new HashMap<String, ITestMessage.Level>();
        aMap.put(XML_NODE_INFO, ITestMessage.Level.Info);
        aMap.put(XML_NODE_MESSAGE, ITestMessage.Level.Message);
        aMap.put(XML_NODE_WARNING, ITestMessage.Level.Warning);
        aMap.put(XML_NODE_ERROR, ITestMessage.Level.Error);
        aMap.put(XML_NODE_FATAL_ERROR, ITestMessage.Level.FatalError);
        STRING_TO_MESSAGE_LEVEL = Collections.unmodifiableMap(aMap);
        DEFAULT_LOCATION_FILE = null;
    }

    BoostXmlLogHandler(ITestModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.elementDataStack.push(new StringBuilder());
        if (qName == XML_NODE_TEST_SUITE) {
            String testSuiteName = attrs.getValue("name");
            this.modelUpdater.enterTestSuite(testSuiteName);
        } else if (qName == XML_NODE_TEST_CASE) {
            String testCaseName = attrs.getValue("name");
            if (this.lastTestCaseName.equals(testCaseName)) {
                testCaseName = String.valueOf(testCaseName) + " (" + this.sameTestCaseNameCount + ")";
                ++this.sameTestCaseNameCount;
            } else {
                this.lastTestCaseName = testCaseName;
                this.sameTestCaseNameCount = 2;
            }
            this.modelUpdater.enterTestCase(testCaseName);
            this.testStatus = ITestItem.Status.Passed;
        } else if (STRING_TO_MESSAGE_LEVEL.containsKey(qName) || qName == XML_NODE_LAST_CHECKPOINT) {
            this.fileName = attrs.getValue(XML_ATTR_MESSAGE_FILE);
            String lineNumberStr = attrs.getValue(XML_ATTR_MESSAGE_LINE);
            this.lineNumber = lineNumberStr != null ? Integer.parseInt(lineNumberStr.trim()) : -1;
        } else if (qName == XML_NODE_EXCEPTION) {
            this.fileName = DEFAULT_LOCATION_FILE;
            this.lineNumber = -1;
        } else if (qName != XML_NODE_TESTING_TIME && qName != XML_NODE_TEST_LOG) {
            this.logAndThrowErrorForElement(qName);
        }
    }

    private void addCurrentMessage(ITestMessage.Level level) {
        this.modelUpdater.addTestMessage(this.fileName, this.lineNumber, level, this.elementDataStack.peek().toString());
        this.fileName = DEFAULT_LOCATION_FILE;
        this.lineNumber = -1;
        if (level == ITestMessage.Level.Error || level == ITestMessage.Level.FatalError) {
            if (this.testStatus != ITestItem.Status.Aborted) {
                this.testStatus = ITestItem.Status.Failed;
            }
        } else if (level == ITestMessage.Level.Exception) {
            this.testStatus = ITestItem.Status.Aborted;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName == XML_NODE_TEST_SUITE) {
            this.modelUpdater.exitTestSuite();
        } else if (qName == XML_NODE_TEST_CASE) {
            this.modelUpdater.setTestStatus(this.testStatus);
            this.modelUpdater.exitTestCase();
        } else if (qName == XML_NODE_TESTING_TIME) {
            this.modelUpdater.setTestingTime(Integer.parseInt(this.elementDataStack.peek().toString().trim()) / 1000);
        } else if (STRING_TO_MESSAGE_LEVEL.containsKey(qName)) {
            this.addCurrentMessage(STRING_TO_MESSAGE_LEVEL.get(qName));
        } else if (qName == XML_NODE_EXCEPTION) {
            if (this.fileName != DEFAULT_LOCATION_FILE && !this.fileName.isEmpty() && this.lineNumber >= 0) {
                this.elementDataStack.peek().append(BoostTestsRunnerMessages.BoostXmlLogHandler_exception_suffix);
            }
            this.addCurrentMessage(ITestMessage.Level.Exception);
        } else if (qName != XML_NODE_TEST_LOG && qName != XML_NODE_LAST_CHECKPOINT) {
            this.logAndThrowErrorForElement(qName);
        }
        this.elementDataStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        StringBuilder builder = this.elementDataStack.peek();
        int i = start;
        while (i < start + length) {
            builder.append(ch[i]);
            ++i;
        }
    }

    private void logAndThrowErrorForElement(String tagName) throws SAXException {
        this.logAndThrowError(MessageFormat.format(BoostTestsRunnerMessages.BoostXmlLogHandler_wrong_tag_name, tagName));
    }

    private void logAndThrowError(String message) throws SAXException {
        SAXException e = new SAXException(message);
        BoostTestsRunnerPlugin.log(e);
        throw e;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        BoostTestsRunnerPlugin.log(ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        BoostTestsRunnerPlugin.log(ex);
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        BoostTestsRunnerPlugin.log(ex);
        throw ex;
    }
}

