/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tools.templates.ui.internal.Template;

public class TemplateTable
implements Listener {
    private final Table table;
    private Font fontBold;
    private Font fontDefault;
    private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
    private static final Rectangle EMPTY_IMAGE_BOUNDS = new Rectangle(0, 0, 48, 48);

    public TemplateTable(Composite parent, int style) {
        this.table = new Table(parent, style);
        this.table.addListener(41, (Listener)this);
        this.table.addListener(40, (Listener)this);
        this.table.addListener(42, (Listener)this);
        this.table.addListener(12, (Listener)this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTemplates(Collection<Template> templates) {
        this.table.removeAll();
        ArrayList<Template> sorted = new ArrayList<Template>(templates);
        Collections.sort(sorted, new Comparator<Template>(){

            @Override
            public int compare(Template o1, Template o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
        for (Template template : sorted) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)template);
            item.setData("org.eclipse.swtbot.widget.key", (Object)template.getLabel());
        }
    }

    public Template getSelectedTemplate() {
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            return (Template)items[0].getData();
        }
        return null;
    }

    public void selectTemplate(Template template) {
        if (template == null) {
            return;
        }
        int i = 0;
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (template.equals(item.getData())) {
                this.table.select(i);
                break;
            }
            ++i;
            ++n2;
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 41: {
                this.computeItemArea(event);
                break;
            }
            case 42: {
                this.paintItem(event);
                break;
            }
            case 40: {
                this.computeItemArea(event);
                break;
            }
            case 12: {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
                break;
            }
        }
    }

    private void computeItemArea(Event event) {
        GC gc = event.gc;
        FontMetrics metrics = gc.getFontMetrics();
        int height = (int)((double)metrics.getHeight() * 3.15);
        event.width = this.table.getClientArea().width - event.x;
        event.height = Math.max(48, height) + 8;
    }

    private void paintItem(Event event) {
        Font font;
        FontData[] data;
        Widget w = event.item;
        GC gc = event.gc;
        if (this.fontDefault == null && (data = (font = gc.getFont()).getFontData()).length > 0) {
            FontData d = data[0];
            FontData normal = new FontData(d.getName(), d.getHeight(), d.getStyle() | 2);
            this.fontDefault = new Font((Device)event.display, normal);
            FontData bold = new FontData(d.getName(), Math.round((float)d.getHeight() * 1.15f), d.getStyle() | 1);
            this.fontBold = new Font((Device)event.display, bold);
        }
        if (w instanceof TableItem) {
            TableItem item = (TableItem)w;
            Template template = (Template)item.getData();
            ImageDescriptor imageDesc = template.getIcon();
            Image image = this.images.get(imageDesc);
            if (image == null && imageDesc != null) {
                image = imageDesc.createImage();
                this.images.put(imageDesc, image);
            }
            Rectangle rect = EMPTY_IMAGE_BOUNDS;
            int y = 0;
            if (image != null) {
                rect = image.getBounds();
                y = event.y + Math.max(0, (event.height - rect.height) / 2);
                gc.drawImage(image, event.x + 4, y);
            } else {
                y = event.y + Math.max(0, (event.height - 48) / 2);
            }
            gc.setFont(this.fontBold);
            String name = template.getLabel();
            Point nameExtent = gc.textExtent(name, 1);
            int iconMargin = 10;
            gc.drawText(name, rect.x + rect.width + iconMargin, y, 1);
            gc.setFont(this.fontDefault);
            int flags = 3;
            String description = template.getDescription();
            int width = this.table.getClientArea().width;
            if (description != null) {
                Point descExt = gc.textExtent(description, flags);
                int descWidth = width - (rect.x + rect.width + iconMargin);
                if (descExt.x > descWidth) {
                    FontMetrics fm = gc.getFontMetrics();
                    int averageCharWidth = fm.getAverageCharWidth();
                    int charsMaxNumberInRow = descWidth / averageCharWidth;
                    if (description.length() > charsMaxNumberInRow) {
                        String firstLine = description.substring(0, charsMaxNumberInRow);
                        int lastWS = firstLine.lastIndexOf(32);
                        int endIndex = lastWS + 1 + charsMaxNumberInRow;
                        description = String.valueOf(firstLine.substring(0, lastWS)) + '\n' + description.substring(lastWS + 1, Math.min(endIndex, description.length()));
                    }
                }
                gc.drawText(description, rect.x + rect.width + iconMargin, y + nameExtent.y + 2, flags);
            }
        }
    }
}

