/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public abstract class AbstractTracepoint
extends CBreakpoint
implements ICTracepoint {
    public AbstractTracepoint() {
    }

    public AbstractTracepoint(IResource resource, Map<String, Object> attributes, boolean add) throws CoreException {
        super(resource, attributes, add);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.address", "");
    }

    @Override
    public String getFileName() throws CoreException {
        String fileName = this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.sourceHandle", "");
        Path path = new Path(fileName);
        return path.isValidPath(fileName) ? path.lastSegment() : null;
    }

    @Override
    public String getFunction() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.function", "");
    }

    @Override
    public boolean isConditional() throws CoreException {
        return super.isConditional() || this.getPassCount() > 0;
    }

    @Override
    public void setAddress(String address) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.address", address);
    }

    @Override
    public void setFunction(String function) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.function", function);
    }

    @Override
    public int getPassCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.passCount", 0);
    }

    @Override
    public void setPassCount(int passCount) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.passCount", passCount);
        this.setAttribute("message", this.getMarkerMessage());
    }
}

