/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConflictSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.FolderInfoModification;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IConfigurationModification;
import org.eclipse.core.runtime.IPath;

public class ConfigurationModification
extends FolderInfoModification
implements IConfigurationModification {
    private IBuilder fSelectedBuilder;
    private IBuilder fRealBuilder;
    private boolean fCompatibilityInfoInited;
    private Map<IBuilder, BuilderCompatibilityInfoElement> fCompatibleBuilders;
    private Map<IBuilder, BuilderCompatibilityInfoElement> fInCompatibleBuilders;
    private ToolChainModificationManager.ConflictMatchSet fConflicts;
    private IBuilder[] fAllSysBuilders;
    private BuilderCompatibilityInfoElement fCurrentBuilderCompatibilityInfo;

    public ConfigurationModification(FolderInfo foInfo) {
        super(foInfo);
        this.setBuilder(foInfo.getParent().getBuilder());
    }

    public ConfigurationModification(FolderInfo foInfo, ConfigurationModification base) {
        super(foInfo, base);
        this.fSelectedBuilder = base.fSelectedBuilder;
        if (!this.fSelectedBuilder.isExtensionElement()) {
            this.fSelectedBuilder = ManagedBuildManager.getExtensionBuilder(this.fSelectedBuilder);
        }
        this.fRealBuilder = base.fRealBuilder;
    }

    @Override
    public IBuilder getBuilder() {
        return this.fSelectedBuilder;
    }

    @Override
    public IBuilder getRealBuilder() {
        return this.fRealBuilder;
    }

    @Override
    public CompatibilityStatus getBuilderCompatibilityStatus() {
        BuilderCompatibilityInfoElement currentBuilderCompatibilityInfo = this.getCurrentBuilderCompatibilityInfo();
        if (currentBuilderCompatibilityInfo == null) {
            return new CompatibilityStatus(4, Messages.getString("ConfigurationModification.0"), null);
        }
        return currentBuilderCompatibilityInfo.getCompatibilityStatus();
    }

    private ToolChainModificationManager.ConflictMatchSet getParentConflictMatchSet() {
        if (this.fConflicts == null) {
            PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = this.getCompleteObjectStore();
            Set<IPath> restore = TcModificationUtil.removeBuilderInfo(storage, this.fRealBuilder);
            try {
                this.fConflicts = ToolChainModificationManager.getInstance().getConflictInfo(4, storage);
            }
            finally {
                if (restore != null) {
                    TcModificationUtil.restoreBuilderInfo(storage, this.fRealBuilder, restore);
                }
            }
        }
        return this.fConflicts;
    }

    private IBuilder[] getAllSysBuilders() {
        if (this.fAllSysBuilders == null) {
            this.fAllSysBuilders = ManagedBuildManager.getRealBuilders();
        }
        return this.fAllSysBuilders;
    }

    private void initCompatibilityInfo() {
        if (this.fCompatibilityInfoInited) {
            return;
        }
        this.fCompatibleBuilders = new HashMap<IBuilder, BuilderCompatibilityInfoElement>();
        this.fInCompatibleBuilders = new HashMap<IBuilder, BuilderCompatibilityInfoElement>();
        ToolChainModificationManager.ConflictMatchSet conflicts = this.getParentConflictMatchSet();
        IBuilder[] sysBs = this.getAllSysBuilders();
        Map<? extends IRealBuildObjectAssociation, List<ToolChainModificationManager.ConflictMatch>> conflictMap = conflicts.fObjToConflictListMap;
        int i = 0;
        while (i < sysBs.length) {
            Builder b = (Builder)sysBs[i];
            List<ToolChainModificationManager.ConflictMatch> l = conflictMap.get(b);
            BuilderCompatibilityInfoElement info = new BuilderCompatibilityInfoElement(b, l);
            if (info.isCompatible()) {
                this.fCompatibleBuilders.put(b, info);
            } else {
                this.fInCompatibleBuilders.put(b, info);
            }
            ++i;
        }
        this.fCompatibilityInfoInited = true;
    }

    private BuilderCompatibilityInfoElement getCurrentBuilderCompatibilityInfo() {
        if (this.fCurrentBuilderCompatibilityInfo == null) {
            this.initCompatibilityInfo();
            BuilderCompatibilityInfoElement info = this.fCompatibleBuilders.get(this.fRealBuilder);
            if (info == null) {
                info = this.fInCompatibleBuilders.get(this.fRealBuilder);
            }
            this.fCurrentBuilderCompatibilityInfo = info;
        }
        return this.fCurrentBuilderCompatibilityInfo;
    }

    @Override
    public IBuilder[] getCompatibleBuilders() {
        this.initCompatibilityInfo();
        ArrayList<IBuilder> l = new ArrayList<IBuilder>(this.fCompatibleBuilders.size());
        IConfiguration cfg = this.getResourceInfo().getParent();
        Set<IBuilder> keySet = this.fCompatibleBuilders.keySet();
        for (IBuilder b : keySet) {
            if (b == this.fRealBuilder || !cfg.isBuilderCompatible(b)) continue;
            l.add(b);
        }
        return l.toArray(new IBuilder[l.size()]);
    }

    @Override
    public boolean isBuilderCompatible() {
        BuilderCompatibilityInfoElement be = this.getCurrentBuilderCompatibilityInfo();
        return be == null ? false : be.isCompatible();
    }

    @Override
    public void setBuilder(IBuilder builder) {
        if (builder == this.fSelectedBuilder) {
            return;
        }
        this.fSelectedBuilder = builder;
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(builder);
        if (realBuilder == this.fRealBuilder) {
            return;
        }
        this.fRealBuilder = realBuilder;
        this.fCompletePathMapStorage = null;
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = this.getCompleteObjectStore();
        TcModificationUtil.applyBuilder(storage, this.getResourceInfo().getPath(), this.fSelectedBuilder);
        this.clearBuilderCompatibilityInfo();
        this.clearToolChainCompatibilityInfo();
        this.clearToolCompatibilityInfo();
    }

    @Override
    public void setToolChain(IToolChain tc, boolean force) {
        this.setBuilder(tc.getBuilder());
        super.setToolChain(tc, force);
    }

    @Override
    public void changeProjectTools(ITool removeTool, ITool addTool) {
        this.clearBuilderCompatibilityInfo();
        super.changeProjectTools(removeTool, addTool);
    }

    protected void clearBuilderCompatibilityInfo() {
        this.fInCompatibleBuilders = null;
        this.fCompatibleBuilders = null;
        this.fCompatibilityInfoInited = false;
        this.fCurrentBuilderCompatibilityInfo = null;
    }

    public static class BuilderCompatibilityInfoElement {
        private Builder fBuilder;
        private List<ToolChainModificationManager.ConflictMatch> fErrComflictMatchList;
        private CompatibilityStatus fStatus;

        BuilderCompatibilityInfoElement(Builder builder, List<ToolChainModificationManager.ConflictMatch> errConflictList) {
            this.fBuilder = builder;
            if (errConflictList != null && errConflictList.size() != 0) {
                this.fErrComflictMatchList = errConflictList;
            }
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                String message;
                int severity;
                if (this.fErrComflictMatchList != null) {
                    severity = 4;
                    message = Messages.getString("ConfigurationModification.0");
                } else {
                    severity = 0;
                    message = "";
                }
                this.fStatus = new CompatibilityStatus(severity, message, new ConflictSet(this.fBuilder, this.fErrComflictMatchList, null));
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.fErrComflictMatchList == null;
        }
    }
}

