/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitDestructorName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class DestructorCallCollector {
    public static IASTImplicitDestructorName[] getTemporariesDestructorCalls(ICPPASTExpression expression) {
        if (expression.getParent() instanceof ICPPASTExpression) {
            return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
        }
        TemporariesDestructorCollector collector = new TemporariesDestructorCollector(expression);
        expression.accept(collector);
        return collector.getDestructorCalls();
    }

    public static IASTImplicitDestructorName[] getLocalVariablesDestructorCalls(IASTStatement statement) {
        if (!(statement instanceof IASTImplicitDestructorNameOwner)) {
            return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
        }
        LocalVariablesDestructorCollector collector = new LocalVariablesDestructorCollector((IASTImplicitDestructorNameOwner)((Object)statement));
        statement.accept(collector);
        return collector.getDestructorCalls();
    }

    private DestructorCallCollector() {
    }

    private static abstract class DestructorCollector
    extends ASTVisitor {
        protected final IASTImplicitDestructorNameOwner owner;
        private IASTImplicitDestructorName[] destructorNames = IASTImplicitDestructorName.EMPTY_NAME_ARRAY;

        DestructorCollector(IASTImplicitDestructorNameOwner owner) {
            this.owner = owner;
        }

        IASTImplicitDestructorName[] getDestructorCalls() {
            this.destructorNames = ArrayUtil.trim(this.destructorNames);
            return this.destructorNames;
        }

        static ICPPMethod findDestructor(ICPPClassType classType, IASTNode point) {
            return ClassTypeHelper.getMethodInClass(classType, ClassTypeHelper.MethodKind.DTOR, point);
        }

        protected void addDestructorCall(IASTName name, ICPPMethod destructor) {
            CPPASTImplicitDestructorName destructorName = new CPPASTImplicitDestructorName(destructor.getNameCharArray(), this.owner, name);
            destructorName.setBinding(destructor);
            ASTNode parentNode = (ASTNode)((Object)this.owner);
            int offset = parentNode.getOffset() + parentNode.getLength();
            if (!(this.owner instanceof ICPPASTExpression)) {
                --offset;
            }
            destructorName.setOffsetAndLength(offset, 0);
            this.destructorNames = ArrayUtil.prepend(this.destructorNames, destructorName);
        }
    }

    private static class LocalVariablesDestructorCollector
    extends DestructorCollector {
        private LocalVariablesDestructorCollector(IASTImplicitDestructorNameOwner owner) {
            super(owner);
            this.shouldVisitNames = true;
            this.shouldVisitImplicitNames = true;
        }

        @Override
        public int visit(IASTName name) {
            IBinding binding;
            if (name.getPropertyInParent() == IASTDeclarator.DECLARATOR_NAME && (binding = name.resolveBinding()) instanceof ICPPVariable) {
                ICPPVariable var = (ICPPVariable)binding;
                try {
                    IASTNode scopeNode;
                    IScope scope = var.getScope();
                    if (scope.getKind() == EScopeKind.eLocal && scope instanceof ICPPASTInternalScope && (scopeNode = ((ICPPASTInternalScope)scope).getPhysicalNode()).equals(this.owner)) {
                        IType type = SemanticUtil.getNestedType(var.getType(), 9);
                        if (type instanceof ICPPClassType) {
                            ICPPMethod destructor = LocalVariablesDestructorCollector.findDestructor((ICPPClassType)type, name);
                            if (destructor != null) {
                                this.addDestructorCall(name, destructor);
                            }
                        } else if (type instanceof ICPPReferenceType) {
                            IASTDeclarator decl = (IASTDeclarator)name.getParent();
                            this.addDestructorCallForTemporaryBoundToReference(decl);
                        }
                    }
                }
                catch (DOMException e) {
                    CCorePlugin.log(e);
                }
            }
            return 3;
        }

        private void addDestructorCallForTemporaryBoundToReference(IASTDeclarator decl) {
            ICPPClassType classType;
            ICPPMethod destructor;
            IASTImplicitName name;
            IBinding binding;
            IASTImplicitName[] implicitNames;
            IASTInitializerClause clause;
            IASTInitializer initializer = decl.getInitializer();
            if (initializer instanceof IASTEqualsInitializer && (clause = ((IASTEqualsInitializer)initializer).getInitializerClause()) instanceof IASTImplicitNameOwner && (implicitNames = ((IASTImplicitNameOwner)((Object)clause)).getImplicitNames()).length != 0 && (binding = (name = implicitNames[0]).resolveBinding()) instanceof ICPPConstructor && (destructor = LocalVariablesDestructorCollector.findDestructor(classType = ((ICPPConstructor)binding).getClassOwner(), name)) != null) {
                this.addDestructorCall(name, destructor);
            }
        }
    }

    private static class TemporariesDestructorCollector
    extends DestructorCollector {
        private TemporariesDestructorCollector(ICPPASTExpression owner) {
            super(owner);
            this.shouldVisitImplicitNames = true;
        }

        @Override
        public int visit(IASTName name) {
            ICPPClassType classType;
            ICPPMethod destructor;
            IBinding binding;
            if (name instanceof IASTImplicitName && !(name.getParent() instanceof ICPPASTNewExpression) && (binding = name.resolveBinding()) instanceof ICPPConstructor && (destructor = TemporariesDestructorCollector.findDestructor(classType = ((ICPPConstructor)binding).getClassOwner(), name)) != null && !this.isBoundToVariable(name)) {
                this.addDestructorCall(name, destructor);
            }
            return 3;
        }

        private boolean isBoundToVariable(IASTName name) {
            IASTName name2;
            IBinding binding;
            IASTNode parent = name.getParent();
            if (!(parent instanceof IASTExpression)) {
                return false;
            }
            if (!((parent = parent.getParent()) instanceof IASTBinaryExpression)) {
                return false;
            }
            IASTBinaryExpression binExpr = (IASTBinaryExpression)parent;
            if (binExpr.getOperator() != 17) {
                return false;
            }
            IASTExpression left = binExpr.getOperand1();
            return left instanceof IASTIdExpression && (binding = (name2 = ((IASTIdExpression)left).getName()).resolveBinding()) instanceof ICPPVariable;
        }
    }
}

