/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CompileCommand;
import org.eclipse.cdt.cmake.core.internal.Messages;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CMakeBuildConfiguration
extends CBuildConfiguration {
    public static final String CMAKE_GENERATOR = "cmake.generator";
    public static final String CMAKE_ARGUMENTS = "cmake.arguments";
    public static final String BUILD_COMMAND = "cmake.command.build";
    public static final String CLEAN_COMMAND = "cmake.command.clean";
    private static final String TOOLCHAIN_FILE = "cdt.cmake.toolchainfile";
    private ICMakeToolChainFile toolChainFile;

    public CMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        Preferences settings = this.getSettings();
        String pathStr = settings.get(TOOLCHAIN_FILE, "");
        if (!pathStr.isEmpty()) {
            Path path = Paths.get(pathStr, new String[0]);
            this.toolChainFile = manager.getToolChainFile(path);
        } else {
            this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
            if (this.toolChainFile != null) {
                this.saveToolChainFile();
            }
        }
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, null, "run");
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode) {
        super(config, name, toolChain, launchMode);
        this.toolChainFile = toolChainFile;
        if (toolChainFile != null) {
            this.saveToolChainFile();
        }
    }

    public ICMakeToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    private void saveToolChainFile() {
        Preferences settings = this.getSettings();
        settings.put(TOOLCHAIN_FILE, this.toolChainFile.getPath().toString());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return Platform.getOS().equals(toolchain.getProperty("os")) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        Path buildDir;
        ConsoleOutputStream outStream;
        IProject project;
        block37: {
            boolean runCMake;
            String generator;
            block34: {
                project = this.getProject();
                try {
                    generator = this.getProperty(CMAKE_GENERATOR);
                    if (generator == null) {
                        generator = "Ninja";
                    }
                    project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
                    outStream = console.getOutputStream();
                    buildDir = this.getBuildDirectory();
                    outStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingIn, buildDir.toString()));
                    if (this.toolChainFile != null || this.isLocal()) break block34;
                    ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
                    this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
                    if (this.toolChainFile != null) break block34;
                    console.getErrorStream().write(Messages.CMakeBuildConfiguration_NoToolchainFile);
                    return null;
                }
                catch (IOException e) {
                    throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Building, project.getName()), e));
                }
            }
            switch (generator) {
                case "Ninja": {
                    runCMake = !Files.exists(buildDir.resolve("build.ninja"), new LinkOption[0]);
                    break;
                }
                default: {
                    boolean bl = runCMake = !Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0]);
                }
            }
            if (!runCMake) break block37;
            ArrayList<String> command = new ArrayList<String>();
            Path cmakePath = this.findCommand("cmake");
            if (cmakePath != null) {
                command.add(cmakePath.toString());
            } else {
                command.add("cmake");
            }
            command.add("-G");
            command.add(generator);
            if (this.toolChainFile != null) {
                command.add("-DCMAKE_TOOLCHAIN_FILE=" + this.toolChainFile.getPath().toString());
            }
            switch (this.getLaunchMode()) {
                case "debug": {
                    command.add("-DCMAKE_BUILD_TYPE=Debug");
                }
            }
            command.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
            String userArgs = this.getProperty(CMAKE_ARGUMENTS);
            if (userArgs != null) {
                command.addAll(Arrays.asList(userArgs.trim().split("\\s+")));
            }
            command.add(new File(project.getLocationURI()).getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(buildDir.toFile());
            this.setBuildEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
            this.watchProcess(process, console);
        }
        Throwable throwable = null;
        Object var12_15 = null;
        try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
            CharSequence[] charSequenceArray;
            epm.setOutputStream((OutputStream)console.getOutputStream());
            String buildCommand = this.getProperty(BUILD_COMMAND);
            if (buildCommand != null && !buildCommand.trim().isEmpty()) {
                charSequenceArray = buildCommand.split(" ");
            } else {
                String[] stringArray = new String[3];
                stringArray[0] = "cmake";
                stringArray[1] = "--build";
                charSequenceArray = stringArray;
                stringArray[2] = ".";
            }
            CharSequence[] command = charSequenceArray;
            Path cmdPath = this.findCommand(command[0]);
            if (cmdPath != null) {
                command[0] = cmdPath.toString();
            }
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command).directory(buildDir.toFile());
            this.setBuildEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
            this.watchProcess(process, new IConsoleParser[]{epm});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        project.refreshLocal(2, monitor);
        this.processCompileCommandsFile(monitor);
        outStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingComplete, buildDir.toString()));
        return new IProject[]{project};
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            CharSequence[] command;
            Path cmdPath;
            String generator = this.getProperty(CMAKE_GENERATOR);
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0])) {
                outStream.write(Messages.CMakeBuildConfiguration_NotFound);
                return;
            }
            String cleanCommand = this.getProperty(CLEAN_COMMAND);
            if (cleanCommand == null) {
                cleanCommand = generator == null || generator.equals("Ninja") ? "ninja clean" : "make clean";
            }
            if ((cmdPath = this.findCommand((command = cleanCommand.split(" "))[0])) != null) {
                command[0] = cmdPath.toString();
            }
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command).directory(buildDir.toFile());
            Process process = processBuilder.start();
            outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
            this.watchProcess(process, console);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    private void processCompileCommandsFile(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        Path commandsFile = this.getBuildDirectory().resolve("compile_commands.json");
        if (Files.exists(commandsFile, new LinkOption[0])) {
            monitor.setTaskName(Messages.CMakeBuildConfiguration_ProcCompJson);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileReader reader = new FileReader(commandsFile.toFile());){
                    Gson gson = new Gson();
                    CompileCommand[] commands = (CompileCommand[])gson.fromJson((Reader)reader, CompileCommand[].class);
                    HashMap<String, CompileCommand> dedupedCmds = new HashMap<String, CompileCommand>();
                    CompileCommand[] compileCommandArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CompileCommand command = compileCommandArray[n2];
                        dedupedCmds.put(command.getFile(), command);
                        ++n2;
                    }
                    for (CompileCommand command : dedupedCmds.values()) {
                        this.processLine(command.getCommand());
                    }
                    this.shutdown();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_ProcCompCmds, project.getName()), e));
            }
        }
    }
}

