/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.docker.launcher;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.ICommandLauncherFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.docker.launcher.ContainerCommandLauncher;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.osgi.framework.Bundle;

public class ContainerCommandLauncherFactory
implements ICommandLauncherFactory {
    public ICommandLauncher getCommandLauncher(IProject project) {
        boolean enableContainer;
        String enablementProperty;
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        if (cfg == null) {
            return null;
        }
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            return new ContainerCommandLauncher();
        }
        return null;
    }

    public ICommandLauncher getCommandLauncher(ICConfigurationDescription cfgd) {
        boolean enableContainer;
        String enablementProperty;
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        if (cfg == null) {
            return null;
        }
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            return new ContainerCommandLauncher();
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void registerLanguageSettingEntries(IProject project, List<? extends ICLanguageSettingEntry> langEntries) {
        entries = langEntries;
        cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
        cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            connectionName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
            imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
            if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
                DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
                return;
            }
            launcher = new ContainerLauncher();
            paths = new ArrayList<String>();
            for (ICLanguageSettingEntry entry : entries) {
                if (!(entry instanceof ICIncludePathEntry)) continue;
                paths.add(entry.getValue());
            }
            if (paths.size() > 0) {
                pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher")).append("HEADERS");
                pluginPath.toFile().mkdir();
                pluginPath = pluginPath.append(this.getCleanName(connectionName));
                pluginPath.toFile().mkdir();
                connectionNamePath = pluginPath.append(".name");
                f = connectionNamePath.toFile();
                try {
                    f.createNewFile();
                    try {
                        var16_16 = null;
                        var17_20 = null;
                        try {
                            writer = new FileWriter(f);
                            try {
                                bufferedWriter = new BufferedWriter(writer);
                                try {
                                    bufferedWriter.write(connectionName);
                                    bufferedWriter.newLine();
                                }
                                finally {
                                    if (bufferedWriter != null) {
                                        bufferedWriter.close();
                                    }
                                }
                                ** if (writer == null) goto lbl-1000
                            }
                            catch (Throwable var17_21) {
                                if (var16_16 == null) {
                                    var16_16 = var17_21;
                                } else if (var16_16 != var17_21) {
                                    var16_16.addSuppressed(var17_21);
                                }
                                if (writer != null) {
                                    writer.close();
                                }
                                throw var16_16;
                            }
lbl-1000:
                            // 1 sources

                            {
                                writer.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var17_22) {
                            if (var16_16 == null) {
                                var16_16 = var17_22;
                            } else if (var16_16 != var17_22) {
                                var16_16.addSuppressed(var17_22);
                            }
                            throw var16_16;
                        }
                    }
                    catch (IOException e) {
                        DockerLaunchUIPlugin.log(e);
                        return;
                    }
                    pluginPath = pluginPath.append(this.getCleanName(imageName));
                    pluginPath.toFile().mkdir();
                    imageNamePath = pluginPath.append(".name");
                    f = imageNamePath.toFile();
                    f.createNewFile();
                    try {
                        var17_20 = null;
                        var18_26 = null;
                        try {
                            writer = new FileWriter(f);
                            try {
                                bufferedWriter = new BufferedWriter(writer);
                                try {
                                    bufferedWriter.write(imageName);
                                    bufferedWriter.newLine();
                                }
                                finally {
                                    if (bufferedWriter != null) {
                                        bufferedWriter.close();
                                    }
                                }
                                ** if (writer == null) goto lbl-1000
                            }
                            catch (Throwable var18_27) {
                                if (var17_20 == null) {
                                    var17_20 = var18_27;
                                } else if (var17_20 != var18_27) {
                                    var17_20.addSuppressed(var18_27);
                                }
                                if (writer != null) {
                                    writer.close();
                                }
                                throw var17_20;
                            }
lbl-1000:
                            // 1 sources

                            {
                                writer.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var18_28) {
                            if (var17_20 == null) {
                                var17_20 = var18_28;
                            } else if (var17_20 != var18_28) {
                                var17_20.addSuppressed(var18_28);
                            }
                            throw var17_20;
                        }
                    }
                    catch (IOException e) {
                        DockerLaunchUIPlugin.log(e);
                        return;
                    }
                }
                catch (IOException e) {
                    DockerLaunchUIPlugin.log(e);
                    return;
                }
                hostDir = pluginPath;
                var17_25 = launcher.fetchContainerDirs(connectionName, imageName, paths, hostDir);
            }
        }
    }

    public List<ICLanguageSettingEntry> verifyLanguageSettingEntries(IProject project, List<ICLanguageSettingEntry> entries) {
        boolean enableContainer;
        String enablementProperty;
        if (entries == null) {
            return null;
        }
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            String connectionName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
            String imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
            if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
                DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
                return entries;
            }
            ContainerLauncher launcher = new ContainerLauncher();
            Set copiedVolumes = launcher.getCopiedVolumes(connectionName, imageName);
            ArrayList<ICLanguageSettingEntry> newEntries = new ArrayList<ICLanguageSettingEntry>();
            IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher"));
            IPath hostDir = pluginPath.append("HEADERS").append(this.getCleanName(connectionName)).append(this.getCleanName(imageName));
            for (ICLanguageSettingEntry entry : entries) {
                if (entry instanceof ICIncludePathEntry) {
                    if (copiedVolumes.contains(((ICIncludePathEntry)entry).getName().toString())) {
                        IPath newPath = hostDir.append(entry.getName());
                        CIncludePathEntry newEntry = new CIncludePathEntry(newPath.toString(), entry.getFlags());
                        newEntries.add((ICLanguageSettingEntry)newEntry);
                        continue;
                    }
                    newEntries.add(entry);
                    continue;
                }
                newEntries.add(entry);
            }
            return newEntries;
        }
        return entries;
    }

    private String getCleanName(String name) {
        String cleanName = name.replace("unix:///", "unix_");
        cleanName = cleanName.replace("tcp://", "tcp_");
        return cleanName.replaceAll("[:/.]", "_");
    }
}

