/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTAlignmentSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeList;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationListOwner;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.dom.ast.IASTTokenList;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeList;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.dom.parser.ISourceCodeParser;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IInactiveCodeToken;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.BacktrackException;
import org.eclipse.cdt.internal.core.dom.parser.DeclarationOptions;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.IASTInactiveCompletionName;
import org.eclipse.cdt.internal.core.dom.parser.ParserLogServiceWrapper;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

public abstract class AbstractGNUSourceCodeParser
implements ISourceCodeParser {
    private static final ASTVisitor MARK_INACTIVE = new ASTGenericVisitor(true){
        {
            this.shouldVisitAmbiguousNodes = true;
        }

        @Override
        protected int genericVisit(IASTNode node) {
            ((ASTNode)node).setInactive();
            return 3;
        }

        @Override
        public int visit(ASTAmbiguousNode node) {
            IASTNode[] alternatives;
            node.setInactive();
            IASTNode[] iASTNodeArray = alternatives = node.getNodes();
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode alt = iASTNodeArray[n2];
                if (!alt.accept(this)) {
                    return 2;
                }
                ++n2;
            }
            return 3;
        }
    };
    protected static final int DEFAULT_DESIGNATOR_LIST_SIZE = 4;
    protected final AbstractParserLogService log;
    protected final IScanner scanner;
    protected final ParserMode mode;
    protected final boolean supportStatementsInExpressions;
    protected final boolean supportTypeOfUnaries;
    protected final boolean supportAlignOfUnaries;
    protected final boolean supportKnRC;
    protected final boolean supportAttributeSpecifiers;
    protected final boolean supportDeclspecSpecifiers;
    protected boolean supportParameterInfoBlock;
    protected boolean supportFunctionStyleAsm;
    protected boolean supportExtendedSizeofOperator;
    protected final IBuiltinBindingsProvider builtinBindingsProvider;
    protected boolean functionCallCanBeLValue;
    protected int maximumTrivialExpressionsInAggregateInitializers = Integer.MAX_VALUE;
    protected IToken declarationMark;
    protected IToken nextToken;
    protected IToken lastToken;
    protected IToken lastTokenFromScanner;
    protected boolean isCancelled = false;
    protected boolean parsePassed = true;
    protected int backtrackCount = 0;
    protected BacktrackException backtrack = new BacktrackException();
    protected ASTCompletionNode completionNode;
    private final INodeFactory nodeFactory;
    private boolean fActiveCode = true;

    protected AbstractGNUSourceCodeParser(IScanner scanner, IParserLogService logService, ParserMode parserMode, INodeFactory nodeFactory, boolean supportStatementsInExpressions, boolean supportTypeOfUnaries, boolean supportAlignOfUnaries, boolean supportKnRC, boolean supportAttributeSpecifiers, boolean supportDeclspecSpecifiers, IBuiltinBindingsProvider builtinBindingsProvider) {
        this.scanner = scanner;
        this.log = this.wrapLogService(logService);
        this.mode = parserMode;
        this.supportStatementsInExpressions = supportStatementsInExpressions;
        this.supportTypeOfUnaries = supportTypeOfUnaries;
        this.supportAlignOfUnaries = supportAlignOfUnaries;
        this.supportKnRC = supportKnRC;
        this.supportAttributeSpecifiers = supportAttributeSpecifiers;
        this.supportDeclspecSpecifiers = supportDeclspecSpecifiers;
        this.builtinBindingsProvider = builtinBindingsProvider;
        this.nodeFactory = nodeFactory;
    }

    public void setMaximumTrivialExpressionsInAggregateInitializers(int limit) {
        this.maximumTrivialExpressionsInAggregateInitializers = limit;
    }

    private AbstractParserLogService wrapLogService(IParserLogService logService) {
        if (logService instanceof AbstractParserLogService) {
            return (AbstractParserLogService)logService;
        }
        return new ParserLogServiceWrapper(logService);
    }

    protected final void throwBacktrack(int offset, int length) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(offset, length < 0 ? 0 : length);
        throw this.backtrack;
    }

    protected INodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public IASTCompletionNode getCompletionNode() {
        return this.completionNode;
    }

    protected ASTCompletionNode createCompletionNode(IToken token) {
        if (this.completionNode == null && token != null && token.getType() == 140) {
            this.completionNode = new ASTCompletionNode(token, this.getTranslationUnit());
        }
        return this.completionNode;
    }

    private final IToken fetchToken(boolean skipInactive) throws EndOfFileException {
        try {
            IToken t = this.scanner.nextToken();
            if (skipInactive) {
                while (t.getType() == 145) {
                    this.scanner.skipInactiveCode();
                    t = this.scanner.nextToken();
                }
            }
            if (this.lastTokenFromScanner != null) {
                this.lastTokenFromScanner.setNext(t);
            }
            this.lastTokenFromScanner = t;
            return t;
        }
        catch (OffsetLimitReachedException olre) {
            if (this.mode != ParserMode.COMPLETION_PARSE) {
                throw new EndOfFileException(olre.getEndOffset());
            }
            IToken completionToken = olre.getFinalToken();
            this.createCompletionNode(completionToken);
            if (olre.getOriginator() == 3) {
                IASTInactiveCompletionName completionName = this.nodeFactory.newInactiveCompletionName(completionToken.getCharImage(), this.getTranslationUnit());
                ((ASTNode)((Object)completionName)).setOffsetAndLength(completionToken.getOffset(), completionToken.getLength());
                this.completionNode.addName(completionName);
                this.consume();
            }
            throw olre;
        }
    }

    private final IToken nextToken(boolean skipInactive) throws EndOfFileException {
        IToken tn;
        IToken t = this.nextToken;
        if (t != null) {
            return t;
        }
        this.nextToken = tn = this.fetchToken(skipInactive);
        return tn;
    }

    private final IToken lookaheadToken(int i, boolean skipInactive) throws EndOfFileException {
        assert (i >= 0);
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        IToken t = this.nextToken(skipInactive);
        while (i > 1) {
            if ((t = t.getNext()) == null) {
                t = this.fetchToken(skipInactive);
            }
            --i;
        }
        return t;
    }

    protected final IToken LA() throws EndOfFileException {
        IToken t = this.nextToken(true);
        this.checkForEOI(t);
        return t;
    }

    protected final IToken LA(int i) throws EndOfFileException {
        IToken t = this.lookaheadToken(i, true);
        this.checkForEOI(t);
        return t;
    }

    protected final IToken consume() throws EndOfFileException {
        IToken t = this.nextToken(true);
        this.checkForEOI(t);
        this.nextToken = t.getNext();
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean acceptInactiveCodeBoundary(int nesting) {
        try {
            block6: while (true) {
                IToken t = this.nextToken(false);
                switch (t.getType()) {
                    case 145: 
                    case 146: {
                        IInactiveCodeToken it = (IInactiveCodeToken)t;
                        if (it.getNewNesting() < nesting || it.getNewNesting() == nesting && it.getOldNesting() == nesting) {
                            return false;
                        }
                        this.fActiveCode = false;
                        this.nextToken = t.getNext();
                        continue block6;
                    }
                    case 147: {
                        IInactiveCodeToken it = (IInactiveCodeToken)t;
                        if (it.getNewNesting() < nesting || it.getNewNesting() == nesting && it.getOldNesting() == nesting) {
                            return false;
                        }
                        this.fActiveCode = true;
                        this.nextToken = t.getNext();
                        continue block6;
                    }
                }
                break;
            }
            return true;
        }
        catch (EndOfFileException endOfFileException) {
            return true;
        }
    }

    protected final void skipInactiveCode() throws OffsetLimitReachedException {
        block6: {
            IToken t = this.nextToken;
            if (this.fActiveCode && (t == null || t.getType() != 145)) {
                return;
            }
            try {
                this.fActiveCode = true;
                while (t != null && t.getType() != 147) {
                    t = t.getNext();
                }
                if (t != null) {
                    this.nextToken = t.getNext();
                } else {
                    this.nextToken = null;
                    this.scanner.skipInactiveCode();
                }
            }
            catch (OffsetLimitReachedException olre) {
                if (this.mode != ParserMode.COMPLETION_PARSE) break block6;
                this.createCompletionNode(olre.getFinalToken());
                throw olre;
            }
        }
    }

    protected final boolean isActiveCode() {
        return this.fActiveCode;
    }

    protected final int getCodeBranchNesting() {
        return this.scanner.getCodeBranchNesting();
    }

    protected final IToken mark() throws EndOfFileException {
        return this.LA();
    }

    protected final void backup(IToken mark) {
        this.nextToken = mark;
    }

    private final void checkForEOI(IToken t) throws EndOfFileException {
        int lt = t.getType();
        if (lt == 146 || lt == 147) {
            throw new EndOfFileException(t.getOffset(), true);
        }
    }

    protected final IToken LAcatchEOF(int i) {
        try {
            return this.LA(i);
        }
        catch (EndOfFileException e) {
            return null;
        }
    }

    protected final int LT(int i) throws EndOfFileException {
        return this.LA(i).getType();
    }

    protected final int LTcatchEOF(int i) {
        try {
            return this.LT(i);
        }
        catch (EndOfFileException e) {
            return 0;
        }
    }

    protected final IToken consume(int type) throws EndOfFileException, BacktrackException {
        IToken result = this.consume();
        if (result.getType() != type) {
            this.throwBacktrack(result);
        }
        return result;
    }

    protected final IToken consume(int type1, int type2) throws EndOfFileException, BacktrackException {
        IToken result = this.consume();
        int lt1 = result.getType();
        if (lt1 != type1 && lt1 != type2) {
            this.throwBacktrack(result);
        }
        return result;
    }

    protected IToken consumeOrEOC(int type) throws EndOfFileException, BacktrackException {
        IToken la1 = this.LA(1);
        int lt1 = la1.getType();
        if (lt1 != type) {
            if (lt1 == 141) {
                return la1;
            }
            this.throwBacktrack(la1);
        }
        return this.consume();
    }

    protected final boolean isOnSameLine(int offset1, int offset2) {
        ILocationResolver lr = (ILocationResolver)this.getTranslationUnit().getAdapter(ILocationResolver.class);
        IASTFileLocation floc = lr.getMappedFileLocation(offset1, offset2 - offset1 + 1);
        return floc.getFileName().equals(lr.getContainingFilePath(offset1)) && floc.getStartingLineNumber() == floc.getEndingLineNumber();
    }

    protected final int calculateEndOffset(IASTNode n) {
        ASTNode node = (ASTNode)n;
        return node.getOffset() + node.getLength();
    }

    protected final <T extends IASTNode> T setRange(T n, IASTNode from) {
        ((ASTNode)n).setOffsetAndLength((ASTNode)from);
        return n;
    }

    protected final <T extends IASTNode> T setRange(T n, IASTNode from, int endOffset) {
        int offset = ((ASTNode)from).getOffset();
        ((ASTNode)n).setOffsetAndLength(offset, endOffset - offset);
        return n;
    }

    protected final <T extends IASTNode> T setRange(T n, int offset, int endOffset) {
        ((ASTNode)n).setOffsetAndLength(offset, endOffset - offset);
        return n;
    }

    protected final void adjustLength(IASTNode n, IASTNode endNode) {
        int endOffset = this.calculateEndOffset(endNode);
        this.adjustEndOffset(n, endOffset);
    }

    protected final <T extends IASTNode> T adjustEndOffset(T n, int endOffset) {
        ASTNode node = (ASTNode)n;
        node.setLength(endOffset - node.getOffset());
        return n;
    }

    protected final int getEndOffset() {
        if (this.lastTokenFromScanner == null) {
            return 0;
        }
        return this.lastTokenFromScanner.getEndOffset();
    }

    protected void failParse() {
        this.parsePassed = false;
    }

    @Override
    public synchronized void cancel() {
        this.isCancelled = true;
    }

    protected abstract IASTName identifier() throws EndOfFileException, BacktrackException;

    public final int getBacktrackCount() {
        return this.backtrackCount;
    }

    protected IASTProblem createProblem(BacktrackException bt) {
        IASTProblem result = bt.getProblem();
        if (result == null) {
            result = this.createProblem(0x4000001, bt.getOffset(), bt.getLength());
        }
        return result;
    }

    protected final IASTProblem createProblem(int signal, int offset, int length) {
        IASTProblem result = this.nodeFactory.newProblem(signal, CharArrayUtils.EMPTY, true);
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, length);
        return result;
    }

    protected void logThrowable(String methodName, Throwable e) {
        if (e != null) {
            if (this.log.isTracing()) {
                String message = String.format("Parser: Unexpected throwable in %s:%s::%s. w/%s", methodName, e.getClass().getName(), e.getMessage(), this.scanner);
                this.log.traceLog(message);
            }
            this.log.traceException(e);
        }
    }

    public String toString() {
        return this.scanner.toString();
    }

    protected void logException(String methodName, Exception e) {
        if (!(e instanceof EndOfFileException) && e != null) {
            if (this.log.isTracing()) {
                String message = String.format("Parser: Unexpected exception in %s:%s::%s. w/%s", methodName, e.getClass().getName(), e.getMessage(), this.scanner);
                this.log.traceLog(message);
            }
            this.log.traceException(e);
        }
    }

    protected final void throwBacktrack(IASTProblem problem, IASTNode node) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(problem, node);
        throw this.backtrack;
    }

    protected final void throwBacktrack(IASTProblem problem) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(problem);
        throw this.backtrack;
    }

    protected final void throwBacktrack(IASTNode node) throws BacktrackException {
        ASTNode n = (ASTNode)node;
        this.throwBacktrack(n.getOffset(), n.getLength());
    }

    @Override
    public IASTTranslationUnit parse() {
        long t0 = this.log.isTracing() ? System.currentTimeMillis() : 0L;
        this.translationUnit();
        long t1 = this.log.isTracing() ? System.currentTimeMillis() : 0L;
        this.resolveAmbiguities();
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (this.log.isTracing()) {
            ITranslationUnit tu = ast.getOriginatingTranslationUnit();
            String name = tu == null ? "<unknown>" : tu.getElementName();
            String message = String.format("Parsed %s: %d ms%s. Ambiguity resolution: %d ms", name, t1 - t0, this.parsePassed ? "" : " - parse failure", System.currentTimeMillis() - t1);
            this.log.traceLog(message);
        }
        this.nullifyTranslationUnit();
        ast.freeze();
        return ast;
    }

    protected void resolveAmbiguities() {
        IASTTranslationUnit translationUnit = this.getTranslationUnit();
        if (translationUnit instanceof ASTTranslationUnit) {
            ((ASTTranslationUnit)translationUnit).resolveAmbiguities();
        }
    }

    protected abstract ASTVisitor createAmbiguityNodeVisitor();

    protected abstract void nullifyTranslationUnit();

    protected IToken skipOverCompoundStatement(boolean hasSkippedNodes) throws BacktrackException, EndOfFileException {
        if (hasSkippedNodes) {
            this.getTranslationUnit().setHasNodesOmitted(true);
        }
        boolean isActive = this.isActiveCode();
        int codeBranchNesting = this.getCodeBranchNesting();
        this.consume(12);
        IToken result = null;
        int depth = 1;
        while (depth > 0) {
            IToken t;
            int lt;
            if (!(isActive || (lt = (t = this.lookaheadToken(1, false)).getType()) != 146 && lt != 147 && lt != 145 || this.acceptInactiveCodeBoundary(codeBranchNesting))) {
                throw new EndOfFileException(t.getOffset(), true);
            }
            result = this.consume();
            switch (result.getType()) {
                case 13: {
                    --depth;
                    break;
                }
                case 12: {
                    ++depth;
                    break;
                }
                case 141: {
                    throw new EndOfFileException(result.getOffset());
                }
            }
        }
        return result;
    }

    protected IASTProblemDeclaration skipProblemDeclaration(int offset) {
        return this.skipProblemDeclaration(offset, null);
    }

    protected IASTProblemDeclaration skipProblemDeclaration(int offset, IASTProblem origProblem) {
        this.failParse();
        this.declarationMark = null;
        int endOffset = this.skipToSemiOrClosingBrace(offset, false);
        IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
        if (origProblem != null && origProblem.getID() != 0x4000001) {
            problem.setOriginalProblem(origProblem);
        }
        return this.buildProblemDeclaration(problem);
    }

    protected IASTProblemStatement skipProblemStatement(int offset) {
        this.failParse();
        this.declarationMark = null;
        int endOffset = this.skipToSemiOrClosingBrace(offset, false);
        IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
        return this.buildProblemStatement(problem);
    }

    private IASTProblem skipProblemEnumerator(int offset) {
        this.failParse();
        int endOffset = this.skipToSemiOrClosingBrace(offset, true);
        return this.createProblem(0x4000001, offset, endOffset - offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int skipToSemiOrClosingBrace(int offset, boolean eatBrace) {
        this.failParse();
        this.declarationMark = null;
        int depth = 0;
        try {
            int endOffset = this.LA(1).getOffset();
            while (true) {
                switch (this.LT(1)) {
                    case 141: {
                        return this.getEndOffset();
                    }
                    case 5: {
                        if (depth != 0) break;
                        return this.consume().getEndOffset();
                    }
                    case 12: {
                        ++depth;
                        break;
                    }
                    case 13: {
                        if (--depth > 0) break;
                        if (depth == 0 || offset == endOffset || eatBrace) {
                            endOffset = this.consume().getEndOffset();
                        }
                        if (this.LTcatchEOF(1) != 5) return endOffset;
                        return this.consume().getEndOffset();
                    }
                }
                endOffset = this.consume().getEndOffset();
            }
        }
        catch (EndOfFileException e) {
            return this.getEndOffset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IASTProblemExpression skipProblemConditionInParenthesis(int offset) {
        int endOffset;
        block11: {
            this.failParse();
            int compExpr = 0;
            int depth = 0;
            endOffset = offset;
            try {
                while (true) {
                    switch (this.LT(1)) {
                        case 141: {
                            endOffset = this.getEndOffset();
                            break block11;
                        }
                        case 5: 
                        case 12: {
                            if (compExpr != 0) break;
                            break block11;
                        }
                        case 8: {
                            ++depth;
                            if (this.LTcatchEOF(2) != 12) break;
                            if (compExpr == 0) {
                                compExpr = depth;
                            }
                            this.consume();
                            break;
                        }
                        case 9: {
                            if (--depth < 0) break block11;
                            if (depth >= compExpr) break;
                            compExpr = 0;
                        }
                    }
                    endOffset = this.consume().getEndOffset();
                }
            }
            catch (EndOfFileException e) {
                endOffset = this.getEndOffset();
            }
        }
        IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
        return this.buildProblemExpression(problem);
    }

    protected IASTCompoundStatement compoundStatement() throws EndOfFileException, BacktrackException {
        IASTCompoundStatement result = this.nodeFactory.newCompoundStatement();
        if (this.LT(1) == 141) {
            return result;
        }
        int offset = this.LA(1).getOffset();
        int endOffset = this.consume(12).getOffset();
        int stmtOffset = -1;
        while (true) {
            IASTStatement stmt;
            IToken next;
            block17: {
                block16: {
                    if ((next = this.LAcatchEOF(1)) == null) {
                        ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
                        this.throwBacktrack(this.createProblem(0x4000001, endOffset, 0), result);
                        return null;
                    }
                    if (next.getType() != 141) break block16;
                    this.declarationMark = null;
                    break;
                }
                if (next.getType() != 13) break block17;
                endOffset = this.consume().getEndOffset();
                this.declarationMark = null;
                break;
            }
            try {
                int nextOffset = next.getOffset();
                this.declarationMark = next;
                next = null;
                if (stmtOffset == nextOffset) {
                    stmt = this.skipProblemStatement(stmtOffset);
                } else {
                    stmtOffset = nextOffset;
                    stmt = this.statement();
                }
                result.addStatement(stmt);
                endOffset = this.calculateEndOffset(stmt);
            }
            catch (BacktrackException bt) {
                IASTNode beforeProblem = bt.getNodeBeforeProblem();
                IASTProblem problem = bt.getProblem();
                if (problem != null && beforeProblem instanceof IASTStatement) {
                    result.addStatement((IASTStatement)beforeProblem);
                    result.addStatement(this.buildProblemStatement(problem));
                    endOffset = this.calculateEndOffset(beforeProblem);
                } else {
                    IASTProblemStatement stmt2 = this.skipProblemStatement(stmtOffset);
                    result.addStatement(stmt2);
                    endOffset = this.calculateEndOffset(stmt2);
                }
                this.declarationMark = null;
                continue;
            }
            catch (EndOfFileException e) {
                try {
                    stmt = this.skipProblemStatement(stmtOffset);
                    result.addStatement(stmt);
                    endOffset = this.calculateEndOffset(stmt);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.declarationMark = null;
                }
            }
            this.declarationMark = null;
            continue;
            break;
        }
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
        return result;
    }

    private IASTProblemDeclaration buildProblemDeclaration(IASTProblem problem) {
        IASTProblemDeclaration pd = this.nodeFactory.newProblemDeclaration(problem);
        ((ASTNode)((Object)pd)).setOffsetAndLength((ASTNode)((Object)problem));
        return pd;
    }

    private IASTProblemStatement buildProblemStatement(IASTProblem problem) {
        IASTProblemStatement pstmt = this.nodeFactory.newProblemStatement(problem);
        ((ASTNode)((Object)pstmt)).setOffsetAndLength((ASTNode)((Object)problem));
        return pstmt;
    }

    private IASTProblemExpression buildProblemExpression(IASTProblem problem) {
        IASTProblemExpression pexpr = this.nodeFactory.newProblemExpression(problem);
        ((ASTNode)((Object)pexpr)).setOffsetAndLength((ASTNode)((Object)problem));
        return pexpr;
    }

    protected IASTExpression compoundStatementExpression() throws EndOfFileException, BacktrackException {
        int startingOffset = this.consume().getOffset();
        IASTCompoundStatement compoundStatement = null;
        if (this.mode == ParserMode.QUICK_PARSE || this.mode == ParserMode.STRUCTURAL_PARSE || !this.isActiveCode()) {
            this.skipOverCompoundStatement(true);
        } else if (this.mode == ParserMode.COMPLETION_PARSE || this.mode == ParserMode.SELECTION_PARSE) {
            if (this.scanner.isOnTopContext()) {
                this.compoundStatement();
            } else {
                this.skipOverCompoundStatement(true);
            }
        } else if (this.mode == ParserMode.COMPLETE_PARSE) {
            compoundStatement = this.compoundStatement();
        }
        int lastOffset = this.consume(9).getEndOffset();
        IGNUASTCompoundStatementExpression resultExpression = this.nodeFactory.newGNUCompoundStatementExpression(compoundStatement);
        ((ASTNode)((Object)resultExpression)).setOffsetAndLength(startingOffset, lastOffset - startingOffset);
        return resultExpression;
    }

    public final IASTExpression buildExpression(BinaryOperator leftChain, IASTInitializerClause expr) {
        BinaryOperator rightChain = null;
        while (true) {
            if (leftChain == null) {
                if (rightChain == null) {
                    return (IASTExpression)expr;
                }
                expr = this.buildExpression((IASTExpression)expr, rightChain);
                rightChain = rightChain.fNext;
                continue;
            }
            if (rightChain != null && leftChain.fRightPrecedence < rightChain.fLeftPrecedence) {
                expr = this.buildExpression((IASTExpression)expr, rightChain);
                rightChain = rightChain.fNext;
                continue;
            }
            BinaryOperator op = leftChain;
            leftChain = leftChain.fNext;
            expr = op.exchange(expr);
            op.fNext = rightChain;
            rightChain = op;
        }
    }

    private IASTExpression buildExpression(IASTExpression left, BinaryOperator operator) {
        int op;
        int unaryOp = 0;
        IASTInitializerClause right = operator.fExpression;
        switch (operator.fOperatorToken) {
            case 7: {
                IASTInitializerClause negative;
                if (operator.fNext == null || operator.fNext.fOperatorToken != 4) {
                    negative = null;
                } else {
                    negative = operator.fNext.fExpression;
                    operator.fNext = operator.fNext.fNext;
                }
                IASTConditionalExpression conditionalEx = this.nodeFactory.newConditionalExpession(left, (IASTExpression)right, (IASTExpression)negative);
                this.setRange(conditionalEx, left);
                if (negative != null) {
                    this.adjustLength(conditionalEx, negative);
                }
                return conditionalEx;
            }
            case 6: {
                IASTExpressionList list;
                if (left instanceof IASTExpressionList) {
                    list = (IASTExpressionList)left;
                } else {
                    list = this.nodeFactory.newExpressionList();
                    list.addExpression(left);
                    this.setRange(list, left);
                }
                list.addExpression((IASTExpression)right);
                this.adjustLength(list, right);
                return list;
            }
            case 38: {
                op = 17;
                break;
            }
            case 22: {
                op = 18;
                break;
            }
            case 51: {
                op = 19;
                break;
            }
            case 24: {
                op = 20;
                break;
            }
            case 14: {
                op = 21;
                break;
            }
            case 17: {
                op = 22;
                break;
            }
            case 43: {
                op = 24;
                break;
            }
            case 47: {
                op = 23;
                break;
            }
            case 28: {
                op = 25;
                break;
            }
            case 26: {
                op = 26;
                break;
            }
            case 31: {
                op = 27;
                break;
            }
            case 32: {
                op = 16;
                break;
            }
            case 29: {
                op = 15;
                unaryOp = 18;
                break;
            }
            case 33: {
                op = 14;
                break;
            }
            case 27: {
                op = 13;
                break;
            }
            case 30: {
                op = 12;
                unaryOp = 5;
                break;
            }
            case 37: {
                op = 28;
                break;
            }
            case 35: {
                op = 29;
                break;
            }
            case 46: {
                op = 9;
                break;
            }
            case 42: {
                op = 8;
                break;
            }
            case 41: {
                op = 10;
                break;
            }
            case 45: {
                op = 11;
                break;
            }
            case 152: {
                op = 32;
                break;
            }
            case 153: {
                op = 33;
                break;
            }
            case 40: {
                op = 6;
                break;
            }
            case 44: {
                op = 7;
                break;
            }
            case 16: {
                op = 4;
                unaryOp = 2;
                break;
            }
            case 21: {
                op = 5;
                unaryOp = 3;
                break;
            }
            case 23: {
                op = 1;
                unaryOp = 4;
                break;
            }
            case 52: {
                op = 2;
                break;
            }
            case 25: {
                op = 3;
                break;
            }
            case 49: {
                op = 30;
                break;
            }
            case 19: {
                op = 31;
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        IASTExpression result = this.buildBinaryExpression(op, left, right, this.calculateEndOffset(right));
        CastAmbiguityMarker am = operator.fAmbiguityMarker;
        if (am != null) {
            if (unaryOp != 0) {
                result = this.createCastVsBinaryExpressionAmbiguity((IASTBinaryExpression)result, am.getTypeIdForCast(), unaryOp, am.getUnaryOperatorOffset());
            } else assert (false);
        }
        return result;
    }

    protected abstract IASTExpression expression() throws BacktrackException, EndOfFileException;

    protected abstract IASTExpression constantExpression() throws BacktrackException, EndOfFileException;

    protected abstract IASTExpression unaryExpression(CastExprCtx var1, ITemplateIdStrategy var2) throws BacktrackException, EndOfFileException;

    protected abstract IASTExpression primaryExpression(CastExprCtx var1, ITemplateIdStrategy var2) throws BacktrackException, EndOfFileException;

    protected abstract IASTTypeId typeId(DeclarationOptions var1) throws EndOfFileException, BacktrackException;

    protected abstract IASTExpression expressionWithOptionalTrailingEllipsis() throws BacktrackException, EndOfFileException;

    protected abstract IASTTypeId typeIdWithOptionalTrailingEllipsis(DeclarationOptions var1) throws EndOfFileException, BacktrackException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final IASTExpression castExpression(CastExprCtx ctx, ITemplateIdStrategy strat) throws EndOfFileException, BacktrackException {
        IToken mark;
        block22: {
            if (this.LT(1) != 8) return this.unaryExpression(ctx, strat);
            mark = this.mark();
            int startingOffset = mark.getOffset();
            boolean canBeCast = this.canBeCastExpression();
            this.consume();
            IASTTypeId typeId = null;
            if (canBeCast) {
                try {
                    typeId = this.typeId(DeclarationOptions.TYPEID);
                }
                catch (BacktrackException backtrackException) {
                    // empty catch block
                }
            }
            if (typeId != null && this.LT(1) == 9) {
                this.consume();
                boolean unaryFailed = false;
                if (ctx == CastExprCtx.eDirectlyInBExpr) {
                    switch (this.LT(1)) {
                        case 16: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 30: {
                            int operatorOffset = this.LA(1).getOffset();
                            IToken markEnd = this.mark();
                            this.backup(mark);
                            try {
                                IASTExpression unary = this.unaryExpression(CastExprCtx.eInBExpr, strat);
                                return new CastAmbiguityMarker(unary, typeId, operatorOffset);
                            }
                            catch (BacktrackException bt) {
                                this.backup(markEnd);
                                unaryFailed = true;
                                break;
                            }
                        }
                    }
                }
                try {
                    IASTExpression iASTExpression;
                    boolean couldBeFunctionCall = this.LT(1) == 8;
                    IASTExpression rhs = this.castExpression(ctx, strat);
                    CastAmbiguityMarker ca = null;
                    if (rhs instanceof CastAmbiguityMarker) {
                        ca = (CastAmbiguityMarker)rhs;
                        rhs = ca.getExpression();
                        assert (!(rhs instanceof CastAmbiguityMarker));
                    }
                    IASTCastExpression result = this.buildCastExpression(0, typeId, rhs, startingOffset, this.calculateEndOffset(rhs));
                    if (!unaryFailed && couldBeFunctionCall && !(rhs instanceof IASTCastExpression)) {
                        IToken markEnd = this.mark();
                        this.backup(mark);
                        try {
                            IASTExpression expr = this.primaryExpression(ctx, strat);
                            IASTFunctionCallExpression fcall = this.nodeFactory.newFunctionCallExpression(expr, (IASTInitializerClause[])null);
                            IASTAmbiguousExpression ambiguity = this.createAmbiguousCastVsFunctionCallExpression(result, fcall);
                            ((ASTNode)((Object)ambiguity)).setOffsetAndLength((ASTNode)((Object)result));
                            IASTAmbiguousExpression iASTAmbiguousExpression = ca == null ? ambiguity : ca.updateExpression(ambiguity);
                            return iASTAmbiguousExpression;
                        }
                        catch (BacktrackException backtrackException) {
                        }
                        finally {
                            this.backup(markEnd);
                        }
                    }
                    if (ca == null) {
                        iASTExpression = result;
                        return iASTExpression;
                    }
                    iASTExpression = ca.updateExpression(result);
                    return iASTExpression;
                }
                catch (BacktrackException b) {
                    if (!unaryFailed) break block22;
                    throw b;
                }
            }
        }
        this.backup(mark);
        return this.unaryExpression(ctx, strat);
    }

    protected abstract IASTTranslationUnit getTranslationUnit();

    protected abstract void setupTranslationUnit() throws Exception;

    protected void translationUnit() {
        try {
            this.setupTranslationUnit();
        }
        catch (Exception e) {
            this.logException("translationUnit::createCompilationUnit()", e);
            return;
        }
        this.parseTranslationUnit();
    }

    protected void parseTranslationUnit() {
        IASTTranslationUnit tu = this.getTranslationUnit();
        this.declarationList(tu, DeclarationOptions.GLOBAL, false, 0);
    }

    protected final void declarationListInBraces(IASTDeclarationListOwner tu, int offset, DeclarationOptions options) throws EndOfFileException, BacktrackException {
        int codeBranchNesting = this.getCodeBranchNesting();
        this.consume(12);
        this.declarationList(tu, options, true, codeBranchNesting);
        int lt1 = this.LTcatchEOF(1);
        if (lt1 == 13) {
            int endOffset = this.consume().getEndOffset();
            this.setRange(tu, offset, endOffset);
            return;
        }
        int endOffset = this.getEndOffset();
        this.setRange(tu, offset, endOffset);
        if (lt1 == 141 || lt1 == 0 && tu instanceof IASTCompositeTypeSpecifier) {
            return;
        }
        this.throwBacktrack(this.createProblem(0x4000001, endOffset, 0), tu);
    }

    /*
     * Unable to fully structure code
     */
    private final void declarationList(IASTDeclarationListOwner tu, DeclarationOptions options, boolean upToBrace, int codeBranchNesting) {
        wasActive = this.isActiveCode();
        while (true) {
            if (!(ok = this.acceptInactiveCodeBoundary(codeBranchNesting))) {
                if (!wasActive) {
                    return;
                }
                try {
                    this.skipInactiveCode();
                }
                catch (OffsetLimitReachedException e) {
                    return;
                }
                codeBranchNesting = Math.min(this.getCodeBranchNesting() + 1, codeBranchNesting);
                continue;
            }
            active = this.isActiveCode();
            next = this.LAcatchEOF(1);
            if (next == null || next.getType() == 141) {
                return;
            }
            if (upToBrace && next.getType() == 13 && active == wasActive) {
                return;
            }
            offset = next.getOffset();
            this.declarationMark = next;
            next = null;
            try {
                declaration = this.declaration(options);
                if (((ASTNode)declaration).getLength() == 0 && this.LTcatchEOF(1) != 141) {
                    declaration = this.skipProblemDeclaration(offset);
                }
                this.addDeclaration(tu, declaration, active);
            }
            catch (BacktrackException bt) {
                var15_18 = decls = this.problemDeclaration(offset, bt, options);
                var14_17 = decls.length;
                var13_16 = 0;
                ** while (var13_16 < var14_17)
            }
lbl-1000:
            // 1 sources

            {
                declaration = var15_18[var13_16];
                this.addDeclaration(tu, declaration, active);
                ++var13_16;
                continue;
            }
lbl38:
            // 1 sources

            this.declarationMark = null;
            continue;
            catch (EndOfFileException e) {
                try {
                    declaration = this.skipProblemDeclaration(offset);
                    this.addDeclaration(tu, declaration, active);
                    if (e.endsInactiveCode()) continue;
                    break;
                }
                catch (Throwable var16_19) {
                    throw var16_19;
                }
                finally {
                    this.declarationMark = null;
                    continue;
                }
            }
            this.declarationMark = null;
        }
    }

    private void addDeclaration(IASTDeclarationListOwner parent, IASTDeclaration declaration, boolean active) {
        if (!active) {
            declaration.accept(MARK_INACTIVE);
        }
        parent.addDeclaration(declaration);
    }

    protected abstract IASTExpression buildBinaryExpression(int var1, IASTExpression var2, IASTInitializerClause var3, int var4);

    private IASTExpression createCastVsBinaryExpressionAmbiguity(IASTBinaryExpression expr, IASTTypeId typeid, int unaryOperator, int unaryOpOffset) {
        IASTUnaryExpression unary = this.nodeFactory.newUnaryExpression(unaryOperator, null);
        ((ASTNode)((Object)unary)).setOffset(unaryOpOffset);
        IASTCastExpression castExpr = this.buildCastExpression(0, typeid, unary, 0, 0);
        IASTAmbiguousExpression result = this.createAmbiguousBinaryVsCastExpression(expr, castExpr);
        ((ASTNode)((Object)result)).setOffsetAndLength((ASTNode)((Object)expr));
        return result;
    }

    protected IASTExpression unaryExpression(int operator, CastExprCtx ctx, ITemplateIdStrategy strat) throws EndOfFileException, BacktrackException {
        IToken operatorToken = this.consume();
        IASTExpression operand = this.castExpression(ctx, strat);
        CastAmbiguityMarker ca = null;
        if (operand instanceof CastAmbiguityMarker) {
            ca = (CastAmbiguityMarker)operand;
            operand = ca.getExpression();
            assert (!(operand instanceof CastAmbiguityMarker));
        }
        if (operator == 4 && operand instanceof IASTLiteralExpression) {
            IASTLiteralExpression lit = (IASTLiteralExpression)operand;
            switch (lit.getKind()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    this.throwBacktrack(operatorToken);
                }
            }
        }
        IASTExpression result = this.buildUnaryExpression(operator, operand, operatorToken.getOffset(), this.calculateEndOffset(operand));
        return ca == null ? result : ca.updateExpression(result);
    }

    protected IASTExpression buildUnaryExpression(int operator, IASTExpression operand, int offset, int lastOffset) {
        IASTUnaryExpression result = this.nodeFactory.newUnaryExpression(operator, operand);
        this.setRange(result, offset, lastOffset);
        return result;
    }

    protected IASTStatement handleFunctionBody() throws BacktrackException, EndOfFileException {
        this.declarationMark = null;
        if (this.mode == ParserMode.QUICK_PARSE || this.mode == ParserMode.STRUCTURAL_PARSE || !this.isActiveCode()) {
            int offset = this.LA(1).getOffset();
            IToken last = this.skipOverCompoundStatement(true);
            IASTCompoundStatement cs = this.nodeFactory.newCompoundStatement();
            this.setRange(cs, offset, last.getEndOffset());
            return cs;
        }
        if (this.mode == ParserMode.COMPLETION_PARSE || this.mode == ParserMode.SELECTION_PARSE) {
            if (this.scanner.isOnTopContext()) {
                return this.functionBody();
            }
            int offset = this.LA(1).getOffset();
            IToken last = this.skipOverCompoundStatement(true);
            IASTCompoundStatement cs = this.nodeFactory.newCompoundStatement();
            this.setRange(cs, offset, last.getEndOffset());
            return cs;
        }
        return this.functionBody();
    }

    protected IASTCompoundStatement functionBody() throws EndOfFileException, BacktrackException {
        return this.compoundStatement();
    }

    protected abstract IASTDeclarator initDeclarator(IASTDeclSpecifier var1, DeclarationOptions var2) throws EndOfFileException, BacktrackException, FoundAggregateInitializer;

    protected IASTEnumerationSpecifier enumSpecifier() throws BacktrackException, EndOfFileException {
        IToken mark = this.mark();
        int offset = this.consume().getOffset();
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        IASTName name = this.LT(1) == 1 ? this.identifier() : this.nodeFactory.newName();
        if (this.LT(1) != 12) {
            this.backup(mark);
            this.throwBacktrack(mark);
        }
        IASTEnumerationSpecifier result = this.nodeFactory.newEnumerationSpecifier(name);
        int endOffset = this.enumBody(result);
        return this.setRange(result, offset, endOffset);
    }

    protected int enumBody(IASTEnumerationSpecifier result) throws EndOfFileException, BacktrackException {
        int endOffset;
        block14: {
            boolean needComma = false;
            int problemOffset = endOffset = this.consume(12).getEndOffset();
            try {
                block10: while (true) {
                    switch (this.LTcatchEOF(1)) {
                        case 0: {
                            endOffset = this.getEndOffset();
                            break block14;
                        }
                        case 13: {
                            endOffset = this.consume().getEndOffset();
                            break block14;
                        }
                        case 141: {
                            break block14;
                        }
                        case 6: {
                            if (!needComma) {
                                problemOffset = this.LA(1).getOffset();
                                throw this.backtrack;
                            }
                            endOffset = this.consume().getEndOffset();
                            needComma = false;
                            continue block10;
                        }
                        case 1: 
                        case 140: {
                            problemOffset = this.LA(1).getOffset();
                            if (needComma) {
                                throw this.backtrack;
                            }
                            IASTName etorName = this.identifier();
                            IASTEnumerationSpecifier.IASTEnumerator enumerator = this.nodeFactory.newEnumerator(etorName, null);
                            endOffset = this.calculateEndOffset(etorName);
                            this.setRange(enumerator, problemOffset, endOffset);
                            List<IASTAttributeSpecifier> attributes = this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
                            this.addAttributeSpecifiers(attributes, enumerator);
                            result.addEnumerator(enumerator);
                            if (this.LTcatchEOF(1) == 38) {
                                problemOffset = this.consume().getOffset();
                                IASTExpression value = this.constantExpression();
                                enumerator.setValue(value);
                                this.adjustLength(enumerator, value);
                                endOffset = this.calculateEndOffset(value);
                            }
                            needComma = true;
                            continue block10;
                        }
                        default: {
                            problemOffset = this.LA(1).getOffset();
                            throw this.backtrack;
                        }
                    }
                    break;
                }
            }
            catch (EndOfFileException eof) {
                this.throwBacktrack(this.createProblem(0x4000001, problemOffset, this.getEndOffset() - problemOffset), result);
            }
            catch (BacktrackException bt) {
                IASTProblem problem = this.skipProblemEnumerator(problemOffset);
                this.throwBacktrack(problem, result);
            }
        }
        return endOffset;
    }

    protected abstract IASTStatement statement() throws EndOfFileException, BacktrackException;

    protected IASTExpression condition(boolean followedByParenthesis) throws BacktrackException, EndOfFileException {
        IToken mark;
        block6: {
            mark = this.mark();
            try {
                IASTExpression expr = this.expression();
                if (!followedByParenthesis) {
                    return expr;
                }
                switch (this.LT(1)) {
                    case 9: 
                    case 141: {
                        return expr;
                    }
                }
            }
            catch (BacktrackException b) {
                if (followedByParenthesis) break block6;
                throw b;
            }
        }
        this.backup(mark);
        return this.skipProblemConditionInParenthesis(mark.getOffset());
    }

    @Override
    public boolean encounteredError() {
        return !this.parsePassed;
    }

    protected abstract IASTDeclaration declaration(DeclarationOptions var1) throws BacktrackException, EndOfFileException;

    protected Decl declSpecifierSeq(DeclarationOptions option) throws BacktrackException, EndOfFileException {
        return this.declSpecifierSeq(option, null);
    }

    protected abstract Decl declSpecifierSeq(DeclarationOptions var1, ITemplateIdStrategy var2) throws BacktrackException, EndOfFileException;

    protected Decl declSpecifierSequence_initDeclarator(DeclarationOptions option, boolean acceptCompoundWithoutDtor) throws EndOfFileException, FoundAggregateInitializer, BacktrackException {
        return this.declSpecifierSequence_initDeclarator(option, acceptCompoundWithoutDtor, null);
    }

    protected Decl declSpecifierSequence_initDeclarator(DeclarationOptions option, boolean acceptCompoundWithoutDtor, ITemplateIdStrategy strat) throws EndOfFileException, FoundAggregateInitializer, BacktrackException {
        IASTDeclarator dtor2;
        IASTDeclarator dtor1;
        boolean acceptEmpty;
        Decl result = this.declSpecifierSeq(option, strat);
        int lt1 = this.LTcatchEOF(1);
        if (lt1 == 141) {
            return result;
        }
        boolean bl = acceptEmpty = acceptCompoundWithoutDtor && this.isLegalWithoutDtor(result.fDeclSpec1);
        if (acceptEmpty) {
            switch (lt1) {
                case 0: 
                case 5: 
                case 141: {
                    return result;
                }
            }
        }
        IToken dtorMark1 = this.mark();
        IToken dtorMark2 = result.fDtorToken1;
        IASTDeclSpecifier declspec1 = result.fDeclSpec1;
        IASTDeclSpecifier declspec2 = result.fDeclSpec2;
        try {
            dtor1 = this.initDeclarator(declspec1, option);
        }
        catch (BacktrackException e) {
            if (acceptEmpty) {
                this.backup(dtorMark1);
                dtor1 = null;
            }
            if (dtorMark2 == null) {
                throw e;
            }
            this.backup(dtorMark2);
            IASTDeclarator dtor22 = this.initDeclarator(declspec2, option);
            return result.set(declspec2, dtor22, dtorMark2);
        }
        if (dtorMark2 == null) {
            return result.set(declspec1, dtor1, dtorMark1);
        }
        IToken end1 = this.mark();
        this.backup(dtorMark2);
        try {
            dtor2 = this.initDeclarator(declspec2, option);
        }
        catch (BacktrackException e) {
            this.backup(end1);
            return result.set(declspec1, dtor1, dtorMark1);
        }
        IToken end2 = this.mark();
        if (end1 == end2) {
            return result.set(declspec1, dtor1, declspec2, dtor2);
        }
        if (end1.getEndOffset() > end2.getEndOffset()) {
            this.backup(end1);
            return result.set(declspec1, dtor1, dtorMark1);
        }
        return result.set(declspec2, dtor2, dtorMark2);
    }

    protected boolean isLegalWithoutDtor(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof IASTCompositeTypeSpecifier) {
            return true;
        }
        if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            return true;
        }
        return declSpec instanceof IASTEnumerationSpecifier;
    }

    protected IASTDeclaration[] problemDeclaration(int offset, BacktrackException bt, DeclarationOptions option) {
        IToken la1;
        this.failParse();
        IASTProblem origProblem = this.createProblem(bt);
        IASTNode n = bt.getNodeBeforeProblem();
        if (n instanceof IASTDeclaration && ((la1 = this.LAcatchEOF(1)) == null || la1.getOffset() > offset)) {
            this.declarationMark = null;
            return new IASTDeclaration[]{(IASTDeclaration)n, this.buildProblemDeclaration(origProblem)};
        }
        if (this.declarationMark != null && this.isActiveCode()) {
            IASTProblemDeclaration trailingProblem = null;
            offset = this.declarationMark.getOffset();
            IASTDeclaration decl = null;
            int endOffset = 0;
            block6: while (this.declarationMark != null && this.declarationMark.getType() == 1) {
                endOffset = this.declarationMark.getEndOffset();
                this.declarationMark = this.declarationMark.getNext();
                if (this.declarationMark == null) continue;
                this.backup(this.declarationMark);
                switch (this.LTcatchEOF(1)) {
                    case 0: 
                    case 5: 
                    case 141: {
                        break block6;
                    }
                    default: {
                        try {
                            decl = this.declaration(option);
                        }
                        catch (BacktrackException bt2) {
                            n = bt2.getNodeBeforeProblem();
                            if (!(n instanceof IASTDeclaration)) continue block6;
                            decl = (IASTDeclaration)n;
                            trailingProblem = this.buildProblemDeclaration(bt2.getProblem());
                        }
                        catch (EndOfFileException e) {
                            endOffset = this.getEndOffset();
                        }
                        break block6;
                    }
                }
            }
            this.declarationMark = null;
            if (decl != null) {
                IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
                IASTProblemDeclaration pd = this.buildProblemDeclaration(problem);
                if (trailingProblem != null) {
                    return new IASTDeclaration[]{pd, decl, trailingProblem};
                }
                return new IASTDeclaration[]{pd, decl};
            }
        }
        return new IASTDeclaration[]{this.skipProblemDeclaration(offset, origProblem)};
    }

    protected IASTDeclaration asmDeclaration() throws EndOfFileException, BacktrackException {
        int offset = this.consume().getOffset();
        if (this.LT(1) == 124) {
            this.consume();
        }
        if (this.supportFunctionStyleAsm && this.LT(1) != 8) {
            return this.functionStyleAsmDeclaration();
        }
        StringBuilder buffer = new StringBuilder();
        this.asmExpression(buffer);
        int lastOffset = this.consume(5).getEndOffset();
        return this.buildASMDirective(offset, buffer.toString(), lastOffset);
    }

    protected IASTDeclaration functionStyleAsmDeclaration() throws BacktrackException, EndOfFileException {
        IASTDeclarator fdtor;
        IASTDeclarator dtor;
        IASTDeclSpecifier declSpec;
        int offset = this.LA(1).getOffset();
        try {
            Decl decl = this.declSpecifierSequence_initDeclarator(DeclarationOptions.FUNCTION_STYLE_ASM, false);
            declSpec = decl.fDeclSpec1;
            dtor = decl.fDtor1;
        }
        catch (FoundAggregateInitializer lie) {
            declSpec = lie.fDeclSpec;
            dtor = this.addInitializer(lie, DeclarationOptions.FUNCTION_STYLE_ASM);
        }
        if (this.LT(1) != 12) {
            this.throwBacktrack(this.LA(1));
        }
        if (!((fdtor = ASTQueries.findTypeRelevantDeclarator(dtor)) instanceof IASTFunctionDeclarator)) {
            this.throwBacktrack(offset, this.LA(1).getEndOffset() - offset);
        }
        int compoundOffset = this.LA(1).getOffset();
        int endOffset = this.skipOverCompoundStatement(false).getEndOffset();
        IASTCompoundStatement cs = this.nodeFactory.newCompoundStatement();
        ((ASTNode)((Object)cs)).setOffsetAndLength(compoundOffset, endOffset - compoundOffset);
        IASTFunctionDefinition funcDefinition = this.nodeFactory.newFunctionDefinition(declSpec, (IASTFunctionDeclarator)fdtor, cs);
        ((ASTNode)((Object)funcDefinition)).setOffsetAndLength(offset, endOffset - offset);
        return funcDefinition;
    }

    protected abstract IASTInitializer optionalInitializer(IASTDeclarator var1, DeclarationOptions var2) throws EndOfFileException, BacktrackException;

    protected IASTDeclarator addInitializer(FoundAggregateInitializer e, DeclarationOptions options) throws EndOfFileException, BacktrackException {
        IASTDeclarator d = e.fDeclarator;
        IASTInitializer i = this.optionalInitializer(d, options);
        if (i != null) {
            d.setInitializer(i);
            ((ASTNode)((Object)d)).setLength(this.calculateEndOffset(i) - ((ASTNode)((Object)d)).getOffset());
        }
        return d;
    }

    protected IToken asmExpression(StringBuilder content) throws EndOfFileException, BacktrackException {
        IToken t = this.consume(8);
        boolean needspace = false;
        int open = 1;
        block5: while (open > 0) {
            t = this.consume();
            switch (t.getType()) {
                case 8: {
                    ++open;
                    break;
                }
                case 9: {
                    --open;
                    break;
                }
                case 141: {
                    throw new EndOfFileException(t.getOffset());
                }
                default: {
                    if (content == null) continue block5;
                    if (needspace) {
                        content.append(' ');
                    }
                    content.append(t.getCharImage());
                    needspace = true;
                }
            }
        }
        return t;
    }

    protected IASTASMDeclaration buildASMDirective(int offset, String assembly, int lastOffset) {
        IASTASMDeclaration result = this.nodeFactory.newASMDeclaration(assembly);
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, lastOffset - offset);
        return result;
    }

    protected IASTCastExpression buildCastExpression(int op, IASTTypeId typeId, IASTExpression operand, int offset, int endOffset) {
        IASTCastExpression result = this.nodeFactory.newCastExpression(op, typeId, operand);
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
        return result;
    }

    protected IASTStatement parseDeclarationOrExpressionStatement() throws EndOfFileException, BacktrackException {
        return this.parseDeclarationOrExpressionStatement(null);
    }

    protected IASTStatement parseDeclarationOrExpressionStatement(List<IASTAttributeSpecifier> attributeSpecifiers) throws EndOfFileException, BacktrackException {
        IASTDeclarator[] declarators;
        IASTSimpleDeclaration simpleDecl;
        IASTDeclSpecifier declspec;
        IASTDeclaration declaration;
        IASTBinaryExpression exp;
        IASTDeclarationStatement ds;
        boolean foundSemicolon;
        IToken afterExpression;
        IASTExpressionStatement expressionStatement;
        block13: {
            IToken mark = this.mark();
            expressionStatement = null;
            afterExpression = null;
            foundSemicolon = false;
            try {
                IASTExpression expression = this.expression();
                expressionStatement = this.nodeFactory.newExpressionStatement(expression);
                this.addAttributeSpecifiers(attributeSpecifiers, expressionStatement);
                this.setRange(expressionStatement, expression);
                afterExpression = this.LA();
                IToken semi = this.consumeOrEOC(5);
                foundSemicolon = true;
                this.adjustEndOffset(expressionStatement, semi.getEndOffset());
                afterExpression = this.LA();
            }
            catch (BacktrackException expression) {
                // empty catch block
            }
            this.backup(mark);
            ds = null;
            try {
                IASTDeclaration d = this.declaration(DeclarationOptions.LOCAL);
                if (d instanceof IASTAttributeOwner) {
                    this.addAttributeSpecifiers(attributeSpecifiers, (IASTAttributeOwner)((Object)d));
                }
                ds = this.nodeFactory.newDeclarationStatement(d);
                this.setRange(ds, d);
            }
            catch (BacktrackException b) {
                IASTNode node = b.getNodeBeforeProblem();
                boolean isProblemDecl = node instanceof IASTDeclaration;
                if (expressionStatement != null && (foundSemicolon || !isProblemDecl || !node.contains(expressionStatement))) break block13;
                if (isProblemDecl) {
                    ds = this.nodeFactory.newDeclarationStatement((IASTDeclaration)node);
                    b.initialize(b.getProblem(), this.setRange(ds, node));
                }
                throw b;
            }
        }
        if (ds == null) {
            this.backup(afterExpression);
            if (foundSemicolon) {
                return expressionStatement;
            }
            this.throwBacktrack(this.createProblem(0x4000002, this.calculateEndOffset(expressionStatement) - 1, 1), expressionStatement);
            return null;
        }
        if (expressionStatement == null || !foundSemicolon) {
            return ds;
        }
        if (expressionStatement.getExpression() instanceof IASTBinaryExpression && (exp = (IASTBinaryExpression)expressionStatement.getExpression()).getOperator() == 17) {
            IASTExpression lhs = exp.getOperand1();
            if (lhs instanceof IASTBinaryExpression && ((IASTBinaryExpression)lhs).getOperator() == 1) {
                return ds;
            }
            if (lhs instanceof IASTFunctionCallExpression && !this.functionCallCanBeLValue) {
                return ds;
            }
        }
        if ((declaration = ds.getDeclaration()) instanceof IASTSimpleDeclaration && (declspec = (simpleDecl = (IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTNamedTypeSpecifier && (declarators = simpleDecl.getDeclarators()).length == 0) {
            this.backup(afterExpression);
            return expressionStatement;
        }
        IASTAmbiguousStatement statement = this.createAmbiguousStatement();
        statement.addStatement(expressionStatement);
        statement.addStatement(ds);
        return this.setRange(statement, ds);
    }

    protected static boolean isImplicitInt(IASTDeclaration declaration) {
        IASTDeclSpecifier declSpec;
        return declaration instanceof IASTSimpleDeclaration && (declSpec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)declSpec).getType() == 0;
    }

    protected abstract IASTAmbiguousStatement createAmbiguousStatement();

    protected IASTStatement parseLabelStatement() throws EndOfFileException, BacktrackException {
        int offset = this.LA(1).getOffset();
        IASTName name = this.identifier();
        this.consume(4);
        IASTStatement nestedStatement = this.statement();
        int lastOffset = this.calculateEndOffset(nestedStatement);
        IASTLabelStatement label_statement = this.nodeFactory.newLabelStatement(name, nestedStatement);
        this.setRange(label_statement, offset, lastOffset);
        return label_statement;
    }

    protected IASTStatement parseNullStatement() throws EndOfFileException, BacktrackException {
        IToken t = this.consume();
        IASTNullStatement null_statement = this.nodeFactory.newNullStatement();
        ((ASTNode)((Object)null_statement)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
        return null_statement;
    }

    protected IASTStatement parseGotoStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume(85).getOffset();
        IASTStatement gotoStatement = null;
        if (this.LT(1) == 23) {
            IASTExpression gotoLabelNameExpression = this.expression();
            gotoStatement = this.nodeFactory.newGotoStatement(gotoLabelNameExpression);
        } else {
            IASTName gotoLabelName = this.identifier();
            gotoStatement = this.nodeFactory.newGotoStatement(gotoLabelName);
        }
        int lastOffset = this.consume(5).getEndOffset();
        ((ASTNode)((Object)gotoStatement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return gotoStatement;
    }

    protected IASTStatement parseBreakStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        int lastOffset = this.consume(5).getEndOffset();
        IASTBreakStatement break_statement = this.nodeFactory.newBreakStatement();
        ((ASTNode)((Object)break_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return break_statement;
    }

    protected IASTStatement parseSwitchBody() throws EndOfFileException, BacktrackException {
        IASTStatement stmt = null;
        if (this.LT(1) != 141) {
            stmt = this.statement();
        }
        if (!(stmt instanceof IASTCaseStatement) && !(stmt instanceof IASTDefaultStatement)) {
            return stmt;
        }
        IASTCompoundStatement comp = this.nodeFactory.newCompoundStatement();
        ((ASTNode)((Object)comp)).setOffsetAndLength((ASTNode)((Object)stmt));
        comp.addStatement(stmt);
        while (this.LT(1) != 141 && (stmt instanceof IASTCaseStatement || stmt instanceof IASTDefaultStatement)) {
            stmt = this.statement();
            comp.addStatement(stmt);
        }
        this.adjustLength(comp, stmt);
        return comp;
    }

    protected IASTStatement parseContinueStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        int lastOffset = this.consume(5).getEndOffset();
        IASTContinueStatement continue_statement = this.nodeFactory.newContinueStatement();
        ((ASTNode)((Object)continue_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return continue_statement;
    }

    protected IASTStatement parseReturnStatement() throws EndOfFileException, BacktrackException {
        int offset = this.consume(103).getOffset();
        IASTExpression expr = null;
        if (this.LT(1) != 5) {
            expr = this.expression();
        }
        int endOffset = this.consumeOrEOC(5).getEndOffset();
        return this.setRange(this.nodeFactory.newReturnStatement(expr), offset, endOffset);
    }

    protected IASTStatement parseDoStatement() throws EndOfFileException, BacktrackException {
        int lastOffset;
        int startOffset = this.consume().getOffset();
        IASTStatement do_body = this.statement();
        IASTExpression do_condition = null;
        if (this.LT(1) != 141) {
            this.consume(126);
            this.consume(8);
            do_condition = this.condition(true);
        }
        switch (this.LT(1)) {
            case 9: 
            case 141: {
                this.consume();
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        switch (this.LT(1)) {
            case 5: 
            case 141: {
                lastOffset = this.consume().getEndOffset();
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        IASTDoStatement do_statement = this.nodeFactory.newDoStatement(do_body, do_condition);
        ((ASTNode)((Object)do_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return do_statement;
    }

    protected IASTStatement parseWhileStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        this.consume(8);
        IASTExpression while_condition = this.condition(true);
        switch (this.LT(1)) {
            case 9: {
                this.consume();
                break;
            }
            case 141: {
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTStatement while_body = null;
        if (this.LT(1) != 141) {
            while_body = this.statement();
        }
        IASTWhileStatement while_statement = this.nodeFactory.newWhileStatement(while_condition, while_body);
        ((ASTNode)((Object)while_statement)).setOffsetAndLength(startOffset, (while_body != null ? this.calculateEndOffset(while_body) : this.LA(1).getEndOffset()) - startOffset);
        return while_statement;
    }

    protected void reconcileLengths(IASTIfStatement result) {
        if (result == null) {
            return;
        }
        IASTIfStatement current = result;
        while (current.getElseClause() instanceof IASTIfStatement) {
            current = (IASTIfStatement)current.getElseClause();
        }
        while (current != null) {
            ASTNode r = (ASTNode)((Object)current);
            if (current.getElseClause() != null) {
                ASTNode else_clause = (ASTNode)((Object)current.getElseClause());
                r.setLength(else_clause.getOffset() + else_clause.getLength() - r.getOffset());
            } else {
                ASTNode then_clause = (ASTNode)((Object)current.getThenClause());
                if (then_clause != null) {
                    r.setLength(then_clause.getOffset() + then_clause.getLength() - r.getOffset());
                }
            }
            current = current.getParent() != null && current.getParent() instanceof IASTIfStatement ? (IASTIfStatement)current.getParent() : null;
        }
    }

    protected IASTStatement parseCompoundStatement() throws EndOfFileException, BacktrackException {
        IASTCompoundStatement compound = this.compoundStatement();
        return compound;
    }

    protected IASTStatement parseDefaultStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume(71).getOffset();
        int lastOffset = this.consume(4).getEndOffset();
        IASTDefaultStatement df = this.nodeFactory.newDefaultStatement();
        ((ASTNode)((Object)df)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return df;
    }

    protected IASTStatement parseCaseStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        IASTExpression caseExpression = this.constantExpression();
        int lt1 = this.LT(1);
        if (lt1 == 48) {
            this.consume();
            IASTExpression upperBoundExpression = this.constantExpression();
            caseExpression = this.buildBinaryExpression(34, caseExpression, upperBoundExpression, this.calculateEndOffset(upperBoundExpression));
            lt1 = this.LT(1);
        }
        int lastOffset = 0;
        switch (lt1) {
            case 4: 
            case 141: {
                lastOffset = this.consume().getEndOffset();
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTCaseStatement cs = this.nodeFactory.newCaseStatement(caseExpression);
        ((ASTNode)((Object)cs)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return cs;
    }

    protected int figureEndOffset(IASTDeclSpecifier declSpec, IASTDeclarator[] declarators) {
        if (declarators.length == 0) {
            return this.calculateEndOffset(declSpec);
        }
        return this.calculateEndOffset(declarators[declarators.length - 1]);
    }

    protected int figureEndOffset(IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) {
        if (declarator == null || ((ASTNode)((Object)declarator)).getLength() == 0) {
            return this.calculateEndOffset(declSpecifier);
        }
        return this.calculateEndOffset(declarator);
    }

    protected void throwBacktrack(IToken token) throws BacktrackException {
        this.throwBacktrack(token.getOffset(), token.getLength());
    }

    protected IASTExpression parseTypeidInParenthesisOrUnaryExpression(boolean exprIsLimitedToParenthesis, int offset, int typeExprKind, int unaryExprKind, CastExprCtx ctx, ITemplateIdStrategy strat) throws BacktrackException, EndOfFileException {
        IASTExpression result2;
        CastAmbiguityMarker ca;
        IASTTypeId typeid;
        int endOffset2;
        int endOffset1;
        IToken typeidLA;
        IASTExpression expr;
        block22: {
            expr = null;
            typeidLA = null;
            IToken mark = this.mark();
            endOffset1 = -1;
            endOffset2 = -1;
            try {
                this.consume(8);
                int typeidOffset = this.LA(1).getOffset();
                typeid = this.typeId(DeclarationOptions.TYPEID);
                if (!this.isValidTypeIDForUnaryExpression(unaryExprKind, typeid)) {
                    typeid = null;
                } else {
                    switch (this.LT(1)) {
                        case 9: 
                        case 141: {
                            endOffset1 = this.consume().getEndOffset();
                            typeidLA = this.LA(1);
                            break;
                        }
                        case 6: {
                            if (this.supportExtendedSizeofOperator && typeExprKind == 0) {
                                this.consume();
                                IASTExpression expr2 = this.expression();
                                endOffset1 = this.consumeOrEOC(9).getEndOffset();
                                expr = this.nodeFactory.newTypeIdExpression(3, typeid);
                                this.setRange(expr, typeidOffset, this.calculateEndOffset(typeid));
                                IASTExpressionList expressionList = this.nodeFactory.newExpressionList();
                                ((ASTNode)((Object)expressionList)).setOffsetAndLength(typeidOffset, this.calculateEndOffset(expr2) - typeidOffset);
                                expressionList.addExpression(expr);
                                if (expr2 instanceof IASTExpressionList) {
                                    IASTExpression[] iASTExpressionArray = ((IASTExpressionList)expr2).getExpressions();
                                    int n = iASTExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IASTExpression e = iASTExpressionArray[n2];
                                        expressionList.addExpression(e);
                                        ++n2;
                                    }
                                } else {
                                    expressionList.addExpression(expr2);
                                }
                                return this.buildUnaryExpression(unaryExprKind, expressionList, offset, endOffset1);
                            }
                            typeid = null;
                            break;
                        }
                        default: {
                            typeid = null;
                            break;
                        }
                    }
                }
            }
            catch (BacktrackException e) {
                typeid = null;
            }
            ca = null;
            this.backup(mark);
            try {
                if (exprIsLimitedToParenthesis) {
                    this.consume(8);
                    expr = this.expression();
                    endOffset2 = this.consumeOrEOC(9).getEndOffset();
                } else {
                    expr = this.unaryExpression(ctx, strat);
                    if (expr instanceof CastAmbiguityMarker) {
                        ca = (CastAmbiguityMarker)expr;
                        expr = ca.getExpression();
                        assert (!(expr instanceof CastAmbiguityMarker));
                    }
                    endOffset2 = this.calculateEndOffset(expr);
                }
            }
            catch (BacktrackException bte) {
                if (typeid != null) break block22;
                throw bte;
            }
        }
        IASTTypeIdExpression result1 = null;
        if (typeid != null && endOffset1 >= endOffset2) {
            IASTTypeIdExpression typeIdExpression = this.nodeFactory.newTypeIdExpression(typeExprKind, typeid);
            this.setRange(typeIdExpression, offset, endOffset1);
            result1 = typeIdExpression;
            this.backup(typeidLA);
            if (expr == null || endOffset1 > endOffset2) {
                return result1;
            }
        }
        IASTExpression iASTExpression = result2 = unaryExprKind == -1 ? expr : this.buildUnaryExpression(unaryExprKind, expr, offset, endOffset2);
        if (ca != null) {
            result2 = ca.updateExpression(result2);
        }
        if (result1 == null) {
            return result2;
        }
        IASTAmbiguousExpression ambExpr = this.createAmbiguousExpression();
        ambExpr.addExpression(result1);
        ambExpr.addExpression(result2);
        ((ASTNode)((Object)ambExpr)).setOffsetAndLength((ASTNode)((Object)result1));
        return ambExpr;
    }

    private boolean isValidTypeIDForUnaryExpression(int unaryExprKind, IASTTypeId typeid) {
        if (typeid == null) {
            return false;
        }
        return unaryExprKind != 8 || !(ASTQueries.findTypeRelevantDeclarator(typeid.getAbstractDeclarator()) instanceof IASTFunctionDeclarator);
    }

    protected abstract IASTAmbiguousExpression createAmbiguousExpression();

    protected abstract IASTAmbiguousExpression createAmbiguousBinaryVsCastExpression(IASTBinaryExpression var1, IASTCastExpression var2);

    protected abstract IASTAmbiguousExpression createAmbiguousCastVsFunctionCallExpression(IASTCastExpression var1, IASTFunctionCallExpression var2);

    protected IASTStatement forInitStatement() throws BacktrackException, EndOfFileException {
        if (this.LT(1) == 5) {
            return this.parseNullStatement();
        }
        try {
            return this.parseDeclarationOrExpressionStatement();
        }
        catch (BacktrackException e) {
            IASTNode before = e.getNodeBeforeProblem();
            if (before != null) {
                e.initialize(e.getProblem());
            }
            throw e;
        }
    }

    protected List<IASTAttributeSpecifier> __attribute_decl_seq(boolean allowAttrib, boolean allowDeclspec) throws BacktrackException, EndOfFileException {
        ArrayList<IASTAttributeList> result = null;
        while (true) {
            int lt = this.LTcatchEOF(1);
            if (allowAttrib && lt == 154) {
                if (result == null) {
                    result = new ArrayList<IASTAttributeList>();
                }
                result.add(this.__attribute__());
                continue;
            }
            if (!allowDeclspec || lt != 155) break;
            this.__declspec();
        }
        return result;
    }

    protected IASTAttributeList __attribute__() throws BacktrackException, EndOfFileException {
        if (this.LT(1) != 154) {
            return null;
        }
        IGCCASTAttributeList result = this.nodeFactory.newGCCAttributeList();
        this.consume();
        if (this.LT(1) == 8) {
            int lt1;
            this.consume();
            this.consume(8);
            while ((lt1 = this.LT(1)) != 9 && lt1 != 141) {
                if (lt1 != 6) {
                    result.addAttribute(this.singleAttribute());
                }
                if (this.LT(1) != 6) break;
                this.consume();
            }
            this.consumeOrEOC(9);
            this.consumeOrEOC(9);
        }
        return result;
    }

    protected IASTAttribute singleAttribute() throws EndOfFileException, BacktrackException {
        IToken nameToken = this.identifierOrKeyword();
        IASTTokenList argumentClause = null;
        int endOffset = nameToken.getEndOffset();
        if (this.LT(1) == 8) {
            int argumentOffset = this.consume().getEndOffset();
            argumentClause = this.balancedTokenSeq(argumentOffset, 9);
            endOffset = this.consumeOrEOC(9).getEndOffset();
        }
        char[] attributeName = nameToken.getCharImage();
        IASTAttribute result = this.nodeFactory.newAttribute(attributeName, argumentClause);
        this.setRange(result, nameToken.getOffset(), endOffset);
        return result;
    }

    protected void addAttributeSpecifiers(List<IASTAttributeSpecifier> specifiers, IASTAttributeOwner owner) {
        if (specifiers != null && owner != null) {
            for (IASTAttributeSpecifier specifier : specifiers) {
                owner.addAttributeSpecifier(specifier);
            }
        }
    }

    protected IToken identifierOrKeyword() throws EndOfFileException, BacktrackException {
        IToken t = this.LA(1);
        char[] image = t.getCharImage();
        if (image.length == 0) {
            throw this.backtrack;
        }
        char firstChar = image[0];
        if (!Character.isLetter(firstChar) && firstChar != '_') {
            throw this.backtrack;
        }
        this.consume();
        return t;
    }

    protected IASTTokenList balancedTokenSeq(int offset, int endType) throws EndOfFileException, BacktrackException {
        IToken t;
        IASTTokenList result = this.nodeFactory.newTokenList();
        block5: while ((t = this.LA(1)).getType() != endType) {
            IASTToken token;
            t = this.consume();
            if (t.getType() == 140 || t.getType() == 141) break;
            result.addToken(this.createASTToken(t));
            switch (t.getType()) {
                case 8: {
                    token = this.balancedTokenSeq(t.getOffset(), 9);
                    break;
                }
                case 10: {
                    token = this.balancedTokenSeq(t.getOffset(), 11);
                    break;
                }
                case 12: {
                    token = this.balancedTokenSeq(t.getOffset(), 13);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            result.addToken(token);
            t = this.consume();
            token = this.createASTToken(t);
            result.addToken(token);
        }
        this.setRange(result, offset, t.getEndOffset());
        return result;
    }

    private IASTToken createASTToken(IToken t) {
        IASTToken token = this.nodeFactory.newToken(t.getType(), t.getCharImage());
        this.setRange(token, t.getOffset(), t.getEndOffset());
        return token;
    }

    protected void __declspec() throws BacktrackException, EndOfFileException {
        IToken token = this.LA(1);
        if (token.getType() == 155) {
            this.consume();
            if (this.LT(1) == 8) {
                this.skipBrackets(8, 9, 0);
            }
        }
    }

    protected void handleOtherDeclSpecModifier() throws BacktrackException, EndOfFileException {
        this.consume();
        IToken token = this.LA(1);
        if (token.getType() == 8) {
            this.consume();
            int openParen = 1;
            while (true) {
                token = this.LA(1);
                this.consume();
                if (token.getType() == 8) {
                    ++openParen;
                    continue;
                }
                if (token.getType() == 9 && --openParen == 0) break;
            }
        }
    }

    protected boolean canBeCompoundLiteral() throws EndOfFileException {
        IToken m = this.mark();
        try {
            this.skipBrackets(8, 9, 5);
            boolean bl = this.LTcatchEOF(1) == 12;
            return bl;
        }
        catch (BacktrackException bt) {
            return false;
        }
        finally {
            this.backup(m);
        }
    }

    protected boolean canBeCastExpression() throws EndOfFileException {
        IToken m = this.mark();
        try {
            this.skipBrackets(8, 9, 5);
            switch (this.LTcatchEOF(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: 
                case 28: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 5201: {
                    return false;
                }
            }
            return true;
        }
        catch (BacktrackException bt) {
            return false;
        }
        finally {
            this.backup(m);
        }
    }

    protected boolean canBeTypeSpecifier() throws EndOfFileException {
        int lt1 = this.LT(1);
        switch (lt1) {
            case 1: 
            case 3: 
            case 57: 
            case 60: 
            case 64: 
            case 65: 
            case 67: 
            case 74: 
            case 77: 
            case 82: 
            case 88: 
            case 89: 
            case 104: 
            case 108: 
            case 109: 
            case 118: 
            case 119: 
            case 120: 
            case 123: 
            case 124: 
            case 125: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 140: 
            case 150: 
            case 154: 
            case 175: 
            case 176: 
            case 179: 
            case 180: 
            case 181: 
            case 5202: 
            case 5203: 
            case 5204: {
                return true;
            }
        }
        return lt1 >= 243 && lt1 <= 253;
    }

    protected void skipBrackets(int left, int right, int terminator) throws EndOfFileException, BacktrackException {
        this.consume(left);
        int nesting = 0;
        int braceNesting = 0;
        while (true) {
            int lt1;
            if ((lt1 = this.LT(1)) == 141) {
                this.throwBacktrack(this.LA(1));
            }
            if (lt1 == 12) {
                ++braceNesting;
            } else if (lt1 == 13) {
                --braceNesting;
            }
            if (braceNesting > 0) {
                this.consume();
                continue;
            }
            if (lt1 == terminator) {
                this.throwBacktrack(this.LA(1));
            }
            this.consume();
            if (lt1 == left) {
                ++nesting;
                continue;
            }
            if (lt1 == right && --nesting < 0) break;
        }
    }

    protected abstract IASTAlignmentSpecifier createAmbiguousAlignmentSpecifier(IASTAlignmentSpecifier var1, IASTAlignmentSpecifier var2);

    protected IASTAlignmentSpecifier alignmentSpecifier() throws BacktrackException, EndOfFileException {
        IASTAlignmentSpecifier result;
        IToken typeIdEnd;
        IASTExpression expression;
        IASTTypeId typeId;
        int startOffset;
        block11: {
            startOffset = this.consume(5900, 51000).getOffset();
            this.consume(8);
            typeId = null;
            expression = null;
            IToken beginning = this.mark();
            typeIdEnd = null;
            try {
                typeId = this.typeIdWithOptionalTrailingEllipsis(DeclarationOptions.TYPEID);
                typeIdEnd = this.mark();
            }
            catch (BacktrackException backtrackException) {
                // empty catch block
            }
            this.backup(beginning);
            try {
                expression = this.expressionWithOptionalTrailingEllipsis();
            }
            catch (BacktrackException e) {
                if (typeId != null) break block11;
                throw e;
            }
        }
        if (typeId == null) {
            result = this.nodeFactory.newAlignmentSpecifier(expression);
        } else if (expression == null) {
            this.backup(typeIdEnd);
            result = this.nodeFactory.newAlignmentSpecifier(typeId);
        } else if (expression.contains(typeId)) {
            if (typeId.contains(expression)) {
                int endOffset = this.consume(9).getEndOffset();
                IASTAlignmentSpecifier expressionAlternative = this.nodeFactory.newAlignmentSpecifier(expression);
                IASTAlignmentSpecifier typeIdAlternative = this.nodeFactory.newAlignmentSpecifier(typeId);
                this.setRange(expressionAlternative, startOffset, endOffset);
                this.setRange(typeIdAlternative, startOffset, endOffset);
                return this.createAmbiguousAlignmentSpecifier(expressionAlternative, typeIdAlternative);
            }
            result = this.nodeFactory.newAlignmentSpecifier(expression);
        } else {
            this.backup(typeIdEnd);
            result = this.nodeFactory.newAlignmentSpecifier(typeId);
        }
        int endOffset = this.consume(9).getEndOffset();
        this.setRange(result, startOffset, endOffset);
        return result;
    }

    public static class BinaryOperator {
        final int fOperatorToken;
        final int fLeftPrecedence;
        final int fRightPrecedence;
        BinaryOperator fNext;
        IASTInitializerClause fExpression;
        final CastAmbiguityMarker fAmbiguityMarker;

        public BinaryOperator(BinaryOperator nextOp, IASTInitializerClause expression, int operatorToken, int leftPrecedence, int rightPrecedence) {
            this.fNext = nextOp;
            this.fOperatorToken = operatorToken;
            this.fLeftPrecedence = leftPrecedence;
            this.fRightPrecedence = rightPrecedence;
            if (expression instanceof CastAmbiguityMarker) {
                this.fAmbiguityMarker = (CastAmbiguityMarker)expression;
                this.fExpression = this.fAmbiguityMarker.fExpression;
                this.fAmbiguityMarker.fExpression = null;
            } else {
                this.fExpression = expression;
                this.fAmbiguityMarker = null;
            }
        }

        public IASTInitializerClause exchange(IASTInitializerClause expr) {
            IASTInitializerClause e = this.fExpression;
            this.fExpression = expr;
            return e;
        }

        public IASTInitializerClause getExpression() {
            return this.fExpression;
        }

        public BinaryOperator getNext() {
            return this.fNext;
        }

        public void setNext(BinaryOperator next) {
            this.fNext = next;
        }
    }

    private static final class CastAmbiguityMarker
    extends ASTNode
    implements IASTExpression {
        private IASTExpression fExpression;
        private final IASTTypeId fTypeIdForCast;
        private final int fUnaryOperatorOffset;

        CastAmbiguityMarker(IASTExpression unary, IASTTypeId typeIdForCast, int unaryOperatorOffset) {
            this.fExpression = unary;
            this.fTypeIdForCast = typeIdForCast;
            this.fUnaryOperatorOffset = unaryOperatorOffset;
        }

        public CastAmbiguityMarker updateExpression(IASTExpression expression) {
            this.fExpression = expression;
            return this;
        }

        public IASTExpression getExpression() {
            return this.fExpression;
        }

        public IASTTypeId getTypeIdForCast() {
            return this.fTypeIdForCast;
        }

        public int getUnaryOperatorOffset() {
            return this.fUnaryOperatorOffset;
        }

        @Override
        public IASTExpression copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IASTExpression copy(IASTNode.CopyStyle style) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IType getExpressionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IASTExpression.ValueCategory getValueCategory() {
            throw new UnsupportedOperationException();
        }
    }

    protected static enum CastExprCtx {
        eDirectlyInBExpr,
        eInBExpr,
        eNotInBExpr;

    }

    protected static class Decl {
        public IASTDeclSpecifier fDeclSpec1;
        public IASTDeclSpecifier fDeclSpec2;
        public IASTDeclarator fDtor1;
        public IASTDeclarator fDtor2;
        public IToken fDtorToken1;

        public Decl set(IASTDeclSpecifier declspec, IASTDeclarator dtor, IToken dtorToken) {
            this.fDeclSpec1 = declspec;
            this.fDtor1 = dtor;
            this.fDtorToken1 = dtorToken;
            this.fDeclSpec2 = null;
            this.fDtor2 = null;
            return this;
        }

        public Decl set(IASTDeclSpecifier declspec1, IASTDeclarator dtor1, IASTDeclSpecifier declspec2, IASTDeclarator dtor2) {
            this.fDeclSpec1 = declspec1;
            this.fDtor1 = dtor1;
            this.fDtorToken1 = null;
            this.fDeclSpec2 = declspec2;
            this.fDtor2 = dtor2;
            return this;
        }
    }

    protected static enum ExprKind {
        eExpression,
        eAssignment,
        eConstant;

    }

    protected static class FoundAggregateInitializer
    extends Exception {
        public final IASTDeclarator fDeclarator;
        public final IASTDeclSpecifier fDeclSpec;

        public FoundAggregateInitializer(IASTDeclSpecifier declSpec, IASTDeclarator d) {
            this.fDeclSpec = declSpec;
            this.fDeclarator = d;
        }
    }

    public static interface ITemplateIdStrategy {
        public boolean shallParseAsTemplateID(IASTName var1);
    }
}

