/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.FilterTransform;
import org.eclipse.debug.internal.ui.viewers.model.HasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.ViewerStateTracker;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckboxModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewerFilter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;

public class TreeModelContentProvider
implements ITreeModelContentProvider,
IContentProvider,
IModelChangedListener {
    private IInternalTreeModelViewer fViewer;
    private int fModelDeltaMask = -1;
    private Map<TreePath, IModelProxy> fTreeModelProxies = new HashMap<TreePath, IModelProxy>();
    private Map<Object, IModelProxy> fModelProxies = new HashMap<Object, IModelProxy>();
    private FilterTransform fTransform = new FilterTransform();
    private ListenerList<IModelChangedListener> fModelListeners = new ListenerList();
    private ListenerList<IViewerUpdateListener> fUpdateListeners = new ListenerList();
    private boolean fModelSequenceRunning = false;
    private Map<TreePath, List<ViewerUpdateMonitor>> fRequestsInProgress = new HashMap<TreePath, List<ViewerUpdateMonitor>>();
    private Map<TreePath, List<ViewerUpdateMonitor>> fWaitingRequests = new HashMap<TreePath, List<ViewerUpdateMonitor>>();
    private List<ViewerUpdateMonitor> fCompletedUpdates = new ArrayList<ViewerUpdateMonitor>();
    private Runnable fCompletedUpdatesRunnable;
    private ViewerStateTracker fStateTracker = new ViewerStateTracker(this);
    private TreePath fRevealPath;
    private int fRevealIndex;
    static final int UPDATE_SEQUENCE_BEGINS = 0;
    static final int UPDATE_SEQUENCE_COMPLETE = 1;
    static final int UPDATE_BEGINS = 2;
    static final int UPDATE_COMPLETE = 3;
    static final TreePath EMPTY_TREE_PATH = new TreePath(new Object[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.fViewer == null) {
            return;
        }
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        for (List<ViewerUpdateMonitor> requests : this.fRequestsInProgress.values()) {
            for (ViewerUpdateMonitor vu : requests) {
                vu.cancel();
            }
        }
        this.fWaitingRequests.clear();
        this.fStateTracker.dispose();
        this.fModelListeners.clear();
        this.fUpdateListeners.clear();
        this.disposeAllModelProxies();
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            this.fViewer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisposed() {
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            return this.fViewer == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            this.fViewer = (IInternalTreeModelViewer)viewer;
        }
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        if (oldInput != null) {
            this.fStateTracker.saveViewerState(oldInput);
        }
    }

    @Override
    public void postInputChanged(IInternalTreeModelViewer viewer, Object oldInput, Object newInput) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.cancelSubtreeUpdates(TreePath.EMPTY);
        this.disposeAllModelProxies();
        this.cancelSubtreeUpdates(TreePath.EMPTY);
        this.fTransform.clear();
        if (newInput != null) {
            this.installModelProxy(newInput, TreePath.EMPTY);
            this.fStateTracker.restoreViewerState(newInput);
        }
    }

    @Override
    public void addViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.add((Object)listener);
    }

    @Override
    public void removeViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.remove((Object)listener);
    }

    @Override
    public void addStateUpdateListener(IStateUpdateListener listener) {
        this.fStateTracker.addStateUpdateListener(listener);
    }

    @Override
    public void preserveState(TreePath path) {
        this.fStateTracker.appendToPendingStateDelta(path);
    }

    @Override
    public void removeStateUpdateListener(IStateUpdateListener listener) {
        this.fStateTracker.removeStateUpdateListener(listener);
    }

    @Override
    public void addModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.add((Object)listener);
    }

    @Override
    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.remove((Object)listener);
    }

    @Override
    public void cancelRestore(TreePath path, int flags) {
        this.fStateTracker.cancelRestore(path, flags);
    }

    @Override
    public boolean setChecked(TreePath path, boolean checked) {
        IModelProxy elementProxy = this.getElementProxy(path);
        if (elementProxy instanceof ICheckboxModelProxy) {
            return ((ICheckboxModelProxy)((Object)elementProxy)).setChecked(this.getPresentationContext(), this.getViewer().getInput(), path, checked);
        }
        return false;
    }

    private void installModelProxy(Object input, TreePath path) {
        if (!this.fTreeModelProxies.containsKey(path) && !this.fModelProxies.containsKey(path.getLastSegment())) {
            IModelProxyFactory modelProxyFactory;
            Object element = path.getSegmentCount() != 0 ? path.getLastSegment() : input;
            IModelProxy proxy = null;
            IModelProxyFactory2 modelProxyFactory2 = ViewerAdapterService.getModelProxyFactory2(element);
            if (modelProxyFactory2 != null && (proxy = modelProxyFactory2.createTreeModelProxy(input, path, this.getPresentationContext())) != null) {
                this.fTreeModelProxies.put(path, proxy);
            }
            if (proxy == null && (modelProxyFactory = ViewerAdapterService.getModelProxyFactory(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
                this.fModelProxies.put(element, proxy);
            }
            if (proxy instanceof IModelProxy2) {
                proxy.addModelChangedListener(this);
                ((IModelProxy2)proxy).initialize(this.getViewer());
            } else if (proxy != null) {
                final IModelProxy finalProxy = proxy;
                Job job = new Job("Model Proxy installed notification job"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        if (!monitor.isCanceled()) {
                            IPresentationContext context = null;
                            Viewer viewer = null;
                            TreeModelContentProvider treeModelContentProvider = TreeModelContentProvider.this;
                            synchronized (treeModelContentProvider) {
                                if (!TreeModelContentProvider.this.isDisposed()) {
                                    context = TreeModelContentProvider.this.getPresentationContext();
                                    viewer = (Viewer)TreeModelContentProvider.this.getViewer();
                                }
                            }
                            if (viewer != null && context != null && !finalProxy.isDisposed()) {
                                finalProxy.init(context);
                                finalProxy.addModelChangedListener(TreeModelContentProvider.this);
                                finalProxy.installed(viewer);
                            }
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean shouldRun() {
                        return !TreeModelContentProvider.this.isDisposed();
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    private IModelProxy getElementProxy(TreePath path) {
        while (path != null) {
            IModelProxy proxy = this.fTreeModelProxies.get(path);
            if (proxy != null) {
                return proxy;
            }
            Object element = path.getSegmentCount() == 0 ? this.getViewer().getInput() : path.getLastSegment();
            proxy = this.fModelProxies.get(element);
            if (proxy != null) {
                return proxy;
            }
            path = path.getParentPath();
        }
        return null;
    }

    private void disposeAllModelProxies() {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        for (IModelProxy proxy : this.fModelProxies.values()) {
            proxy.dispose();
        }
        this.fModelProxies.clear();
        for (IModelProxy proxy : this.fTreeModelProxies.values()) {
            proxy.dispose();
        }
        this.fTreeModelProxies.clear();
    }

    private void disposeModelProxy(TreePath path) {
        IModelProxy proxy = this.fTreeModelProxies.remove(path);
        if (proxy != null) {
            proxy.dispose();
        }
        if ((proxy = this.fModelProxies.remove(path.getLastSegment())) != null) {
            proxy.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelChanged(final IModelDelta delta, final IModelProxy proxy) {
        Display display = null;
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            if (this.fViewer != null && !proxy.isDisposed()) {
                display = this.fViewer.getDisplay();
            }
        }
        if (display != null) {
            if (Thread.currentThread().equals(display.getThread())) {
                this.doModelChanged(delta, proxy);
            } else {
                this.fViewer.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeModelContentProvider.this.doModelChanged(delta, proxy);
                    }
                });
            }
        }
    }

    private void doModelChanged(IModelDelta delta, IModelProxy proxy) {
        if (!proxy.isDisposed()) {
            if (DebugUIPlugin.DEBUG_DELTAS && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("RECEIVED DELTA: " + delta.toString());
            }
            this.updateModel(delta, this.getModelDeltaMask());
            this.trigger(null);
            for (IModelChangedListener iModelChangedListener : this.fModelListeners) {
                iModelChangedListener.modelChanged(delta, proxy);
            }
        }
    }

    @Override
    public void setModelDeltaMask(int mask) {
        this.fModelDeltaMask = mask;
    }

    @Override
    public int getModelDeltaMask() {
        return this.fModelDeltaMask;
    }

    @Override
    public void updateModel(IModelDelta delta, int mask) {
        if (this.getViewer() == null || this.getViewer().getInput() == null) {
            return;
        }
        this.fRevealPath = null;
        IModelDelta[] deltaArray = new IModelDelta[]{delta};
        this.updateNodes(deltaArray, mask & 0x800002);
        this.updateNodes(deltaArray, mask & 0xC00C1B & 0xFF7FFFFD);
        this.updateNodes(deltaArray, mask & 0x7300000);
        this.fStateTracker.checkIfRestoreComplete();
    }

    TreePath getFullTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (node.getParentDelta() != null) {
            list.add(0, node.getElement());
            node = node.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    TreePath getViewerTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        IModelDelta parentDelta = node.getParentDelta();
        while (parentDelta != null) {
            list.add(0, node.getElement());
            node = parentDelta;
            parentDelta = node.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IInternalTreeModelViewer getViewer() {
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            return this.fViewer;
        }
    }

    @Override
    public int viewToModelIndex(TreePath parentPath, int index) {
        return this.fTransform.viewToModelIndex(parentPath, index);
    }

    @Override
    public int viewToModelCount(TreePath parentPath, int count) {
        return this.fTransform.viewToModelCount(parentPath, count);
    }

    @Override
    public int modelToViewIndex(TreePath parentPath, int index) {
        return this.fTransform.modelToViewIndex(parentPath, index);
    }

    @Override
    public int modelToViewChildCount(TreePath parentPath, int count) {
        return this.fTransform.modelToViewCount(parentPath, count);
    }

    @Override
    public boolean areTreeModelViewerFiltersApplicable(Object parentElement) {
        ViewerFilter[] filters = this.fViewer.getFilters();
        if (filters.length > 0) {
            int j = 0;
            while (j < filters.length) {
                if (filters[j] instanceof TreeModelViewerFilter && ((TreeModelViewerFilter)filters[j]).isApplicable(this.fViewer, parentElement)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    @Override
    public boolean shouldFilter(Object parentElementOrTreePath, Object element) {
        block6: {
            ViewerFilter[] filters = this.fViewer.getFilters();
            if (filters.length <= 0) break block6;
            int j = 0;
            while (j < filters.length) {
                block8: {
                    block7: {
                        Object parentElement;
                        if (!(filters[j] instanceof TreeModelViewerFilter)) break block7;
                        Object object = parentElement = parentElementOrTreePath instanceof TreePath ? ((TreePath)parentElementOrTreePath).getLastSegment() : parentElementOrTreePath;
                        if (parentElement == null) {
                            parentElement = this.fViewer.getInput();
                        }
                        if (!((TreeModelViewerFilter)filters[j]).isApplicable(this.fViewer, parentElement)) break block8;
                    }
                    if (!filters[j].select((Viewer)this.fViewer, parentElementOrTreePath, element)) {
                        return true;
                    }
                }
                ++j;
            }
        }
        return false;
    }

    @Override
    public void unmapPath(TreePath path) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fTransform.clear(path);
        this.cancelSubtreeUpdates(path);
    }

    boolean addFilteredIndex(TreePath parentPath, int index, Object element) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        return this.fTransform.addFilteredIndex(parentPath, index, element);
    }

    void removeElementFromFilters(TreePath parentPath, int index) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fTransform.removeElementFromFilters(parentPath, index);
    }

    boolean removeElementFromFilters(TreePath parentPath, Object element) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        return this.fTransform.removeElementFromFilters(parentPath, element);
    }

    void setModelChildCount(TreePath parentPath, int childCount) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fTransform.setModelChildCount(parentPath, childCount);
    }

    boolean isFiltered(TreePath parentPath, int index) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        return this.fTransform.isFiltered(parentPath, index);
    }

    int[] getFilteredChildren(TreePath parent) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        return this.fTransform.getFilteredChildren(parent);
    }

    void clearFilteredChild(TreePath parent, int modelIndex) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fTransform.clear(parent, modelIndex);
    }

    void clearFilters(TreePath parent) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fTransform.clear(parent);
    }

    void updateStarted(ViewerUpdateMonitor update) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        List<ViewerUpdateMonitor> requests = this.fRequestsInProgress.get(update.getSchedulingPath());
        if (requests == null) {
            requests = new ArrayList<ViewerUpdateMonitor>();
            this.fRequestsInProgress.put(update.getSchedulingPath(), requests);
        }
        requests.add(update);
        if (!this.fModelSequenceRunning) {
            this.fModelSequenceRunning = true;
            if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("MODEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("\tBEGIN - " + update);
        }
        this.notifyUpdate(2, update);
    }

    void updatesComplete(final List<ViewerUpdateMonitor> updates) {
        int i = 0;
        while (i < updates.size()) {
            ViewerUpdateMonitor update = updates.get(i);
            this.notifyUpdate(3, update);
            if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("\tEND - " + update);
            }
            ++i;
        }
        this.getViewer().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TreeModelContentProvider.this.isDisposed()) {
                    return;
                }
                int i = 0;
                while (i < updates.size()) {
                    ViewerUpdateMonitor update = (ViewerUpdateMonitor)updates.get(i);
                    List requests = (List)TreeModelContentProvider.this.fRequestsInProgress.get(update.getSchedulingPath());
                    boolean found = false;
                    if (requests != null) {
                        int j = 0;
                        while (j < requests.size()) {
                            if (requests.get(j) == update) {
                                found = true;
                                requests.remove(j);
                                break;
                            }
                            ++j;
                        }
                    }
                    if (found) {
                        TreeModelContentProvider.this.trigger(update.getSchedulingPath());
                    } else {
                        Assert.isTrue((boolean)update.isCanceled());
                    }
                    if (requests != null && requests.isEmpty()) {
                        TreeModelContentProvider.this.fRequestsInProgress.remove(update.getSchedulingPath());
                    }
                    ++i;
                }
                if (TreeModelContentProvider.this.fRequestsInProgress.isEmpty() && TreeModelContentProvider.this.fWaitingRequests.isEmpty() && TreeModelContentProvider.this.fModelSequenceRunning) {
                    TreeModelContentProvider.this.fModelSequenceRunning = false;
                    if (TreeModelContentProvider.this.fRevealPath != null) {
                        TreeModelContentProvider.this.getViewer().reveal(TreeModelContentProvider.this.fRevealPath, TreeModelContentProvider.this.fRevealIndex);
                        TreeModelContentProvider.this.fRevealPath = null;
                    }
                    if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(TreeModelContentProvider.this.getPresentationContext())) {
                        DebugUIPlugin.trace("MODEL SEQUENCE ENDS");
                    }
                    TreeModelContentProvider.this.notifyUpdate(1, null);
                }
            }
        });
    }

    boolean areRequestsPending() {
        return !this.fRequestsInProgress.isEmpty() || !this.fWaitingRequests.isEmpty();
    }

    ViewerStateTracker getStateTracker() {
        return this.fStateTracker;
    }

    private void notifyUpdate(final int type, final IViewerUpdate update) {
        if (!this.fUpdateListeners.isEmpty()) {
            Iterator iterator = this.fUpdateListeners.iterator();
            while (iterator.hasNext()) {
                IViewerUpdateListener iViewerUpdateListener;
                final IViewerUpdateListener listener = iViewerUpdateListener = (IViewerUpdateListener)iterator.next();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.viewerUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.viewerUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.updateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.updateComplete(update);
                                break;
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
            }
        }
    }

    private void cancelSubtreeUpdates(TreePath path) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        for (Map.Entry<TreePath, List<ViewerUpdateMonitor>> entry : this.fRequestsInProgress.entrySet()) {
            TreePath entryPath = entry.getKey();
            if (!entryPath.startsWith(path, null)) continue;
            List<ViewerUpdateMonitor> requests = entry.getValue();
            Iterator<ViewerUpdateMonitor> reqIter = requests.iterator();
            while (reqIter.hasNext()) {
                reqIter.next().cancel();
                reqIter.remove();
            }
        }
        ArrayList<TreePath> purge = new ArrayList<TreePath>();
        for (TreePath entryPath : this.fWaitingRequests.keySet()) {
            if (!entryPath.startsWith(path, null)) continue;
            purge.add(entryPath);
        }
        for (TreePath tp : purge) {
            this.fWaitingRequests.remove(tp);
        }
        this.fStateTracker.cancelStateSubtreeUpdates(path);
    }

    private void schedule(final ViewerUpdateMonitor update) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        TreePath schedulingPath = update.getSchedulingPath();
        List<ViewerUpdateMonitor> requests = this.fWaitingRequests.get(schedulingPath);
        if (requests == null) {
            int staleUpdateIndex;
            requests = new LinkedList<ViewerUpdateMonitor>();
            requests.add(update);
            this.fWaitingRequests.put(schedulingPath, requests);
            List<ViewerUpdateMonitor> inProgressList = this.fRequestsInProgress.get(schedulingPath);
            if (inProgressList != null && (staleUpdateIndex = inProgressList.indexOf(update)) >= 0) {
                ViewerUpdateMonitor staleUpdate = inProgressList.remove(staleUpdateIndex);
                staleUpdate.cancel();
            }
            if (inProgressList == null || inProgressList.isEmpty()) {
                this.getViewer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TreeModelContentProvider.this.isDisposed()) {
                            return;
                        }
                        TreeModelContentProvider.this.trigger(update.getSchedulingPath());
                    }
                });
            }
        } else {
            requests.add(this.coalesce(requests, update));
        }
    }

    private ViewerUpdateMonitor coalesce(List<ViewerUpdateMonitor> requests, ViewerUpdateMonitor toCoalesce) {
        for (ViewerUpdateMonitor waiting : requests) {
            if (!waiting.coalesce(toCoalesce)) continue;
            requests.remove(waiting);
            return this.coalesce(requests, waiting);
        }
        return toCoalesce;
    }

    boolean areChildrenUpdatesPending(TreePath path) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        List<ViewerUpdateMonitor> requests = this.fWaitingRequests.get(path);
        if (requests != null) {
            int i = 0;
            while (i < requests.size()) {
                if (requests.get(i) instanceof ChildrenUpdate) {
                    return true;
                }
                ++i;
            }
        }
        if ((requests = this.fRequestsInProgress.get(path)) != null) {
            int numChildrenUpdateRequests = 0;
            int i = 0;
            while (i < requests.size()) {
                if (requests.get(i) instanceof ChildrenUpdate && ++numChildrenUpdateRequests > 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void trigger(TreePath schedulingPath) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        if (this.fWaitingRequests.isEmpty()) {
            return;
        }
        List<ViewerUpdateMonitor> waiting = this.fWaitingRequests.get(schedulingPath);
        if (waiting == null) {
            int length = Integer.MAX_VALUE;
            Map.Entry<TreePath, List<ViewerUpdateMonitor>> candidate = null;
            for (Map.Entry<TreePath, List<ViewerUpdateMonitor>> entry : this.fWaitingRequests.entrySet()) {
                TreePath key = entry.getKey();
                if (key.getSegmentCount() >= length || this.isRequestBlocked(key)) continue;
                candidate = entry;
                length = key.getSegmentCount();
            }
            if (candidate != null) {
                this.startHighestPriorityRequest((TreePath)candidate.getKey(), (List)candidate.getValue());
            }
        } else if (!this.isRequestBlocked(schedulingPath)) {
            this.startHighestPriorityRequest(schedulingPath, waiting);
        }
    }

    private boolean isRequestBlocked(TreePath requestPath) {
        TreePath parentPath = requestPath;
        List<ViewerUpdateMonitor> parentRequests = this.fRequestsInProgress.get(parentPath);
        while (parentRequests == null || parentRequests.isEmpty()) {
            if ((parentPath = parentPath.getParentPath()) == null) {
                return false;
            }
            parentRequests = this.fRequestsInProgress.get(parentPath);
        }
        return true;
    }

    private void startHighestPriorityRequest(TreePath key, List<ViewerUpdateMonitor> waiting) {
        int priority = 4;
        ViewerUpdateMonitor next = null;
        for (ViewerUpdateMonitor vu : waiting) {
            if (vu.getPriority() >= priority) continue;
            next = vu;
            priority = next.getPriority();
        }
        if (next != null) {
            waiting.remove(next);
            if (waiting.isEmpty()) {
                this.fWaitingRequests.remove(key);
            }
            next.start();
        }
    }

    protected Object getElement(TreePath path) {
        if (path.getSegmentCount() > 0) {
            return path.getLastSegment();
        }
        return this.getViewer().getInput();
    }

    private void rescheduleUpdates(TreePath parentPath, int modelIndex) {
        IChildrenUpdate childrenUpdate;
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        List<ViewerUpdateMonitor> requests = this.fRequestsInProgress.get(parentPath);
        ArrayList<IChildrenUpdate> reCreate = null;
        if (requests != null) {
            Iterator<ViewerUpdateMonitor> iterator = requests.iterator();
            while (iterator.hasNext()) {
                ViewerUpdateMonitor update = iterator.next();
                if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)((Object)update)).getOffset() <= modelIndex) continue;
                childrenUpdate.cancel();
                iterator.remove();
                if (reCreate == null) {
                    reCreate = new ArrayList<IChildrenUpdate>();
                }
                reCreate.add(childrenUpdate);
                if (!DebugUIPlugin.DEBUG_CONTENT_PROVIDER || !DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) continue;
                DebugUIPlugin.trace("canceled update in progress handling REMOVE: " + childrenUpdate);
            }
        }
        if ((requests = this.fWaitingRequests.get(parentPath)) != null) {
            for (ViewerUpdateMonitor update : requests) {
                if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)((Object)update)).getOffset() <= modelIndex) continue;
                ((ChildrenUpdate)childrenUpdate).setOffset(childrenUpdate.getOffset() - 1);
                if (!DebugUIPlugin.DEBUG_CONTENT_PROVIDER || !DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) continue;
                DebugUIPlugin.trace("modified waiting update handling REMOVE: " + childrenUpdate);
            }
        }
        if (reCreate != null) {
            for (IChildrenUpdate childrenUpdate2 : reCreate) {
                int start = childrenUpdate2.getOffset() - 1;
                int end = start + childrenUpdate2.getLength();
                int i = start;
                while (i < end) {
                    this.doUpdateElement(parentPath, i);
                    ++i;
                }
            }
        }
    }

    private void doUpdateChildCount(TreePath path) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        Object element = this.getElement(path);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(element);
        if (contentAdapter != null) {
            ChildrenCountUpdate request = new ChildrenCountUpdate(this, this.getViewer().getInput(), path, element, contentAdapter);
            this.schedule(request);
        }
    }

    void doUpdateElement(TreePath parentPath, int modelIndex) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        Object parent = this.getElement(parentPath);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(parent);
        if (contentAdapter != null) {
            ChildrenUpdate request = new ChildrenUpdate(this, this.getViewer().getInput(), parentPath, parent, modelIndex, contentAdapter);
            this.schedule(request);
        }
    }

    private void doUpdateHasChildren(TreePath path) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        Object element = this.getElement(path);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(element);
        if (contentAdapter != null) {
            HasChildrenUpdate request = new HasChildrenUpdate(this, this.getViewer().getInput(), path, element, contentAdapter);
            this.schedule(request);
        }
    }

    boolean areElementUpdatesPending(TreePath path) {
        ViewerUpdateMonitor update;
        int i;
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        TreePath parentPath = path.getParentPath();
        List<ViewerUpdateMonitor> requests = this.fWaitingRequests.get(path);
        if (requests != null) {
            i = 0;
            while (i < requests.size()) {
                update = requests.get(i);
                if (update instanceof ChildrenUpdate) {
                    return true;
                }
                ++i;
            }
        }
        if ((requests = this.fWaitingRequests.get(parentPath)) != null) {
            i = 0;
            while (i < requests.size()) {
                update = requests.get(i);
                if (update.containsUpdate(path)) {
                    return true;
                }
                ++i;
            }
        }
        if ((requests = this.fRequestsInProgress.get(path)) != null) {
            i = 0;
            while (i < requests.size()) {
                update = requests.get(i);
                if (update instanceof ChildrenUpdate) {
                    return true;
                }
                ++i;
            }
        }
        if ((requests = this.fRequestsInProgress.get(parentPath)) != null) {
            i = 0;
            while (i < requests.size()) {
                update = requests.get(i);
                if (update.getElement().equals(path.getLastSegment())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected IPresentationContext getPresentationContext() {
        IInternalTreeModelViewer viewer = this.getViewer();
        if (viewer != null) {
            return viewer.getPresentationContext();
        }
        return null;
    }

    protected void updateNodes(IModelDelta[] nodes, int mask) {
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags() & mask;
            if ((flags & 1) != 0) {
                this.handleAdd(node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(node);
            }
            if ((flags & 0x800) != 0) {
                this.handleState(node);
            }
            if ((flags & 0x10) != 0) {
                this.handleInsert(node);
            }
            if ((flags & 8) != 0) {
                this.handleReplace(node);
            }
            if ((flags & 0x400000) != 0) {
                this.handleInstall(node);
            }
            if ((flags & 0x800000) != 0) {
                this.handleUninstall(node);
            }
            if ((flags & 0x100000) != 0) {
                this.handleExpand(node);
            }
            if ((flags & 0x2000000) != 0) {
                this.handleCollapse(node);
            }
            if ((flags & 0x200000) != 0) {
                this.handleSelect(node);
            }
            if ((flags & 0x1000000) != 0) {
                this.handleReveal(node);
            }
            this.updateNodes(node.getChildDeltas(), mask);
            ++i;
        }
    }

    protected void handleInstall(IModelDelta delta) {
        this.installModelProxy(this.getViewer().getInput(), this.getFullTreePath(delta));
    }

    protected void handleUninstall(IModelDelta delta) {
        this.disposeModelProxy(this.getFullTreePath(delta));
    }

    protected void handleAdd(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta == null) {
            DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Invalid viewer update: " + delta + ", in " + this.getPresentationContext().getId(), null));
            return;
        }
        TreePath parentPath = this.getViewerTreePath(parentDelta);
        Object element = delta.getElement();
        int count = parentDelta.getChildCount();
        if (count > 0) {
            this.setModelChildCount(parentPath, count);
            int modelIndex = count - 1;
            if (delta.getIndex() != -1) {
                modelIndex = delta.getIndex();
            }
            if (this.shouldFilter(parentPath, element)) {
                this.addFilteredIndex(parentPath, modelIndex, element);
                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    DebugUIPlugin.trace("[filtered] handleAdd(" + delta.getElement() + ") > modelIndex: " + modelIndex);
                }
            } else {
                if (this.isFiltered(parentPath, modelIndex)) {
                    this.clearFilteredChild(parentPath, modelIndex);
                }
                int viewIndex = this.modelToViewIndex(parentPath, modelIndex);
                int viewCount = this.modelToViewChildCount(parentPath, count);
                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    DebugUIPlugin.trace("handleAdd(" + delta.getElement() + ") viewIndex: " + viewIndex + " modelIndex: " + modelIndex + " viewCount: " + viewCount + " modelCount: " + count);
                }
                this.getViewer().setChildCount(parentPath, viewCount);
                this.getViewer().autoExpand(parentPath);
                this.getViewer().replace(parentPath, viewIndex, element);
                TreePath childPath = parentPath.createChildPath(element);
                this.updateHasChildren(childPath);
                this.fStateTracker.restorePendingStateOnUpdate(childPath, modelIndex, false, false, false);
            }
        } else {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("handleAdd(" + delta.getElement() + ")");
            }
            this.doUpdateChildCount(this.getViewerTreePath(delta.getParentDelta()));
        }
    }

    protected void handleContent(IModelDelta delta) {
        if (delta.getParentDelta() == null && delta.getChildCount() == 0 && !delta.getElement().equals(this.getViewer().getInput())) {
            return;
        }
        TreePath treePath = this.getViewerTreePath(delta);
        this.cancelSubtreeUpdates(treePath);
        this.getViewer().refresh(this.getElement(treePath));
    }

    protected void handleCollapse(IModelDelta delta) {
        TreePath elementPath = this.getViewerTreePath(delta);
        this.getViewer().setExpandedState(elementPath, false);
        this.cancelRestore(elementPath, 0x100000);
    }

    protected void handleExpand(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta != null) {
            if ((parentDelta.getFlags() & 0x100000) == 0) {
                this.handleExpand(parentDelta);
            }
            this.expand(delta);
        } else {
            int childCount = delta.getChildCount();
            TreePath elementPath = this.getViewerTreePath(delta);
            if (childCount > 0) {
                int viewCount = this.modelToViewChildCount(elementPath, childCount);
                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    DebugUIPlugin.trace("[expand] setChildCount(" + delta.getElement() + ", (model) " + childCount + " (view) " + viewCount);
                }
                this.getViewer().setChildCount(elementPath, viewCount);
            }
        }
    }

    private void expand(IModelDelta delta) {
        int childCount = delta.getChildCount();
        int modelIndex = delta.getIndex();
        IInternalTreeModelViewer treeViewer = this.getViewer();
        TreePath elementPath = this.getViewerTreePath(delta);
        if (modelIndex >= 0) {
            int viewIndex;
            TreePath parentPath = elementPath.getParentPath();
            if (parentPath == null) {
                parentPath = TreePath.EMPTY;
            }
            if ((viewIndex = this.modelToViewIndex(parentPath, modelIndex)) >= 0) {
                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    DebugUIPlugin.trace("[expand] replace(" + delta.getParentDelta().getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace(parentPath, viewIndex, delta.getElement());
            } else {
                viewIndex = this.unfilterElement(parentPath, delta.getElement(), modelIndex);
                if (viewIndex < 0) {
                    return;
                }
            }
        }
        if (childCount > 0) {
            int viewCount = this.modelToViewChildCount(elementPath, childCount);
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("[expand] setChildCount(" + delta.getElement() + ", (model) " + childCount + " (view) " + viewCount);
            }
            treeViewer.setChildCount(elementPath, viewCount);
            if (!treeViewer.getExpandedState(elementPath)) {
                treeViewer.expandToLevel(elementPath, 1);
                this.cancelRestore(elementPath, 0x2000000);
            }
        }
    }

    private int unfilterElement(TreePath parentPath, Object element, int modelIndex) {
        if (this.shouldFilter(parentPath, element)) {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("[unfilter] abort unfilter element: " + element + ", (model) " + modelIndex);
            }
            return -1;
        }
        this.clearFilteredChild(parentPath, modelIndex);
        int viewIndex = this.modelToViewIndex(parentPath, modelIndex);
        if (viewIndex >= 0) {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("[unfilter] insert(" + parentPath.getLastSegment() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + element);
            }
            this.getViewer().insert(parentPath, element, viewIndex);
            return viewIndex;
        }
        return -1;
    }

    protected void handleInsert(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta == null) {
            DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Invalid viewer update: " + delta + ", in " + this.getPresentationContext().getId(), null));
            return;
        }
        TreePath parentPath = this.getViewerTreePath(delta.getParentDelta());
        Object element = delta.getElement();
        int modelIndex = delta.getIndex();
        int viewIndex = modelIndex >= 0 ? this.modelToViewIndex(parentPath, modelIndex) : -1;
        int viewCount = this.getViewer().getChildCount(parentPath);
        if (viewIndex >= 0 && viewIndex <= viewCount) {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("handleInsert(" + parentPath.getLastSegment() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + element);
            }
            this.getViewer().insert(parentPath, element, viewIndex);
        } else if (modelIndex >= 0 && viewIndex < 0) {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("[filtered] handleInsert(" + delta.getElement() + ") > modelIndex: " + modelIndex);
            }
        } else {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("handleInsert(" + delta.getElement() + ")");
            }
            this.doUpdateChildCount(this.getViewerTreePath(delta.getParentDelta()));
        }
    }

    protected void handleRemove(IModelDelta delta) {
        Object element;
        IModelDelta parentDelta;
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("handleRemove(" + delta.getElement() + ")");
        }
        if ((parentDelta = delta.getParentDelta()) == null) {
            DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Invalid viewer update: " + delta + ", in " + this.getPresentationContext().getId(), null));
            return;
        }
        IInternalTreeModelViewer treeViewer = this.getViewer();
        TreePath parentPath = this.getViewerTreePath(parentDelta);
        if (this.removeElementFromFilters(parentPath, element = delta.getElement())) {
            return;
        }
        int viewIndex = -1;
        int modelIndex = delta.getIndex();
        int unmappedIndex = -1;
        int itemCount = -1;
        if (modelIndex < 0) {
            itemCount = treeViewer.getChildCount(parentPath);
            if (itemCount == -1) {
                this.clearFilters(parentPath);
            }
            if ((viewIndex = treeViewer.findElementIndex(parentPath, element)) >= 0) {
                modelIndex = this.viewToModelIndex(parentPath, viewIndex);
            } else {
                unmappedIndex = treeViewer.findElementIndex(parentPath, null);
            }
        } else {
            viewIndex = this.modelToViewIndex(parentPath, modelIndex);
        }
        if (modelIndex >= 0) {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace(" - (found) remove(" + parentPath.getLastSegment() + ", viewIndex: " + viewIndex + " modelIndex: " + modelIndex);
            }
            this.rescheduleUpdates(parentPath, modelIndex);
            this.getViewer().remove(parentPath, viewIndex);
            this.removeElementFromFilters(parentPath, modelIndex);
            return;
        }
        if (unmappedIndex >= 0) {
            if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace(" - (not found) remove(" + parentPath.getLastSegment() + ", viewIndex: " + viewIndex + " modelIndex: " + modelIndex + " unmapped index: " + unmappedIndex);
            }
            modelIndex = this.viewToModelIndex(parentPath, unmappedIndex);
            this.rescheduleUpdates(parentPath, modelIndex);
            this.getViewer().remove(parentPath, unmappedIndex);
            this.removeElementFromFilters(parentPath, modelIndex);
            return;
        }
        int modelCount = parentDelta.getChildCount();
        if (itemCount >= 0 && modelCount >= 0 && this.modelToViewChildCount(parentPath, modelCount) == itemCount) {
            return;
        }
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace(" - (not found) remove/refresh(" + delta.getElement());
        }
        this.getViewer().remove(this.getViewerTreePath(delta));
        this.clearFilters(parentPath);
        this.getViewer().refresh(parentDelta.getElement());
    }

    protected void handleReplace(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta == null) {
            DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Invalid viewer update: " + delta + ", in " + this.getPresentationContext().getId(), null));
            return;
        }
        TreePath parentPath = this.getViewerTreePath(parentDelta);
        int index = delta.getIndex();
        if (index < 0) {
            index = this.fTransform.indexOfFilteredElement(parentPath, delta.getElement());
        }
        if (index >= 0) {
            boolean filtered = this.isFiltered(parentPath, index);
            boolean shouldFilter = this.shouldFilter(parentPath, delta.getReplacementElement());
            if (filtered) {
                this.clearFilteredChild(parentPath, index);
            }
            if (shouldFilter) {
                this.addFilteredIndex(parentPath, index, delta.getElement());
            }
            if (filtered) {
                if (!shouldFilter) {
                    this.getViewer().insert(parentPath, delta.getReplacementElement(), this.modelToViewIndex(parentPath, index));
                }
            } else if (shouldFilter) {
                this.getViewer().remove(parentPath, this.modelToViewIndex(parentPath, index));
            } else {
                this.getViewer().replace(parentPath, delta.getIndex(), delta.getReplacementElement());
            }
        }
    }

    protected void handleSelect(IModelDelta delta) {
        TreePath selectionPath;
        int modelIndex = delta.getIndex();
        IInternalTreeModelViewer treeViewer = this.getViewer();
        TreeSelection candidate = new TreeSelection(this.getViewerTreePath(delta));
        if ((delta.getFlags() & 0x4000000) == 0 && !treeViewer.overrideSelection(treeViewer.getSelection(), (ISelection)candidate)) {
            return;
        }
        treeViewer.clearSelectionQuiet();
        if (modelIndex >= 0) {
            IModelDelta parentDelta = delta.getParentDelta();
            if (parentDelta == null) {
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Invalid viewer update: " + delta + ", in " + this.getPresentationContext().getId(), null));
                return;
            }
            TreePath parentPath = this.getViewerTreePath(parentDelta);
            int viewIndex = this.modelToViewIndex(parentPath, modelIndex);
            if (viewIndex >= 0) {
                int modelCount = parentDelta.getChildCount();
                if (modelCount > 0) {
                    int viewCount = this.modelToViewChildCount(parentPath, modelCount);
                    if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                        DebugUIPlugin.trace("[select] setChildCount(" + parentDelta.getElement() + ", (model) " + parentDelta.getChildCount() + " (view) " + viewCount);
                    }
                    treeViewer.setChildCount(parentPath, viewCount);
                }
                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    DebugUIPlugin.trace("[select] replace(" + parentDelta.getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace(parentPath, viewIndex, delta.getElement());
            }
        }
        if (treeViewer.trySelection((ISelection)new TreeSelection(selectionPath = this.getViewerTreePath(delta)), false, (delta.getFlags() | 0x4000000) == 0)) {
            this.cancelRestore(selectionPath, 0x200000);
        }
    }

    protected void handleState(IModelDelta delta) {
        this.getViewer().update(delta.getElement());
    }

    protected void handleReveal(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta == null) {
            DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Invalid viewer update: " + delta + ", in " + this.getPresentationContext().getId(), null));
            return;
        }
        this.handleExpand(parentDelta);
        this.reveal(delta);
        this.cancelRestore(this.getViewerTreePath(delta), 0x1000000);
    }

    private void reveal(IModelDelta delta) {
        int modelIndex = delta.getIndex();
        IInternalTreeModelViewer treeViewer = this.getViewer();
        TreePath elementPath = this.getViewerTreePath(delta);
        if (modelIndex >= 0) {
            int viewIndex;
            TreePath parentPath = elementPath.getParentPath();
            if (parentPath == null) {
                parentPath = TreePath.EMPTY;
            }
            if ((viewIndex = this.modelToViewIndex(parentPath, modelIndex)) >= 0) {
                if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    DebugUIPlugin.trace("[reveal] replace(" + delta.getParentDelta().getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace(parentPath, viewIndex, delta.getElement());
            } else {
                viewIndex = this.unfilterElement(parentPath, delta.getElement(), modelIndex);
                if (viewIndex < 0) {
                    return;
                }
            }
            if ((delta.getFlags() & 0x4000000) != 0 || treeViewer.overrideSelection(treeViewer.getSelection(), (ISelection)new TreeSelection(elementPath))) {
                this.fRevealPath = parentPath;
                this.fRevealIndex = viewIndex;
                treeViewer.reveal(parentPath, viewIndex);
            }
        }
    }

    public TreePath[] getParents(Object element) {
        return null;
    }

    public void updateChildCount(TreePath treePath, int currentChildCount) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("updateChildCount(" + this.getElement(treePath) + ", " + currentChildCount + ")");
        }
        this.doUpdateChildCount(treePath);
    }

    public void updateElement(TreePath parentPath, int viewIndex) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        int modelIndex = this.viewToModelIndex(parentPath, viewIndex);
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("updateElement(" + this.getElement(parentPath) + ", " + viewIndex + ") > modelIndex = " + modelIndex);
        }
        this.doUpdateElement(parentPath, modelIndex);
    }

    public void updateHasChildren(TreePath path) {
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("updateHasChildren(" + this.getElement(path));
        }
        this.doUpdateHasChildren(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleViewerUpdate(ViewerUpdateMonitor update) {
        Display display;
        Runnable updateJob = null;
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            if (this.isDisposed()) {
                return;
            }
            display = this.getViewer().getDisplay();
            this.fCompletedUpdates.add(update);
            if (this.fCompletedUpdatesRunnable == null) {
                updateJob = this.fCompletedUpdatesRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!TreeModelContentProvider.this.isDisposed()) {
                            TreeModelContentProvider.this.performUpdates();
                        }
                    }
                };
            }
        }
        if (updateJob != null) {
            if (Thread.currentThread() == display.getThread()) {
                this.performUpdates();
            } else {
                display.asyncExec(updateJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpdates() {
        List<ViewerUpdateMonitor> jobCompletedUpdates;
        Assert.isTrue((this.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        TreeModelContentProvider treeModelContentProvider = this;
        synchronized (treeModelContentProvider) {
            if (this.isDisposed()) {
                return;
            }
            jobCompletedUpdates = this.fCompletedUpdates;
            this.fCompletedUpdatesRunnable = null;
            this.fCompletedUpdates = new ArrayList<ViewerUpdateMonitor>();
        }
        try {
            int i = 0;
            while (i < jobCompletedUpdates.size()) {
                IStatus status;
                ViewerUpdateMonitor completedUpdate = jobCompletedUpdates.get(i);
                if (!(completedUpdate.isCanceled() || this.isDisposed() || (status = completedUpdate.getStatus()) != null && !status.isOK())) {
                    completedUpdate.performUpdate();
                }
                ++i;
            }
        }
        finally {
            this.updatesComplete(jobCompletedUpdates);
        }
    }
}

