/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecExpressionStatement;

public class CPPASTExpressionStatement
extends CPPASTAttributeOwner
implements IASTExpressionStatement,
ICPPExecutionOwner {
    private IASTExpression expression;

    public CPPASTExpressionStatement() {
    }

    public CPPASTExpressionStatement(IASTExpression expression) {
        this.setExpression(expression);
    }

    @Override
    public CPPASTExpressionStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTExpressionStatement copy(IASTNode.CopyStyle style) {
        CPPASTExpressionStatement copy = new CPPASTExpressionStatement();
        copy.setExpression(this.expression == null ? null : this.expression.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.expression = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(EXPRESSION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.expression != null && !this.expression.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.expression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.expression = (IASTExpression)other;
            return;
        }
        super.replace(child, other);
    }

    @Override
    public ICPPExecution getExecution() {
        ICPPASTExpression expr = (ICPPASTExpression)this.getExpression();
        ICPPEvaluation exprEval = expr.getEvaluation();
        return new ExecExpressionStatement(exprEval);
    }
}

