/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public abstract class FormTextHoverManager
extends AbstractHoverInformationControlManager {
    protected AbstractInformationControlManager.IInformationControlCloser closer;
    protected KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent event) {
            IInformationControl informationControl;
            if (event.keyCode == 0x100000B && (informationControl = FormTextHoverManager.this.getInformationControl()) instanceof FormTextInformationControl) {
                Control myControl = ((FormTextInformationControl)informationControl).getControl();
                Event mouseEvent = new Event();
                mouseEvent.display = myControl.getDisplay();
                mouseEvent.widget = myControl;
                mouseEvent.type = 4;
                ((Listener)FormTextHoverManager.this.closer).handleEvent(mouseEvent);
                event.doit = false;
            }
        }

        public void keyPressed(KeyEvent event) {
        }
    };

    public FormTextHoverManager() {
        super((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new FormTextInformationControl(parent, false);
            }
        });
        this.getInternalAccessor().setInformationControlReplacer(new InformationControlReplacer((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new FormTextInformationControl(parent, true);
            }
        }){
            {
                this.setCloser(new Closer());
            }

            class Closer
            implements AbstractInformationControlManager.IInformationControlCloser,
            ControlListener,
            MouseListener,
            KeyListener,
            FocusListener,
            Listener {
                protected boolean isActive;
                protected Display display;
                protected Control subjectControl;
                protected IInformationControl informationControl;

                Closer() {
                }

                public void setSubjectControl(Control control) {
                    this.subjectControl = control;
                }

                public void setInformationControl(IInformationControl control) {
                    this.informationControl = control;
                }

                public void start(Rectangle informationArea) {
                    if (!this.isActive) {
                        this.isActive = true;
                        if (this.subjectControl != null && !this.subjectControl.isDisposed()) {
                            this.subjectControl.addControlListener((ControlListener)this);
                            this.subjectControl.addMouseListener((MouseListener)this);
                            this.subjectControl.addKeyListener((KeyListener)this);
                        }
                        if (this.informationControl != null) {
                            this.informationControl.addFocusListener((FocusListener)this);
                        }
                        this.display = this.subjectControl.getDisplay();
                        if (!this.display.isDisposed()) {
                            this.display.addFilter(5, (Listener)this);
                            this.display.addFilter(16, (Listener)this);
                        }
                    }
                }

                public void stop() {
                    if (this.isActive) {
                        this.isActive = false;
                        if (this.subjectControl != null && !this.subjectControl.isDisposed()) {
                            this.subjectControl.removeControlListener((ControlListener)this);
                            this.subjectControl.removeMouseListener((MouseListener)this);
                            this.subjectControl.removeKeyListener((KeyListener)this);
                        }
                        if (this.informationControl != null) {
                            this.informationControl.removeFocusListener((FocusListener)this);
                        }
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.removeFilter(5, (Listener)this);
                            this.display.removeFilter(16, (Listener)this);
                        }
                        this.display = null;
                    }
                }

                public void controlResized(ControlEvent event) {
                    this.hideInformationControl();
                }

                public void controlMoved(ControlEvent event) {
                    this.hideInformationControl();
                }

                public void mouseDown(MouseEvent event) {
                    this.hideInformationControl();
                }

                public void mouseUp(MouseEvent event) {
                }

                public void mouseDoubleClick(MouseEvent event) {
                    this.hideInformationControl();
                }

                public void keyPressed(KeyEvent event) {
                    this.hideInformationControl();
                }

                public void keyReleased(KeyEvent event) {
                }

                public void focusGained(FocusEvent event) {
                }

                public void focusLost(FocusEvent event) {
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.hideInformationControl();
                            }
                        });
                    }
                }

                public void handleEvent(Event event) {
                    if (event.type == 5) {
                        if (event.widget instanceof Control && event.widget.isDisposed()) {
                            if (this.informationControl != null && !this.informationControl.isFocusControl() && this.informationControl instanceof IInformationControlExtension3) {
                                Point mouseLocation;
                                Rectangle controlBounds = ((IInformationControlExtension3)this.informationControl).getBounds();
                                if (controlBounds != null && !controlBounds.contains(mouseLocation = event.display.map((Control)event.widget, null, event.x, event.y))) {
                                    this.hideInformationControl();
                                }
                            } else if (this.display != null && !this.display.isDisposed()) {
                                this.display.removeFilter(5, (Listener)this);
                            }
                        }
                    } else if (event.type == 16 && this.informationControl != null && !this.informationControl.isFocusControl()) {
                        this.hideInformationControl();
                    }
                }
            }
        });
    }

    protected void setCloser(AbstractInformationControlManager.IInformationControlCloser closer) {
        this.closer = closer;
        super.setCloser(closer);
    }

    protected boolean canClearDataOnHide() {
        return false;
    }

    public void install(Control subjectControl) {
        Control oldSubjectControl = this.getSubjectControl();
        if (oldSubjectControl != null && !oldSubjectControl.isDisposed()) {
            oldSubjectControl.removeKeyListener(this.keyListener);
        }
        if (subjectControl != null) {
            subjectControl.addKeyListener(this.keyListener);
        }
        super.install(subjectControl);
        this.getInternalAccessor().getInformationControlReplacer().install(subjectControl);
    }

    public void dispose() {
        Control subjectControl = this.getSubjectControl();
        if (subjectControl != null && !subjectControl.isDisposed()) {
            subjectControl.removeKeyListener(this.keyListener);
        }
        super.dispose();
    }

    private static class FormTextInformationControl
    extends AbstractInformationControl {
        private ScrolledComposite comp;
        private FormText formText;
        private String text;

        public FormTextInformationControl(Shell parentShell, boolean inFocus) {
            super(parentShell, true);
            if (!inFocus) {
                Shell shell = this.getShell();
                Composite statusComposite = new Composite((Composite)shell, 0);
                GridData gridData = new GridData(4, 1024, true, false);
                statusComposite.setLayoutData((Object)gridData);
                GridLayout statusLayout = new GridLayout(1, false);
                statusLayout.marginHeight = 0;
                statusLayout.marginWidth = 0;
                statusLayout.verticalSpacing = 1;
                statusComposite.setLayout((Layout)statusLayout);
                Label separator = new Label(statusComposite, 258);
                separator.setLayoutData((Object)new GridData(768));
                Label statusLabel = new Label(statusComposite, 131072);
                statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                statusLabel.setText("Press F2 for focus");
                FontData[] fontDatas = JFaceResources.getDialogFont().getFontData();
                int i = 0;
                while (i < fontDatas.length) {
                    fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                    ++i;
                }
                Font statusLabelFont = new Font((Device)statusLabel.getDisplay(), fontDatas);
                statusLabel.setFont(statusLabelFont);
            }
            this.create();
        }

        public boolean hasContents() {
            return this.text != null;
        }

        public void setInformation(String information) {
            this.text = information;
            if (this.text != null) {
                this.formText.setText(this.text, true, true);
                this.comp.setMinSize(this.formText.computeSize(-1, -1));
            }
        }

        protected void createContent(Composite parent) {
            this.comp = new ScrolledComposite(parent, 768);
            this.comp.setExpandHorizontal(true);
            this.comp.setExpandVertical(true);
            this.formText = new FormText((Composite)this.comp, 0);
            this.comp.setContent((Control)this.formText);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL((String)event.getHref()));
                    }
                    catch (MalformedURLException | PartInitException e) {
                        Activator.log((Exception)e);
                    }
                }
            });
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new FormTextInformationControl(parent, true);
                }
            };
        }

        public Control getControl() {
            return this.getShell();
        }
    }
}

