/*******************************************************************************
 * Copyright (c) 2015 QNX Software Systems and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * QNX Software Systems - Initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.internal.qt.ui.editor;

import java.util.ArrayList;

/**
 * Various keywords associated with Qt Project Files. Namely, special function and variable names used by qmake.
 */
public enum QtProjectFileKeyword {
	// QMake function keywords
	FUNC_MEMBER("member"), //$NON-NLS-1$
	FUNC_FIRST("first"), //$NON-NLS-1$
	FUNC_LAST("last"), //$NON-NLS-1$
	FUNC_SIZE("size"), //$NON-NLS-1$
	FUNC_CAT("cat"), //$NON-NLS-1$
	FUNC_FROMFILE("fromfile"), //$NON-NLS-1$
	FUNC_EVAL("eval"), //$NON-NLS-1$
	FUNC_LIST("list"), //$NON-NLS-1$
	FUNC_SPRINTF("sprintf"), //$NON-NLS-1$
	FUNC_FORMAT_NUMBER("format_number"), //$NON-NLS-1$
	FUNC_JOIN("join"), //$NON-NLS-1$
	FUNC_SPLIT("split"), //$NON-NLS-1$
	FUNC_BASENAME("basename"), //$NON-NLS-1$
	FUNC_DIRNAME("dirname"), //$NON-NLS-1$
	FUNC_SECTION("section"), //$NON-NLS-1$
	FUNC_FIND("find"), //$NON-NLS-1$
	FUNC_SYSTEM("system"), //$NON-NLS-1$
	FUNC_UNIQUE("unique"), //$NON-NLS-1$
	FUNC_REVERSE("reverse"), //$NON-NLS-1$
	FUNC_QUOTE("quote"), //$NON-NLS-1$
	FUNC_ESCAPE_EXPAND("escape_expand"), //$NON-NLS-1$
	FUNC_UPPER("upper"), //$NON-NLS-1$
	FUNC_LOWER("lower"), //$NON-NLS-1$
	FUNC_TITLE("title"), //$NON-NLS-1$
	FUNC_RE_ESCAPE("re_escape"), //$NON-NLS-1$
	FUNC_VAL_ESCAPE("val_escape"), //$NON-NLS-1$
	FUNC_FILES("files"), //$NON-NLS-1$
	FUNC_PROMPT("prompt"), //$NON-NLS-1$
	FUNC_REPLACE("replace"), //$NON-NLS-1$
	FUNC_SORT_DEPENDS("sort_depends"), //$NON-NLS-1$
	FUNC_RESOLVE_DEPENDS("resolve_depends"), //$NON-NLS-1$
	FUNC_ENUMERATE_VARS("enumerate_vars"), //$NON-NLS-1$
	FUNC_SHADOWED("shadowed"), //$NON-NLS-1$
	FUNC_ABSOLUTE_PATH("absolute_path"), //$NON-NLS-1$
	FUNC_RELATIVE_PATH("relative_path"), //$NON-NLS-1$
	FUNC_CLEAN_PATH("clean_path"), //$NON-NLS-1$
	FUNC_SYSTEM_PATH("system_path"), //$NON-NLS-1$
	FUNC_SHELL_PATH("shell_path"), //$NON-NLS-1$
	FUNC_SYSTEM_QUOTE("system_quote"), //$NON-NLS-1$
	FUNC_SHELL_QUOTE("shell_quote"), //$NON-NLS-1$
	FUNC_REQUIRES("requires"), //$NON-NLS-1$
	FUNC_GREATERTHAN("greaterThan"), //$NON-NLS-1$
	FUNC_LESSTHAN("lessThan"), //$NON-NLS-1$
	FUNC_EQUALS("equals"), //$NON-NLS-1$
	FUNC_ISEQUAL("isEqual"), //$NON-NLS-1$
	FUNC_EXISTS("exists"), //$NON-NLS-1$
	FUNC_EXPORT("export"), //$NON-NLS-1$
	FUNC_CLEAR("clear"), //$NON-NLS-1$
	FUNC_UNSET("unset"), //$NON-NLS-1$
	FUNC_IF("if"), //$NON-NLS-1$
	FUNC_ISACTIVECONFIG("isActiveConfig"), //$NON-NLS-1$
	FUNC_DEFINED("defined"), //$NON-NLS-1$
	FUNC_CONTAINS("contains"), //$NON-NLS-1$
	FUNC_INFILE("infile"), //$NON-NLS-1$
	FUNC_COUNT("count"), //$NON-NLS-1$
	FUNC_ISEMPTY("isEmpty"), //$NON-NLS-1$
	FUNC_PARSEJSON("parseJson"), //$NON-NLS-1$
	FUNC_LOAD("load"), //$NON-NLS-1$
	FUNC_INCLUDE("include"), //$NON-NLS-1$
	FUNC_DEBUG("debug"), //$NON-NLS-1$
	FUNC_LOG("log"), //$NON-NLS-1$
	FUNC_MESSAGE("message"), //$NON-NLS-1$
	FUNC_WARNING("warning"), //$NON-NLS-1$
	FUNC_ERROR("error"), //$NON-NLS-1$
	FUNC_MKPATH("mkpath"), //$NON-NLS-1$
	FUNC_WRITE_FILE("write_file"), //$NON-NLS-1$
	FUNC_TOUCH("touch"), //$NON-NLS-1$
	FUNC_CACHE("cache"), //$NON-NLS-1$

	// QMake variable keywords
	VAR_CCFLAG("CCFLAG"), //$NON-NLS-1$
	VAR_CLEAN_DEPS("CLEAN_DEPS"), //$NON-NLS-1$
	VAR_CONFIG("CONFIG"), //$NON-NLS-1$
	VAR_DEFINES("DEFINES"), //$NON-NLS-1$
	VAR_DEF_FILE("DEF_FILE"), //$NON-NLS-1$
	VAR_DEPENDPATH("DEPENDPATH"), //$NON-NLS-1$
	VAR_DEPLOYMENT("DEPLOYMENT"), //$NON-NLS-1$
	VAR_DEPLOYMENT_PLUGIN("DEPLOYMENT_PLUGIN"), //$NON-NLS-1$
	VAR_DESTDIR("DESTDIR"), //$NON-NLS-1$
	VAR_DESTDIR_TARGET("DESTDIR_TARGET"), //$NON-NLS-1$
	VAR_DISTFILES("DISTFILES"), //$NON-NLS-1$
	VAR_DLLDESTDIR("DLLDESTDIR"), //$NON-NLS-1$
	VAR_DSP_TEMPLATE("DSP_TEMPLATE"), //$NON-NLS-1$
	VAR_FORMS("FORMS"), //$NON-NLS-1$
	VAR_FORMS3("FORMS3"), //$NON-NLS-1$
	VAR_GUID("GUID"), //$NON-NLS-1$
	VAR_HEADERS("HEADERS"), //$NON-NLS-1$
	VAR_ICON("ICON"), //$NON-NLS-1$
	VAR_INCLUDEPATH("INCLUDEPATH"), //$NON-NLS-1$
	VAR_INSTALLS("INSTALLS"), //$NON-NLS-1$
	VAR_LEXIMPLS("LEXIMPLS"), //$NON-NLS-1$
	VAR_LEXOBJECTS("LEXOBJECTS"), //$NON-NLS-1$
	VAR_LEXSOURCES("LEXSOURCES"), //$NON-NLS-1$
	VAR_LIBS("LIBS"), //$NON-NLS-1$
	VAR_LITERAL_HASH("LITERAL_HASH"), //$NON-NLS-1$
	VAR_MAKEFILE("MAKEFILE"), //$NON-NLS-1$
	VAR_MAKEFILE_GENERATOR("MAKEFILE_GENERATOR"), //$NON-NLS-1$
	VAR_MOBILITY("MOBILITY"), //$NON-NLS-1$
	VAR_MOC_DIR("MOC_DIR"), //$NON-NLS-1$
	VAR_OBJECTIVE_HEADERS("OBJECTIVE_HEADERS"), //$NON-NLS-1$
	VAR_OBJECTIVE_SOURCES("OBJECTIVE_SOURCES"), //$NON-NLS-1$
	VAR_OBJECTS("OBJECTS"), //$NON-NLS-1$
	VAR_OBJECTS_DIR("OBJECTS_DIR"), //$NON-NLS-1$
	VAR_OBJMOC("OBJMOC"), //$NON-NLS-1$
	VAR_OTHER_FILES("OTHER_FILES"), //$NON-NLS-1$
	VAR_OUT_PWD("OUT_PWD"), //$NON-NLS-1$
	VAR_PKGCONFIG("PKGCONFIG"), //$NON-NLS-1$
	VAR_POST_TARGETDEPS("POST_TARGETDEPS"), //$NON-NLS-1$
	VAR_PRECOMPILED_HEADER("PRECOMPILED_HEADER"), //$NON-NLS-1$
	VAR_PRE_TARGETDEPS("PRE_TARGETDEPS"), //$NON-NLS-1$
	VAR_PWD("PWD"), //$NON-NLS-1$
	VAR_QMAKE("QMAKE"), //$NON-NLS-1$
	VAR_QMAKESPEC("QMAKESPEC"), //$NON-NLS-1$
	VAR_QMAKE_APP_FLAG("QMAKE_APP_FLAG"), //$NON-NLS-1$
	VAR_QMAKE_APP_OR_DLL("QMAKE_APP_OR_DLL"), //$NON-NLS-1$
	VAR_QMAKE_AR_CMD("QMAKE_AR_CMD"), //$NON-NLS-1$
	VAR_QMAKE_BUNDLE_DATA("QMAKE_BUNDLE_DATA"), //$NON-NLS-1$
	VAR_QMAKE_BUNDLE_EXTENSION("QMAKE_BUNDLE_EXTENSION"), //$NON-NLS-1$
	VAR_QMAKE_CC("QMAKE_CC"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS("QMAKE_CFLAGS"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_DEBUG("QMAKE_CFLAGS_DEBUG"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_MT("QMAKE_CFLAGS_MT"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_MT_DBG("QMAKE_CFLAGS_MT_DBG"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_MT_DLL("QMAKE_CFLAGS_MT_DLL"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_MT_DLLDBG("QMAKE_CFLAGS_MT_DLLDBG"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_RELEASE("QMAKE_CFLAGS_RELEASE"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_SHLIB("QMAKE_CFLAGS_SHLIB"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_THREAD("QMAKE_CFLAGS_THREAD"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_WARN_OFF("QMAKE_CFLAGS_WARN_OFF"), //$NON-NLS-1$
	VAR_QMAKE_CFLAGS_WARN_ON("QMAKE_CFLAGS_WARN_ON"), //$NON-NLS-1$
	VAR_QMAKE_CLEAN("QMAKE_CLEAN"), //$NON-NLS-1$
	VAR_QMAKE_CXX("QMAKE_CXX"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS("QMAKE_CXXFLAGS"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_DEBUG("QMAKE_CXXFLAGS_DEBUG"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_MT("QMAKE_CXXFLAGS_MT"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_MT_DBG("QMAKE_CXXFLAGS_MT_DBG"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_MT_DLL("QMAKE_CXXFLAGS_MT_DLL"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_MT_DLLDBG("QMAKE_CXXFLAGS_MT_DLLDBG"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_RELEASE("QMAKE_CXXFLAGS_RELEASE"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_SHLIB("QMAKE_CXXFLAGS_SHLIB"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_THREAD("QMAKE_CXXFLAGS_THREAD"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_WARN_OFF("QMAKE_CXXFLAGS_WARN_OFF"), //$NON-NLS-1$
	VAR_QMAKE_CXXFLAGS_WARN_ON("QMAKE_CXXFLAGS_WARN_ON"), //$NON-NLS-1$
	VAR_QMAKE_DISTCLEAN("QMAKE_DISTCLEAN"), //$NON-NLS-1$
	VAR_QMAKE_EXTENSION_SHLIB("QMAKE_EXTENSION_SHLIB"), //$NON-NLS-1$
	VAR_QMAKE_EXTRA_COMPILERS("QMAKE_EXTRA_COMPILERS"), //$NON-NLS-1$
	VAR_QMAKE_EXTRA_TARGETS("QMAKE_EXTRA_TARGETS"), //$NON-NLS-1$
	VAR_QMAKE_EXT_CPP("QMAKE_EXT_CPP"), //$NON-NLS-1$
	VAR_QMAKE_EXT_H("QMAKE_EXT_H"), //$NON-NLS-1$
	VAR_QMAKE_EXT_LEX("QMAKE_EXT_LEX"), //$NON-NLS-1$
	VAR_QMAKE_EXT_MOC("QMAKE_EXT_MOC"), //$NON-NLS-1$
	VAR_QMAKE_EXT_OBJ("QMAKE_EXT_OBJ"), //$NON-NLS-1$
	VAR_QMAKE_EXT_PRL("QMAKE_EXT_PRL"), //$NON-NLS-1$
	VAR_QMAKE_EXT_UI("QMAKE_EXT_UI"), //$NON-NLS-1$
	VAR_QMAKE_EXT_YACC("QMAKE_EXT_YACC"), //$NON-NLS-1$
	VAR_QMAKE_FAILED_REQUIREMENTS("QMAKE_FAILED_REQUIREMENTS"), //$NON-NLS-1$
	VAR_QMAKE_FRAMEWORK_BUNDLE_NAME("QMAKE_FRAMEWORK_BUNDLE_NAME"), //$NON-NLS-1$
	VAR_QMAKE_FRAMEWORK_VERSION("QMAKE_FRAMEWORK_VERSION"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR("QMAKE_INCDIR"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_EGL("QMAKE_INCDIR_EGL"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_OPENGL("QMAKE_INCDIR_OPENGL"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_OPENGL_ES1("QMAKE_INCDIR_OPENGL_ES1"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_OPENGL_ES2("QMAKE_INCDIR_OPENGL_ES2"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_OPENVG("QMAKE_INCDIR_OPENVG"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_QT("QMAKE_INCDIR_QT"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_THREAD("QMAKE_INCDIR_THREAD"), //$NON-NLS-1$
	VAR_QMAKE_INCDIR_X("QMAKE_INCDIR_X11"), //$NON-NLS-1$
	VAR_QMAKE_INFO_PLIST("QMAKE_INFO_PLIST"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS("QMAKE_LFLAGS"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_CONSOLE("QMAKE_LFLAGS_CONSOLE"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_CONSOLE_DLL("QMAKE_LFLAGS_CONSOLE_DLL"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_DEBUG("QMAKE_LFLAGS_DEBUG"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_PLUGIN("QMAKE_LFLAGS_PLUGIN"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_QT_DLL("QMAKE_LFLAGS_QT_DLL"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_RELEASE("QMAKE_LFLAGS_RELEASE"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_RPATH("QMAKE_LFLAGS_RPATH"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_SHAPP("QMAKE_LFLAGS_SHAPP"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_SHLIB("QMAKE_LFLAGS_SHLIB"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_SONAME("QMAKE_LFLAGS_SONAME"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_THREAD("QMAKE_LFLAGS_THREAD"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_WINDOWS("QMAKE_LFLAGS_WINDOWS"), //$NON-NLS-1$
	VAR_QMAKE_LFLAGS_WINDOWS_DLL("QMAKE_LFLAGS_WINDOWS_DLL"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR("QMAKE_LIBDIR"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR_EGL("QMAKE_LIBDIR_EGL"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR_FLAGS("QMAKE_LIBDIR_FLAGS"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR_OPENGL("QMAKE_LIBDIR_OPENGL"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR_OPENVG("QMAKE_LIBDIR_OPENVG"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR_QT("QMAKE_LIBDIR_QT"), //$NON-NLS-1$
	VAR_QMAKE_LIBDIR_X("QMAKE_LIBDIR_X11"), //$NON-NLS-1$
	VAR_QMAKE_LIBS("QMAKE_LIBS"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_CONSOLE("QMAKE_LIBS_CONSOLE"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_EGL("QMAKE_LIBS_EGL"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_OPENGL("QMAKE_LIBS_OPENGL"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_OPENGL_ES1("QMAKE_LIBS_OPENGL_ES1"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_OPENGL_ES2("QMAKE_LIBS_OPENGL_ES2"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_OPENGL_QT("QMAKE_LIBS_OPENGL_QT"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_OPENVG("QMAKE_LIBS_OPENVG"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_QT("QMAKE_LIBS_QT"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_QT_DLL("QMAKE_LIBS_QT_DLL"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_QT_OPENGL("QMAKE_LIBS_QT_OPENGL"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_QT_THREAD("QMAKE_LIBS_QT_THREAD"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_RT("QMAKE_LIBS_RT"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_RTMT("QMAKE_LIBS_RTMT"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_THREAD("QMAKE_LIBS_THREAD"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_WINDOWS("QMAKE_LIBS_WINDOWS"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_X11("QMAKE_LIBS_X11"), //$NON-NLS-1$
	VAR_QMAKE_LIBS_X11SM("QMAKE_LIBS_X11SM"), //$NON-NLS-1$
	VAR_QMAKE_LIB_FLAG("QMAKE_LIB_FLAG"), //$NON-NLS-1$
	VAR_QMAKE_LINK("QMAKE_LINK"), //$NON-NLS-1$
	VAR_QMAKE_LINK_SHLIB_CMD("QMAKE_LINK_SHLIB_CMD"), //$NON-NLS-1$
	VAR_QMAKE_LN_SHLIB("QMAKE_LN_SHLIB"), //$NON-NLS-1$
	VAR_QMAKE_MACOSX_DEPLOYMENT_TARGET("QMAKE_MACOSX_DEPLOYMENT_TARGET"), //$NON-NLS-1$
	VAR_QMAKE_MAC_SDK("QMAKE_MAC_SDK"), //$NON-NLS-1$
	VAR_QMAKE_MAKEFILE("QMAKE_MAKEFILE"), //$NON-NLS-1$
	VAR_QMAKE_MOC_SRC("QMAKE_MOC_SRC"), //$NON-NLS-1$
	VAR_QMAKE_POST_LINK("QMAKE_POST_LINK"), //$NON-NLS-1$
	VAR_QMAKE_PRE_LINK("QMAKE_PRE_LINK"), //$NON-NLS-1$
	VAR_QMAKE_PROJECT_NAME("QMAKE_PROJECT_NAME"), //$NON-NLS-1$
	VAR_QMAKE_QMAKE("QMAKE_QMAKE"), //$NON-NLS-1$
	VAR_QMAKE_QT_DLL("QMAKE_QT_DLL"), //$NON-NLS-1$
	VAR_QMAKE_RESOURCE_FLAGS("QMAKE_RESOURCE_FLAGS"), //$NON-NLS-1$
	VAR_QMAKE_RPATH("QMAKE_RPATH"), //$NON-NLS-1$
	VAR_QMAKE_RPATHDIR("QMAKE_RPATHDIR"), //$NON-NLS-1$
	VAR_QMAKE_RUN_CC("QMAKE_RUN_CC"), //$NON-NLS-1$
	VAR_QMAKE_RUN_CC_IMP("QMAKE_RUN_CC_IMP"), //$NON-NLS-1$
	VAR_QMAKE_RUN_CXX("QMAKE_RUN_CXX"), //$NON-NLS-1$
	VAR_QMAKE_RUN_CXX_IMP("QMAKE_RUN_CXX_IMP"), //$NON-NLS-1$
	VAR_QMAKE_TARGET("QMAKE_TARGET"), //$NON-NLS-1$
	VAR_QMAKE_UIC("QMAKE_UIC"), //$NON-NLS-1$
	VAR_QT("QT"), //$NON-NLS-1$
	VAR_QTPLUGIN("QTPLUGIN"), //$NON-NLS-1$
	VAR_QT_MAJOR_VERSION("QT_MAJOR_VERSION"), //$NON-NLS-1$
	VAR_QT_MINOR_VERSION("QT_MINOR_VERSION"), //$NON-NLS-1$
	VAR_QT_PATCH_VERSION("QT_PATCH_VERSION"), //$NON-NLS-1$
	VAR_QT_VERSION("QT_VERSION"), //$NON-NLS-1$
	VAR_RCC_DIR("RCC_DIR"), //$NON-NLS-1$
	VAR_RC_FILE("RC_FILE"), //$NON-NLS-1$
	VAR_REQUIRES("REQUIRES"), //$NON-NLS-1$
	VAR_RESOURCES("RESOURCES"), //$NON-NLS-1$
	VAR_RES_FILE("RES_FILE"), //$NON-NLS-1$
	VAR_RSS_RULES("RSS_RULES"), //$NON-NLS-1$
	VAR_SIGNATURE_FILE("SIGNATURE_FILE"), //$NON-NLS-1$
	VAR_SOURCES("SOURCES"), //$NON-NLS-1$
	VAR_SRCMOC("SRCMOC"), //$NON-NLS-1$
	VAR_STATECHARTS("STATECHARTS"), //$NON-NLS-1$
	VAR_SUBDIRS("SUBDIRS"), //$NON-NLS-1$
	VAR_TARGET("TARGET"), //$NON-NLS-1$
	VAR_TEMPLATE("TEMPLATE"), //$NON-NLS-1$
	VAR_TRANSLATIONS("TRANSLATIONS"), //$NON-NLS-1$
	VAR_UICIMPLS("UICIMPLS"), //$NON-NLS-1$
	VAR_UICOBJECTS("UICOBJECTS"), //$NON-NLS-1$
	VAR_UI_DIR("UI_DIR"), //$NON-NLS-1$
	VAR_UI_HEADERS_DIR("UI_HEADERS_DIR"), //$NON-NLS-1$
	VAR_UI_SOURCES_DIR("UI_SOURCES_DIR"), //$NON-NLS-1$
	VAR_VERSION("VERSION"), //$NON-NLS-1$
	VAR_VERSION_PE_HEADER("VERSION_PE_HEADER"), //$NON-NLS-1$
	VAR_VER_MAJ("VER_MAJ"), //$NON-NLS-1$
	VAR_VER_MIN("VER_MIN"), //$NON-NLS-1$
	VAR_VER_PAT("VER_PAT"), //$NON-NLS-1$
	VAR_VPATH("VPATH"), //$NON-NLS-1$
	VAR_YACCIMPLS("YACCIMPLS"), //$NON-NLS-1$
	VAR_YACCOBJECTS("YACCOBJECTS"), //$NON-NLS-1$
	VAR_YACCSOURCES("YACCSOURCES"), //$NON-NLS-1$
	VAR__PRO_FILE_("_PRO_FILE_"), //$NON-NLS-1$
	VAR__PRO_FILE_PWD_("_PRO_FILE_PWD_"); //$NON-NLS-1$

	private final String keyword;

	QtProjectFileKeyword(String key) {
		this.keyword = key;
	}

	/**
	 * Returns a <code>String</code> containing this keyword's identifier.
	 *
	 * @return a string
	 */
	public String getKeyword() {
		return keyword;
	}

	private static QtProjectFileKeyword[] getKeywordsWithPrefix(String prefix) {
		ArrayList<QtProjectFileKeyword> list = new ArrayList<>();
		for (QtProjectFileKeyword word : QtProjectFileKeyword.values()) {
			if (word.name().startsWith(prefix)) {
				list.add(word);
			}
		}
		QtProjectFileKeyword[] array = new QtProjectFileKeyword[list.size()];
		return list.toArray(array);
	}

	/**
	 * Returns all keywords associated with functions in qmake.
	 *
	 * @return an array of keywords
	 */
	public static QtProjectFileKeyword[] getFunctionKeywords() {
		return getKeywordsWithPrefix("FUNC_"); //$NON-NLS-1$
	}

	/**
	 * Returns all keywords associated with variables in qmake.
	 *
	 * @return an array of keywords
	 */
	public static QtProjectFileKeyword[] getVariableKeywords() {
		return getKeywordsWithPrefix("VAR_"); //$NON-NLS-1$
	}
}
