/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ColocatedRepositoryTracker;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.p2.ui.dialogs.AddRepositoryDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.ComboAutoCompleteField;
import org.eclipse.equinox.internal.p2.ui.dialogs.IRepositoryManipulationHook;
import org.eclipse.equinox.internal.p2.ui.dialogs.IRepositorySelectionListener;
import org.eclipse.equinox.internal.p2.ui.dialogs.URLDropAdapter;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class RepositorySelectionGroup {
    private static final String SITE_NONE = ProvUIMessages.AvailableIUsPage_NoSites;
    private static final String SITE_ALL = ProvUIMessages.AvailableIUsPage_AllSites;
    private static final String SITE_LOCAL = ProvUIMessages.AvailableIUsPage_LocalSites;
    private static final int INDEX_SITE_NONE = 0;
    private static final int INDEX_SITE_ALL = 1;
    private static final int DEC_MARGIN_WIDTH = 2;
    private static final String LINKACTION = "linkAction";
    private static final int COUNT_VISIBLE_ITEMS = 20;
    IWizardContainer container;
    ProvisioningUI ui;
    IUViewQueryContext queryContext;
    ListenerList<IRepositorySelectionListener> listeners = new ListenerList();
    Combo repoCombo;
    Link repoManipulatorLink;
    ControlDecoration repoDec;
    ComboAutoCompleteField repoAutoComplete;
    ProvUIProvisioningListener comboRepoListener;
    IRepositoryManipulationHook repositoryManipulationHook;
    Image info;
    Image warning;
    Image error;
    URI[] comboRepos;
    HashMap<String, URI> disabledRepoProposals = new HashMap();

    public RepositorySelectionGroup(ProvisioningUI ui, IWizardContainer container, Composite parent, IUViewQueryContext queryContext) {
        this.container = container;
        this.queryContext = queryContext;
        this.ui = ui;
        this.createControl(parent);
    }

    public Control getDefaultFocusControl() {
        return this.repoCombo;
    }

    public void addRepositorySelectionListener(IRepositorySelectionListener listener) {
        this.listeners.add((Object)listener);
    }

    protected void createControl(Composite parent) {
        RepositoryTracker tracker = this.ui.getRepositoryTracker();
        this.info = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        this.warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        Composite comboComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginBottom = 4;
        layout.numColumns = 4;
        layout.marginWidth = 0;
        comboComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        comboComposite.setLayoutData((Object)gd);
        comboComposite.setFont(parent.getFont());
        Label label = new Label(comboComposite, 0);
        label.setText(ProvUIMessages.AvailableIUsPage_RepoFilterLabel);
        label.setFont(comboComposite.getFont());
        this.repoCombo = new Combo(comboComposite, 4);
        this.repoCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.repoComboSelectionChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.repoComboSelectionChanged();
            }
        });
        this.repoAutoComplete = new ComboAutoCompleteField(this.repoCombo);
        this.repoCombo.setVisibleItemCount(20);
        this.repoCombo.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                this.addRepository(false);
            }
        }));
        this.repoCombo.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 4;
        this.repoCombo.setLayoutData((Object)gd);
        this.repoCombo.setFont(comboComposite.getFont());
        this.repoCombo.addModifyListener(event -> {
            URI location = null;
            IStatus status = null;
            String text = this.repoCombo.getText().trim();
            int index = this.getComboIndex(text);
            if (index < 0) {
                location = tracker.locationFromString(this.repoCombo.getText());
                status = location == null ? tracker.getInvalidLocationStatus(this.repoCombo.getText()) : tracker.validateRepositoryLocation(this.ui.getSession(), location, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                this.repoComboSelectionChanged();
            }
            this.setRepoComboDecoration(status);
        });
        this.repoDec = new ControlDecoration((Control)this.repoCombo, 16512);
        this.repoDec.setMarginWidth(2);
        DropTarget target = new DropTarget((Control)this.repoCombo, 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new URLDropAdapter(true){

            @Override
            protected void handleDrop(String urlText, DropTargetEvent event) {
                RepositorySelectionGroup.this.repoCombo.setText(urlText);
                event.detail = 4;
                RepositorySelectionGroup.this.addRepository(false);
            }
        });
        Button button = new Button(comboComposite, 8);
        button.setText(ProvUIMessages.AvailableIUsPage_AddButton);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.addRepository(true);
            }

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.addRepository(true);
            }
        });
        this.setButtonLayoutData(button);
        button.setFont(comboComposite.getFont());
        this.createRepoManipulatorButton(comboComposite);
        this.addComboProvisioningListeners();
        parent.addDisposeListener(e -> this.removeProvisioningListeners());
    }

    private void createRepoManipulatorButton(Composite comboComposite) {
        Button repoManipulatorButton = new Button(comboComposite, 8);
        repoManipulatorButton.setText(ProvUIMessages.RepositoryManipulationPage_Manage);
        this.setButtonLayoutData(repoManipulatorButton);
        repoManipulatorButton.setFont(comboComposite.getFont());
        repoManipulatorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.openRepoManipulatorUi()));
    }

    private void openRepoManipulatorUi() {
        if (this.repositoryManipulationHook != null) {
            this.repositoryManipulationHook.preManipulateRepositories();
        }
        this.ui.manipulateRepositories(this.repoCombo.getShell());
        if (this.repositoryManipulationHook != null) {
            this.repositoryManipulationHook.postManipulateRepositories();
        }
    }

    private void setButtonLayoutData(Button button) {
        GridData data = new GridData(4, 0x1000000, false, false);
        GC gc = new GC((Drawable)button);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fm, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    public void setRepositorySelection(int scope, URI location) {
        switch (scope) {
            case 1: {
                this.fillRepoCombo(SITE_ALL);
                break;
            }
            case 3: {
                this.fillRepoCombo(SITE_LOCAL);
                break;
            }
            case 4: {
                this.fillRepoCombo(this.getSiteString(location));
                break;
            }
            default: {
                this.fillRepoCombo(SITE_NONE);
            }
        }
        this.setRepoComboDecoration(null);
    }

    public void setRepositoryManipulationHook(IRepositoryManipulationHook hook) {
        this.repositoryManipulationHook = hook;
    }

    protected void setRepoComboDecoration(IStatus status) {
        if (status == null || status.isOK() || status.getSeverity() == 8) {
            this.repoDec.setShowOnlyOnFocus(true);
            this.repoDec.setDescriptionText(ProvUIMessages.AvailableIUsPage_RepoFilterInstructions);
            this.repoDec.setImage(this.info);
            if (this.repoCombo.getText().length() > 0) {
                this.repoDec.showHoverText(null);
            }
            return;
        }
        Image image = status.getSeverity() == 2 ? this.warning : (status.getSeverity() == 4 ? this.error : this.info);
        this.repoDec.setImage(image);
        this.repoDec.setDescriptionText(status.getMessage());
        this.repoDec.setShowOnlyOnFocus(false);
        this.repoCombo.getDisplay().timerExec(500, () -> {
            if (this.repoDec != null && this.repoDec.getImage() != this.info) {
                this.repoDec.showHoverText(status.getMessage());
            }
        });
    }

    void fillRepoCombo(String selection) {
        String[] items;
        boolean hasLocalSites;
        RepositoryTracker tracker = this.ui.getRepositoryTracker();
        URI[] sites = tracker.getKnownRepositories(this.ui.getSession());
        boolean bl = hasLocalSites = this.getLocalSites().length > 0;
        if (hasLocalSites) {
            this.comboRepos = new URI[sites.length + 3];
            items = new String[sites.length + 3];
        } else {
            this.comboRepos = new URI[sites.length + 2];
            items = new String[sites.length + 2];
        }
        items[0] = SITE_NONE;
        items[1] = SITE_ALL;
        int i = 0;
        while (i < sites.length) {
            items[i + 2] = this.getSiteString(sites[i]);
            this.comboRepos[i + 2] = sites[i];
            ++i;
        }
        if (hasLocalSites) {
            items[items.length - 1] = SITE_LOCAL;
        }
        if (sites.length > 0) {
            this.sortRepoItems(items, this.comboRepos, hasLocalSites);
        }
        Runnable runnable = () -> {
            if (this.repoCombo == null || this.repoCombo.isDisposed()) {
                return;
            }
            String repoToSelect = selection;
            if (repoToSelect == null) {
                int selIndex = this.repoCombo.getSelectionIndex();
                repoToSelect = selIndex >= 0 ? this.repoCombo.getItem(selIndex) : this.repoCombo.getText();
            }
            this.repoCombo.setItems(items);
            this.repoAutoComplete.setProposalStrings(this.getComboProposals());
            boolean selected = false;
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(repoToSelect)) {
                    selected = true;
                    if (this.repoCombo.getListVisible()) {
                        this.repoCombo.select(i);
                    }
                    this.repoCombo.setText(repoToSelect);
                    break;
                }
                ++i;
            }
            if (!selected) {
                if (this.repoCombo.getListVisible()) {
                    this.repoCombo.select(0);
                }
                this.repoCombo.setText(SITE_NONE);
            }
            this.repoComboSelectionChanged();
        };
        if (Display.getCurrent() == null) {
            this.repoCombo.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    String getSiteString(URI uri) {
        String nickname = this.getMetadataRepositoryManager().getRepositoryProperty(uri, "p2.nickname");
        if (nickname != null && nickname.length() > 0) {
            return NLS.bind((String)ProvUIMessages.AvailableIUsPage_NameWithLocation, (Object[])new Object[]{nickname, ProvUIMessages.RepositorySelectionGroup_NameAndLocationSeparator, URIUtil.toUnencodedString((URI)uri)});
        }
        return URIUtil.toUnencodedString((URI)uri);
    }

    IAction getLinkAction(Widget widget) {
        Object data = widget.getData(LINKACTION);
        if (data == null || !(data instanceof IAction)) {
            return null;
        }
        return (IAction)data;
    }

    private void sortRepoItems(String[] strings, URI[] locations, boolean hasLocalSites) {
        int sortEnd;
        int sortStart = 2;
        int n = sortEnd = hasLocalSites ? strings.length - 2 : strings.length - 1;
        if (sortStart >= sortEnd) {
            return;
        }
        HashMap<URI, String> uriToString = new HashMap<URI, String>();
        int i = sortStart;
        while (i <= sortEnd) {
            uriToString.put(locations[i], strings[i]);
            ++i;
        }
        Collator collator = Collator.getInstance((Locale)Locale.getDefault());
        Comparator stringComparator = (a, b) -> collator.compare(a, b);
        Comparator uriComparator = (a, b) -> collator.compare((String)uriToString.get(a), (String)uriToString.get(b));
        Arrays.sort(strings, sortStart, sortEnd, stringComparator);
        Arrays.sort(locations, sortStart, sortEnd, uriComparator);
    }

    private URI[] getLocalSites() {
        int flags = this.ui.getRepositoryTracker().getMetadataRepositoryFlags() | 4;
        return this.getMetadataRepositoryManager().getKnownRepositories(flags);
    }

    String[] getComboProposals() {
        int flags = this.ui.getRepositoryTracker().getMetadataRepositoryFlags() | 8;
        String[] items = this.repoCombo.getItems();
        this.disabledRepoProposals = new HashMap();
        URI[] disabled = this.getMetadataRepositoryManager().getKnownRepositories(flags);
        String[] disabledItems = new String[disabled.length];
        int i = 0;
        while (i < disabledItems.length) {
            disabledItems[i] = this.getSiteString(disabled[i]);
            this.disabledRepoProposals.put(disabledItems[i], disabled[i]);
            ++i;
        }
        String[] both = new String[items.length + disabledItems.length];
        System.arraycopy(items, 0, both, 0, items.length);
        System.arraycopy(disabledItems, 0, both, items.length, disabledItems.length);
        return both;
    }

    int getComboIndex(String repoText) {
        int i;
        if ((repoText = repoText.trim()).length() > 0) {
            String[] items = this.repoCombo.getItems();
            i = 0;
            while (i < items.length) {
                if (repoText.equals(items[i])) {
                    return i;
                }
                ++i;
            }
        }
        try {
            URI location = URIUtil.fromString((String)repoText);
            i = 0;
            while (i < this.comboRepos.length) {
                if (URIUtil.sameURI((URI)location, (URI)this.comboRepos[i])) {
                    return i;
                }
                ++i;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        int length = repoText.length();
        if (length > 0 && repoText.charAt(length - 1) == '/') {
            return this.getComboIndex(repoText.substring(0, length - 1));
        }
        return -1;
    }

    void addComboProvisioningListeners() {
        this.comboRepoListener = new ProvUIProvisioningListener(this.getClass().getName(), 1, this.ui.getOperationRunner()){

            @Override
            protected void repositoryAdded(RepositoryEvent e) {
                RepositorySelectionGroup.this.fillRepoCombo(RepositorySelectionGroup.this.getSiteString(e.getRepositoryLocation()));
            }

            @Override
            protected void repositoryRemoved(RepositoryEvent e) {
                RepositorySelectionGroup.this.fillRepoCombo(null);
            }

            @Override
            protected void refreshAll() {
                RepositorySelectionGroup.this.fillRepoCombo(null);
            }
        };
        ProvUI.getProvisioningEventBus(this.ui.getSession()).addListener((ProvisioningListener)this.comboRepoListener);
    }

    void removeProvisioningListeners() {
        if (this.comboRepoListener != null) {
            ProvUI.getProvisioningEventBus(this.ui.getSession()).removeListener((ProvisioningListener)this.comboRepoListener);
            this.comboRepoListener = null;
        }
    }

    void addRepository(boolean alwaysPrompt) {
        boolean isNewText;
        final RepositoryTracker manipulator = this.ui.getRepositoryTracker();
        final String selectedRepo = this.repoCombo.getText().trim();
        int selectionIndex = this.getComboIndex(selectedRepo);
        boolean bl = isNewText = selectionIndex < 0;
        if (!alwaysPrompt && !isNewText && selectionIndex != this.repoCombo.getSelectionIndex()) {
            this.repoComboSelectionChanged();
        } else if (alwaysPrompt) {
            AddRepositoryDialog dialog = new AddRepositoryDialog(this.repoCombo.getShell(), this.ui){

                @Override
                protected String getInitialLocationText() {
                    if (isNewText) {
                        URI loc = manipulator.locationFromString(selectedRepo);
                        return loc.toString();
                    }
                    return super.getInitialLocationText();
                }

                @Override
                protected String getInitialNameText() {
                    String parsedNickname;
                    URI loc;
                    if (isNewText && (loc = manipulator.locationFromString(selectedRepo)) != null && manipulator instanceof ColocatedRepositoryTracker && (parsedNickname = ((ColocatedRepositoryTracker)manipulator).getParsedNickname(loc)) != null) {
                        return parsedNickname;
                    }
                    return super.getInitialNameText();
                }
            };
            dialog.setTitle(ProvUIMessages.AddRepositoryDialog_Title);
            dialog.open();
            URI location = dialog.getAddedLocation();
            if (location != null) {
                this.fillRepoCombo(this.getSiteString(location));
            }
        } else if (isNewText) {
            try {
                this.container.run(false, false, monitor -> {
                    IStatus status;
                    URI location;
                    if (this.disabledRepoProposals.containsKey(selectedRepo)) {
                        location = this.disabledRepoProposals.get(selectedRepo);
                        status = Status.OK_STATUS;
                    } else {
                        location = manipulator.locationFromString(selectedRepo);
                        status = location == null ? manipulator.getInvalidLocationStatus(selectedRepo) : manipulator.validateRepositoryLocation(this.ui.getSession(), location, false, monitor);
                    }
                    if (status.isOK() && location != null) {
                        String nick = null;
                        if (manipulator instanceof ColocatedRepositoryTracker) {
                            nick = ((ColocatedRepositoryTracker)manipulator).getParsedNickname(location);
                        }
                        manipulator.addRepository(location, nick, this.ui.getSession());
                        this.fillRepoCombo(this.getSiteString(location));
                    }
                    this.setRepoComboDecoration(status);
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ProvisioningContext getProvisioningContext() {
        int siteSel = this.getComboIndex(this.repoCombo.getText().trim());
        if (siteSel < 0 || siteSel == 1 || siteSel == 0) {
            return new ProvisioningContext(this.ui.getSession().getProvisioningAgent());
        }
        URI[] locals = this.getLocalSites();
        if (locals.length > 0 && siteSel == this.repoCombo.getItemCount() - 1) {
            ProvisioningContext context = new ProvisioningContext(this.ui.getSession().getProvisioningAgent());
            context.setMetadataRepositories(locals);
            context.setArtifactRepositories(locals);
            return context;
        }
        ProvisioningContext context = new ProvisioningContext(this.ui.getSession().getProvisioningAgent());
        context.setMetadataRepositories(new URI[]{this.comboRepos[siteSel]});
        context.setArtifactRepositories(new URI[]{this.comboRepos[siteSel]});
        return context;
    }

    void repoComboSelectionChanged() {
        int localIndex;
        int repoChoice = -1;
        URI repoLocation = null;
        int selection = -1;
        selection = this.repoCombo.getListVisible() ? this.repoCombo.getSelectionIndex() : this.getComboIndex(this.repoCombo.getText().trim());
        int n = localIndex = this.getLocalSites().length == 0 ? this.repoCombo.getItemCount() : this.repoCombo.getItemCount() - 1;
        if (this.comboRepos == null || selection < 0) {
            selection = 0;
        }
        if (selection == 0) {
            repoChoice = 2;
        } else if (selection == 1) {
            repoChoice = 1;
        } else if (selection >= localIndex) {
            repoChoice = 3;
        } else {
            repoChoice = 4;
            repoLocation = this.comboRepos[selection];
        }
        for (IRepositorySelectionListener listener : this.listeners) {
            listener.repositorySelectionChanged(repoChoice, repoLocation);
        }
    }

    IMetadataRepositoryManager getMetadataRepositoryManager() {
        return ProvUI.getMetadataRepositoryManager(this.ui.getSession());
    }
}

