/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.autotools.core;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.autotools.core.AutotoolsBuildConfiguration;
import org.eclipse.cdt.core.autotools.core.internal.Activator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class AutotoolsBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.core.autotools.core.provider";
    private ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);

    public String getId() {
        return ID;
    }

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        IToolChain tc;
        IToolChain toolChain = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("os", Platform.getOS());
        properties.put("arch", Platform.getOSArch());
        IToolChainManager toolChainManager = Activator.getService(IToolChainManager.class);
        Iterator iterator = toolChainManager.getToolChainsMatching(properties).iterator();
        if (iterator.hasNext()) {
            toolChain = tc = (IToolChain)iterator.next();
        }
        if (toolChain == null && (iterator = toolChainManager.getToolChainsMatching(new HashMap()).iterator()).hasNext()) {
            toolChain = tc = (IToolChain)iterator.next();
        }
        if (toolChain != null) {
            return new AutotoolsBuildConfiguration(config, name, toolChain);
        }
        return null;
    }

    public ICBuildConfiguration createBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, IProgressMonitor monitor) throws CoreException {
        String arch;
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            CBuildConfiguration cmakeConfig;
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            ICBuildConfiguration cconfig = (ICBuildConfiguration)config.getAdapter(ICBuildConfiguration.class);
            if (cconfig != null && (cmakeConfig = (CBuildConfiguration)cconfig.getAdapter(AutotoolsBuildConfiguration.class)) != null && cmakeConfig.getToolChain().equals(toolChain) && launchMode.equals(cmakeConfig.getLaunchMode())) {
                return cconfig;
            }
            ++n2;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String os = toolChain.getProperty("os");
        if (os != null && !os.isEmpty()) {
            properties.put("os", os);
        }
        if (!(arch = toolChain.getProperty("arch")).isEmpty()) {
            properties.put("arch", arch);
        }
        String configName = "autotools." + launchMode + '.' + toolChain.getId();
        IBuildConfiguration config = this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, configName, monitor);
        AutotoolsBuildConfiguration autotoolsConfig = new AutotoolsBuildConfiguration(config, configName);
        this.configManager.addBuildConfiguration(config, (ICBuildConfiguration)autotoolsConfig);
        return autotoolsConfig;
    }
}

