/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalDeclaredVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.VariableHelpers;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPVariable
extends PlatformObject
implements ICPPInternalDeclaredVariable {
    private IASTName fDefinition;
    private IASTName[] fDeclarations;
    private IType fType;
    private IValue fInitialValue = IntegralValue.NOT_INITIALIZED;
    private boolean fAllResolved;
    private static final ThreadLocal<Set<CPPVariable>> fInitialValueInProgress = new ThreadLocal<Set<CPPVariable>>(){

        @Override
        protected Set<CPPVariable> initialValue() {
            return new HashSet<CPPVariable>();
        }
    };

    public CPPVariable(IASTName name) {
        boolean isDef;
        boolean bl = isDef = name != null && name.isDefinition();
        if (name instanceof ICPPASTQualifiedName) {
            name = name.getLastName();
        }
        if (isDef) {
            this.fDefinition = name;
        } else {
            this.fDeclarations = new IASTName[]{name};
        }
        if (name != null) {
            name.setBinding(this);
        } else assert (this instanceof CPPBuiltinVariable);
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.fDefinition == null && name.isDefinition()) {
            this.fDefinition = name;
        } else {
            this.fDeclarations = this.fDeclarations == null ? new IASTName[]{name} : (this.fDeclarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.fDeclarations[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.fDeclarations, name) : ArrayUtil.append(IASTName.class, this.fDeclarations, name));
        }
        if (this.fType instanceof IArrayType) {
            this.fType = null;
        }
        this.fInitialValue = IntegralValue.NOT_INITIALIZED;
    }

    public IASTName[] getDeclarations() {
        return this.fDeclarations == null ? null : ArrayUtil.trim(this.fDeclarations);
    }

    @Override
    public IASTNode getDefinition() {
        return this.fDefinition;
    }

    @Override
    public IType getType() {
        if (this.fType != null) {
            return this.fType;
        }
        boolean allResolved = this.fAllResolved;
        this.fAllResolved = true;
        this.fType = VariableHelpers.createType(this, this.fDefinition, this.getDeclarations(), allResolved);
        return this.fType;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        if (this.fDeclarations != null) {
            return this.fDeclarations[0].getSimpleID();
        }
        return this.fDefinition.getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.fDefinition != null ? this.fDefinition : this.fDeclarations[0]);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    @Override
    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        return VariableHelpers.hasStorageClass(name, ns, storage);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return VariableHelpers.isConstexpr(this.fDefinition);
    }

    @Override
    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    @Override
    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isExternC() {
        return CPPVisitor.isExternC(this.getDefinition(), this.getDeclarations());
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        IASTName node = this.fDefinition != null ? this.fDefinition : this.fDeclarations[0];
        return CPPVisitor.findNameOwner(node, !this.hasStorageClass(2));
    }

    @Override
    public IValue getInitialValue() {
        if (this.fInitialValue == IntegralValue.NOT_INITIALIZED) {
            this.fInitialValue = this.computeInitialValue();
        }
        return this.fInitialValue;
    }

    private IValue computeInitialValue() {
        Set<CPPVariable> recursionProtectionSet = fInitialValueInProgress.get();
        if (!recursionProtectionSet.add(this)) {
            return IntegralValue.UNKNOWN;
        }
        try {
            IValue initialValue = null;
            IType nestedType = SemanticUtil.getNestedType(this.getType(), 13);
            if (nestedType instanceof ICPPClassType || (initialValue = VariableHelpers.getInitialValue(this.fDefinition, this.fDeclarations, this.getType())) == IntegralValue.UNKNOWN) {
                ICPPEvaluation initEval = this.getInitializerEvaluation();
                if (initEval == null) {
                    return null;
                }
                if (!initEval.isValueDependent()) {
                    IASTName point = this.fDefinition != null ? this.fDefinition : this.fDeclarations[0];
                    CPPSemantics.pushLookupPoint(point);
                    try {
                        IValue iValue = initEval.getValue();
                        return iValue;
                    }
                    finally {
                        CPPSemantics.popLookupPoint();
                    }
                }
                DependentValue dependentValue = DependentValue.create(initEval);
                return dependentValue;
            }
            IValue iValue = initialValue;
            return iValue;
        }
        finally {
            recursionProtectionSet.remove(this);
        }
    }

    private IASTDeclarator findDeclarator() {
        IASTDeclarator declarator = null;
        if (this.fDefinition != null && (declarator = VariableHelpers.findDeclarator(this.fDefinition)) != null) {
            return declarator;
        }
        if (this.fDeclarations != null) {
            IASTName[] iASTNameArray = this.fDeclarations;
            int n = this.fDeclarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName decl = iASTNameArray[n2];
                if (decl == null) break;
                declarator = VariableHelpers.findDeclarator(decl);
                if (declarator != null) {
                    return declarator;
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public ICPPEvaluation getInitializerEvaluation() {
        ICPPASTDeclarator declarator = (ICPPASTDeclarator)this.findDeclarator();
        if (declarator != null) {
            IASTInitializer initializer = declarator.getInitializer();
            ICPPConstructor constructor = CPPVariable.getImplicitlyCalledCtor(declarator);
            if (constructor != null) {
                ICPPEvaluation[] arguments = EvalConstructor.extractArguments(initializer, constructor);
                return new EvalConstructor(this.getType(), constructor, arguments, declarator);
            }
            if (initializer instanceof IASTEqualsInitializer) {
                IASTEqualsInitializer equalsInitializer = (IASTEqualsInitializer)initializer;
                ICPPASTInitializerClause clause = (ICPPASTInitializerClause)equalsInitializer.getInitializerClause();
                return clause.getEvaluation();
            }
            if (initializer instanceof ICPPASTInitializerList) {
                return ((ICPPASTInitializerClause)((Object)initializer)).getEvaluation();
            }
            if (initializer instanceof ICPPASTConstructorInitializer) {
                ICPPASTConstructorInitializer ctorInitializer = (ICPPASTConstructorInitializer)initializer;
                ICPPASTInitializerClause evalOwner = (ICPPASTInitializerClause)ctorInitializer.getArguments()[0];
                return evalOwner.getEvaluation();
            }
            if (initializer == null) {
                return null;
            }
        }
        return EvalFixed.INCOMPLETE;
    }

    private static ICPPConstructor getImplicitlyCalledCtor(ICPPASTDeclarator declarator) {
        IBinding ctor = CPPSemantics.findImplicitlyCalledConstructor(declarator);
        if (ctor instanceof ICPPConstructor && (!EvalUtil.isCompilerGeneratedCtor(ctor) || EvalUtil.isDefaultConstructor((ICPPConstructor)ctor))) {
            return (ICPPConstructor)ctor;
        }
        return null;
    }

    @Override
    public void allDeclarationsDefinitionsAdded() {
        this.fAllResolved = true;
    }
}

