/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceWithSettingsDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenWorkspaceAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_DATA = "-data";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";
    private IWorkbenchWindow window;

    private IContributionItem[] getContributionItems() {
        ArrayList<Object> list = new ArrayList<Object>();
        ChooseWorkspaceData data = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
        data.readPersistedData();
        String current = data.getInitialDefault();
        String[] workspaces = data.getRecentWorkspaces();
        int i = 0;
        while (i < workspaces.length) {
            if (workspaces[i] != null && !workspaces[i].equals(current)) {
                list.add(new ActionContributionItem((IAction)new WorkspaceMRUAction(workspaces[i], data)));
            }
            ++i;
        }
        if (list.size() > 0) {
            list.add(new Separator());
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    public OpenWorkspaceAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.OpenWorkspaceAction_text, 4);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.setToolTipText(IDEWorkbenchMessages.OpenWorkspaceAction_toolTip);
        this.setActionDefinitionId("org.eclipse.ui.file.openWorkspace");
        this.setMenuCreator(new MenuCreator());
    }

    public void run() {
        String path = this.promptForWorkspace();
        if (path == null) {
            return;
        }
        this.restart(path);
    }

    private void restart(String path) {
        String command_line = this.buildCommandLine(path);
        if (command_line == null) {
            return;
        }
        System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
        System.setProperty(PROP_EXIT_DATA, command_line);
        this.window.getWorkbench().restart();
    }

    private String promptForWorkspace() {
        ChooseWorkspaceData data = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
        ChooseWorkspaceWithSettingsDialog dialog = new ChooseWorkspaceWithSettingsDialog(this.window.getShell(), data, true, false);
        dialog.prompt(true);
        String selection = data.getSelection();
        if (selection == null) {
            return null;
        }
        data.writePersistedData();
        return selection;
    }

    private String buildCommandLine(String workspace) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.OpenWorkspaceAction_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.OpenWorkspaceAction_errorMessage, (Object)PROP_VM));
            return null;
        }
        StringBuilder result = new StringBuilder(512);
        result.append(property);
        result.append(NEW_LINE);
        String vmargs = System.getProperty(PROP_VMARGS);
        if (vmargs != null) {
            result.append(vmargs);
        }
        if ((property = System.getProperty(PROP_COMMANDS)) == null) {
            result.append(CMD_DATA);
            result.append(NEW_LINE);
            result.append(workspace);
            result.append(NEW_LINE);
        } else {
            int cmd_data_pos = property.lastIndexOf(CMD_DATA);
            if (cmd_data_pos != -1) {
                result.append(property.substring(0, cmd_data_pos += CMD_DATA.length() + 1));
                result.append(workspace);
                int nextArg = property.indexOf("\n-", cmd_data_pos - 1);
                if (nextArg != -1) {
                    result.append(property.substring(nextArg));
                }
            } else {
                result.append(CMD_DATA);
                result.append(NEW_LINE);
                result.append(workspace);
                result.append(NEW_LINE);
                result.append(property);
            }
        }
        if (vmargs != null) {
            if (result.charAt(result.length() - 1) != '\n') {
                result.append('\n');
            }
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append(vmargs);
        }
        return result.toString();
    }

    public void dispose() {
        this.window = null;
    }

    class MenuCreator
    implements IMenuCreator {
        ArrayList<Menu> menus = new ArrayList();
        private MenuManager dropDownMenuMgr;

        MenuCreator() {
        }

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                this.dropDownMenuMgr.setRemoveAllWhenShown(true);
            }
        }

        public Menu getMenu(Control parent) {
            this.createDropDownMenuMgr();
            this.dropDownMenuMgr.addMenuListener(manager -> {
                IContributionItem[] iContributionItemArray = OpenWorkspaceAction.this.getContributionItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem contributionItem = iContributionItemArray[n2];
                    manager.add(contributionItem);
                    ++n2;
                }
                manager.add((IAction)new OpenDialogAction());
            });
            return this.dropDownMenuMgr.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            this.createDropDownMenuMgr();
            Menu menu = new Menu(parent);
            menu.addListener(22, event -> {
                if (menu.isDisposed()) {
                    return;
                }
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                menuItemArray = OpenWorkspaceAction.this.getContributionItems();
                n = menuItemArray.length;
                n2 = 0;
                while (n2 < n) {
                    MenuItem contribution = menuItemArray[n2];
                    contribution.fill(menu, -1);
                    ++n2;
                }
                new ActionContributionItem((IAction)new OpenDialogAction()).fill(menu, -1);
            });
            return menu;
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
            if (this.menus.size() > 0) {
                for (Menu m : this.menus) {
                    if (m.isDisposed()) continue;
                    m.dispose();
                }
                this.menus.clear();
            }
        }
    }

    class OpenDialogAction
    extends Action {
        OpenDialogAction() {
            super(IDEWorkbenchMessages.OpenWorkspaceAction_other);
            this.setToolTipText(IDEWorkbenchMessages.OpenWorkspaceAction_toolTip);
        }

        public void run() {
            OpenWorkspaceAction.this.run();
        }
    }

    class WorkspaceMRUAction
    extends Action {
        private ChooseWorkspaceData data;
        private String location;

        WorkspaceMRUAction(String location, ChooseWorkspaceData data) {
            this.location = location;
            this.setText(location);
            this.setToolTipText(location);
            this.data = data;
        }

        public void run() {
            this.data.workspaceSelected(this.location);
            this.data.writePersistedData();
            OpenWorkspaceAction.this.restart(this.location);
        }
    }
}

