/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.terminal.model.StyleColor;

public class Style {
    private final StyleColor fForground;
    private final StyleColor fBackground;
    private final boolean fBold;
    private final boolean fBlink;
    private final boolean fUnderline;
    private final boolean fReverse;
    private static final Map<Style, Style> fgStyles = new HashMap<Style, Style>();

    private Style(StyleColor forground, StyleColor background, boolean bold, boolean blink, boolean underline, boolean reverse) {
        this.fForground = forground;
        this.fBackground = background;
        this.fBold = bold;
        this.fBlink = blink;
        this.fUnderline = underline;
        this.fReverse = reverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Style getStyle(StyleColor forground, StyleColor background, boolean bold, boolean blink, boolean underline, boolean reverse) {
        Style cached;
        Style style = new Style(forground, background, bold, blink, underline, reverse);
        Map<Style, Style> map = fgStyles;
        synchronized (map) {
            cached = fgStyles.get(style);
            if (cached == null) {
                cached = style;
                fgStyles.put(cached, cached);
            }
        }
        return cached;
    }

    public static Style getStyle(String forground, String background) {
        return Style.getStyle(StyleColor.getStyleColor(forground), StyleColor.getStyleColor(background), false, false, false, false);
    }

    public static Style getStyle(StyleColor forground, StyleColor background) {
        return Style.getStyle(forground, background, false, false, false, false);
    }

    public Style setForground(StyleColor forground) {
        return Style.getStyle(forground, this.fBackground, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public Style setBackground(StyleColor background) {
        return Style.getStyle(this.fForground, background, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public Style setForground(String colorName) {
        return Style.getStyle(StyleColor.getStyleColor(colorName), this.fBackground, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public Style setBackground(String colorName) {
        return Style.getStyle(this.fForground, StyleColor.getStyleColor(colorName), this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public Style setBold(boolean bold) {
        return Style.getStyle(this.fForground, this.fBackground, bold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public Style setBlink(boolean blink) {
        return Style.getStyle(this.fForground, this.fBackground, this.fBold, blink, this.fUnderline, this.fReverse);
    }

    public Style setUnderline(boolean underline) {
        return Style.getStyle(this.fForground, this.fBackground, this.fBold, this.fBlink, underline, this.fReverse);
    }

    public Style setReverse(boolean reverse) {
        return Style.getStyle(this.fForground, this.fBackground, this.fBold, this.fBlink, this.fUnderline, reverse);
    }

    public StyleColor getBackground() {
        return this.fBackground;
    }

    public boolean isBlink() {
        return this.fBlink;
    }

    public boolean isBold() {
        return this.fBold;
    }

    public StyleColor getForground() {
        return this.fForground;
    }

    public boolean isReverse() {
        return this.fReverse;
    }

    public boolean isUnderline() {
        return this.fUnderline;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fBackground == null ? 0 : this.fBackground.hashCode());
        result = 31 * result + (this.fBlink ? 1231 : 1237);
        result = 31 * result + (this.fBold ? 1231 : 1237);
        result = 31 * result + (this.fForground == null ? 0 : this.fForground.hashCode());
        result = 31 * result + (this.fReverse ? 1231 : 1237);
        result = 31 * result + (this.fUnderline ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)obj;
        if (this.fBackground != other.fBackground) {
            return false;
        }
        if (this.fBlink != other.fBlink) {
            return false;
        }
        if (this.fBold != other.fBold) {
            return false;
        }
        if (this.fForground != other.fForground) {
            return false;
        }
        if (this.fReverse != other.fReverse) {
            return false;
        }
        return this.fUnderline == other.fUnderline;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Style(foreground=");
        result.append(this.fForground);
        result.append(", background=");
        result.append(this.fBackground);
        if (this.fBlink) {
            result.append(", blink");
        }
        if (this.fBold) {
            result.append(", bold");
        }
        if (this.fBlink) {
            result.append(", blink");
        }
        if (this.fReverse) {
            result.append(", reverse");
        }
        if (this.fUnderline) {
            result.append(", underline");
        }
        result.append(")");
        return result.toString();
    }
}

