/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.autotools.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.autotools.core.internal.Activator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class AutotoolsBuildConfiguration
extends CBuildConfiguration {
    public static final String AUTOTOOLS_GENERATOR = "autotools.generator";
    public static final String AUTOTOOLS_ARGUMENTS = "autotools.arguments";
    public static final String BUILD_COMMAND = "autotools.command.build";
    public static final String CLEAN_COMMAND = "autotools.command.clean";

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
    }

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        super(config, name, toolChain, "run");
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.execute(Arrays.asList("autoreconf", "--install"), project.getLocation(), console, monitor);
        this.execute(Arrays.asList("./configure"), project.getLocation(), console, monitor);
        this.execute(Arrays.asList("make"), project.getLocation(), console, monitor);
        return new IProject[]{project};
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        this.execute(Arrays.asList("make", "clean"), this.getProject().getLocation(), console, monitor);
    }

    protected void execute(List<String> command, IPath dir, IConsole console, IProgressMonitor monitor) throws CoreException {
        String cmd = command.get(0);
        if (Platform.getOS().equals("win32") && (!cmd.endsWith(".exe") || cmd.endsWith(".bat"))) {
            Path shPath = this.findCommand("sh");
            if (shPath != null) {
                ArrayList<String> shCommand = new ArrayList<String>();
                shCommand.add(shPath.toString());
                shCommand.add("-c");
                shCommand.add("\"" + String.join((CharSequence)" ", command) + "\"");
                command = shCommand;
            }
        } else {
            Path cmdPath = this.findCommand(cmd);
            if (cmdPath != null) {
                cmd = cmdPath.toString();
                command.set(0, cmd);
            }
        }
        ProcessBuilder builder = new ProcessBuilder(command).directory(dir.toFile());
        this.setBuildEnvironment(builder.environment());
        try {
            Process process = builder.start();
            this.watchProcess(process, console);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus("Error executing: " + String.join((CharSequence)" ", command), e));
        }
        this.getProject().refreshLocal(2, monitor);
    }
}

