/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergePolicyWrapper;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class OneMergeWrappingMergePolicy
extends MergePolicyWrapper {
    private final UnaryOperator<MergePolicy.OneMerge> wrapOneMerge;

    public OneMergeWrappingMergePolicy(MergePolicy in, UnaryOperator<MergePolicy.OneMerge> wrapOneMerge) {
        super(in);
        this.wrapOneMerge = wrapOneMerge;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.wrapSpec(this.in.findMerges(mergeTrigger, segmentInfos, writer));
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        return this.wrapSpec(this.in.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, writer));
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.wrapSpec(this.in.findForcedDeletesMerges(segmentInfos, writer));
    }

    private MergePolicy.MergeSpecification wrapSpec(MergePolicy.MergeSpecification spec) {
        MergePolicy.MergeSpecification wrapped;
        MergePolicy.MergeSpecification mergeSpecification = wrapped = spec == null ? null : new MergePolicy.MergeSpecification();
        if (wrapped != null) {
            for (MergePolicy.OneMerge merge : spec.merges) {
                wrapped.add((MergePolicy.OneMerge)this.wrapOneMerge.apply(merge));
            }
        }
        return wrapped;
    }
}

