/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;

class AggregateInitialization {
    private ICPPEvaluation[] fInitializers;
    private int fIndex = 0;

    public static Cost check(IType target, EvalInitList list) throws DOMException {
        return new AggregateInitialization().checkImpl(target, list);
    }

    private AggregateInitialization() {
    }

    private Cost checkImpl(IType target, EvalInitList list) throws DOMException {
        this.fInitializers = list.getClauses();
        this.fIndex = 0;
        Cost worstCost = new Cost(list.getType(), target, Cost.Rank.IDENTITY);
        Cost cost = this.checkInitializationOfElements(target, worstCost);
        if (!cost.converts()) {
            return cost;
        }
        if (this.fIndex < this.fInitializers.length) {
            return Cost.NO_CONVERSION;
        }
        return worstCost;
    }

    private Cost checkElement(IType type, IValue initialValue, Cost worstCost) throws DOMException {
        assert (!CPPTemplates.isDependentType(type));
        IType nestedType = SemanticUtil.getNestedType(type, 1);
        if (this.fIndex >= this.fInitializers.length) {
            return this.checkInitializationFromDefaultMemberInitializer(nestedType, initialValue, worstCost);
        }
        worstCost = new Cost(this.fInitializers[this.fIndex].getType(), nestedType, Cost.Rank.IDENTITY);
        ICPPEvaluation initializer = this.fInitializers[this.fIndex];
        if (AggregateInitialization.initFromStringLiteral(nestedType, initializer)) {
            ++this.fIndex;
            Number sizeOfCharArrayNumber = AggregateInitialization.getArraySize(nestedType);
            long sizeofCharArray = 0L;
            if (sizeOfCharArrayNumber != null) {
                sizeofCharArray = sizeOfCharArrayNumber.longValue();
            }
            Number sizeofStringLiteralNumber = AggregateInitialization.getArraySize(initializer.getType());
            long sizeofStringLiteral = Long.MAX_VALUE;
            if (sizeofStringLiteralNumber != null) {
                sizeofStringLiteral = sizeofStringLiteralNumber.longValue();
            }
            ICPPBasicType targetCharType = AggregateInitialization.getBasicTypeFromArray(nestedType);
            ICPPBasicType literalCharType = AggregateInitialization.getBasicTypeFromArray(initializer.getType());
            Cost cost = sizeofCharArray >= sizeofStringLiteral && targetCharType.isSameType(literalCharType) ? new Cost(initializer.getType(), nestedType, Cost.Rank.CONVERSION) : Cost.NO_CONVERSION;
            return cost;
        }
        Cost costWithoutElision = Conversions.checkImplicitConversionSequence(nestedType, initializer.getType(), initializer.getValueCategory(), Conversions.UDCMode.ALLOWED, Conversions.Context.ORDINARY);
        if (costWithoutElision.converts()) {
            ++this.fIndex;
            if (!initializer.isConstantExpression() && !(initializer instanceof EvalInitList) && costWithoutElision.isNarrowingConversion()) {
                return Cost.NO_CONVERSION;
            }
            if (costWithoutElision.compareTo(worstCost) > 0) {
                worstCost = costWithoutElision;
            }
        } else {
            if (this.fInitializers[this.fIndex].isInitializerList() || !AggregateInitialization.isAggregate(nestedType)) {
                return costWithoutElision;
            }
            Cost cost = this.checkInitializationOfElements(nestedType, worstCost);
            if (!cost.converts()) {
                return cost;
            }
            if (cost.compareTo(worstCost) > 0) {
                worstCost = cost;
            }
        }
        return worstCost;
    }

    private Cost checkInitializationOfElements(IType type, Cost worstCost) throws DOMException {
        block7: {
            IArrayType arrayType;
            Number arraySize;
            block6: {
                ICPPField[] fields;
                if (!(type instanceof ICPPClassType) || !TypeTraits.isAggregateClass((ICPPClassType)type)) break block6;
                ICPPField[] iCPPFieldArray = fields = AggregateInitialization.getFieldsForAggregateInitialization((ICPPClassType)type);
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPField field = iCPPFieldArray[n2];
                    Cost cost = this.checkElement(field.getType(), field.getInitialValue(), worstCost);
                    if (!cost.converts()) {
                        return cost;
                    }
                    if (cost.compareTo(worstCost) > 0) {
                        worstCost = cost;
                    }
                    ++n2;
                }
                break block7;
            }
            if (!(type instanceof IArrayType) || (arraySize = (arrayType = (IArrayType)type).getSize().numberValue()) == null) break block7;
            long i = 0L;
            while (i < arraySize.longValue()) {
                Cost cost = this.checkElement(arrayType.getType(), null, worstCost);
                if (!cost.converts()) {
                    return cost;
                }
                if (cost.compareTo(worstCost) > 0) {
                    worstCost = cost;
                }
                ++i;
            }
        }
        return worstCost;
    }

    private Cost checkInitializationFromDefaultMemberInitializer(IType type, IValue initialValue, Cost worstCost) throws DOMException {
        if (initialValue != null) {
            return worstCost;
        }
        IType fieldType = SemanticUtil.getNestedType(type, 1);
        if (fieldType instanceof ICPPReferenceType) {
            return Cost.NO_CONVERSION;
        }
        EvalInitList emptyInit = new EvalInitList(ICPPEvaluation.EMPTY_ARRAY, CPPSemantics.getCurrentLookupPoint());
        Cost cost = Conversions.listInitializationSequence(emptyInit, fieldType, Conversions.UDCMode.ALLOWED, false);
        return cost;
    }

    private static boolean isAggregate(IType type) {
        return type instanceof ICPPClassType && TypeTraits.isAggregateClass((ICPPClassType)type) || type instanceof IArrayType;
    }

    private static ICPPField[] getFieldsForAggregateInitialization(ICPPClassType targetClass) {
        ICPPField[] fields;
        ICPPField[] result = fields = targetClass.getDeclaredFields();
        int j = 0;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isStatic()) {
                if (fields == result) {
                    result = new ICPPField[fields.length - 1];
                    System.arraycopy(fields, 0, result, 0, i);
                }
            } else if (fields != result) {
                result[j] = fields[i];
                ++j;
            }
            ++i;
        }
        return ArrayUtil.trim(result);
    }

    private static ICPPBasicType getBasicTypeFromArray(IType type) {
        IType nested;
        if (type instanceof IArrayType && (nested = SemanticUtil.getNestedType(((IArrayType)type).getType(), 17)) instanceof ICPPBasicType) {
            return (ICPPBasicType)nested;
        }
        return null;
    }

    private static boolean isCharArray(IType target) {
        ICPPBasicType t = AggregateInitialization.getBasicTypeFromArray(target);
        if (t != null) {
            IBasicType.Kind k = t.getKind();
            return k == IBasicType.Kind.eChar || k == IBasicType.Kind.eChar16 || k == IBasicType.Kind.eChar32 || k == IBasicType.Kind.eWChar;
        }
        return false;
    }

    private static boolean fromStringLiteral(ICPPEvaluation initializer) {
        ICPPBasicType t = AggregateInitialization.getBasicTypeFromArray(initializer.getType());
        if (t != null && t instanceof CPPBasicType) {
            return ((CPPBasicType)t).isFromStringLiteral();
        }
        return false;
    }

    private static boolean initFromStringLiteral(IType target, ICPPEvaluation initializer) {
        return AggregateInitialization.isCharArray(target) && AggregateInitialization.fromStringLiteral(initializer);
    }

    private static Number getArraySize(IType type) {
        IValue size;
        if (((IArrayType)type).getSize() != null && (size = ((IArrayType)type).getSize()).numberValue() != null) {
            return ((IArrayType)type).getSize().numberValue();
        }
        return null;
    }
}

