/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.target;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.target.LaunchTargetWizardDialog;
import org.eclipse.launchbar.ui.target.ILaunchTargetUIManager;
import org.eclipse.launchbar.ui.target.LaunchTargetWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class LaunchTargetUIManager
implements ILaunchTargetUIManager {
    private Map<String, IConfigurationElement> typeElements;
    private Map<String, ILabelProvider> labelProviders = new HashMap<String, ILabelProvider>();
    private Map<String, IConfigurationElement> editElements;

    @Override
    public synchronized ILabelProvider getLabelProvider(ILaunchTarget target) {
        String typeId;
        Object labelProvider;
        if (this.typeElements == null) {
            this.typeElements = new HashMap<String, IConfigurationElement>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".launchTargetTypeUI");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("launchTargetTypeUI".equals(element.getName()) && (id = element.getAttribute("id")) != null) {
                        this.typeElements.put(id, element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if ((labelProvider = this.labelProviders.get(typeId = target.getTypeId())) == null) {
            IConfigurationElement element = this.typeElements.get(typeId);
            if (element != null) {
                try {
                    labelProvider = (ILabelProvider)element.createExecutableExtension("labelProvider");
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            if (labelProvider == null) {
                labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof ILaunchTarget) {
                            return ((ILaunchTarget)element).getId();
                        }
                        return super.getText(element);
                    }

                    public Image getImage(Object element) {
                        if (element instanceof ILaunchTarget) {
                            return Activator.getDefault().getImage("localTarget");
                        }
                        return super.getImage(element);
                    }
                };
            }
        }
        return labelProvider;
    }

    @Override
    public IWizardDescriptor[] getLaunchTargetWizards() {
        return null;
    }

    @Override
    public void editLaunchTarget(final ILaunchTarget target) {
        if (this.editElements == null) {
            this.editElements = new HashMap<String, IConfigurationElement>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".launchTargetTypeUI");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("wizard2".equals(element.getName()) && (id = element.getAttribute("id")) != null) {
                        this.editElements.put(id, element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IConfigurationElement element = this.editElements.get(target.getTypeId());
        if (element != null) {
            try {
                LaunchTargetWizard wizard = (LaunchTargetWizard)((Object)element.createExecutableExtension("class"));
                wizard.setLaunchTarget(target);
                LaunchTargetWizardDialog dialog = wizard.canDelete() ? new LaunchTargetWizardDialog(shell, (IWizard)wizard) : new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        } else {
            new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), new ISelectionProvider(){

                public void setSelection(ISelection selection) {
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)target);
                }

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }
            }).run();
        }
    }
}

