/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.terminal;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.arduino.ui.internal.terminal.ArduinoTerminalSettings;
import org.eclipse.cdt.serial.BaudRate;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;

public class ArduinoTerminalSettingsPage
extends AbstractSettingsPage {
    private final ArduinoTerminalSettings settings;
    private final IConfigurationPanel panel;
    private final IDialogSettings dialogSettings;
    private Combo boardCombo;
    private Label portNameLabel;
    private Combo baudRateCombo;
    private Combo byteSizeCombo;
    private Combo parityCombo;
    private Combo stopBitsCombo;
    private String boardName;
    private String portName;
    private BaudRate baudRate;
    private ByteSize byteSize;
    private Parity parity;
    private StopBits stopBits;
    private IRemoteConnectionType arduinoType;

    public ArduinoTerminalSettingsPage(ArduinoTerminalSettings settings, IConfigurationPanel panel) {
        this.settings = settings;
        this.panel = panel;
        this.setHasControlDecoration(true);
        this.dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getSimpleName());
        this.boardName = this.dialogSettings.get("arduino.board");
        this.portName = this.dialogSettings.get("cdtserial.portName");
        String baudRateStr = this.dialogSettings.get("cdtserial.baudRate");
        if (baudRateStr == null || baudRateStr.isEmpty()) {
            this.baudRate = BaudRate.getDefault();
        } else {
            String[] rates = BaudRate.getStrings();
            int i = 0;
            while (i < rates.length) {
                if (baudRateStr.equals(rates[i])) {
                    this.baudRate = BaudRate.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String byteSizeStr = this.dialogSettings.get("cdtserial.byteSize");
        if (byteSizeStr == null || byteSizeStr.isEmpty()) {
            this.byteSize = ByteSize.getDefault();
        } else {
            String[] sizes = ByteSize.getStrings();
            int i = 0;
            while (i < sizes.length) {
                if (byteSizeStr.equals(sizes[i])) {
                    this.byteSize = ByteSize.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String parityStr = this.dialogSettings.get("cdtserial.parity");
        if (parityStr == null || parityStr.isEmpty()) {
            this.parity = Parity.getDefault();
        } else {
            String[] parities = Parity.getStrings();
            int i = 0;
            while (i < parities.length) {
                if (parityStr.equals(parities[i])) {
                    this.parity = Parity.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String stopBitsStr = this.dialogSettings.get("cdtserial.stopBits");
        if (stopBitsStr == null || stopBitsStr.isEmpty()) {
            this.stopBits = StopBits.getDefault();
        } else {
            String[] bits = StopBits.getStrings();
            int i = 0;
            while (i < bits.length) {
                if (stopBitsStr.equals(bits[i])) {
                    this.stopBits = StopBits.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData(768);
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)gridData);
        Label boardLabel = new Label(comp, 0);
        boardLabel.setText(Messages.ArduinoTerminalSettingsPage_BoardName);
        this.boardCombo = new Combo(comp, 8);
        this.boardCombo.setLayoutData((Object)new GridData(768));
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        this.arduinoType = manager.getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
        ArrayList connections = new ArrayList(this.arduinoType.getConnections());
        Collections.sort(connections, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        for (IRemoteConnection connection : connections) {
            this.boardCombo.add(connection.getName());
        }
        this.boardCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArduinoTerminalSettingsPage.this.validate();
                ArduinoTerminalSettingsPage.this.updatePortLabel();
            }
        });
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.ArduinoTerminalSettingsPage_SerialPort);
        this.portNameLabel = new Label(comp, 0);
        this.portNameLabel.setLayoutData((Object)new GridData(768));
        Label baudRateLabel = new Label(comp, 0);
        baudRateLabel.setText(Messages.ArduinoTerminalSettingsPage_BaudRate);
        this.baudRateCombo = new Combo(comp, 8);
        this.baudRateCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray = BaudRate.getStrings();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String baudRateStr = stringArray[n2];
            this.baudRateCombo.add(baudRateStr);
            ++n2;
        }
        Label byteSizeLabel = new Label(comp, 0);
        byteSizeLabel.setText(Messages.ArduinoTerminalSettingsPage_DataSize);
        this.byteSizeCombo = new Combo(comp, 8);
        this.byteSizeCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray2 = ByteSize.getStrings();
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String byteSizeStr = stringArray2[n];
            this.byteSizeCombo.add(byteSizeStr);
            ++n;
        }
        Label parityLabel = new Label(comp, 0);
        parityLabel.setText(Messages.ArduinoTerminalSettingsPage_Parity);
        this.parityCombo = new Combo(comp, 8);
        this.parityCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray3 = Parity.getStrings();
        int n4 = stringArray3.length;
        n3 = 0;
        while (n3 < n4) {
            String parityStr = stringArray3[n3];
            this.parityCombo.add(parityStr);
            ++n3;
        }
        Label stopBitsLabel = new Label(comp, 0);
        stopBitsLabel.setText(Messages.ArduinoTerminalSettingsPage_StopBits);
        this.stopBitsCombo = new Combo(comp, 8);
        this.stopBitsCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray4 = StopBits.getStrings();
        int n5 = stringArray4.length;
        n4 = 0;
        while (n4 < n5) {
            String stopBitsStr = stringArray4[n4];
            this.stopBitsCombo.add(stopBitsStr);
            ++n4;
        }
        this.loadSettings();
    }

    void validate() {
        IConfigurationPanelContainer container = this.panel.getContainer();
        container.validate();
    }

    void updatePortLabel() {
        if (this.boardCombo.getSelectionIndex() < 0) {
            return;
        }
        String boardName = this.boardCombo.getItem(this.boardCombo.getSelectionIndex());
        IRemoteConnection connection = this.arduinoType.getConnection(boardName);
        if (connection != null) {
            ArduinoRemoteConnection board = (ArduinoRemoteConnection)connection.getService(ArduinoRemoteConnection.class);
            this.portName = board.getPortName();
            this.portNameLabel.setText(this.portName);
        } else {
            this.portName = null;
            this.portNameLabel.setText(Messages.ArduinoTerminalSettingsPage_UnknownPort);
        }
    }

    public void loadSettings() {
        String boardName = this.settings.getBoardName();
        if (boardName == null || boardName.isEmpty()) {
            boardName = this.boardName;
        }
        if (boardName != null && !boardName.isEmpty()) {
            int i = 0;
            String[] stringArray = this.boardCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (boardName.equals(name)) {
                    this.boardCombo.select(i);
                    break;
                }
                ++i;
                ++n2;
            }
        } else if (this.boardCombo.getItemCount() > 0) {
            this.boardCombo.select(0);
        }
        this.updatePortLabel();
        BaudRate baudRate = this.settings.getBaudRate();
        if (baudRate == null) {
            baudRate = this.baudRate;
        }
        this.baudRateCombo.select(BaudRate.getStringIndex((BaudRate)baudRate));
        ByteSize byteSize = this.settings.getByteSize();
        if (byteSize == null) {
            byteSize = this.byteSize;
        }
        this.byteSizeCombo.select(ByteSize.getStringIndex((ByteSize)byteSize));
        Parity parity = this.settings.getParity();
        if (parity == null) {
            parity = this.parity;
        }
        this.parityCombo.select(Parity.getStringIndex((Parity)parity));
        StopBits stopBits = this.settings.getStopBits();
        if (stopBits == null) {
            stopBits = this.stopBits;
        }
        this.stopBitsCombo.select(StopBits.getStringIndex((StopBits)stopBits));
    }

    public void saveSettings() {
        if (this.boardCombo.getSelectionIndex() < 0) {
            return;
        }
        this.settings.setBoardName(this.boardCombo.getItem(this.boardCombo.getSelectionIndex()));
        this.settings.setPortName(this.portNameLabel.getText());
        this.settings.setBaudRate(BaudRate.fromStringIndex((int)this.baudRateCombo.getSelectionIndex()));
        this.settings.setByteSize(ByteSize.fromStringIndex((int)this.byteSizeCombo.getSelectionIndex()));
        this.settings.setParity(Parity.fromStringIndex((int)this.parityCombo.getSelectionIndex()));
        this.settings.setStopBits(StopBits.fromStringIndex((int)this.stopBitsCombo.getSelectionIndex()));
        this.dialogSettings.put("arduino.board", this.boardCombo.getItem(this.boardCombo.getSelectionIndex()));
        this.dialogSettings.put("cdtserial.portName", this.portNameLabel.getText());
        this.dialogSettings.put("cdtserial.baudRate", BaudRate.getStrings()[this.baudRateCombo.getSelectionIndex()]);
        this.dialogSettings.put("cdtserial.byteSize", ByteSize.getStrings()[this.byteSizeCombo.getSelectionIndex()]);
        this.dialogSettings.put("cdtserial.parity", Parity.getStrings()[this.parityCombo.getSelectionIndex()]);
        this.dialogSettings.put("cdtserial.stopBits", StopBits.getStrings()[this.stopBitsCombo.getSelectionIndex()]);
    }

    public boolean validateSettings() {
        return this.boardCombo.getSelectionIndex() >= 0 || !this.boardCombo.getText().isEmpty();
    }
}

