/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.IndexerBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class IndexerOptionPropertyPage
extends PropertyPage {
    private IndexerBlock optionPage = new IndexerBlock();
    private String oldIndexerID;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.optionPage.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_indexer");
        this.initialize();
        return composite;
    }

    protected void performDefaults() {
        ICProject tempProject = CoreModel.getDefault().create(this.getProject());
        this.optionPage.resetIndexerPageSettings(tempProject);
    }

    private void initialize() {
        ICProject project = CoreModel.getDefault().create(this.getProject());
        try {
            this.oldIndexerID = CCorePlugin.getPDOMManager().getIndexerId(project);
            this.optionPage.setIndexerID(this.oldIndexerID, project);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    public boolean performOk() {
        ICProject tempProject = CoreModel.getDefault().create(this.getProject());
        try {
            this.optionPage.persistIndexerSettings(tempProject, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        return true;
    }

    public IProject getProject() {
        IAdaptable tempElement = this.getElement();
        IProject project = null;
        if (tempElement != null && tempElement instanceof IProject) {
            project = (IProject)tempElement;
        }
        return project;
    }
}

