/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;

public class ASTTemplateDeclaration
extends ASTSymbol
implements IASTTemplateDeclaration {
    private final List templateParameters;
    private ISymbol owned = null;
    private IASTScope ownerScope;
    private ITemplateFactory factory;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    private ITemplateSymbol getTemplateSymbol() {
        return (ITemplateSymbol)(this.getSymbol() instanceof ITemplateSymbol ? this.getSymbol() : null);
    }

    public ASTTemplateDeclaration(ITemplateSymbol template, IASTScope scope, List parameters, char[] filename) {
        super(template);
        IContainerSymbol container = null;
        container = scope instanceof ASTTemplateDeclaration ? ((ASTTemplateDeclaration)scope).getContainerSymbol() : ((ASTScope)scope).getContainerSymbol();
        if (container instanceof ITemplateFactory) {
            this.factory = (ITemplateFactory)container;
        } else {
            this.factory = template.getSymbolTable().newTemplateFactory();
            this.factory.setContainingSymbol(container);
            this.factory.setASTExtension(new StandardSymbolExtension(this.factory, this));
        }
        this.factory.pushTemplate(template);
        this.templateParameters = parameters != null ? parameters : Collections.EMPTY_LIST;
        this.ownerScope = scope;
        this.fn = filename;
    }

    public IASTScope getOwnerScope() {
        return this.ownerScope;
    }

    public boolean isExported() {
        return false;
    }

    public IASTDeclaration getOwnedDeclaration() {
        if (this.owned != null && this.owned.getASTExtension() != null) {
            ISymbolASTExtension extension = this.owned.getASTExtension();
            Iterator i = extension.getAllDefinitions();
            ASTSymbol s = null;
            while (i.hasNext()) {
                s = (ASTSymbol)i.next();
            }
            return s;
        }
        IContainerSymbol ownedSymbol = this.getTemplateSymbol().getTemplatedSymbol();
        if (ownedSymbol != null && ownedSymbol.getASTExtension() != null) {
            ASTNode node = ownedSymbol.getASTExtension().getPrimaryDeclaration();
            return node instanceof IASTDeclaration ? (IASTDeclaration)((Object)node) : null;
        }
        return null;
    }

    public void setOwnedDeclaration(ISymbol symbol) {
        this.owned = symbol;
    }

    public void releaseFactory() {
        this.factory = null;
    }

    public IContainerSymbol getContainerSymbol() {
        return this.factory != null ? this.factory : this.getTemplateSymbol();
    }

    public Iterator getTemplateParameters() {
        return this.templateParameters.iterator();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterTemplateDeclaration(this);
        }
        catch (Exception exception) {}
        if (this.templateParameters == null || this.templateParameters.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.templateParameters.size()) {
            ((IASTTemplateParameter)this.templateParameters.get(i)).acceptElement(requestor);
            ++i;
        }
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitTemplateDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void setOwnedDeclaration(IASTDeclaration declaration) {
    }

    public Iterator getDeclarations() throws ASTNotImplementedException {
        return null;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

