/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PDOMTypeInfo;
import org.eclipse.cdt.core.dom.IPDOMManager;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespace;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespaceAlias;
import org.eclipse.core.runtime.CoreException;

public class AllTypesCache {
    private static ITypeInfo[] getTypes(ICProject[] projects, int[] kinds) throws CoreException {
        ArrayList types = new ArrayList();
        IPDOMManager pdomManager = CCorePlugin.getPDOMManager();
        int i = 0;
        while (i < projects.length) {
            ICProject project = projects[i];
            CTypesCollector cCollector = new CTypesCollector(kinds, types, project);
            CPPTypesCollector cppCollector = new CPPTypesCollector(kinds, types, project);
            PDOM pdom = (PDOM)pdomManager.getPDOM(project);
            PDOMLinkage cLinkage = pdom.getLinkage(GCCLanguage.getDefault());
            cLinkage.accept(cCollector);
            PDOMLinkage cppLinkage = pdom.getLinkage(GPPLanguage.getDefault());
            cppLinkage.accept(cppCollector);
            ++i;
        }
        return types.toArray(new ITypeInfo[types.size()]);
    }

    public static ITypeInfo[] getAllTypes() {
        try {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            return AllTypesCache.getTypes(projects, ITypeInfo.KNOWN_TYPES);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope scope, int[] kinds) {
        try {
            return AllTypesCache.getTypes(scope.getEnclosingProjects(), kinds);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo[] getNamespaces(ITypeSearchScope scope, boolean includeGlobalNamespace) {
        try {
            return AllTypesCache.getTypes(scope.getEnclosingProjects(), new int[]{61});
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo getType(ICProject project, int type, IQualifiedTypeName qualifiedName) {
        return null;
    }

    public static ITypeInfo[] getTypes(ICProject project, IQualifiedTypeName qualifiedName, boolean matchEnclosed, boolean ignoreCase) {
        return new ITypeInfo[0];
    }

    private static abstract class TypesCollector
    implements IPDOMVisitor {
        private final int[] kinds;
        protected final List types;
        protected final ICProject project;

        protected TypesCollector(int[] kinds, List types, ICProject project) {
            this.kinds = kinds;
            this.types = types;
            this.project = project;
        }

        protected abstract void visitKind(IPDOMNode var1, int var2);

        public boolean visit(IPDOMNode node) throws CoreException {
            int i = 0;
            while (i < this.kinds.length) {
                this.visitKind(node, this.kinds[i]);
                ++i;
            }
            return true;
        }

        public List getTypes() {
            return this.types;
        }
    }

    private static class CTypesCollector
    extends TypesCollector {
        public CTypesCollector(int[] kinds, List types, ICProject project) {
            super(kinds, types, project);
        }

        protected void visitKind(IPDOMNode node, int kind) {
            switch (kind) {
                case 61: {
                    return;
                }
                case 65: {
                    return;
                }
                case 67: {
                    if (node instanceof PDOMCStructure) {
                        this.types.add(new PDOMTypeInfo((PDOMBinding)node, kind, this.project));
                    }
                    return;
                }
                case 69: {
                    return;
                }
                case 63: {
                    return;
                }
                case 80: {
                    return;
                }
            }
        }
    }

    private static class CPPTypesCollector
    extends TypesCollector {
        public CPPTypesCollector(int[] kinds, List types, ICProject project) {
            super(kinds, types, project);
        }

        protected void visitKind(IPDOMNode node, int kind) {
            try {
                switch (kind) {
                    case 61: {
                        if (node instanceof PDOMCPPNamespace || node instanceof PDOMCPPNamespaceAlias) {
                            this.types.add(new PDOMTypeInfo((PDOMBinding)node, kind, this.project));
                        }
                        return;
                    }
                    case 65: {
                        if (node instanceof PDOMCPPClassType && ((PDOMCPPClassType)node).getKey() == 3) {
                            this.types.add(new PDOMTypeInfo((PDOMBinding)node, kind, this.project));
                        }
                        return;
                    }
                    case 67: {
                        if (node instanceof PDOMCPPClassType && ((PDOMCPPClassType)node).getKey() == 1) {
                            this.types.add(new PDOMTypeInfo((PDOMBinding)node, kind, this.project));
                        }
                        return;
                    }
                    case 69: {
                        if (node instanceof PDOMCPPClassType && ((PDOMCPPClassType)node).getKey() == 2) {
                            this.types.add(new PDOMTypeInfo((PDOMBinding)node, kind, this.project));
                        }
                        return;
                    }
                    case 63: {
                        return;
                    }
                    case 80: {
                        return;
                    }
                }
            }
            catch (DOMException e) {
                CCorePlugin.log((Throwable)((Object)e));
            }
        }
    }
}

