/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.ctags;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.core.runtime.CoreException;

public class CtagsBindingFinder
implements IPDOMVisitor {
    private final String name;
    private final int[] types;
    private List bindings = new ArrayList();

    public CtagsBindingFinder(String name, int[] types) {
        this.name = name;
        this.types = types;
    }

    public boolean visit(IPDOMNode node) throws CoreException {
        PDOMBinding binding = (PDOMBinding)node;
        if (this.name.equals(binding.getDBName())) {
            int type = binding.getNodeType();
            int i = 0;
            while (i < this.types.length) {
                if (type == this.types[i]) {
                    this.bindings.add(binding);
                    break;
                }
                ++i;
            }
        }
        return false;
    }

    public PDOMBinding[] getBindings() {
        return this.bindings.toArray(new PDOMBinding[this.bindings.size()]);
    }
}

