/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMember;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMMemberOwner
extends PDOMBinding {
    private static final int FIRST_MEMBER = 24;
    private static final int LAST_MEMBER = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMMemberOwner(PDOM pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name);
    }

    public PDOMMemberOwner(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            if (visitor.visit(member)) {
                member.accept(visitor);
            }
            member = member.getNextMember();
        }
    }

    public void addMember(PDOMMember member) throws CoreException {
        PDOMMember last = this.getLastMember();
        if (last != null) {
            last.setNextMember(member);
            member.setPrevMember(last);
        } else {
            this.setFirstMember(member);
        }
        this.setLastMember(member);
        member.setMemberOwner(this);
    }

    public PDOMMember getFirstMember() throws CoreException {
        return (PDOMMember)this.getLinkage().getNode(this.pdom.getDB().getInt(this.record + 24));
    }

    public PDOMMember getLastMember() throws CoreException {
        return (PDOMMember)this.getLinkage().getNode(this.pdom.getDB().getInt(this.record + 28));
    }

    public void setFirstMember(PDOMMember member) throws CoreException {
        int memberrec = member != null ? member.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 24, memberrec);
    }

    public void setLastMember(PDOMMember member) throws CoreException {
        int memberrec = member != null ? member.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, memberrec);
    }

    public int getNumMembers() throws CoreException {
        int n = 0;
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            ++n;
            member = member.getNextMember();
        }
        return n;
    }

    public PDOMMember getMember(int index) throws CoreException {
        int n = 0;
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            if (n++ == index) {
                return member;
            }
            member = member.getNextMember();
        }
        return null;
    }

    public PDOMMember[] findMembers(char[] name) throws CoreException {
        ArrayList<PDOMMember> members = new ArrayList<PDOMMember>();
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            if (member.hasName(name)) {
                members.add(member);
            }
            member = member.getNextMember();
        }
        return members.toArray(new PDOMMember[members.size()]);
    }
}

