/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.ctags;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsCName;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsCPPName;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsIndexer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;

public abstract class CtagsIndexerJob
extends Job {
    protected final CtagsIndexer indexer;
    protected final PDOM pdom;

    public CtagsIndexerJob(CtagsIndexer indexer) throws CoreException {
        super("ctags Indexer: " + indexer.getProject().getElementName());
        this.indexer = indexer;
        this.pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM(indexer.getProject());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runCtags(IPath sourcePath) {
        String ctagsFileName = this.indexer.getResolvedCtagsFileName();
        File ctagsFile = new File(ctagsFileName);
        if (ctagsFile.exists()) {
            ctagsFile.delete();
        }
        String[] cmd = new String[]{this.indexer.getResolvedCtagsCommand(), "--excmd=number", "--format=2", "--sort=no", "--fields=aiKlmnsSz", "--c-types=cdefgmnpstuvx", "--c++-types=cdefgmnpstuvx", "--languages=c,c++", "-f", ctagsFileName, "-R", sourcePath.toOSString()};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            this.pdom.acquireWriteLock();
            try {
                this.processCtagsFile(ctagsFileName);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.pdom.releaseWriteLock();
                throw throwable;
            }
            {
                Object var6_10 = null;
                this.pdom.releaseWriteLock();
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (IOException e) {
            CCorePlugin.log(e);
            return;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return;
        }
    }

    private void processCtagsFile(String ctagsFileName) throws IOException, CoreException {
        BufferedReader reader = new BufferedReader(new FileReader(ctagsFileName));
        String line = reader.readLine();
        while (line != null) {
            if (line.charAt(0) != '!') {
                String elementName = null;
                String fileName = null;
                int lineNum = -1;
                HashMap<String, String> fields = new HashMap<String, String>();
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                int state = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    switch (state) {
                        case 0: {
                            elementName = token;
                            break;
                        }
                        case 1: {
                            fileName = token;
                            break;
                        }
                        case 2: {
                            int i;
                            try {
                                token = token.trim();
                                i = token.indexOf(59);
                                lineNum = Integer.parseInt(token.substring(0, i)) - 1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                lineNum = -1;
                            }
                            break;
                        }
                        default: {
                            int i = token.indexOf(58);
                            if (i == -1) break;
                            String key = token.substring(0, i);
                            String value = token.substring(i + 1);
                            fields.put(key, value);
                        }
                    }
                    ++state;
                }
                if (elementName != null && fileName != null) {
                    PDOMFile file = this.pdom.addFile(fileName);
                    String languageName = (String)fields.get("language");
                    if (languageName.equals("C++")) {
                        PDOMLinkage linkage = this.pdom.getLinkage(new GPPLanguage());
                        new CtagsCPPName(linkage, fileName, lineNum, elementName, fields).addToPDOM(file);
                    } else {
                        PDOMLinkage linkage = this.pdom.getLinkage(new GCCLanguage());
                        new CtagsCName(linkage, fileName, lineNum, elementName, fields).addToPDOM(file);
                    }
                }
            }
            line = reader.readLine();
        }
    }
}

