/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class CodeFormatterBlock {
    private HashMap idMap = new HashMap();
    Preferences fPrefs;
    protected Combo fFormatterCombo;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";
    private static final String NONE = PreferencesMessages.getString("CodeFormatterPreferencePage.emptyName");

    public CodeFormatterBlock(Preferences prefs) {
        this.fPrefs = prefs;
        this.initializeFormatters();
    }

    public void performOk() {
        String text = this.fFormatterCombo.getText();
        String selection = (String)this.idMap.get(text);
        if (selection != null && selection.length() > 0) {
            HashMap options = CCorePlugin.getOptions();
            String formatterID = (String)options.get("org.eclipse.cdt.core.code_formatter");
            if (formatterID == null || !formatterID.equals(selection)) {
                options.put("org.eclipse.cdt.core.code_formatter", selection);
                CCorePlugin.setOptions((HashMap)options);
            }
        } else {
            this.performDefaults();
        }
    }

    public void performDefaults() {
        HashMap optionsDefault = CCorePlugin.getDefaultOptions();
        HashMap options = CCorePlugin.getOptions();
        String formatterID = (String)optionsDefault.get("org.eclipse.cdt.core.code_formatter");
        options.put("org.eclipse.cdt.core.code_formatter", formatterID);
        CCorePlugin.setOptions((HashMap)options);
        this.fFormatterCombo.clearSelection();
        this.fFormatterCombo.setText(NONE);
        Iterator iterator = this.idMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String val = (String)entry.getValue();
            if (val == null || !val.equals(formatterID)) continue;
            this.fFormatterCombo.setText((String)entry.getKey());
        }
    }

    public Control createControl(Composite parent) {
        new PixelConverter((Control)parent);
        Composite control = ControlFactory.createComposite(parent, 2);
        ((GridLayout)control.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)control.getLayout()).marginWidth = 5;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.cdt.ui.codeformatter_preference_page_context");
        ControlFactory.createEmptySpace(control, 2);
        Label label = ControlFactory.createLabel(control, PreferencesMessages.getString("CodeFormatterPreferencePage.selectionName"));
        label.setLayoutData((Object)new GridData());
        this.fFormatterCombo = new Combo(control, 12);
        GridData gd = new GridData(512);
        gd.grabExcessHorizontalSpace = true;
        this.fFormatterCombo.setLayoutData((Object)gd);
        this.fFormatterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeFormatterBlock.this.handleFormatterChanged();
            }
        });
        Iterator items = this.idMap.keySet().iterator();
        while (items.hasNext()) {
            this.fFormatterCombo.add((String)items.next());
        }
        this.initDefault();
        this.handleFormatterChanged();
        return control;
    }

    public void handleFormatterChanged() {
    }

    public void initDefault() {
        boolean init = false;
        String selection = CCorePlugin.getOption((String)"org.eclipse.cdt.core.code_formatter");
        if (selection != null) {
            Iterator iterator = this.idMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String val = (String)entry.getValue();
                if (val == null || !val.equals(selection)) continue;
                this.fFormatterCombo.setText((String)entry.getKey());
                init = true;
            }
        }
        if (!init) {
            this.fFormatterCombo.setText(NONE);
        }
    }

    private void initializeFormatters() {
        this.idMap = new HashMap();
        this.idMap.put(NONE, null);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CodeFormatter");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            int i = 0;
            while (i < exts.length) {
                IConfigurationElement[] elements = exts[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String name = elements[j].getAttribute(ATTR_NAME);
                    this.idMap.put(name, elements[j].getAttribute(ATTR_ID));
                    ++j;
                }
                ++i;
            }
        }
    }
}

