/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.ICDIDebugger2;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISessionConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBProcess;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public abstract class AbstractGDBCDIDebugger
implements ICDIDebugger2 {
    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        return this.createSession(launch, exe.getPath().toFile(), monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createSession(ILaunch launch, File executable, IProgressMonitor monitor) throws CoreException {
        boolean failed = false;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean verboseMode = this.verboseMode(launch.getLaunchConfiguration());
        Session session = this.createGDBSession(launch, executable, monitor);
        if (session == null) return session;
        try {
            try {
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (true) {
                    block15: {
                        if (i < targets.length) break block15;
                        this.doStartSession(launch, session, monitor);
                        break;
                    }
                    Process debugger = session.getSessionProcess(targets[i]);
                    if (debugger != null) {
                        IProcess debuggerProcess = this.createGDBProcess((Target)targets[i], launch, debugger, this.renderDebuggerProcessLabel(launch), null);
                        launch.addProcess(debuggerProcess);
                    }
                    ((Target)targets[i]).enableVerboseMode(verboseMode);
                    ((Target)targets[i]).getMISession().start();
                    ++i;
                }
            }
            catch (MIException e) {
                failed = true;
                throw this.newCoreException(e);
            }
            catch (CoreException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (!failed) {
                    if (!monitor.isCanceled()) throw throwable;
                }
                if (session == null) throw throwable;
                session.terminate();
                throw throwable;
            }
            catch (CDIException cDIException) {}
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        try {}
        catch (CDIException cDIException) {
            return session;
        }
        if (!failed) {
            if (!monitor.isCanceled()) return session;
        }
        if (session == null) return session;
        session.terminate();
        return session;
    }

    protected Session createGDBSession(ILaunch launch, File executable, IProgressMonitor monitor) throws CoreException {
        Session session = null;
        IPath gdbPath = this.getGDBPath(launch);
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        CommandFactory factory = this.getCommandFactory(config);
        String[] extraArgs = this.getExtraArguments(config);
        boolean usePty = this.usePty(config);
        try {
            session = MIPlugin.getDefault().createSession(this.getSessionType(config), gdbPath.toOSString(), factory, executable, extraArgs, usePty, monitor);
            ICDISessionConfiguration sessionConfig = this.getSessionConfiguration(session);
            if (sessionConfig != null) {
                session.setConfiguration(sessionConfig);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw this.newCoreException(e);
        }
        return session;
    }

    protected int getSessionType(ILaunchConfiguration config) throws CoreException {
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            return 0;
        }
        if ("attach".equals(debugMode)) {
            return 1;
        }
        if ("core".equals(debugMode)) {
            return 2;
        }
        throw this.newCoreException(String.valueOf(MIPlugin.getResourceString("src.AbstractGDBCDIDebugger.0")) + debugMode, null);
    }

    protected String[] getExtraArguments(ILaunchConfiguration config) throws CoreException {
        return new String[0];
    }

    protected boolean usePty(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
    }

    protected abstract CommandFactory getCommandFactory(ILaunchConfiguration var1) throws CoreException;

    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
    }

    protected String renderDebuggerProcessLabel(ILaunch launch) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String label = MIPlugin.getResourceString("src.AbstractGDBCDIDebugger.2");
        try {
            IPath path = this.getGDBPath(launch);
            label = path.toOSString();
        }
        catch (CoreException coreException) {}
        return MessageFormat.format(format, label, timestamp);
    }

    protected IPath getGDBPath(ILaunch launch) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        return new Path(config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb"));
    }

    protected ICDISessionConfiguration getSessionConfiguration(ICDISession session) {
        return null;
    }

    protected CoreException newCoreException(Throwable exception) {
        String message = MIPlugin.getResourceString("src.AbstractGDBCDIDebugger.1");
        return this.newCoreException(message, exception);
    }

    protected CoreException newCoreException(String message, Throwable exception) {
        int code = 150;
        String ID = MIPlugin.getUniqueIdentifier();
        MultiStatus status = new MultiStatus(ID, code, message, exception);
        status.add((IStatus)new Status(4, ID, code, exception == null ? new String() : exception.getLocalizedMessage(), exception));
        return new CoreException((IStatus)status);
    }

    protected IProcess createGDBProcess(Target target, ILaunch launch, Process process, String label, Map attributes) {
        return new GDBProcess(target, launch, process, label, attributes);
    }

    protected boolean verboseMode(ILaunchConfiguration config) {
        boolean result = false;
        try {
            return config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, result);
        }
        catch (CoreException coreException) {
            return result;
        }
    }
}

