/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.CharTable;
import org.eclipse.cdt.internal.core.parser.ast.ASTCompletionNode;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicFunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.MacroExpansionToken;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerCallbackManager;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerProblemFactory;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.parser.token.SimpleToken;

abstract class BaseScanner
implements IScanner {
    static boolean cacheIdentifiers = true;
    protected static final char[] ONE = "1".toCharArray();
    protected static final char[] ELLIPSIS_CHARARRAY = "...".toCharArray();
    protected static final char[] VA_ARGS_CHARARRAY = "__VA_ARGS__".toCharArray();
    protected final IToken eocToken = new SimpleToken(141, Integer.MAX_VALUE, null, Integer.MAX_VALUE);
    protected ParserLanguage language;
    protected IParserLogService log;
    protected CharArrayObjectMap definitions = new CharArrayObjectMap(512);
    protected String[] stdIncludePaths;
    protected String[] locIncludePaths = null;
    int count;
    protected ExpressionEvaluator expressionEvaluator;
    protected static final int bufferInitialSize = 8;
    protected int bufferStackPos = -1;
    protected char[][] bufferStack = new char[8][];
    protected Object[] bufferData = new Object[8];
    protected int[] bufferPos = new int[8];
    protected int[] bufferLimit = new int[8];
    int[] lineNumbers = new int[8];
    protected int[] lineOffsets = new int[8];
    protected int branchStackPos = -1;
    protected int[] branches = new int[8];
    protected static final int BRANCH_IF = 1;
    protected static final int BRANCH_ELIF = 2;
    protected static final int BRANCH_ELSE = 3;
    protected static final int BRANCH_END = 4;
    protected static String[] EMPTY_STRING_ARRAY = new String[0];
    protected static char[] EMPTY_CHAR_ARRAY = new char[0];
    protected static EndOfFileException EOF = new EndOfFileException();
    protected ParserMode parserMode;
    protected Iterator preIncludeFiles = EmptyIterator.EMPTY_ITERATOR;
    protected boolean isInitialized = false;
    protected boolean macroFilesInitialized = false;
    protected final char[] suffixes;
    protected final boolean support$Initializers;
    protected final boolean supportMinAndMax;
    protected final CharArrayIntMap additionalKeywords;
    protected IToken lastToken;
    protected IToken nextToken;
    protected boolean finished = false;
    protected static final String EMPTY_STRING = "";
    protected static final char[] EMPTY_STRING_CHAR_ARRAY = new char[0];
    protected boolean isCancelled = false;
    public static CharTable ident = new CharTable(1024);
    public static int idents = 0;
    static int countIt = 0;
    protected static final ObjectStyleMacro __cplusplus = new ObjectStyleMacro("__cplusplus".toCharArray(), ONE);
    protected static final ObjectStyleMacro __STDC__ = new ObjectStyleMacro("__STDC__".toCharArray(), ONE);
    protected static final ObjectStyleMacro __STDC_HOSTED__ = new ObjectStyleMacro("__STDC_HOSTED_".toCharArray(), ONE);
    protected static final ObjectStyleMacro __STDC_VERSION__ = new ObjectStyleMacro("__STDC_VERSION_".toCharArray(), "199901L".toCharArray());
    protected final DynamicStyleMacro __FILE__ = new DynamicStyleMacro("__FILE__".toCharArray()){

        public char[] execute() {
            StringBuffer buffer = new StringBuffer("\"");
            buffer.append(BaseScanner.this.getCurrentFilename());
            buffer.append('\"');
            return buffer.toString().toCharArray();
        }
    };
    protected final DynamicStyleMacro __DATE__ = new DynamicStyleMacro("__DATE__".toCharArray()){

        protected final void append(StringBuffer buffer, int value) {
            if (value < 10) {
                buffer.append("0");
            }
            buffer.append(value);
        }

        public char[] execute() {
            StringBuffer buffer = new StringBuffer("\"");
            Calendar cal = Calendar.getInstance();
            buffer.append(cal.get(2));
            buffer.append(" ");
            this.append(buffer, cal.get(5));
            buffer.append(" ");
            buffer.append(cal.get(1));
            buffer.append("\"");
            return buffer.toString().toCharArray();
        }
    };
    protected final DynamicStyleMacro __TIME__ = new DynamicStyleMacro("__TIME__".toCharArray()){

        protected final void append(StringBuffer buffer, int value) {
            if (value < 10) {
                buffer.append("0");
            }
            buffer.append(value);
        }

        public char[] execute() {
            StringBuffer buffer = new StringBuffer("\"");
            Calendar cal = Calendar.getInstance();
            this.append(buffer, cal.get(10));
            buffer.append(":");
            this.append(buffer, cal.get(12));
            buffer.append(":");
            this.append(buffer, cal.get(13));
            buffer.append("\"");
            return buffer.toString().toCharArray();
        }
    };
    protected final DynamicStyleMacro __LINE__ = new DynamicStyleMacro("__LINE__".toCharArray()){

        public char[] execute() {
            int lineNumber = BaseScanner.this.lineNumbers[BaseScanner.this.bufferStackPos];
            return Long.toString(lineNumber).toCharArray();
        }
    };
    protected int offsetBoundary = -1;
    protected boolean contentAssistMode = false;
    protected final CharArrayIntMap keywords;
    protected static CharArrayIntMap ckeywords;
    protected static CharArrayIntMap cppkeywords;
    protected static CharArrayIntMap ppKeywords;
    protected static final int ppIf = 0;
    protected static final int ppIfdef = 1;
    protected static final int ppIfndef = 2;
    protected static final int ppElif = 3;
    protected static final int ppElse = 4;
    protected static final int ppEndif = 5;
    protected static final int ppInclude = 6;
    protected static final int ppDefine = 7;
    protected static final int ppUndef = 8;
    protected static final int ppError = 9;
    protected static final int ppInclude_next = 10;
    protected static final int ppPragma = 11;
    protected static final char[] TAB;
    protected static final char[] SPACE;
    private static final MacroExpansionToken EXPANSION_TOKEN;

    static {
        TAB = new char[]{'\t'};
        SPACE = new char[]{' '};
        EXPANSION_TOKEN = new MacroExpansionToken();
        CharArrayIntMap words = new CharArrayIntMap(141, -1);
        words.put(Keywords.cAUTO, 57);
        words.put(Keywords.cBREAK, 61);
        words.put(Keywords.cCASE, 62);
        words.put(Keywords.cCHAR, 64);
        words.put(Keywords.cCONST, 67);
        words.put(Keywords.cCONTINUE, 70);
        words.put(Keywords.cDEFAULT, 71);
        words.put(Keywords.cDO, 73);
        words.put(Keywords.cDOUBLE, 74);
        words.put(Keywords.cELSE, 76);
        words.put(Keywords.cENUM, 77);
        words.put(Keywords.cEXTERN, 80);
        words.put(Keywords.cFLOAT, 82);
        words.put(Keywords.cFOR, 83);
        words.put(Keywords.cGOTO, 85);
        words.put(Keywords.cIF, 86);
        words.put(Keywords.cINLINE, 87);
        words.put(Keywords.cINT, 88);
        words.put(Keywords.cLONG, 89);
        words.put(Keywords.cREGISTER, 101);
        words.put(Keywords.cRETURN, 103);
        words.put(Keywords.cSHORT, 104);
        words.put(Keywords.cSIGNED, 108);
        words.put(Keywords.cSIZEOF, 105);
        words.put(Keywords.cSTATIC, 106);
        words.put(Keywords.cSTRUCT, 109);
        words.put(Keywords.cSWITCH, 110);
        words.put(Keywords.cTYPEDEF, 116);
        words.put(Keywords.cUNION, 119);
        words.put(Keywords.cUNSIGNED, 120);
        words.put(Keywords.cVOID, 123);
        words.put(Keywords.cVOLATILE, 124);
        words.put(Keywords.cWHILE, 126);
        words.put(Keywords.cASM, 56);
        ckeywords = (CharArrayIntMap)words.clone();
        ckeywords.put(Keywords.cRESTRICT, 137);
        ckeywords.put(Keywords.c_BOOL, 134);
        ckeywords.put(Keywords.c_COMPLEX, 135);
        ckeywords.put(Keywords.c_IMAGINARY, 136);
        cppkeywords = words;
        cppkeywords.put(Keywords.cBOOL, 60);
        cppkeywords.put(Keywords.cCATCH, 63);
        cppkeywords.put(Keywords.cCLASS, 65);
        cppkeywords.put(Keywords.cCONST_CAST, 69);
        cppkeywords.put(Keywords.cDELETE, 72);
        cppkeywords.put(Keywords.cDYNAMIC_CAST, 75);
        cppkeywords.put(Keywords.cEXPLICIT, 78);
        cppkeywords.put(Keywords.cEXPORT, 79);
        cppkeywords.put(Keywords.cFALSE, 81);
        cppkeywords.put(Keywords.cFRIEND, 84);
        cppkeywords.put(Keywords.cMUTABLE, 90);
        cppkeywords.put(Keywords.cNAMESPACE, 91);
        cppkeywords.put(Keywords.cNEW, 92);
        cppkeywords.put(Keywords.cOPERATOR, 95);
        cppkeywords.put(Keywords.cPRIVATE, 98);
        cppkeywords.put(Keywords.cPROTECTED, 99);
        cppkeywords.put(Keywords.cPUBLIC, 100);
        cppkeywords.put(Keywords.cREINTERPRET_CAST, 102);
        cppkeywords.put(Keywords.cSTATIC_CAST, 107);
        cppkeywords.put(Keywords.cTEMPLATE, 111);
        cppkeywords.put(Keywords.cTHIS, 112);
        cppkeywords.put(Keywords.cTHROW, 113);
        cppkeywords.put(Keywords.cTRUE, 114);
        cppkeywords.put(Keywords.cTRY, 115);
        cppkeywords.put(Keywords.cTYPEID, 117);
        cppkeywords.put(Keywords.cTYPENAME, 118);
        cppkeywords.put(Keywords.cUSING, 121);
        cppkeywords.put(Keywords.cVIRTUAL, 122);
        cppkeywords.put(Keywords.cWCHAR_T, 125);
        cppkeywords.put(Keywords.cAND, 54);
        cppkeywords.put(Keywords.cAND_EQ, 55);
        cppkeywords.put(Keywords.cBITAND, 58);
        cppkeywords.put(Keywords.cBITOR, 59);
        cppkeywords.put(Keywords.cCOMPL, 66);
        cppkeywords.put(Keywords.cNOT, 93);
        cppkeywords.put(Keywords.cNOT_EQ, 94);
        cppkeywords.put(Keywords.cOR, 96);
        cppkeywords.put(Keywords.cOR_EQ, 97);
        cppkeywords.put(Keywords.cXOR, 127);
        cppkeywords.put(Keywords.cXOR_EQ, 128);
        ppKeywords = new CharArrayIntMap(16, -1);
        ppKeywords.put(Keywords.cIF, 0);
        ppKeywords.put(Keywords.cIFDEF, 1);
        ppKeywords.put(Keywords.cIFNDEF, 2);
        ppKeywords.put(Keywords.cELIF, 3);
        ppKeywords.put(Keywords.cELSE, 4);
        ppKeywords.put(Keywords.cENDIF, 5);
        ppKeywords.put(Keywords.cINCLUDE, 6);
        ppKeywords.put(Keywords.cDEFINE, 7);
        ppKeywords.put(Keywords.cUNDEF, 8);
        ppKeywords.put(Keywords.cERROR, 9);
        ppKeywords.put(Keywords.cINCLUDE_NEXT, 10);
        ppKeywords.put(Keywords.cPRAGMA, 11);
    }

    public BaseScanner(CodeReader reader, IScannerInfo info, ParserMode parserMode, ParserLanguage language, IParserLogService log, IScannerExtensionConfiguration configuration) {
        this.parserMode = parserMode;
        this.language = language;
        this.log = log;
        this.suffixes = configuration.supportAdditionalNumericLiteralSuffixes() != null ? configuration.supportAdditionalNumericLiteralSuffixes() : EMPTY_CHAR_ARRAY;
        this.support$Initializers = configuration.support$InIdentifiers();
        this.supportMinAndMax = configuration.supportMinAndMaxOperators();
        this.keywords = language == ParserLanguage.C ? ckeywords : cppkeywords;
        this.additionalKeywords = configuration.getAdditionalKeywords();
        this.setupBuiltInMacros(configuration);
        if (info.getDefinedSymbols() != null) {
            Map symbols = info.getDefinedSymbols();
            String[] keys = symbols.keySet().toArray(EMPTY_STRING_ARRAY);
            int i = 0;
            while (i < keys.length) {
                String symbolName = keys[i];
                Object value = symbols.get(symbolName);
                if (value instanceof String) {
                    if (configuration.initializeMacroValuesTo1() && ((String)value).trim().equals(EMPTY_STRING)) {
                        this.addDefinition(symbolName.toCharArray(), ONE);
                    } else {
                        this.addDefinition(symbolName.toCharArray(), ((String)value).toCharArray());
                    }
                }
                ++i;
            }
        }
        this.stdIncludePaths = info.getIncludePaths();
    }

    protected void postConstructorSetup(CodeReader reader, IScannerInfo info) {
        if (info instanceof IExtendedScannerInfo) {
            this.extendedScannerInfoSetup(reader, info);
        } else {
            this.macroFilesInitialized = true;
            this.pushContext(reader.buffer, reader);
            this.isInitialized = true;
        }
    }

    protected void extendedScannerInfoSetup(CodeReader reader, IScannerInfo info) {
        IExtendedScannerInfo einfo = (IExtendedScannerInfo)info;
        if (einfo.getMacroFiles() != null) {
            int i = 0;
            while (i < einfo.getMacroFiles().length) {
                CodeReader r = this.createReaderDuple(einfo.getMacroFiles()[i]);
                if (r != null) {
                    this.pushContext(r.buffer, r);
                    try {
                        while (true) {
                            this.nextToken();
                        }
                    }
                    catch (EndOfFileException endOfFileException) {
                        this.finished = false;
                    }
                }
                ++i;
            }
        }
        this.macroFilesInitialized = true;
        if (this.parserMode != ParserMode.QUICK_PARSE && einfo.getIncludeFiles() != null && einfo.getIncludeFiles().length > 0) {
            this.preIncludeFiles = Arrays.asList(einfo.getIncludeFiles()).iterator();
        }
        this.locIncludePaths = einfo.getLocalIncludePath();
        this.pushContext(reader.buffer, reader);
        while (this.preIncludeFiles.hasNext()) {
            this.pushForcedInclusion();
        }
        this.isInitialized = true;
    }

    protected void pushContext(char[] buffer) {
        if (++this.bufferStackPos == this.bufferStack.length) {
            int size = this.bufferStack.length * 2;
            char[][] oldBufferStack = this.bufferStack;
            this.bufferStack = new char[size][];
            System.arraycopy(oldBufferStack, 0, this.bufferStack, 0, oldBufferStack.length);
            Object[] oldBufferData = this.bufferData;
            this.bufferData = new Object[size];
            System.arraycopy(oldBufferData, 0, this.bufferData, 0, oldBufferData.length);
            int[] oldBufferPos = this.bufferPos;
            this.bufferPos = new int[size];
            System.arraycopy(oldBufferPos, 0, this.bufferPos, 0, oldBufferPos.length);
            int[] oldBufferLimit = this.bufferLimit;
            this.bufferLimit = new int[size];
            System.arraycopy(oldBufferLimit, 0, this.bufferLimit, 0, oldBufferLimit.length);
            int[] oldLineNumbers = this.lineNumbers;
            this.lineNumbers = new int[size];
            System.arraycopy(oldLineNumbers, 0, this.lineNumbers, 0, oldLineNumbers.length);
            int[] oldLineOffsets = this.lineOffsets;
            this.lineOffsets = new int[size];
            System.arraycopy(oldLineOffsets, 0, this.lineOffsets, 0, oldLineOffsets.length);
        }
        this.bufferStack[this.bufferStackPos] = buffer;
        this.bufferPos[this.bufferStackPos] = -1;
        this.lineNumbers[this.bufferStackPos] = 1;
        this.lineOffsets[this.bufferStackPos] = 0;
        this.bufferLimit[this.bufferStackPos] = buffer.length;
    }

    protected void pushContext(char[] buffer, Object data) {
        if (data instanceof InclusionData && this.isCircularInclusion((InclusionData)data)) {
            return;
        }
        this.pushContext(buffer);
        this.bufferData[this.bufferStackPos] = data;
    }

    protected boolean isCircularInclusion(InclusionData data) {
        int i = 0;
        while (i < this.bufferStackPos) {
            if (this.bufferData[i] instanceof CodeReader && CharArrayUtils.equals(((CodeReader)this.bufferData[i]).filename, data.reader.filename)) {
                return true;
            }
            if (this.bufferData[i] instanceof InclusionData && CharArrayUtils.equals(((InclusionData)this.bufferData[i]).reader.filename, data.reader.filename)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Object popContext() {
        this.bufferStack[this.bufferStackPos] = null;
        Object result = this.bufferData[this.bufferStackPos];
        this.bufferData[this.bufferStackPos] = null;
        --this.bufferStackPos;
        return result;
    }

    protected void pushForcedInclusion() {
        CodeReader r = null;
        while (r == null) {
            if (!this.preIncludeFiles.hasNext()) break;
            r = this.createReaderDuple((String)this.preIncludeFiles.next());
        }
        if (r == null) {
            return;
        }
        int o = this.getCurrentOffset() + 1;
        int l = this.getLineNumber(o);
        Object i = this.createInclusionConstruct(r.filename, r.filename, false, o, l, o, o, l, o, l, true);
        InclusionData d = new InclusionData(r, i);
        this.pushContext(r.buffer, d);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMacro addDefinition(char[] key, char[] value) {
        int idx = CharArrayUtils.indexOf('(', key);
        if (idx == -1) {
            ObjectStyleMacro macro = new ObjectStyleMacro(key, value);
            this.definitions.put(key, macro);
            return macro;
        }
        this.pushContext(key);
        this.bufferPos[this.bufferStackPos] = idx;
        char[][] args = null;
        try {
            args = this.extractMacroParameters(0, EMPTY_STRING_CHAR_ARRAY, false);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.popContext();
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.popContext();
        }
        if (args != null) {
            key = CharArrayUtils.extract(key, 0, idx);
            return this.addDefinition(key, args, value);
        }
        return null;
    }

    public IMacro addDefinition(char[] name, char[][] params, char[] expansion) {
        FunctionStyleMacro macro = new FunctionStyleMacro(name, expansion, params);
        this.definitions.put(name, macro);
        return macro;
    }

    public void addDefinition(IMacro macro) {
        this.definitions.put(macro.getName(), macro);
    }

    public int getCount() {
        return this.count;
    }

    public Map getDefinitions() {
        CharArrayObjectMap objMap = this.getRealDefinitions();
        int size = objMap.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(size);
        int i = 0;
        while (i < size) {
            hashMap.put(String.valueOf(objMap.keyAt(i)), objMap.getAt(i));
            ++i;
        }
        return hashMap;
    }

    public CharArrayObjectMap getRealDefinitions() {
        return this.definitions;
    }

    public String[] getIncludePaths() {
        return this.stdIncludePaths;
    }

    public boolean isOnTopContext() {
        int i = 1;
        while (i <= this.bufferStackPos) {
            if (this.bufferData[i] instanceof InclusionData) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized void cancel() {
        this.isCancelled = true;
        int index = this.bufferStackPos < 0 ? 0 : this.bufferStackPos;
        this.bufferPos[index] = this.bufferLimit[index];
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IToken nextToken() throws EndOfFileException {
        boolean exception = false;
        if (this.nextToken == null && !this.finished) {
            try {
                this.nextToken = this.fetchToken();
            }
            catch (Exception e) {
                if (e instanceof OffsetLimitReachedException) {
                    throw (OffsetLimitReachedException)e;
                }
                if (e instanceof ArrayIndexOutOfBoundsException && this.isCancelled) {
                    throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
                }
                exception = true;
                this.errorHandle();
            }
            if (this.nextToken == null && !exception) {
                this.finished = true;
            }
        }
        this.beforeSecondFetchToken();
        if (this.finished) {
            if (this.contentAssistMode) {
                if (this.lastToken != null) {
                    this.lastToken.setNext(this.nextToken);
                }
                this.lastToken = this.nextToken;
                this.nextToken = this.eocToken;
                return this.lastToken;
            }
            if (this.isCancelled) {
                throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
            }
            if (this.offsetBoundary == -1) {
                this.throwEOF();
            }
            this.throwOLRE();
        }
        if (this.lastToken != null) {
            this.lastToken.setNext(this.nextToken);
        }
        IToken oldToken = this.lastToken;
        this.lastToken = this.nextToken;
        try {
            this.nextToken = this.fetchToken();
        }
        catch (Exception e) {
            if (e instanceof OffsetLimitReachedException) {
                throw (OffsetLimitReachedException)e;
            }
            this.nextToken = null;
            exception = true;
            this.errorHandle();
        }
        if (this.nextToken == null) {
            if (exception) return this.lastToken;
            this.finished = true;
            return this.lastToken;
        }
        if (this.nextToken.getType() == 140) {
            this.finished = true;
            return this.lastToken;
        }
        if (this.nextToken.getType() == 139) {
            IToken token2 = this.fetchToken();
            if (token2 == null) {
                this.nextToken = null;
                this.finished = true;
                return this.lastToken;
            }
            char[] pb = CharArrayUtils.concat(this.lastToken.getCharImage(), token2.getCharImage());
            this.pushContext(pb);
            this.lastToken = oldToken;
            this.nextToken = null;
            return this.nextToken();
        }
        if (this.lastToken == null) return this.lastToken;
        if (this.lastToken.getType() == 130) {
            if (this.nextToken == null) return this.lastToken;
            if (this.nextToken.getType() != 130 && this.nextToken.getType() != 131) {
                return this.lastToken;
            }
        } else {
            if (this.lastToken.getType() != 131) return this.lastToken;
            if (true) {
                if (this.nextToken == null) return this.lastToken;
                if (this.nextToken.getType() != 130 && this.nextToken.getType() != 131) return this.lastToken;
            }
        }
        do {
            int tokenType = 130;
            if (this.lastToken.getType() == 131 || this.nextToken.getType() == 131) {
                tokenType = 131;
            }
            this.lastToken = this.newToken(tokenType, CharArrayUtils.concat(this.lastToken.getCharImage(), this.nextToken.getCharImage()));
            if (oldToken != null) {
                oldToken.setNext(this.lastToken);
            }
            this.nextToken = this.fetchToken();
            if (this.nextToken == null) return this.lastToken;
        } while (this.nextToken.getType() == 130 || this.nextToken.getType() == 131);
        return this.lastToken;
    }

    protected void throwEOF() throws EndOfFileException {
        throw EOF;
    }

    protected void beforeSecondFetchToken() {
    }

    protected void errorHandle() {
        if (this.bufferStackPos > 0) {
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
        }
    }

    protected void throwOLRE() throws OffsetLimitReachedException {
        if (this.lastToken != null && this.lastToken.getEndOffset() != this.offsetBoundary) {
            throw new OffsetLimitReachedException(null);
        }
        throw new OffsetLimitReachedException(this.lastToken);
    }

    protected IToken fetchToken() throws EndOfFileException {
        ++this.count;
        block39: while (this.bufferStackPos >= 0) {
            if (this.isCancelled) {
                throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
            }
            this.skipOverWhiteSpace();
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
            if (this.bufferPos[n] >= this.bufferLimit[this.bufferStackPos]) {
                this.popContext();
                continue;
            }
            char[] buffer = this.bufferStack[this.bufferStackPos];
            int limit = this.bufferLimit[this.bufferStackPos];
            int pos = this.bufferPos[this.bufferStackPos];
            switch (buffer[pos]) {
                case '\n': 
                case '\r': {
                    break;
                }
                case 'L': {
                    if (pos + 1 < limit && buffer[pos + 1] == '\"') {
                        return this.scanString();
                    }
                    if (pos + 1 < limit && buffer[pos + 1] == '\'') {
                        return this.scanCharLiteral();
                    }
                    IToken t = this.scanIdentifier();
                    if (t instanceof MacroExpansionToken) continue block39;
                    return t;
                }
                case '\"': {
                    return this.scanString();
                }
                case '\'': {
                    return this.scanCharLiteral();
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    IToken t = this.scanIdentifier();
                    if (t instanceof MacroExpansionToken) continue block39;
                    return t;
                }
                case '\\': {
                    IToken t;
                    if (pos + 1 < limit && (buffer[pos + 1] == 'u' || buffer[pos + 1] == 'U')) {
                        t = this.scanIdentifier();
                        if (t instanceof MacroExpansionToken) continue block39;
                        return t;
                    }
                    this.handleProblem(0x1000001, this.bufferPos[this.bufferStackPos], new char[]{'\\'});
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.scanNumber();
                }
                case '.': {
                    if (pos + 1 < limit) {
                        switch (buffer[pos + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                return this.scanNumber();
                            }
                            case '.': {
                                if (pos + 2 < limit && buffer[pos + 2] == '.') {
                                    int n2 = this.bufferStackPos;
                                    this.bufferPos[n2] = this.bufferPos[n2] + 2;
                                    return this.newToken(48);
                                }
                            }
                            case '*': {
                                int n3 = this.bufferStackPos;
                                this.bufferPos[n3] = this.bufferPos[n3] + 1;
                                return this.newToken(49);
                            }
                        }
                    }
                    return this.newToken(50);
                }
                case '#': {
                    if (pos + 1 < limit && buffer[pos + 1] == '#') {
                        int n4 = this.bufferStackPos;
                        this.bufferPos[n4] = this.bufferPos[n4] + 1;
                        return this.newToken(139);
                    }
                    this.handlePPDirective(pos);
                    break;
                }
                case '{': {
                    return this.newToken(12);
                }
                case '}': {
                    return this.newToken(13);
                }
                case '[': {
                    return this.newToken(10);
                }
                case ']': {
                    return this.newToken(11);
                }
                case '(': {
                    return this.newToken(8);
                }
                case ')': {
                    return this.newToken(9);
                }
                case ';': {
                    return this.newToken(5);
                }
                case ':': {
                    if (pos + 1 < limit && buffer[pos + 1] == ':' && this.getLanguage() == ParserLanguage.CPP) {
                        int n5 = this.bufferStackPos;
                        this.bufferPos[n5] = this.bufferPos[n5] + 1;
                        return this.newToken(3);
                    }
                    return this.newToken(4);
                }
                case '?': {
                    return this.newToken(7);
                }
                case '+': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '+') {
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            return this.newToken(15);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            return this.newToken(14);
                        }
                    }
                    return this.newToken(16);
                }
                case '-': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '>') {
                            if (pos + 2 < limit && buffer[pos + 2] == '*') {
                                int n8 = this.bufferStackPos;
                                this.bufferPos[n8] = this.bufferPos[n8] + 2;
                                return this.newToken(19);
                            }
                            int n9 = this.bufferStackPos;
                            this.bufferPos[n9] = this.bufferPos[n9] + 1;
                            return this.newToken(20);
                        }
                        if (buffer[pos + 1] == '-') {
                            int n10 = this.bufferStackPos;
                            this.bufferPos[n10] = this.bufferPos[n10] + 1;
                            return this.newToken(18);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n11 = this.bufferStackPos;
                            this.bufferPos[n11] = this.bufferPos[n11] + 1;
                            return this.newToken(17);
                        }
                    }
                    return this.newToken(21);
                }
                case '*': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n12 = this.bufferStackPos;
                        this.bufferPos[n12] = this.bufferPos[n12] + 1;
                        return this.newToken(22);
                    }
                    return this.newToken(23);
                }
                case '/': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n13 = this.bufferStackPos;
                        this.bufferPos[n13] = this.bufferPos[n13] + 1;
                        return this.newToken(51);
                    }
                    return this.newToken(52);
                }
                case '%': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n14 = this.bufferStackPos;
                        this.bufferPos[n14] = this.bufferPos[n14] + 1;
                        return this.newToken(24);
                    }
                    return this.newToken(25);
                }
                case '^': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n15 = this.bufferStackPos;
                        this.bufferPos[n15] = this.bufferPos[n15] + 1;
                        return this.newToken(26);
                    }
                    return this.newToken(27);
                }
                case '&': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '&') {
                            int n16 = this.bufferStackPos;
                            this.bufferPos[n16] = this.bufferPos[n16] + 1;
                            return this.newToken(29);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n17 = this.bufferStackPos;
                            this.bufferPos[n17] = this.bufferPos[n17] + 1;
                            return this.newToken(28);
                        }
                    }
                    return this.newToken(30);
                }
                case '|': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '|') {
                            int n18 = this.bufferStackPos;
                            this.bufferPos[n18] = this.bufferPos[n18] + 1;
                            return this.newToken(32);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n19 = this.bufferStackPos;
                            this.bufferPos[n19] = this.bufferPos[n19] + 1;
                            return this.newToken(31);
                        }
                    }
                    return this.newToken(33);
                }
                case '~': {
                    return this.newToken(34);
                }
                case '!': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n20 = this.bufferStackPos;
                        this.bufferPos[n20] = this.bufferPos[n20] + 1;
                        return this.newToken(35);
                    }
                    return this.newToken(36);
                }
                case '=': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n21 = this.bufferStackPos;
                        this.bufferPos[n21] = this.bufferPos[n21] + 1;
                        return this.newToken(37);
                    }
                    return this.newToken(38);
                }
                case '<': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '=') {
                            int n22 = this.bufferStackPos;
                            this.bufferPos[n22] = this.bufferPos[n22] + 1;
                            return this.newToken(41);
                        }
                        if (buffer[pos + 1] == '<') {
                            if (pos + 2 < limit && buffer[pos + 2] == '=') {
                                int n23 = this.bufferStackPos;
                                this.bufferPos[n23] = this.bufferPos[n23] + 2;
                                return this.newToken(47);
                            }
                            int n24 = this.bufferStackPos;
                            this.bufferPos[n24] = this.bufferPos[n24] + 1;
                            return this.newToken(40);
                        }
                        if (buffer[pos + 1] == '?' && this.supportMinAndMax) {
                            int n25 = this.bufferStackPos;
                            this.bufferPos[n25] = this.bufferPos[n25] + 1;
                            return this.newToken(145, CharArrayUtils.extract(buffer, pos, 2));
                        }
                    }
                    return this.newToken(42);
                }
                case '>': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '=') {
                            int n26 = this.bufferStackPos;
                            this.bufferPos[n26] = this.bufferPos[n26] + 1;
                            return this.newToken(45);
                        }
                        if (buffer[pos + 1] == '>') {
                            if (pos + 2 < limit && buffer[pos + 2] == '=') {
                                int n27 = this.bufferStackPos;
                                this.bufferPos[n27] = this.bufferPos[n27] + 2;
                                return this.newToken(43);
                            }
                            int n28 = this.bufferStackPos;
                            this.bufferPos[n28] = this.bufferPos[n28] + 1;
                            return this.newToken(44);
                        }
                        if (buffer[pos + 1] == '?' && this.supportMinAndMax) {
                            int n29 = this.bufferStackPos;
                            this.bufferPos[n29] = this.bufferPos[n29] + 1;
                            return this.newToken(144, CharArrayUtils.extract(buffer, pos, 2));
                        }
                    }
                    return this.newToken(46);
                }
                case ',': {
                    return this.newToken(6);
                }
                default: {
                    IToken t;
                    if (Character.isLetter(buffer[pos]) || buffer[pos] == '_' || this.support$Initializers && buffer[pos] == '$') {
                        t = this.scanIdentifier();
                        if (t instanceof MacroExpansionToken) continue block39;
                        return t;
                    }
                    char[] x = new char[]{buffer[pos]};
                    this.handleProblem(0x1000001, pos, x);
                }
            }
        }
        return this.contentAssistMode ? this.eocToken : null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected IToken scanIdentifier() {
        char[] cArray;
        int tokenType;
        int len;
        int limit;
        int start;
        boolean escapedNewline;
        char[] buffer;
        block25: {
            int n;
            block24: {
                buffer = this.bufferStack[this.bufferStackPos];
                escapedNewline = false;
                start = this.bufferPos[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                len = 1;
                if (!true) break block24;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block25;
            }
            do {
                block23: {
                    char c;
                    block27: {
                        block26: {
                            if (!((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') && !Character.isUnicodeIdentifierPart(c)) break block26;
                            ++len;
                            break block23;
                        }
                        if (c != '\\' || this.bufferPos[this.bufferStackPos] + 1 >= limit) break block27;
                        if (buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                            int n2 = this.bufferStackPos;
                            this.bufferPos[n2] = this.bufferPos[n2] + 1;
                            len += 2;
                            escapedNewline = true;
                            break block23;
                        } else if (buffer[this.bufferPos[this.bufferStackPos] + 1] == '\r' && buffer[this.bufferPos[this.bufferStackPos] + 2] == '\n') {
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 1;
                            int n4 = this.bufferStackPos;
                            this.bufferPos[n4] = this.bufferPos[n4] + 1;
                            len += 3;
                            escapedNewline = true;
                            break block23;
                        } else {
                            if (buffer[this.bufferPos[this.bufferStackPos] + 1] != 'u' && buffer[this.bufferPos[this.bufferStackPos] + 1] != 'U') break;
                            int n5 = this.bufferStackPos;
                            this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            len += 2;
                        }
                        break block23;
                    }
                    if (!this.support$Initializers || c != '$') break;
                    ++len;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        if (escapedNewline) {
            buffer = this.removedEscapedNewline(buffer, start, len);
            start = 0;
            len = buffer.length;
        }
        if (this.contentAssistMode && this.bufferStackPos == 0 && this.bufferPos[this.bufferStackPos] + 1 == limit) {
            if (!escapedNewline) return this.newToken(140, CharArrayUtils.extract(buffer, start, this.bufferPos[this.bufferStackPos] - start + 1));
            return this.newToken(140, buffer);
        }
        Object expObject = this.definitions.get(buffer, start, len);
        if (expObject != null && !this.isLimitReached() && this.shouldExpandMacro((IMacro)expObject)) {
            char[] expText;
            IMacro expMacro;
            boolean expanding = true;
            if (expObject instanceof FunctionStyleMacro) {
                if (this.handleFunctionStyleMacro((FunctionStyleMacro)expObject, true) == null) {
                    expanding = false;
                }
            } else if (expObject instanceof ObjectStyleMacro) {
                expMacro = (ObjectStyleMacro)expObject;
                char[] expText2 = ((ObjectStyleMacro)expMacro).getExpansion();
                if (expText2.length > 0) {
                    this.pushContext(expText2, new MacroData(this.bufferPos[this.bufferStackPos] - ((ObjectStyleMacro)expMacro).name.length + 1, this.bufferPos[this.bufferStackPos], expMacro));
                }
            } else if (expObject instanceof DynamicStyleMacro) {
                expMacro = (DynamicStyleMacro)expObject;
                char[] expText3 = ((DynamicStyleMacro)expMacro).execute();
                if (expText3.length > 0) {
                    this.pushContext(expText3, new MacroData(this.bufferPos[this.bufferStackPos] - ((DynamicStyleMacro)expMacro).name.length + 1, this.bufferPos[this.bufferStackPos], expMacro));
                }
            } else if (expObject instanceof char[] && (expText = (char[])expObject).length > 0) {
                this.pushContext(expText);
            }
            if (expanding) {
                return EXPANSION_TOKEN;
            }
        }
        if ((tokenType = this.keywords.get(buffer, start, len)) != this.keywords.undefined) {
            return this.newToken(tokenType);
        }
        int keyLoc = this.additionalKeywords.getKeyLocation(buffer, start, len);
        if (keyLoc != this.additionalKeywords.undefined) {
            return this.newToken(this.additionalKeywords.get(keyLoc), this.additionalKeywords.keyAt(keyLoc));
        }
        if (cacheIdentifiers) {
            return this.newToken(1, ident.keyAt(ident.addIndex(buffer, start, len)));
        }
        if (escapedNewline) {
            cArray = buffer;
            return this.newToken(1, cArray);
        }
        cArray = CharArrayUtils.extract(buffer, start, len);
        return this.newToken(1, cArray);
    }

    protected boolean shouldExpandMacro(IMacro macro) {
        return BaseScanner.shouldExpandMacro(macro, this.bufferStackPos, this.bufferData, this.offsetBoundary, this.bufferPos, this.bufferStack);
    }

    protected static boolean shouldExpandMacro(IMacro macro, int bufferStackPos, Object[] bufferData, int offsetBoundary, int[] bufferPos, char[][] bufferStack) {
        if (macro != null && !BaseScanner.isLimitReached(offsetBoundary, bufferStackPos, bufferPos, bufferStack)) {
            int stackPos = bufferStackPos;
            while (stackPos >= 0) {
                if (bufferData[stackPos] != null && bufferData[stackPos] instanceof MacroData && CharArrayUtils.equals(macro.getName(), ((MacroData)bufferData[stackPos]).macro.getName())) {
                    return false;
                }
                --stackPos;
            }
        }
        return true;
    }

    protected final boolean isLimitReached() {
        return BaseScanner.isLimitReached(this.offsetBoundary, this.bufferStackPos, this.bufferPos, this.bufferStack);
    }

    protected static final boolean isLimitReached(int offsetBoundary, int bufferStackPos, int[] bufferPos, char[][] bufferStack) {
        char c;
        if (offsetBoundary == -1 || bufferStackPos != 0) {
            return false;
        }
        if (bufferPos[bufferStackPos] == offsetBoundary - 1) {
            return true;
        }
        return bufferPos[bufferStackPos] == offsetBoundary && ((c = bufferStack[bufferStackPos][bufferPos[bufferStackPos]]) == '\n' || c == ' ' || c == '\t' || c == '\r');
    }

    /*
     * Unable to fully structure code
     */
    protected IToken scanString() {
        buffer = this.bufferStack[this.bufferStackPos];
        tokenType = 130;
        if (buffer[this.bufferPos[this.bufferStackPos]] == 'L') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            tokenType = 131;
        }
        stringStart = this.bufferPos[this.bufferStackPos] + 1;
        stringLen = 0;
        escaped = false;
        foundClosingQuote = false;
        if (true) ** GOTO lbl33
        do {
            block10: {
                ++stringLen;
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c != '\"') break block10;
                if (!escaped) {
                    foundClosingQuote = true;
                    break;
                }
                ** GOTO lbl32
            }
            if (c == '\\') {
                escaped = escaped == false;
            } else {
                if (c == '\n') {
                    if (!escaped) {
                        break;
                    }
                } else if (c == '\r' && this.bufferPos[this.bufferStackPos] + 1 < this.bufferLimit[this.bufferStackPos] && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] + 1;
                    if (!escaped) break;
                }
lbl32:
                // 5 sources

                escaped = false;
            }
lbl33:
            // 3 sources

            v2 = this.bufferStackPos;
        } while ((this.bufferPos[v2] = this.bufferPos[v2] + 1) < this.bufferLimit[this.bufferStackPos]);
        result = CharArrayUtils.extract(buffer, stringStart, --stringLen);
        if (!foundClosingQuote) {
            this.handleProblem(0x1000002, stringStart, result);
        }
        return this.newToken(tokenType, result);
    }

    /*
     * Unable to fully structure code
     */
    protected IToken scanCharLiteral() {
        buffer = this.bufferStack[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        tokenType = 132;
        length = 1;
        if (buffer[this.bufferPos[this.bufferStackPos]] == 'L') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            tokenType = 133;
            ++length;
        }
        if (start >= limit) {
            return this.newToken(tokenType, BaseScanner.EMPTY_CHAR_ARRAY);
        }
        escaped = false;
        if (true) ** GOTO lbl27
        do {
            block7: {
                ++length;
                pos = this.bufferPos[this.bufferStackPos];
                if (buffer[pos] != '\'') break block7;
                if (!escaped) {
                    break;
                }
                ** GOTO lbl-1000
            }
            if (buffer[pos] == '\\') {
                escaped = escaped == false;
            } else lbl-1000:
            // 2 sources

            {
                escaped = false;
            }
lbl27:
            // 3 sources

            v1 = this.bufferStackPos;
        } while ((this.bufferPos[v1] = this.bufferPos[v1] + 1) < limit);
        if (this.bufferPos[this.bufferStackPos] == limit) {
            this.handleProblem(0x1000001, start, CharArrayUtils.extract(buffer, start, length));
            return this.newToken(tokenType, BaseScanner.EMPTY_CHAR_ARRAY);
        }
        image = length > 0 ? CharArrayUtils.extract(buffer, start, length) : BaseScanner.EMPTY_CHAR_ARRAY;
        return this.newToken(tokenType, image);
    }

    protected abstract void handleProblem(int var1, int var2, char[] var3);

    protected int getLineNumber(int offset) {
        int startingPoint;
        if (this.parserMode == ParserMode.COMPLETION_PARSE) {
            return -1;
        }
        int index = this.getCurrentFileIndex();
        if (offset >= this.bufferLimit[index]) {
            return -1;
        }
        int lineNum = this.lineNumbers[index];
        int i = startingPoint = this.lineOffsets[index];
        while (i < offset) {
            if (this.bufferStack[index][i] == '\n') {
                ++lineNum;
            }
            ++i;
        }
        if (startingPoint < offset) {
            this.lineNumbers[index] = lineNum;
            this.lineOffsets[index] = offset;
        }
        return lineNum;
    }

    /*
     * Unable to fully structure code
     */
    protected IToken scanNumber() throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        isFloat = buffer[start] == '.';
        hasExponent = false;
        isHex = false;
        isOctal = false;
        isMalformedOctal = false;
        if (buffer[start] != '0' || start + 1 >= limit) ** GOTO lbl97
        switch (buffer[start + 1]) {
            case 'X': 
            case 'x': {
                isHex = true;
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                break;
            }
            default: {
                if (buffer[start + 1] > '0' && buffer[start + 1] < '7') {
                    isOctal = true;
                    break;
                }
                if (buffer[start + 1] == '8' || buffer[start + 1] == '9') {
                    isOctal = true;
                    isMalformedOctal = true;
                    break;
                }
                ** GOTO lbl97
            }
        }
        if (true) ** GOTO lbl97
        block21: do {
            pos = this.bufferPos[this.bufferStackPos];
            block3 : switch (buffer[pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (buffer[pos] != '8' && buffer[pos] != '9' || !isOctal) break;
                    isMalformedOctal = true;
                    break block21;
                }
                case '.': {
                    if (this.isLimitReached()) {
                        this.handleNoSuchCompletion();
                    }
                    if (isFloat) {
                        this.handleProblem(0x1000004, start, null);
                        break block21;
                    }
                    isFloat = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (isHex) break;
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            v1 = this.bufferStackPos;
                            this.bufferPos[v1] = this.bufferPos[v1] + 1;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': {
                    if (!isHex) break block21;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (isHex) break;
                    v2 = this.bufferStackPos;
                    this.bufferPos[v2] = this.bufferPos[v2] + 1;
                    if (this.bufferPos[this.bufferStackPos] >= buffer.length || buffer[this.bufferPos[this.bufferStackPos]] != 'i') break block21;
                    break;
                }
                case 'P': 
                case 'p': {
                    if (!isFloat || !isHex) {
                        v3 = this.bufferStackPos;
                        this.bufferPos[v3] = this.bufferPos[v3] - 1;
                        break block21;
                    }
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            v4 = this.bufferStackPos;
                            this.bufferPos[v4] = this.bufferPos[v4] + 1;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    if (true) ** GOTO lbl83
                    do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case 'L': 
                            case 'U': 
                            case 'l': 
                            case 'u': {
                                break;
                            }
                            default: {
                                break block21;
                            }
                        }
lbl83:
                        // 2 sources

                        v5 = this.bufferStackPos;
                    } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
                    break block21;
                }
                default: {
                    success = false;
                    iter = 0;
                    while (iter < this.suffixes.length) {
                        if (buffer[pos] == this.suffixes[iter]) {
                            success = true;
                            break;
                        }
                        ++iter;
                    }
                    if (!success) break block21;
                    break;
                }
            }
lbl97:
            // 12 sources

            v6 = this.bufferStackPos;
        } while ((this.bufferPos[v6] = this.bufferPos[v6] + 1) < limit);
        v7 = this.bufferStackPos;
        this.bufferPos[v7] = this.bufferPos[v7] - 1;
        result = CharArrayUtils.extract(buffer, start, this.bufferPos[this.bufferStackPos] - start + 1);
        v8 = tokenType = isFloat != false ? 129 : 2;
        if (tokenType == 2 && isHex && result.length == 2) {
            this.handleProblem(0x1000005, start, result);
        } else if (tokenType == 2 && isOctal && isMalformedOctal) {
            this.handleProblem(0x1000007, start, result);
        }
        return this.newToken(tokenType, result);
    }

    protected boolean branchState(int state) {
        if (state != 1 && this.branchStackPos == -1) {
            return false;
        }
        switch (state) {
            case 1: {
                if (++this.branchStackPos == this.branches.length) {
                    int[] temp = new int[this.branches.length << 1];
                    System.arraycopy(this.branches, 0, temp, 0, this.branches.length);
                    this.branches = temp;
                }
                this.branches[this.branchStackPos] = 1;
                return true;
            }
            case 2: 
            case 3: {
                switch (this.branches[this.branchStackPos]) {
                    case 1: 
                    case 2: {
                        this.branches[this.branchStackPos] = state;
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (this.branches[this.branchStackPos]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        --this.branchStackPos;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void handlePPDirective(int pos) throws EndOfFileException {
        block30: {
            block29: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                startingLineNumber = this.getLineNumber(pos);
                this.skipOverWhiteSpace();
                if (this.isLimitReached()) {
                    this.handleCompletionOnPreprocessorDirective("#");
                }
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                start = this.bufferPos[v0];
                if (start >= limit || buffer[start] == '\n') {
                    return;
                }
                problem = false;
                c = buffer[start];
                if (c < 'a' || c > 'z') break block29;
                ** GOTO lbl-1000
                while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c == '_') lbl-1000:
                // 2 sources

                {
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] + 1;
                    if (this.bufferPos[v1] < limit) continue;
                }
                v2 = this.bufferStackPos;
                this.bufferPos[v2] = this.bufferPos[v2] - 1;
                len = this.bufferPos[this.bufferStackPos] - start + 1;
                if (this.isLimitReached()) {
                    this.handleCompletionOnPreprocessorDirective(new String(buffer, pos, len + 1));
                }
                if ((type = BaseScanner.ppKeywords.get(buffer, start, len)) != BaseScanner.ppKeywords.undefined) {
                    switch (type) {
                        case 6: {
                            this.handlePPInclude(pos, false, startingLineNumber);
                            return;
                        }
                        case 10: {
                            this.handlePPInclude(pos, true, startingLineNumber);
                            return;
                        }
                        case 7: {
                            this.handlePPDefine(pos, startingLineNumber);
                            return;
                        }
                        case 8: {
                            this.handlePPUndef(pos);
                            return;
                        }
                        case 1: {
                            this.handlePPIfdef(pos, true);
                            return;
                        }
                        case 2: {
                            this.handlePPIfdef(pos, false);
                            return;
                        }
                        case 0: {
                            start = this.bufferPos[this.bufferStackPos] + 1;
                            this.skipToNewLine();
                            len = this.bufferPos[this.bufferStackPos] - start;
                            if (this.isLimitReached()) {
                                this.handleCompletionOnExpression(CharArrayUtils.extract(buffer, start, len));
                            }
                            this.branchState(1);
                            if (this.expressionEvaluator.evaluate(buffer, start, len, this.definitions, this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename()) == 0L) {
                                this.processIf(pos, this.bufferPos[this.bufferStackPos], true);
                                this.skipOverConditionalCode(true);
                                if (this.isLimitReached()) {
                                    this.handleInvalidCompletion();
                                }
                            } else {
                                this.processIf(pos, this.bufferPos[this.bufferStackPos], false);
                            }
                            return;
                        }
                        case 3: 
                        case 4: {
                            if (this.branchState(type == 4 ? 3 : 2)) {
                                if (type == 4) {
                                    this.processElse(pos, this.bufferPos[this.bufferStackPos] + 1, false);
                                } else {
                                    this.processElsif(pos, this.bufferPos[this.bufferStackPos], false);
                                }
                                this.skipToNewLine();
                                this.skipOverConditionalCode(false);
                            } else {
                                this.handleProblem(0x2000004, start, BaseScanner.ppKeywords.findKey(buffer, start, len));
                                this.skipToNewLine();
                            }
                            if (this.isLimitReached()) {
                                this.handleInvalidCompletion();
                            }
                            return;
                        }
                        case 9: {
                            this.skipOverWhiteSpace();
                            start = this.bufferPos[this.bufferStackPos] + 1;
                            this.skipToNewLine();
                            len = this.bufferPos[this.bufferStackPos] - 1 > 0 && buffer[this.bufferPos[this.bufferStackPos] - 1] == '\r' ? this.bufferPos[this.bufferStackPos] - start - 1 : this.bufferPos[this.bufferStackPos] - start;
                            this.handleProblem(0x2000001, start, CharArrayUtils.extract(buffer, start, len));
                            this.processError(pos, pos + len);
                            break;
                        }
                        case 5: {
                            if (!this.branchState(4)) {
                                this.handleProblem(0x2000004, start, BaseScanner.ppKeywords.findKey(buffer, start, len));
                            }
                            this.processEndif(pos, this.bufferPos[this.bufferStackPos] + 1);
                            break;
                        }
                        case 11: {
                            this.skipToNewLine();
                            this.processPragma(pos, this.bufferPos[this.bufferStackPos]);
                            break;
                        }
                        default: {
                            problem = true;
                            break;
                        }
                    }
                }
                break block30;
            }
            problem = true;
        }
        if (problem) {
            this.handleProblem(0x2000006, start, null);
        }
        this.skipToNewLine();
    }

    protected abstract void processPragma(int var1, int var2);

    protected abstract void processEndif(int var1, int var2);

    protected abstract void processError(int var1, int var2);

    protected abstract void processElsif(int var1, int var2, boolean var3);

    protected abstract void processElse(int var1, int var2, boolean var3);

    protected abstract void processIf(int var1, int var2, boolean var3);

    /*
     * Unable to fully structure code
     */
    protected void handlePPInclude(int pos2, boolean include_next, int startingLineNumber) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        this.skipOverWhiteSpace();
        startOffset = pos2;
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        pos = v1;
        if (pos >= limit) {
            return;
        }
        local = false;
        filename = null;
        endOffset = startOffset;
        nameOffset = 0;
        nameEndOffset = 0;
        nameLine = 0;
        endLine = 0;
        c = buffer[pos];
        switch (c) {
            case '\n': {
                return;
            }
            case '\"': {
                nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
                local = true;
                start = this.bufferPos[this.bufferStackPos] + 1;
                length = 0;
                escaped = false;
                if (true) ** GOTO lbl41
                do {
                    ++length;
                    c = buffer[this.bufferPos[this.bufferStackPos]];
                    if (c != '\"') ** GOTO lbl37
                    if (!escaped) {
                        break;
                    }
                    ** GOTO lbl-1000
lbl37:
                    // 1 sources

                    if (c == '\\') {
                        escaped = escaped == false;
                    } else lbl-1000:
                    // 2 sources

                    {
                        escaped = false;
                    }
lbl41:
                    // 3 sources

                    v2 = this.bufferStackPos;
                } while ((this.bufferPos[v2] = this.bufferPos[v2] + 1) < limit);
                filename = new String(buffer, start, --length);
                nameOffset = start;
                nameEndOffset = start + length;
                endOffset = start + length + 1;
                break;
            }
            case '<': {
                nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
                local = false;
                start = this.bufferPos[this.bufferStackPos] + 1;
                length = 0;
                if (true) ** GOTO lbl56
                do {
                    ++length;
lbl56:
                    // 2 sources

                    v3 = this.bufferStackPos;
                } while ((this.bufferPos[v3] = this.bufferPos[v3] + 1) < limit && buffer[this.bufferPos[this.bufferStackPos]] != '>');
                endOffset = start + length + 1;
                nameOffset = start;
                nameEndOffset = start + length;
                filename = new String(buffer, start, length);
                break;
            }
            default: {
                startPos = pos;
                len = 1;
                if (true) ** GOTO lbl75
                do {
                    if ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
                        ++len;
                    } else {
                        if (c != '\\' || this.bufferPos[this.bufferStackPos] + 1 >= buffer.length || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') break;
                        v4 = this.bufferStackPos;
                        this.bufferPos[v4] = this.bufferPos[v4] + 1;
                        len += 2;
                    }
lbl75:
                    // 3 sources

                    v5 = this.bufferStackPos;
                } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
                if ((expObject = this.definitions.get(buffer, startPos, len)) == null) break;
                v6 = this.bufferStackPos;
                this.bufferPos[v6] = this.bufferPos[v6] - 1;
                t = null;
                if (expObject instanceof FunctionStyleMacro) {
                    t = this.handleFunctionStyleMacro((FunctionStyleMacro)expObject, false);
                } else if (expObject instanceof ObjectStyleMacro) {
                    t = ((ObjectStyleMacro)expObject).getExpansion();
                }
                if (t == null) break;
                if ((t = this.replaceArgumentMacros(t))[t.length - 1] == t[0] && t[0] == '\"') {
                    local = true;
                    filename = new String(t, 1, t.length - 2);
                    break;
                }
                if (t[0] != '<' || t[t.length - 1] != '>') break;
                local = false;
                filename = new String(t, 1, t.length - 2);
            }
        }
        if (filename == null || filename == "") {
            this.handleProblem(0x2000006, startOffset, null);
            return;
        }
        fileNameArray = filename.toCharArray();
        endLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        this.skipToNewLine();
        this.findAndPushInclusion(filename, fileNameArray, local, include_next, startOffset, nameOffset, nameEndOffset, endOffset, startingLineNumber, nameLine, endLine);
    }

    protected void findAndPushInclusion(String filename, char[] fileNameArray, boolean local, boolean include_next, int startOffset, int nameOffset, int nameEndOffset, int endOffset, int startingLine, int nameLine, int endLine) {
        String absolutePath;
        if (this.parserMode == ParserMode.QUICK_PARSE) {
            Object inclusion = this.createInclusionConstruct(fileNameArray, EMPTY_CHAR_ARRAY, local, startOffset, startingLine, nameOffset, nameEndOffset, nameLine, endOffset, endLine, false);
            this.quickParsePushPopInclusion(inclusion);
            return;
        }
        CodeReader reader = null;
        if (new File(filename).isAbsolute() || filename.startsWith("/")) {
            reader = this.createReader(EMPTY_STRING, filename);
            if (reader != null) {
                this.pushContext(reader.buffer, new InclusionData(reader, this.createInclusionConstruct(fileNameArray, reader.filename, local, startOffset, startingLine, nameOffset, nameEndOffset, nameLine, endOffset, endLine, false)));
                return;
            }
            this.handleProblem(0x2000002, startOffset, fileNameArray);
            return;
        }
        File currentDirectory = null;
        if (local || include_next) {
            File file = new File(String.valueOf(this.getCurrentFilename()));
            currentDirectory = file.getParentFile();
        }
        if (local && !include_next && currentDirectory != null && (reader = this.createReader(absolutePath = currentDirectory.getAbsolutePath(), filename)) != null) {
            this.pushContext(reader.buffer, new InclusionData(reader, this.createInclusionConstruct(fileNameArray, reader.filename, local, startOffset, startingLine, nameOffset, nameEndOffset, nameLine, endOffset, endLine, false)));
            return;
        }
        String[] includePathsToUse = this.stdIncludePaths;
        if (local && this.locIncludePaths != null && this.locIncludePaths.length > 0) {
            includePathsToUse = new String[this.locIncludePaths.length + this.stdIncludePaths.length];
            System.arraycopy(this.locIncludePaths, 0, includePathsToUse, 0, this.locIncludePaths.length);
            System.arraycopy(this.stdIncludePaths, 0, includePathsToUse, this.locIncludePaths.length, this.stdIncludePaths.length);
        }
        if (includePathsToUse != null) {
            int startpos = 0;
            if (include_next) {
                startpos = this.findIncludePos(includePathsToUse, currentDirectory) + 1;
            }
            int i = startpos;
            while (i < includePathsToUse.length) {
                reader = this.createReader(includePathsToUse[i], filename);
                if (reader != null) {
                    this.pushContext(reader.buffer, new InclusionData(reader, this.createInclusionConstruct(fileNameArray, reader.filename, local, startOffset, startingLine, nameOffset, nameEndOffset, nameLine, endOffset, endLine, false)));
                    return;
                }
                ++i;
            }
        }
        this.handleProblem(0x2000002, startOffset, fileNameArray);
    }

    protected abstract CodeReader createReader(String var1, String var2);

    private int findIncludePos(String[] paths, File currentDirectory) {
        int i = 0;
        while (i < paths.length) {
            try {
                String path = new File(paths[i]).getCanonicalPath();
                String parent = currentDirectory.getCanonicalPath();
                if (path.equals(parent)) {
                    return i;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return -1;
    }

    protected abstract CodeReader createReaderDuple(String var1);

    protected abstract void quickParsePushPopInclusion(Object var1);

    protected abstract Object createInclusionConstruct(char[] var1, char[] var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, boolean var11);

    /*
     * Unable to fully structure code
     */
    protected void handlePPDefine(int pos2, int startingLineNumber) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        startingOffset = pos2;
        endingLine = 0;
        nameLine = 0;
        this.skipOverWhiteSpace();
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        idstart = v1;
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.handleProblem(0x2000005, idstart, null);
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl23
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl23:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        name = new char[idlen];
        System.arraycopy(buffer, idstart, name, 0, idlen);
        arglist = null;
        pos = this.bufferPos[this.bufferStackPos];
        if (pos + 1 < limit && buffer[pos + 1] == '(') {
            v4 = this.bufferStackPos;
            this.bufferPos[v4] = this.bufferPos[v4] + 1;
            arglist = this.extractMacroParameters(idstart, name, true);
            if (arglist == null) {
                return;
            }
        }
        this.skipOverWhiteSpace();
        textstart = this.bufferPos[this.bufferStackPos] + 1;
        textend = textstart - 1;
        varArgDefinitionInd = -1;
        encounteredMultilineComment = false;
        usesVarArgInDefinition = false;
        while (this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') {
            if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos] + 1, BaseScanner.VA_ARGS_CHARARRAY.length, BaseScanner.VA_ARGS_CHARARRAY)) {
                usesVarArgInDefinition = true;
                varArgDefinitionInd = this.bufferPos[this.bufferStackPos] + 1;
            }
            if (arglist != null && !this.skipOverNonWhiteSpace(true)) {
                v5 = this.bufferStackPos;
                this.bufferPos[v5] = this.bufferPos[v5] + 1;
                if (this.skipOverWhiteSpace()) {
                    encounteredMultilineComment = true;
                }
                isArg = false;
                if (this.bufferPos[this.bufferStackPos] + 1 < limit) {
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] + 1;
                    i = 0;
                    while (i < arglist.length && arglist[i] != null) {
                        if (this.bufferPos[this.bufferStackPos] + arglist[i].length - 1 < limit) {
                            if (arglist[i].length > 3 && arglist[i][arglist[i].length - 3] == '.' && arglist[i][arglist[i].length - 2] == '.' && arglist[i][arglist[i].length - 3] == '.') {
                                varArgName = new char[arglist[i].length - 3];
                                System.arraycopy(arglist[i], 0, varArgName, 0, arglist[i].length - 3);
                                if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], varArgName.length, varArgName)) {
                                    isArg = true;
                                    v7 = this.bufferStackPos;
                                    this.bufferPos[v7] = this.bufferPos[v7] + (arglist[i].length - 4);
                                    break;
                                }
                            } else if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], arglist[i].length, arglist[i]) || CharArrayUtils.equals(arglist[i], BaseScanner.ELLIPSIS_CHARARRAY) && CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], BaseScanner.VA_ARGS_CHARARRAY.length, BaseScanner.VA_ARGS_CHARARRAY)) {
                                isArg = true;
                                v8 = this.bufferStackPos;
                                this.bufferPos[v8] = this.bufferPos[v8] + (arglist[i].length - 1);
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (!isArg) {
                    this.handleProblem(0x200000A, this.bufferPos[this.bufferStackPos], null);
                }
            } else {
                this.skipOverNonWhiteSpace();
            }
            textend = this.bufferPos[this.bufferStackPos];
            if (!this.skipOverWhiteSpace()) continue;
            encounteredMultilineComment = true;
        }
        textlen = textend - textstart + 1;
        endingLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        text = BaseScanner.EMPTY_CHAR_ARRAY;
        if (textlen > 0) {
            text = new char[textlen];
            System.arraycopy(buffer, textstart, text, 0, textlen);
        }
        if (encounteredMultilineComment) {
            text = this.removeMultilineCommentFromBuffer(text);
        }
        text = this.removedEscapedNewline(text, 0, text.length);
        result = null;
        result = arglist == null ? new ObjectStyleMacro(name, text) : new FunctionStyleMacro(name, text, arglist);
        this.definitions.put(name, result);
        if (usesVarArgInDefinition && this.definitions.get(name) instanceof FunctionStyleMacro && !((FunctionStyleMacro)this.definitions.get(name)).hasVarArgs()) {
            this.handleProblem(0x200000D, varArgDefinitionInd, null);
        }
        idend = idstart + idlen;
        textEnd = textstart + textlen;
        this.processMacro(name, startingOffset, startingLineNumber, idstart, idend, nameLine, textEnd, endingLine, result);
    }

    protected abstract void processMacro(char[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, IMacro var9);

    protected char[][] extractMacroParameters(int idstart, char[] name, boolean reportProblems) {
        char[] buffer = this.bufferStack[this.bufferStackPos];
        int limit = this.bufferLimit[this.bufferStackPos];
        if (this.bufferPos[this.bufferStackPos] >= limit || buffer[this.bufferPos[this.bufferStackPos]] != '(') {
            return null;
        }
        char[][] arglist = new char[4][];
        int currarg = -1;
        while (this.bufferPos[this.bufferStackPos] < limit) {
            this.skipOverWhiteSpace();
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
            if (this.bufferPos[n] >= limit) {
                return null;
            }
            char c = buffer[this.bufferPos[this.bufferStackPos]];
            int argstart = this.bufferPos[this.bufferStackPos];
            if (c == ')') break;
            if (c == ',') continue;
            if (c == '.' && this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '.' && this.bufferPos[this.bufferStackPos] + 2 < limit && buffer[this.bufferPos[this.bufferStackPos] + 2] == '.') {
                int n2 = this.bufferStackPos;
                this.bufferPos[n2] = this.bufferPos[n2] - 1;
            } else if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isUnicodeIdentifierPart(c) || !reportProblems)) {
                this.handleProblem(0x2000005, idstart, name);
                this.skipToNewLine();
                return null;
            }
            this.skipOverIdentifier();
            if (++currarg == arglist.length) {
                char[][] oldarglist = arglist;
                arglist = new char[oldarglist.length * 2][];
                System.arraycopy(oldarglist, 0, arglist, 0, oldarglist.length);
            }
            int arglen = this.bufferPos[this.bufferStackPos] - argstart + 1;
            char[] arg = new char[arglen];
            System.arraycopy(buffer, argstart, arg, 0, arglen);
            arglist[currarg] = arg;
        }
        return arglist;
    }

    protected char[] removedEscapedNewline(char[] text, int start, int len) {
        if (CharArrayUtils.indexOf('\n', text, start, start + len) == -1) {
            return text;
        }
        char[] result = new char[len];
        Arrays.fill(result, ' ');
        int counter = 0;
        int i = start;
        while (i < start + len) {
            if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\n') {
                ++i;
            } else if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\r' && i + 2 < text.length && text[i + 2] == '\n') {
                i += 2;
            } else {
                result[counter++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim(result);
    }

    protected char[] removeMultilineCommentFromBuffer(char[] text) {
        char[] result = new char[text.length];
        Arrays.fill(result, ' ');
        int resultCount = 0;
        int i = 0;
        while (i < text.length) {
            if (text[i] == '/' && i + 1 < text.length && text[i + 1] == '*') {
                i += 2;
                while (i < text.length && (text[i] != '*' || i + 1 >= text.length || text[i + 1] != '/')) {
                    ++i;
                }
                ++i;
            } else {
                result[resultCount++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim(result);
    }

    /*
     * Unable to fully structure code
     */
    protected void handlePPUndef(int pos) throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        this.skipOverWhiteSpace();
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        idstart = v1;
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl19
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl19:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition(new String(buffer, idstart, idlen));
        }
        this.skipToNewLine();
        definition = this.definitions.remove(buffer, idstart, idlen);
        this.processUndef(pos, this.bufferPos[this.bufferStackPos], CharArrayUtils.extract(buffer, idstart, idlen), idstart, definition);
    }

    protected abstract void processUndef(int var1, int var2, char[] var3, int var4, Object var5);

    /*
     * Unable to fully structure code
     */
    protected void handlePPIfdef(int pos, boolean positive) throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition("");
        }
        this.skipOverWhiteSpace();
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition("");
        }
        v0 = this.bufferStackPos;
        this.bufferPos[v0] = this.bufferPos[v0] + 1;
        idstart = this.bufferPos[v0];
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl22
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl22:
            // 2 sources

            v1 = this.bufferStackPos;
            this.bufferPos[v1] = this.bufferPos[v1] + 1;
            if (this.bufferPos[v1] < limit) continue;
        }
        v2 = this.bufferStackPos;
        this.bufferPos[v2] = this.bufferPos[v2] - 1;
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition(new String(buffer, idstart, idlen));
        }
        this.skipToNewLine();
        this.branchState(1);
        if (this.definitions.get(buffer, idstart, idlen) != null == positive) {
            this.processIfdef(pos, this.bufferPos[this.bufferStackPos], positive, true);
            return;
        }
        this.processIfdef(pos, this.bufferPos[this.bufferStackPos], positive, false);
        this.skipOverConditionalCode(true);
        if (this.isLimitReached()) {
            this.handleInvalidCompletion();
        }
    }

    protected abstract void processIfdef(int var1, int var2, boolean var3, boolean var4);

    /*
     * Unable to fully structure code
     */
    protected void skipOverConditionalCode(boolean checkelse) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        nesting = 0;
        while (this.bufferPos[this.bufferStackPos] < limit) {
            block18: {
                this.skipOverWhiteSpace();
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                if (this.bufferPos[v0] >= limit) {
                    return;
                }
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c != '#') break block18;
                startPos = this.bufferPos[this.bufferStackPos];
                this.skipOverWhiteSpace();
                v1 = this.bufferStackPos;
                v2 = this.bufferPos[v1] + 1;
                this.bufferPos[v1] = v2;
                start = v2;
                if (start >= limit || buffer[start] == '\n' || (c = buffer[start]) < 'a' || c > 'z') continue;
                ** GOTO lbl-1000
                while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z') lbl-1000:
                // 2 sources

                {
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] + 1;
                    if (this.bufferPos[v3] < limit) continue;
                }
                v4 = this.bufferStackPos;
                this.bufferPos[v4] = this.bufferPos[v4] - 1;
                len = this.bufferPos[this.bufferStackPos] - start + 1;
                type = BaseScanner.ppKeywords.get(buffer, start, len);
                if (type == BaseScanner.ppKeywords.undefined) continue;
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++nesting;
                        this.branchState(1);
                        this.skipToNewLine();
                        if (type == 1) {
                            this.processIfdef(startPos, this.bufferPos[this.bufferStackPos], true, false);
                            break;
                        }
                        if (type == 2) {
                            this.processIfdef(startPos, this.bufferPos[this.bufferStackPos], false, false);
                            break;
                        }
                        this.processIf(startPos, this.bufferPos[this.bufferStackPos], false);
                        break;
                    }
                    case 4: {
                        if (this.branchState(3)) {
                            this.skipToNewLine();
                            if (checkelse && nesting == 0) {
                                this.processElse(startPos, this.bufferPos[this.bufferStackPos], true);
                                return;
                            }
                            this.processElse(startPos, this.bufferPos[this.bufferStackPos], false);
                            break;
                        }
                        this.handleProblem(0x2000004, start, BaseScanner.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                        break;
                    }
                    case 3: {
                        if (this.branchState(2)) {
                            if (checkelse && nesting == 0) {
                                start = this.bufferPos[this.bufferStackPos] + 1;
                                this.skipToNewLine();
                                len = this.bufferPos[this.bufferStackPos] - start;
                                if (this.expressionEvaluator.evaluate(buffer, start, len, this.definitions, this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename()) != 0L) {
                                    this.processElsif(startPos, this.bufferPos[this.bufferStackPos], true);
                                    return;
                                }
                                this.processElsif(startPos, this.bufferPos[this.bufferStackPos], false);
                                break;
                            }
                            this.skipToNewLine();
                            this.processElsif(startPos, this.bufferPos[this.bufferStackPos], false);
                            break;
                        }
                        this.handleProblem(0x2000004, start, BaseScanner.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                        break;
                    }
                    case 5: {
                        if (this.branchState(4)) {
                            this.processEndif(startPos, this.bufferPos[this.bufferStackPos] + 1);
                            if (nesting > 0) {
                                --nesting;
                                break;
                            }
                            this.skipToNewLine();
                            return;
                        }
                        this.handleProblem(0x2000004, start, BaseScanner.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                    }
                }
                continue;
            }
            if (c == '\n') continue;
            this.skipToNewLine();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected boolean skipOverWhiteSpace() {
        boolean encounteredMultiLineComment;
        block13: {
            int n;
            int pos;
            int limit;
            char[] buffer;
            block12: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                pos = this.bufferPos[this.bufferStackPos];
                encounteredMultiLineComment = false;
                if (!true) break block12;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block13;
            }
            do {
                block11: {
                    pos = this.bufferPos[this.bufferStackPos];
                    switch (buffer[pos]) {
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            break block11;
                        }
                        case '/': {
                            if (pos + 1 >= limit) break;
                            if (buffer[pos + 1] == '/') {
                                this.skipToNewLine(true);
                                int n2 = this.bufferStackPos;
                                this.bufferPos[n2] = this.bufferPos[n2] - 1;
                                return false;
                            }
                            if (buffer[pos + 1] != '*') break;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 2;
                            while (this.bufferPos[this.bufferStackPos] < limit) {
                                pos = this.bufferPos[this.bufferStackPos];
                                if (buffer[pos] == '*' && pos + 1 < limit && buffer[pos + 1] == '/') {
                                    int n4 = this.bufferStackPos;
                                    this.bufferPos[n4] = this.bufferPos[n4] + 1;
                                    encounteredMultiLineComment = true;
                                    break block11;
                                }
                                int n5 = this.bufferStackPos;
                                this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            }
                            break block11;
                        }
                        case '\\': {
                            if (pos + 1 < limit && buffer[pos + 1] == '\n') {
                                int n6 = this.bufferStackPos;
                                this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            } else {
                                if (pos + 1 >= limit || buffer[pos + 1] != '\r' || pos + 2 >= limit || buffer[pos + 2] != '\n') break;
                                int n7 = this.bufferStackPos;
                                this.bufferPos[n7] = this.bufferPos[n7] + 2;
                            }
                            break block11;
                        }
                    }
                    int n8 = this.bufferStackPos;
                    this.bufferPos[n8] = this.bufferPos[n8] - 1;
                    return encounteredMultiLineComment;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        return encounteredMultiLineComment;
    }

    protected int indexOfNextNonWhiteSpace(char[] buffer, int start, int limit) {
        if (start < 0 || start >= buffer.length || limit > buffer.length) {
            return -1;
        }
        int pos = start + 1;
        block8: while (pos < limit) {
            block0 : switch (buffer[pos++]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    if (pos >= limit) continue block8;
                    if (buffer[pos] == '/') {
                        while (++pos < limit) {
                            switch (buffer[pos]) {
                                case '\\': {
                                    ++pos;
                                    break;
                                }
                            }
                        }
                        continue block8;
                    }
                    if (buffer[pos] != '*') continue block8;
                    while (++pos < limit) {
                        if (buffer[pos] != '*' || pos + 1 >= limit || buffer[pos + 1] != '/') continue;
                        pos += 2;
                        break block0;
                    }
                    continue block8;
                }
                case '\\': {
                    if (pos < limit && (buffer[pos] == '\n' || buffer[pos] == '\r')) {
                        ++pos;
                        break;
                    }
                }
                default: {
                    return --pos;
                }
            }
        }
        return pos;
    }

    protected void skipOverNonWhiteSpace() {
        this.skipOverNonWhiteSpace(false);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean skipOverNonWhiteSpace(boolean stopAtPound) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (true) ** GOTO lbl83
        do {
            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    v0 = this.bufferStackPos;
                    this.bufferPos[v0] = this.bufferPos[v0] - 1;
                    return true;
                }
                case '/': {
                    pos = this.bufferPos[this.bufferStackPos];
                    if ((pos + 1 >= limit || buffer[pos + 1] != '/') && buffer[pos + 1] != '*') break;
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] - 1;
                    return true;
                }
                case '\\': {
                    pos = this.bufferPos[this.bufferStackPos];
                    if (pos + 1 < limit && buffer[pos + 1] == '\n') {
                        v2 = this.bufferStackPos;
                        this.bufferPos[v2] = this.bufferPos[v2] - 1;
                        return true;
                    }
                    if (pos + 1 >= limit || buffer[pos + 1] != '\r' || pos + 2 >= limit || buffer[pos + 2] != '\n') break;
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] + 2;
                    break;
                }
                case '\"': {
                    escaped = false;
                    if (this.bufferPos[this.bufferStackPos] - 1 <= 0 || buffer[this.bufferPos[this.bufferStackPos] - 1] != '\\') ** GOTO lbl49
                    escaped = true;
                    if (true) ** GOTO lbl49
                    block19: do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case '\\': {
                                escaped = escaped == false;
                                break;
                            }
                            case '\"': {
                                if (!escaped) break block19;
                                escaped = false;
                                break;
                            }
                            case '\n': {
                                if (!escaped) break block19;
                            }
                            case '/': {
                                if (escaped && this.bufferPos[this.bufferStackPos] + 1 < limit && (buffer[this.bufferPos[this.bufferStackPos] + 1] == '/' || buffer[this.bufferPos[this.bufferStackPos] + 1] == '*')) {
                                    v4 = this.bufferStackPos;
                                    this.bufferPos[v4] = this.bufferPos[v4] - 1;
                                    return true;
                                }
                            }
                            default: {
                                escaped = false;
                            }
                        }
lbl49:
                        // 5 sources

                        v5 = this.bufferStackPos;
                    } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < this.bufferLimit[this.bufferStackPos]);
                    if (this.bufferPos[this.bufferStackPos] != this.bufferLimit[this.bufferStackPos]) break;
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] - 1;
                    break;
                }
                case '\'': {
                    escaped = false;
                    if (true) ** GOTO lbl69
                    block20: do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case '\\': {
                                escaped = escaped == false;
                                break;
                            }
                            case '\'': {
                                if (!escaped) break block20;
                                escaped = false;
                                break;
                            }
                            default: {
                                escaped = false;
                            }
                        }
lbl69:
                        // 4 sources

                        v7 = this.bufferStackPos;
                    } while ((this.bufferPos[v7] = this.bufferPos[v7] + 1) < this.bufferLimit[this.bufferStackPos]);
                    if (this.bufferPos[this.bufferStackPos] != this.bufferLimit[this.bufferStackPos]) break;
                    v8 = this.bufferStackPos;
                    this.bufferPos[v8] = this.bufferPos[v8] - 1;
                    break;
                }
                case '#': {
                    if (!stopAtPound) break;
                    if (this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '#') {
                        v9 = this.bufferStackPos;
                        this.bufferPos[v9] = this.bufferPos[v9] - 1;
                        return false;
                    }
                    v10 = this.bufferStackPos;
                    this.bufferPos[v10] = this.bufferPos[v10] + 1;
                }
            }
lbl83:
            // 11 sources

            v11 = this.bufferStackPos;
        } while ((this.bufferPos[v11] = this.bufferPos[v11] + 1) < limit);
        v12 = this.bufferStackPos;
        this.bufferPos[v12] = this.bufferPos[v12] - 1;
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected int skipOverMacroArg() {
        int argEnd;
        block21: {
            int n;
            int nesting;
            int limit;
            char[] buffer;
            block20: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                int n2 = this.bufferStackPos;
                int n3 = this.bufferPos[n2];
                this.bufferPos[n2] = n3 - 1;
                argEnd = n3;
                nesting = 0;
                if (!true) break block20;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block21;
            }
            do {
                block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                    case '(': {
                        ++nesting;
                        break;
                    }
                    case ')': {
                        if (nesting == 0) {
                            int n4 = this.bufferStackPos;
                            this.bufferPos[n4] = this.bufferPos[n4] - 1;
                            return argEnd;
                        }
                        --nesting;
                        break;
                    }
                    case ',': {
                        if (nesting != 0) break;
                        int n5 = this.bufferStackPos;
                        this.bufferPos[n5] = this.bufferPos[n5] - 1;
                        return argEnd;
                    }
                    case '\'': {
                        boolean escapedChar = false;
                        while (true) {
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            if (this.bufferPos[n6] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escapedChar = !escapedChar;
                                    break;
                                }
                                case '\'': {
                                    if (!escapedChar) break block0;
                                    escapedChar = false;
                                    break;
                                }
                                default: {
                                    escapedChar = false;
                                    break;
                                }
                            }
                        }
                    }
                    case '\"': {
                        boolean escaped = false;
                        while (true) {
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            if (this.bufferPos[n7] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escaped = !escaped;
                                    break;
                                }
                                case '\"': {
                                    if (!escaped) break block0;
                                    escaped = false;
                                    break;
                                }
                                default: {
                                    escaped = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                argEnd = this.bufferPos[this.bufferStackPos];
                this.skipOverWhiteSpace();
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        return argEnd;
    }

    /*
     * Unable to fully structure code
     */
    protected void skipOverIdentifier() {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (true) ** GOTO lbl34
        do {
            block8: {
                if ((c = buffer[this.bufferPos[this.bufferStackPos]]) != '.' || this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '.' || this.bufferPos[this.bufferStackPos] + 2 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 2] != '.') break block8;
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 2;
                end = this.bufferPos[this.bufferStackPos];
                if (true) ** GOTO lbl29
                do {
                    if ((c2 = buffer[this.bufferPos[this.bufferStackPos]]) == ')') {
                        this.bufferPos[this.bufferStackPos] = end;
                        return;
                    }
                    switch (c2) {
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case '\\': {
                            if (this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                                v1 = this.bufferStackPos;
                                this.bufferPos[v1] = this.bufferPos[v1] + 1;
                                break;
                            }
                            if (this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\r' || this.bufferPos[this.bufferStackPos] + 2 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 2] != '\n') break;
                            v2 = this.bufferStackPos;
                            this.bufferPos[v2] = this.bufferPos[v2] + 2;
                            break;
                        }
                        default: {
                            this.handleProblem(0x200000C, this.bufferPos[this.bufferStackPos], String.valueOf(c2).toCharArray());
                            return;
                        }
                    }
lbl29:
                    // 5 sources

                    v3 = this.bufferStackPos;
                } while ((this.bufferPos[v3] = this.bufferPos[v3] + 1) < limit);
                break;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') && !Character.isUnicodeIdentifierPart(c)) break;
lbl34:
            // 2 sources

            v4 = this.bufferStackPos;
        } while ((this.bufferPos[v4] = this.bufferPos[v4] + 1) < limit);
        v5 = this.bufferStackPos;
        this.bufferPos[v5] = this.bufferPos[v5] - 1;
    }

    protected void skipToNewLine() {
        this.skipToNewLine(false);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected void skipToNewLine(boolean insideComment) {
        block12: {
            int n;
            boolean escaped;
            int pos;
            int limit;
            char[] buffer;
            block11: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                int n2 = this.bufferStackPos;
                this.bufferPos[n2] = this.bufferPos[n2] + 1;
                pos = this.bufferPos[n2];
                if (pos < limit && buffer[pos] == '\n' || pos + 1 < limit && buffer[pos] == '\r' && buffer[pos + 1] == '\n') {
                    return;
                }
                escaped = false;
                if (!true) break block11;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block12;
            }
            do {
                block13: {
                    block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                        case '/': {
                            if (insideComment || (pos = this.bufferPos[this.bufferStackPos]) + 1 >= limit || buffer[pos + 1] != '*') break;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 1;
                            do {
                                int n4 = this.bufferStackPos;
                                this.bufferPos[n4] = this.bufferPos[n4] + 1;
                                if (this.bufferPos[n4] >= limit) break block0;
                            } while (buffer[pos = this.bufferPos[this.bufferStackPos]] != '*' || pos + 1 >= limit || buffer[pos + 1] != '/');
                            int n5 = this.bufferStackPos;
                            this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            break;
                        }
                        case '\\': {
                            escaped = !escaped;
                            break block13;
                        }
                        case '\n': {
                            if (!escaped) {
                                return;
                            }
                            escaped = false;
                            break;
                        }
                        case '\r': {
                            if (escaped && this.bufferPos[this.bufferStackPos] < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                                escaped = false;
                                int n6 = this.bufferStackPos;
                                this.bufferPos[n6] = this.bufferPos[n6] + 1;
                                break;
                            }
                            if (escaped || this.bufferPos[this.bufferStackPos] >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') break;
                            return;
                        }
                    }
                    escaped = false;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected char[] handleFunctionStyleMacro(FunctionStyleMacro macro, boolean pushContext) {
        char[] buffer = this.bufferStack[this.bufferStackPos];
        int limit = this.bufferLimit[this.bufferStackPos];
        int start = this.bufferPos[this.bufferStackPos] - macro.name.length + 1;
        this.skipOverWhiteSpace();
        while (this.bufferPos[this.bufferStackPos] < limit && buffer[this.bufferPos[this.bufferStackPos]] == '\\' && this.bufferPos[this.bufferStackPos] + 1 < buffer.length && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 2;
            this.skipOverWhiteSpace();
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] + 1;
        if (this.bufferPos[n] >= limit) {
            if (!pushContext) {
                int n2 = this.bufferStackPos;
                this.bufferPos[n2] = this.bufferPos[n2] - 1;
                return null;
            }
            int idx = -1;
            int stackpPos = this.bufferStackPos;
            while (this.bufferData[stackpPos] != null && this.bufferData[stackpPos] instanceof MacroData) {
                if (--stackpPos < 0) {
                    return EMPTY_CHAR_ARRAY;
                }
                idx = this.indexOfNextNonWhiteSpace(this.bufferStack[stackpPos], this.bufferPos[stackpPos], this.bufferLimit[stackpPos]);
                if (idx >= this.bufferLimit[stackpPos]) continue;
                if (idx > 0 && this.bufferStack[stackpPos][idx] == '(') break;
                int n3 = this.bufferStackPos;
                this.bufferPos[n3] = this.bufferPos[n3] - 1;
                return null;
            }
            if (idx == -1) {
                int n4 = this.bufferStackPos;
                this.bufferPos[n4] = this.bufferPos[n4] - 1;
                return null;
            }
            MacroData data = (MacroData)this.bufferData[stackpPos + 1];
            int i = this.bufferStackPos;
            while (i > stackpPos) {
                this.popContext();
                --i;
            }
            this.bufferPos[this.bufferStackPos] = idx;
            buffer = this.bufferStack[this.bufferStackPos];
            limit = this.bufferLimit[this.bufferStackPos];
            start = data.startOffset;
        }
        while (this.bufferPos[this.bufferStackPos] + 1 < limit && (buffer[this.bufferPos[this.bufferStackPos]] == '\n' || buffer[this.bufferPos[this.bufferStackPos]] == '\r')) {
            int n5 = this.bufferStackPos;
            this.bufferPos[n5] = this.bufferPos[n5] + 1;
            this.skipOverWhiteSpace();
            if (this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos]] == '(' || buffer[this.bufferPos[this.bufferStackPos] + 1] != '(') continue;
            int n6 = this.bufferStackPos;
            this.bufferPos[n6] = this.bufferPos[n6] + 1;
        }
        if (buffer[this.bufferPos[this.bufferStackPos]] != '(') {
            int n7 = this.bufferStackPos;
            this.bufferPos[n7] = this.bufferPos[n7] - 1;
            return null;
        }
        char[][] arglist = macro.arglist;
        int currarg = -1;
        CharArrayObjectMap argmap = new CharArrayObjectMap(arglist.length);
        boolean insideString = false;
        while (this.bufferPos[this.bufferStackPos] < limit) {
            this.skipOverWhiteSpace();
            if (this.bufferPos[this.bufferStackPos] + 1 >= limit) break;
            int n8 = this.bufferStackPos;
            this.bufferPos[n8] = this.bufferPos[n8] + 1;
            if (buffer[this.bufferPos[n8]] == ')') break;
            if (buffer[this.bufferPos[this.bufferStackPos]] == ',') continue;
            if (!(++currarg < arglist.length && arglist[currarg] != null || macro.hasVarArgs() || macro.hasGCCVarArgs())) {
                this.handleProblem(0x2000009, this.bufferPos[this.bufferStackPos], macro.name);
                break;
            }
            int argstart = this.bufferPos[this.bufferStackPos];
            int argend = -1;
            if (!macro.hasGCCVarArgs() && !macro.hasVarArgs() || currarg != macro.getVarArgsPosition()) {
                argend = this.skipOverMacroArg();
            } else {
                int n9;
                int n10 = this.bufferStackPos;
                this.bufferPos[n10] = this.bufferPos[n10] - 1;
                do {
                    if (buffer[this.bufferPos[this.bufferStackPos]] == '\"') {
                        insideString = !insideString;
                    }
                    if (!insideString && buffer[this.bufferPos[this.bufferStackPos]] == ')') {
                        int n11 = this.bufferStackPos;
                        this.bufferPos[n11] = this.bufferPos[n11] - 1;
                        break;
                    }
                    n9 = this.bufferStackPos;
                } while ((this.bufferPos[n9] = this.bufferPos[n9] + 1) < limit);
                argend = this.bufferPos[this.bufferStackPos];
            }
            char[] arg = EMPTY_CHAR_ARRAY;
            int arglen = argend - argstart + 1;
            if (arglen > 0) {
                arg = new char[arglen];
                System.arraycopy(buffer, argstart, arg, 0, arglen);
            }
            argmap.put(arglist[currarg], arg);
        }
        int numRequiredArgs = arglist.length;
        int i = 0;
        while (i < arglist.length) {
            if (arglist[i] == null) {
                numRequiredArgs = i;
                break;
            }
            ++i;
        }
        if (macro.hasGCCVarArgs() || macro.hasVarArgs()) {
            --numRequiredArgs;
        }
        if (argmap.size() < numRequiredArgs) {
            this.handleProblem(0x2000009, this.bufferPos[this.bufferStackPos], macro.name);
        }
        char[] result = null;
        if (macro instanceof DynamicFunctionStyleMacro) {
            result = ((DynamicFunctionStyleMacro)macro).execute(argmap);
        } else {
            CharArrayObjectMap replacedArgs = new CharArrayObjectMap(argmap.size());
            int size = this.expandFunctionStyleMacro(macro.getExpansion(), argmap, replacedArgs, null);
            result = new char[size];
            this.expandFunctionStyleMacro(macro.getExpansion(), argmap, replacedArgs, result);
        }
        if (pushContext) {
            this.pushContext(result, new MacroData(start, this.bufferPos[this.bufferStackPos], macro));
        }
        return result;
    }

    protected char[] replaceArgumentMacros(char[] arg) {
        int limit = arg.length;
        int start = -1;
        int end = -1;
        Object expObject = null;
        int pos = 0;
        while (pos < limit) {
            char c = arg[pos];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isLetter(c) || this.support$Initializers && c == '$') {
                start = pos;
                while (++pos < limit) {
                    c = arg[pos];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || this.support$Initializers && c == '$') && !Character.isUnicodeIdentifierPart(c)) break;
                }
                end = pos - 1;
            }
            if (start != -1 && end >= start) {
                expObject = this.definitions.get(arg, start, end - start + 1);
                if (expObject != null && this.shouldExpandMacro((IMacro)expObject)) break;
                expObject = null;
                start = -1;
            }
            ++pos;
        }
        if (expObject == null) {
            return arg;
        }
        char[] expansion = null;
        if (expObject instanceof FunctionStyleMacro) {
            FunctionStyleMacro expMacro = (FunctionStyleMacro)expObject;
            this.pushContext(start == 0 ? arg : CharArrayUtils.extract(arg, start, arg.length - start));
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + (end - start + 1);
            expansion = this.handleFunctionStyleMacro(expMacro, false);
            end = this.bufferPos[this.bufferStackPos] + start;
            this.popContext();
        } else if (expObject instanceof ObjectStyleMacro) {
            ObjectStyleMacro expMacro = (ObjectStyleMacro)expObject;
            expansion = expMacro.getExpansion();
        } else if (expObject instanceof char[]) {
            expansion = (char[])expObject;
        } else if (expObject instanceof DynamicStyleMacro) {
            DynamicStyleMacro expMacro = (DynamicStyleMacro)expObject;
            expansion = expMacro.execute();
        }
        if (expansion != null) {
            int newlength = start + expansion.length + (limit - end - 1);
            char[] result = new char[newlength];
            System.arraycopy(arg, 0, result, 0, start);
            System.arraycopy(expansion, 0, result, start, expansion.length);
            if (arg.length > end + 1) {
                System.arraycopy(arg, end + 1, result, start + expansion.length, limit - end - 1);
            }
            this.beforeReplaceAllMacros();
            this.pushContext(EMPTY_CHAR_ARRAY, new MacroData(start, start + ((IMacro)expObject).getName().length, (IMacro)expObject));
            arg = this.replaceArgumentMacros(result);
            this.popContext();
            this.afterReplaceAllMacros();
        }
        return arg;
    }

    protected void afterReplaceAllMacros() {
    }

    protected void beforeReplaceAllMacros() {
    }

    protected int expandFunctionStyleMacro(char[] expansion, CharArrayObjectMap argmap, CharArrayObjectMap replacedArgs, char[] result) {
        int pos = -1;
        int lastcopy = -1;
        int outpos = 0;
        int wsstart = -1;
        boolean prevConcat = false;
        char[] prevArg = null;
        int prevArgStart = -1;
        int prevArgLength = -1;
        int prevArgTarget = -1;
        int limit = expansion.length;
        block8: while (++pos < limit) {
            int n;
            boolean escaped;
            int idstart;
            char c = expansion[pos];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c < '9' || Character.isUnicodeIdentifierPart(c)) {
                boolean nextIsPoundPound;
                wsstart = -1;
                idstart = pos;
                while (++pos < limit) {
                    c = expansion[pos];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') && !Character.isUnicodeIdentifierPart(c)) break;
                }
                char[] repObject = (char[])argmap.get(expansion, idstart, --pos - idstart + 1);
                int next = this.indexOfNextNonWhiteSpace(expansion, pos, limit);
                boolean bl = nextIsPoundPound = next + 1 < limit && expansion[next] == '#' && expansion[next + 1] == '#';
                if (prevConcat && prevArgStart > -1 && prevArgLength > 0) {
                    int l1 = prevArg != null ? prevArg.length : prevArgLength;
                    int l2 = repObject != null ? repObject.length : pos - idstart + 1;
                    char[] newRep = new char[l1 + l2];
                    if (prevArg != null) {
                        System.arraycopy(prevArg, 0, newRep, 0, l1);
                    } else {
                        System.arraycopy(expansion, prevArgStart, newRep, 0, l1);
                    }
                    if (repObject != null) {
                        System.arraycopy(repObject, 0, newRep, l1, l2);
                    } else {
                        System.arraycopy(expansion, idstart, newRep, l1, l2);
                    }
                    idstart = prevArgStart;
                    repObject = newRep;
                }
                if (repObject != null) {
                    if (++lastcopy < idstart) {
                        int n2 = idstart - lastcopy;
                        if (result != null) {
                            System.arraycopy(expansion, lastcopy, result, outpos, n2);
                        }
                        outpos += n2;
                    }
                    if (prevConcat) {
                        outpos = prevArgTarget;
                    }
                    if (!nextIsPoundPound) {
                        char[] rep = (char[])(replacedArgs != null ? replacedArgs.get(repObject) : null);
                        if (rep != null) {
                            repObject = rep;
                        } else {
                            rep = this.replaceArgumentMacros(repObject);
                            if (replacedArgs != null) {
                                replacedArgs.put(repObject, rep);
                            }
                            repObject = rep;
                        }
                        if (result != null) {
                            System.arraycopy(repObject, 0, result, outpos, repObject.length);
                        }
                    }
                    outpos += repObject.length;
                    lastcopy = pos;
                }
                prevArg = repObject;
                prevArgStart = idstart;
                prevArgLength = pos - idstart + 1;
                prevArgTarget = repObject != null ? outpos - repObject.length : outpos + idstart - lastcopy - 1;
                prevConcat = false;
                continue;
            }
            if (c == '\"') {
                wsstart = -1;
                escaped = false;
                while (++pos < limit) {
                    c = expansion[pos];
                    if (c == '\"') {
                        if (!escaped) {
                            break;
                        }
                    } else if (c == '\\') {
                        escaped = !escaped;
                    }
                    escaped = false;
                }
                prevConcat = false;
                continue;
            }
            if (c == '\'') {
                wsstart = -1;
                escaped = false;
                while (++pos < limit) {
                    c = expansion[pos];
                    if (c == '\'') {
                        if (!escaped) {
                            break;
                        }
                    } else if (c == '\\') {
                        escaped = !escaped;
                    }
                    escaped = false;
                }
                prevConcat = false;
                continue;
            }
            if (c == ' ' || c == '\t') {
                if (wsstart >= 0) continue;
                wsstart = pos;
                continue;
            }
            if (c == '/' && pos + 1 < limit) {
                if ((c = expansion[++pos]) == '/') {
                    int n3 = n = wsstart < 0 ? pos - 1 - lastcopy : wsstart - ++lastcopy;
                    if (result != null) {
                        System.arraycopy(expansion, lastcopy, result, outpos, n);
                    }
                    outpos += n;
                    lastcopy = expansion.length - 1;
                    continue;
                }
                if (c == '*') {
                    if (wsstart < 1) {
                        wsstart = pos - 1;
                    }
                    while (++pos < limit) {
                        if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                        ++pos;
                        continue block8;
                    }
                    continue;
                }
                wsstart = -1;
                continue;
            }
            if (c == '\\' && pos + 1 < limit && expansion[pos + 1] == 'n') {
                ++pos;
                continue;
            }
            if (c == '#') {
                int idlen;
                char[] argvalue;
                if (pos + 1 < limit && expansion[pos + 1] == '#') {
                    prevConcat = true;
                    ++pos;
                    if (wsstart < 0) {
                        wsstart = pos - 1;
                    }
                    block13: while (++pos < limit) {
                        block0 : switch (expansion[pos]) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '/': {
                                if (pos + 1 >= limit) break block13;
                                c = expansion[pos + 1];
                                if (c == '/') {
                                    pos = expansion.length;
                                    break block13;
                                }
                                if (c != '*') break block13;
                                ++pos;
                                while (++pos < limit) {
                                    if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                    ++pos;
                                    break block0;
                                }
                                continue block13;
                            }
                            default: {
                                break block13;
                            }
                        }
                    }
                    --pos;
                    continue;
                }
                prevConcat = false;
                if (++lastcopy < pos) {
                    n = pos - lastcopy;
                    if (result != null) {
                        System.arraycopy(expansion, lastcopy, result, outpos, n);
                    }
                    outpos += n;
                }
                block15: while (++pos < limit) {
                    block4 : switch (expansion[pos]) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '/': {
                            if (pos + 1 >= limit) break block15;
                            c = expansion[pos + 1];
                            if (c == '/') {
                                pos = expansion.length;
                                break block15;
                            }
                            if (c != '*') break block15;
                            ++pos;
                            while (++pos < limit) {
                                if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                ++pos;
                                break block4;
                            }
                            continue block15;
                        }
                        default: {
                            break block15;
                        }
                    }
                }
                c = expansion[pos];
                idstart = pos;
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'X' || c == '_' || Character.isUnicodeIdentifierPart(c)) {
                    while (++pos < limit) {
                        c = expansion[pos];
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'X' || c >= '0' && c <= '9' || c == '_') && !Character.isUnicodeIdentifierPart(c)) break;
                    }
                }
                if ((argvalue = (char[])argmap.get(expansion, idstart, idlen = --pos - idstart + 1)) != null) {
                    int i;
                    if (result != null) {
                        result[outpos++] = 34;
                        i = 0;
                        while (i < argvalue.length) {
                            if (argvalue[i] == '\"' || argvalue[i] == '\\') {
                                result[outpos++] = 92;
                            }
                            result[outpos++] = argvalue[i] == '\r' || argvalue[i] == '\n' ? 32 : argvalue[i];
                            ++i;
                        }
                        result[outpos++] = 34;
                    } else {
                        i = 0;
                        while (i < argvalue.length) {
                            if (argvalue[i] == '\"' || argvalue[i] == '\\') {
                                ++outpos;
                            }
                            ++outpos;
                            ++i;
                        }
                        outpos += 2;
                    }
                }
                lastcopy = pos;
                wsstart = -1;
                continue;
            }
            prevConcat = false;
            wsstart = -1;
        }
        if (wsstart < 0 && ++lastcopy < expansion.length) {
            int n = expansion.length - lastcopy;
            if (result != null) {
                System.arraycopy(expansion, lastcopy, result, outpos, n);
            }
            outpos += n;
        }
        return outpos;
    }

    protected void setupBuiltInMacros(IScannerExtensionConfiguration config) {
        this.definitions.put(BaseScanner.__STDC__.name, __STDC__);
        this.definitions.put(this.__FILE__.name, this.__FILE__);
        this.definitions.put(this.__DATE__.name, this.__DATE__);
        this.definitions.put(this.__TIME__.name, this.__TIME__);
        this.definitions.put(this.__LINE__.name, this.__LINE__);
        if (this.language == ParserLanguage.CPP) {
            this.definitions.put(BaseScanner.__cplusplus.name, __cplusplus);
        } else {
            this.definitions.put(BaseScanner.__STDC_HOSTED__.name, __STDC_HOSTED__);
            this.definitions.put(BaseScanner.__STDC_VERSION__.name, __STDC_VERSION__);
        }
        CharArrayObjectMap toAdd = config.getAdditionalMacros();
        int i = 0;
        while (i < toAdd.size()) {
            this.definitions.put(toAdd.keyAt(i), toAdd.getAt(i));
            ++i;
        }
    }

    public final void setOffsetBoundary(int offset) {
        this.offsetBoundary = offset;
        this.bufferLimit[0] = offset;
    }

    public void setContentAssistMode(int offset) {
        this.bufferLimit[0] = offset;
        this.contentAssistMode = true;
    }

    protected ParserLanguage getLanguage() {
        return this.language;
    }

    protected CodeReader getMainReader() {
        if (this.bufferData != null && this.bufferData[0] != null && this.bufferData[0] instanceof CodeReader) {
            return (CodeReader)this.bufferData[0];
        }
        return null;
    }

    public char[] getMainFilename() {
        if (this.bufferData != null && this.bufferData[0] != null && this.bufferData[0] instanceof CodeReader) {
            return ((CodeReader)this.bufferData[0]).filename;
        }
        return EMPTY_CHAR_ARRAY;
    }

    protected final char[] getCurrentFilename() {
        int i = this.bufferStackPos;
        while (i >= 0) {
            if (this.bufferData[i] instanceof InclusionData) {
                return ((InclusionData)this.bufferData[i]).reader.filename;
            }
            if (this.bufferData[i] instanceof CodeReader) {
                return ((CodeReader)this.bufferData[i]).filename;
            }
            --i;
        }
        return EMPTY_CHAR_ARRAY;
    }

    protected final int getCurrentFileIndex() {
        int i = this.bufferStackPos;
        while (i >= 0) {
            if (this.bufferData[i] instanceof InclusionData || this.bufferData[i] instanceof CodeReader) {
                return i;
            }
            --i;
        }
        return 0;
    }

    protected void handleCompletionOnDefinition(String definition) throws EndOfFileException {
        ASTCompletionNode node = new ASTCompletionNode(IASTCompletionNode.CompletionKind.MACRO_REFERENCE, null, null, definition, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null);
        throw new OffsetLimitReachedException(node);
    }

    protected void handleCompletionOnExpression(char[] buffer) throws EndOfFileException {
        int lastTab;
        IASTCompletionNode.CompletionKind kind = IASTCompletionNode.CompletionKind.MACRO_REFERENCE;
        int lastSpace = CharArrayUtils.lastIndexOf(SPACE, buffer);
        int max = lastSpace > (lastTab = CharArrayUtils.lastIndexOf(TAB, buffer)) ? lastSpace : lastTab;
        char[] prefix = CharArrayUtils.trim(CharArrayUtils.extract(buffer, max, buffer.length - max));
        int i = 0;
        while (i < prefix.length) {
            char c = prefix[i];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c))) {
                this.handleInvalidCompletion();
            }
            ++i;
        }
        ASTCompletionNode node = new ASTCompletionNode(kind, null, null, new String(prefix), KeywordSets.getKeywords(kind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND ? KeywordSetKey.EMPTY : KeywordSetKey.MACRO, this.language), EMPTY_STRING, null);
        throw new OffsetLimitReachedException(node);
    }

    protected void handleNoSuchCompletion() throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.NO_SUCH_KIND, null, null, EMPTY_STRING, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null));
    }

    protected void handleInvalidCompletion() throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.UNREACHABLE_CODE, null, null, EMPTY_STRING, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null));
    }

    protected void handleCompletionOnPreprocessorDirective(String prefix) throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.PREPROCESSOR_DIRECTIVE, null, null, prefix, KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, this.language), EMPTY_STRING, null));
    }

    protected int getCurrentOffset() {
        return this.bufferPos[this.bufferStackPos];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Scanner @ file:");
        buffer.append(this.getCurrentFilename());
        buffer.append(" line: ");
        buffer.append(this.getLineNumber(this.getCurrentOffset()));
        return buffer.toString();
    }

    protected abstract IToken newToken(int var1);

    protected abstract IToken newToken(int var1, char[] var2);

    protected static class InclusionData {
        public final Object inclusion;
        public final CodeReader reader;

        public InclusionData(CodeReader reader, Object inclusion) {
            this.reader = reader;
            this.inclusion = inclusion;
        }

        public String toString() {
            return this.reader.toString();
        }
    }

    protected static class MacroData {
        public final int startOffset;
        public final int endOffset;
        public final IMacro macro;

        public MacroData(int start, int end, IMacro macro) {
            this.startOffset = start;
            this.endOffset = end;
            this.macro = macro;
        }

        public String toString() {
            return this.macro.toString();
        }
    }

    protected static class ExpressionEvaluator {
        private static char[] emptyCharArray = new char[0];
        private static final int initSize = 8;
        private int bufferStackPos = -1;
        private char[][] bufferStack = new char[8][];
        private Object[] bufferData = new Object[8];
        private int[] bufferPos = new int[8];
        private int[] bufferLimit = new int[8];
        private ScannerCallbackManager callbackManager = null;
        private ScannerProblemFactory problemFactory = null;
        private int lineNumber = 1;
        private char[] fileName = null;
        private int pos = 0;
        CharArrayObjectMap definitions;
        int tokenType = 0;
        long tokenValue;
        private static char[] _defined = "defined".toCharArray();
        private static final int tNULL = 0;
        private static final int tEOF = 1;
        private static final int tNUMBER = 2;
        private static final int tLPAREN = 3;
        private static final int tRPAREN = 4;
        private static final int tNOT = 5;
        private static final int tCOMPL = 6;
        private static final int tMULT = 7;
        private static final int tDIV = 8;
        private static final int tMOD = 9;
        private static final int tPLUS = 10;
        private static final int tMINUS = 11;
        private static final int tSHIFTL = 12;
        private static final int tSHIFTR = 13;
        private static final int tLT = 14;
        private static final int tGT = 15;
        private static final int tLTEQUAL = 16;
        private static final int tGTEQUAL = 17;
        private static final int tEQUAL = 18;
        private static final int tNOTEQUAL = 19;
        private static final int tBITAND = 20;
        private static final int tBITXOR = 21;
        private static final int tBITOR = 22;
        private static final int tAND = 23;
        private static final int tOR = 24;
        private static final int tQUESTION = 25;
        private static final int tCOLON = 26;
        private static final int t_defined = 27;
        private static final int tCHAR = 28;

        public ExpressionEvaluator() {
        }

        public ExpressionEvaluator(ScannerCallbackManager manager, ScannerProblemFactory spf) {
            this.callbackManager = manager;
            this.problemFactory = spf;
        }

        public long evaluate(char[] buffer, int p, int length, CharArrayObjectMap defs) {
            return this.evaluate(buffer, p, length, defs, 0, BaseScanner.EMPTY_STRING.toCharArray());
        }

        public long evaluate(char[] buffer, int p, int length, CharArrayObjectMap defs, int ln, char[] fn) {
            this.lineNumber = ln;
            this.fileName = fn;
            this.bufferStack[++this.bufferStackPos] = buffer;
            this.bufferPos[this.bufferStackPos] = p - 1;
            this.bufferLimit[this.bufferStackPos] = p + length;
            this.definitions = defs;
            this.tokenType = 0;
            long r = 0L;
            try {
                r = this.expression();
            }
            catch (EvalException evalException) {}
            while (this.bufferStackPos >= 0) {
                this.popContext();
            }
            return r;
        }

        private long expression() throws EvalException {
            return this.conditionalExpression();
        }

        private long conditionalExpression() throws EvalException {
            long r1 = this.logicalOrExpression();
            if (this.LA() == 25) {
                this.consume();
                long r2 = this.expression();
                if (this.LA() != 26) {
                    this.handleProblem(0x100000E, this.pos);
                    throw new EvalException("bad conditional expression");
                }
                this.consume();
                long r3 = this.conditionalExpression();
                return r1 != 0L ? r2 : r3;
            }
            return r1;
        }

        private long logicalOrExpression() throws EvalException {
            long r1 = this.logicalAndExpression();
            while (this.LA() == 24) {
                this.consume();
                long r2 = this.logicalAndExpression();
                r1 = r1 != 0L || r2 != 0L ? 1 : 0;
            }
            return r1;
        }

        private long logicalAndExpression() throws EvalException {
            long r1 = this.inclusiveOrExpression();
            while (this.LA() == 23) {
                this.consume();
                long r2 = this.inclusiveOrExpression();
                r1 = r1 != 0L && r2 != 0L ? 1 : 0;
            }
            return r1;
        }

        private long inclusiveOrExpression() throws EvalException {
            long r1 = this.exclusiveOrExpression();
            while (this.LA() == 22) {
                this.consume();
                long r2 = this.exclusiveOrExpression();
                r1 |= r2;
            }
            return r1;
        }

        private long exclusiveOrExpression() throws EvalException {
            long r1 = this.andExpression();
            while (this.LA() == 21) {
                this.consume();
                long r2 = this.andExpression();
                r1 ^= r2;
            }
            return r1;
        }

        private long andExpression() throws EvalException {
            long r1 = this.equalityExpression();
            while (this.LA() == 20) {
                this.consume();
                long r2 = this.equalityExpression();
                r1 &= r2;
            }
            return r1;
        }

        private long equalityExpression() throws EvalException {
            long r1 = this.relationalExpression();
            int t = this.LA();
            while (t == 18 || t == 19) {
                this.consume();
                long r2 = this.relationalExpression();
                r1 = t == 18 ? (long)(r1 == r2 ? 1 : 0) : (long)(r1 != r2 ? 1 : 0);
                t = this.LA();
            }
            return r1;
        }

        private long relationalExpression() throws EvalException {
            long r1 = this.shiftExpression();
            int t = this.LA();
            while (t == 14 || t == 16 || t == 15 || t == 17) {
                this.consume();
                long r2 = this.shiftExpression();
                switch (t) {
                    case 14: {
                        r1 = r1 < r2 ? 1 : 0;
                        break;
                    }
                    case 16: {
                        r1 = r1 <= r2 ? 1 : 0;
                        break;
                    }
                    case 15: {
                        r1 = r1 > r2 ? 1 : 0;
                        break;
                    }
                    case 17: {
                        r1 = r1 >= r2 ? 1 : 0;
                    }
                }
                t = this.LA();
            }
            return r1;
        }

        private long shiftExpression() throws EvalException {
            long r1 = this.additiveExpression();
            int t = this.LA();
            while (t == 12 || t == 13) {
                this.consume();
                long r2 = this.additiveExpression();
                r1 = t == 12 ? (r1 <<= (int)r2) : (r1 >>= (int)r2);
                t = this.LA();
            }
            return r1;
        }

        private long additiveExpression() throws EvalException {
            long r1 = this.multiplicativeExpression();
            int t = this.LA();
            while (t == 10 || t == 11) {
                this.consume();
                long r2 = this.multiplicativeExpression();
                r1 = t == 10 ? (r1 += r2) : (r1 -= r2);
                t = this.LA();
            }
            return r1;
        }

        private long multiplicativeExpression() throws EvalException {
            long r1 = this.unaryExpression();
            int t = this.LA();
            while (t == 7 || t == 8) {
                int position = this.pos;
                this.consume();
                long r2 = this.unaryExpression();
                if (t == 7) {
                    r1 *= r2;
                } else if (r2 != 0L) {
                    r1 /= r2;
                } else {
                    this.handleProblem(0x100000A, position);
                    throw new EvalException("Divide by 0 encountered");
                }
                t = this.LA();
            }
            return r1;
        }

        private long unaryExpression() throws EvalException {
            switch (this.LA()) {
                case 10: {
                    this.consume();
                    return this.unaryExpression();
                }
                case 11: {
                    this.consume();
                    return -this.unaryExpression();
                }
                case 5: {
                    this.consume();
                    return this.unaryExpression() == 0L ? 1 : 0;
                }
                case 6: {
                    this.consume();
                    return this.unaryExpression() ^ 0xFFFFFFFFFFFFFFFFL;
                }
                case 2: {
                    return this.consume();
                }
                case 27: {
                    return this.handleDefined();
                }
                case 3: {
                    this.consume();
                    long r1 = this.expression();
                    if (this.LA() == 4) {
                        this.consume();
                        return r1;
                    }
                    this.handleProblem(0x100000B, this.pos);
                    throw new EvalException("missing )");
                }
                case 28: {
                    return this.getChar();
                }
            }
            this.handleProblem(0x100000C, this.pos);
            throw new EvalException("expression syntax error");
        }

        /*
         * Unable to fully structure code
         */
        private long handleDefined() throws EvalException {
            this.skipWhiteSpace();
            buffer = this.bufferStack[this.bufferStackPos];
            limit = this.bufferLimit[this.bufferStackPos];
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            if (this.bufferPos[v0] >= limit) {
                return 0L;
            }
            c = buffer[this.bufferPos[this.bufferStackPos]];
            inParens = false;
            if (c == '(') {
                inParens = true;
                this.skipWhiteSpace();
                v1 = this.bufferStackPos;
                this.bufferPos[v1] = this.bufferPos[v1] + 1;
                if (this.bufferPos[v1] >= limit) {
                    return 0L;
                }
                c = buffer[this.bufferPos[this.bufferStackPos]];
            }
            if (!(c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z')) {
                this.handleProblem(0x100000D, this.pos);
                throw new EvalException("illegal identifier in defined()");
            }
            idstart = this.bufferPos[this.bufferStackPos];
            idlen = 1;
            ** GOTO lbl26
            while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                ++idlen;
lbl26:
                // 2 sources

                v2 = this.bufferStackPos;
                this.bufferPos[v2] = this.bufferPos[v2] + 1;
                if (this.bufferPos[v2] < limit) continue;
            }
            v3 = this.bufferStackPos;
            this.bufferPos[v3] = this.bufferPos[v3] - 1;
            if (inParens) {
                this.skipWhiteSpace();
                v4 = this.bufferStackPos;
                this.bufferPos[v4] = this.bufferPos[v4] + 1;
                if (this.bufferPos[v4] <= limit && buffer[this.bufferPos[this.bufferStackPos]] != ')') {
                    this.handleProblem(0x100000B, this.pos);
                    throw new EvalException("missing ) on defined");
                }
            }
            this.nextToken();
            return this.definitions.get(buffer, idstart, idlen) != null ? 1 : 0;
        }

        private int LA() throws EvalException {
            if (this.tokenType == 0) {
                this.nextToken();
            }
            return this.tokenType;
        }

        private long consume() throws EvalException {
            long value = this.tokenValue;
            if (this.tokenType != 1) {
                this.nextToken();
            }
            return value;
        }

        private long getChar() throws EvalException {
            long value = 0L;
            if (this.bufferPos[this.bufferStackPos] - 1 >= 0 && this.bufferPos[this.bufferStackPos] + 1 < this.bufferStack[this.bufferStackPos].length && this.bufferStack[this.bufferStackPos][this.bufferPos[this.bufferStackPos] - 1] == '\'' && this.bufferStack[this.bufferStackPos][this.bufferPos[this.bufferStackPos] + 1] == '\'') {
                value = this.bufferStack[this.bufferStackPos][this.bufferPos[this.bufferStackPos]];
            }
            if (this.tokenType != 1) {
                this.nextToken();
            }
            return value;
        }

        /*
         * Unable to fully structure code
         */
        private void nextToken() throws EvalException {
            isHex = false;
            isOctal = false;
            isDecimal = false;
            block21: while (this.bufferStackPos >= 0) {
                this.skipWhiteSpace();
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                if (this.bufferPos[v0] >= this.bufferLimit[this.bufferStackPos]) {
                    this.popContext();
                    continue;
                }
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                this.pos = this.bufferPos[this.bufferStackPos];
                if (buffer[this.pos] >= '1' && buffer[this.pos] <= '9') {
                    isDecimal = true;
                } else if (buffer[this.pos] == '0' && this.pos + 1 < limit) {
                    if (buffer[this.pos + 1] == 'x' || buffer[this.pos + 1] == 'X') {
                        isHex = true;
                        v1 = this.bufferStackPos;
                        this.bufferPos[v1] = this.bufferPos[v1] + 1;
                        if (!(this.pos + 2 >= limit || buffer[this.pos + 2] >= '0' && buffer[this.pos + 2] <= '9' || buffer[this.pos + 2] >= 'a' && buffer[this.pos + 2] <= 'f' || buffer[this.pos + 2] >= 'A' && buffer[this.pos + 2] <= 'F')) {
                            this.handleProblem(0x1000005, this.pos);
                        }
                    } else {
                        isOctal = true;
                    }
                }
                switch (buffer[this.pos]) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        start = this.bufferPos[this.bufferStackPos];
                        len = 1;
                        ** GOTO lbl33
                        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') {
                            ++len;
lbl33:
                            // 2 sources

                            v2 = this.bufferStackPos;
                            this.bufferPos[v2] = this.bufferPos[v2] + 1;
                            if (this.bufferPos[v2] < limit) continue;
                        }
                        v3 = this.bufferStackPos;
                        this.bufferPos[v3] = this.bufferPos[v3] - 1;
                        this.pos = this.bufferPos[this.bufferStackPos];
                        if (CharArrayUtils.equals(buffer, start, len, ExpressionEvaluator._defined)) {
                            this.tokenType = 27;
                            return;
                        }
                        expObject = null;
                        if (this.bufferData[this.bufferStackPos] instanceof FunctionStyleMacro.Expansion) {
                            expObject = ((FunctionStyleMacro.Expansion)this.bufferData[this.bufferStackPos]).definitions.get(buffer, start, len);
                        }
                        if (expObject == null) {
                            expObject = this.definitions.get(buffer, start, len);
                        }
                        if (expObject != null) {
                            if (expObject instanceof FunctionStyleMacro) {
                                this.handleFunctionStyleMacro((FunctionStyleMacro)expObject);
                                break;
                            }
                            if (expObject instanceof ObjectStyleMacro) {
                                expMacro = (ObjectStyleMacro)expObject;
                                expText = expMacro.getExpansion();
                                if (expText.length <= 0) break;
                                if (BaseScanner.shouldExpandMacro(expMacro, this.bufferStackPos, this.bufferData, -1, this.bufferPos, this.bufferStack)) {
                                    this.pushContext(expText, new MacroData(start, start + len, expMacro));
                                    break;
                                }
                                if (len == 1) {
                                    this.tokenType = 28;
                                    return;
                                }
                                this.tokenValue = 0L;
                                this.tokenType = 2;
                                return;
                            }
                            if (!(expObject instanceof char[]) || (expText = (char[])expObject).length <= 0) continue block21;
                            this.pushContext(expText, null);
                            break;
                        }
                        if (len == 1) {
                            this.tokenType = 28;
                            return;
                        }
                        this.tokenValue = 0L;
                        this.tokenType = 2;
                        return;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.tokenValue = buffer[this.pos] - 48;
                        this.tokenType = 2;
                        if (true) ** GOTO lbl114
                        do {
                            c = buffer[this.bufferPos[this.bufferStackPos]];
                            if (!isHex) ** GOTO lbl95
                            if (c < '0' || c > '9') ** GOTO lbl84
                            this.tokenValue *= 16L;
                            this.tokenValue += (long)(c - 48);
                            ** GOTO lbl114
lbl84:
                            // 1 sources

                            if (c < 'a' || c > 'f') ** GOTO lbl88
                            this.tokenValue = this.tokenValue == 0L ? 10L : this.tokenValue * 16L + 10L;
                            this.tokenValue += (long)(c - 97);
                            ** GOTO lbl114
lbl88:
                            // 1 sources

                            if (c < 'A' || c > 'F') ** GOTO lbl92
                            this.tokenValue = this.tokenValue == 0L ? 10L : this.tokenValue * 16L + 10L;
                            this.tokenValue += (long)(c - 65);
                            ** GOTO lbl114
lbl92:
                            // 1 sources

                            if (this.bufferPos[this.bufferStackPos] + 1 < limit && !this.isValidTokenSeparator(c, buffer[this.bufferPos[this.bufferStackPos] + 1])) {
                                this.handleProblem(0x1000005, this.pos);
                            }
                            ** GOTO lbl110
lbl95:
                            // 1 sources

                            if (!isOctal) ** GOTO lbl103
                            if (c < '0' || c > '7') ** GOTO lbl100
                            this.tokenValue *= 8L;
                            this.tokenValue += (long)(c - 48);
                            ** GOTO lbl114
lbl100:
                            // 1 sources

                            if (this.bufferPos[this.bufferStackPos] + 1 < limit && !this.isValidTokenSeparator(c, buffer[this.bufferPos[this.bufferStackPos] + 1])) {
                                this.handleProblem(0x1000007, this.pos);
                            }
                            ** GOTO lbl110
lbl103:
                            // 1 sources

                            if (!isDecimal) ** GOTO lbl110
                            if (c >= '0' && c <= '9') {
                                this.tokenValue *= 10L;
                                this.tokenValue += (long)(c - 48);
                            } else {
                                if (this.bufferPos[this.bufferStackPos] + 1 < limit && c != 'L' && c != 'l' && c != 'U' && c != 'u' && !this.isValidTokenSeparator(c, buffer[this.bufferPos[this.bufferStackPos] + 1])) {
                                    this.handleProblem(0x1000008, this.pos);
                                }
lbl110:
                                // 6 sources

                                if (c != 'L' && c != 'l' && c != 'U' && c != 'u') break;
                                v4 = this.bufferStackPos;
                                this.bufferPos[v4] = this.bufferPos[v4] + 1;
                                break;
                            }
lbl114:
                            // 6 sources

                            v5 = this.bufferStackPos;
                        } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
                        v6 = this.bufferStackPos;
                        this.bufferPos[v6] = this.bufferPos[v6] - 1;
                        return;
                    }
                    case '(': {
                        this.tokenType = 3;
                        return;
                    }
                    case ')': {
                        this.tokenType = 4;
                        return;
                    }
                    case ':': {
                        this.tokenType = 26;
                        return;
                    }
                    case '?': {
                        this.tokenType = 25;
                        return;
                    }
                    case '+': {
                        this.tokenType = 10;
                        return;
                    }
                    case '-': {
                        this.tokenType = 11;
                        return;
                    }
                    case '*': {
                        this.tokenType = 7;
                        return;
                    }
                    case '/': {
                        this.tokenType = 8;
                        return;
                    }
                    case '%': {
                        this.tokenType = 9;
                        return;
                    }
                    case '^': {
                        this.tokenType = 21;
                        return;
                    }
                    case '&': {
                        if (this.pos + 1 < limit && buffer[this.pos + 1] == '&') {
                            v7 = this.bufferStackPos;
                            this.bufferPos[v7] = this.bufferPos[v7] + 1;
                            this.tokenType = 23;
                            return;
                        }
                        this.tokenType = 20;
                        return;
                    }
                    case '|': {
                        if (this.pos + 1 < limit && buffer[this.pos + 1] == '|') {
                            v8 = this.bufferStackPos;
                            this.bufferPos[v8] = this.bufferPos[v8] + 1;
                            this.tokenType = 24;
                            return;
                        }
                        this.tokenType = 22;
                        return;
                    }
                    case '~': {
                        this.tokenType = 6;
                        return;
                    }
                    case '!': {
                        if (this.pos + 1 < limit && buffer[this.pos + 1] == '=') {
                            v9 = this.bufferStackPos;
                            this.bufferPos[v9] = this.bufferPos[v9] + 1;
                            this.tokenType = 19;
                            return;
                        }
                        this.tokenType = 5;
                        return;
                    }
                    case '=': {
                        if (this.pos + 1 < limit && buffer[this.pos + 1] == '=') {
                            v10 = this.bufferStackPos;
                            this.bufferPos[v10] = this.bufferPos[v10] + 1;
                            this.tokenType = 18;
                            return;
                        }
                        this.handleProblem(0x1000009, this.pos);
                        throw new EvalException("assignment not allowed");
                    }
                    case '<': {
                        if (this.pos + 1 < limit) {
                            if (buffer[this.pos + 1] == '=') {
                                v11 = this.bufferStackPos;
                                this.bufferPos[v11] = this.bufferPos[v11] + 1;
                                this.tokenType = 16;
                                return;
                            }
                            if (buffer[this.pos + 1] == '<') {
                                v12 = this.bufferStackPos;
                                this.bufferPos[v12] = this.bufferPos[v12] + 1;
                                this.tokenType = 12;
                                return;
                            }
                        }
                        this.tokenType = 14;
                        return;
                    }
                    case '>': {
                        if (this.pos + 1 < limit) {
                            if (buffer[this.pos + 1] == '=') {
                                v13 = this.bufferStackPos;
                                this.bufferPos[v13] = this.bufferPos[v13] + 1;
                                this.tokenType = 17;
                                return;
                            }
                            if (buffer[this.pos + 1] == '>') {
                                v14 = this.bufferStackPos;
                                this.bufferPos[v14] = this.bufferPos[v14] + 1;
                                this.tokenType = 13;
                                return;
                            }
                        }
                        this.tokenType = 15;
                        return;
                    }
                }
            }
            this.tokenType = 1;
        }

        private void handleFunctionStyleMacro(FunctionStyleMacro macro) {
            char[] expText;
            char[] buffer = this.bufferStack[this.bufferStackPos];
            int limit = this.bufferLimit[this.bufferStackPos];
            this.skipWhiteSpace();
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
            if (this.bufferPos[n] >= limit || buffer[this.bufferPos[this.bufferStackPos]] != '(') {
                return;
            }
            FunctionStyleMacro.Expansion exp = new FunctionStyleMacro.Expansion(macro);
            char[][] arglist = macro.arglist;
            int currarg = -1;
            int parens = 0;
            while (this.bufferPos[this.bufferStackPos] < limit) {
                if (++currarg >= arglist.length || arglist[currarg] == null) break;
                this.skipWhiteSpace();
                int n2 = this.bufferStackPos;
                int n3 = this.bufferPos[n2] + 1;
                this.bufferPos[n2] = n3;
                int p = n3;
                char c = buffer[p];
                if (c == ')') {
                    if (parens == 0) break;
                    --parens;
                    continue;
                }
                if (c == ',') {
                    exp.definitions.put(arglist[currarg], emptyCharArray);
                    continue;
                }
                if (c == '(') {
                    ++parens;
                    continue;
                }
                int argstart = p;
                int argend = argstart - 1;
                while (this.bufferPos[this.bufferStackPos] < limit) {
                    this.skipOverMacroArg();
                    argend = this.bufferPos[this.bufferStackPos];
                    this.skipWhiteSpace();
                    int n4 = this.bufferStackPos;
                    this.bufferPos[n4] = this.bufferPos[n4] + 1;
                    if (this.bufferPos[n4] >= limit || (c = buffer[this.bufferPos[this.bufferStackPos]]) == ',' || c == ')') break;
                }
                char[] arg = emptyCharArray;
                int arglen = argend - argstart + 1;
                if (arglen > 0) {
                    arg = new char[arglen];
                    System.arraycopy(buffer, argstart, arg, 0, arglen);
                }
                exp.definitions.put(arglist[currarg], arg);
                if (c == ')') break;
            }
            if ((expText = macro.getExpansion()).length > 0) {
                this.pushContext(expText, exp);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private void skipOverMacroArg() {
            block14: {
                int n;
                int limit;
                char[] buffer;
                block13: {
                    buffer = this.bufferStack[this.bufferStackPos];
                    limit = this.bufferLimit[this.bufferStackPos];
                    if (!true) break block13;
                    n = this.bufferStackPos;
                    if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block14;
                }
                do {
                    block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                        case '\t': 
                        case '\r': 
                        case ' ': 
                        case ')': 
                        case ',': {
                            int n2 = this.bufferStackPos;
                            this.bufferPos[n2] = this.bufferPos[n2] - 1;
                            return;
                        }
                        case '\n': {
                            ++this.lineNumber;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] - 1;
                            return;
                        }
                        case '\\': {
                            int p = this.bufferPos[this.bufferStackPos];
                            if (p + 1 >= limit || buffer[p + 1] != '\n') break;
                            ++this.lineNumber;
                            int n4 = this.bufferStackPos;
                            this.bufferPos[n4] = this.bufferPos[n4] - 1;
                            return;
                        }
                        case '\"': {
                            boolean escaped = false;
                            while (true) {
                                int n5 = this.bufferStackPos;
                                this.bufferPos[n5] = this.bufferPos[n5] + 1;
                                if (this.bufferPos[n5] >= this.bufferLimit[this.bufferStackPos]) break block0;
                                switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                    case '\\': {
                                        escaped = !escaped;
                                        break;
                                    }
                                    case '\"': {
                                        if (!escaped) break block0;
                                        escaped = false;
                                        break;
                                    }
                                    default: {
                                        escaped = false;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    n = this.bufferStackPos;
                } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
            }
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] - 1;
        }

        /*
         * Unable to fully structure code
         */
        private void skipWhiteSpace() {
            buffer = this.bufferStack[this.bufferStackPos];
            limit = this.bufferLimit[this.bufferStackPos];
            if (true) ** GOTO lbl53
            do {
                p = this.bufferPos[this.bufferStackPos];
                block0 : switch (buffer[p]) {
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '/': {
                        if (p + 1 >= limit) ** GOTO lbl49
                        if (buffer[p + 1] == '/') {
                            v0 = this.bufferStackPos;
                            this.bufferPos[v0] = this.bufferPos[v0] + 2;
                            while (this.bufferPos[this.bufferStackPos] < limit) {
                                p = this.bufferPos[this.bufferStackPos];
                                if (buffer[p] == '\\' && p + 1 < limit && buffer[p + 1] == '\n') {
                                    v1 = this.bufferStackPos;
                                    this.bufferPos[v1] = this.bufferPos[v1] + 2;
                                } else if (buffer[p] == '\\' && p + 1 < limit && buffer[p + 1] == '\r' && p + 2 < limit && buffer[p + 2] == '\n') {
                                    v2 = this.bufferStackPos;
                                    this.bufferPos[v2] = this.bufferPos[v2] + 3;
                                } else if (buffer[p] == '\n') break block0;
                                v3 = this.bufferStackPos;
                                this.bufferPos[v3] = this.bufferPos[v3] + 1;
                            }
                            break;
                        }
                        if (buffer[p + 1] == '*') {
                            v4 = this.bufferStackPos;
                            this.bufferPos[v4] = this.bufferPos[v4] + 2;
                            while (this.bufferPos[this.bufferStackPos] < limit) {
                                p = this.bufferPos[this.bufferStackPos];
                                if (buffer[p] == '*' && p + 1 < limit && buffer[p + 1] == '/') {
                                    v5 = this.bufferStackPos;
                                    this.bufferPos[v5] = this.bufferPos[v5] + 1;
                                    break block0;
                                }
                                v6 = this.bufferStackPos;
                                this.bufferPos[v6] = this.bufferPos[v6] + 1;
                            }
                            break;
                        }
                        ** GOTO lbl49
                    }
                    case '\\': {
                        if (p + 1 < limit && buffer[p + 1] == '\n') {
                            ++this.lineNumber;
                            v7 = this.bufferStackPos;
                            this.bufferPos[v7] = this.bufferPos[v7] + 1;
                            break;
                        }
                    }
lbl49:
                    // 5 sources

                    default: {
                        v8 = this.bufferStackPos;
                        this.bufferPos[v8] = this.bufferPos[v8] - 1;
                        return;
                    }
                }
lbl53:
                // 7 sources

                v9 = this.bufferStackPos;
            } while ((this.bufferPos[v9] = this.bufferPos[v9] + 1) < limit);
            v10 = this.bufferStackPos;
            this.bufferPos[v10] = this.bufferPos[v10] - 1;
        }

        private void pushContext(char[] buffer, Object data) {
            if (++this.bufferStackPos == this.bufferStack.length) {
                int size = this.bufferStack.length * 2;
                char[][] oldBufferStack = this.bufferStack;
                this.bufferStack = new char[size][];
                System.arraycopy(oldBufferStack, 0, this.bufferStack, 0, oldBufferStack.length);
                Object[] oldBufferData = this.bufferData;
                this.bufferData = new Object[size];
                System.arraycopy(oldBufferData, 0, this.bufferData, 0, oldBufferData.length);
                int[] oldBufferPos = this.bufferPos;
                this.bufferPos = new int[size];
                System.arraycopy(oldBufferPos, 0, this.bufferPos, 0, oldBufferPos.length);
                int[] oldBufferLimit = this.bufferLimit;
                this.bufferLimit = new int[size];
                System.arraycopy(oldBufferLimit, 0, this.bufferLimit, 0, oldBufferLimit.length);
            }
            this.bufferStack[this.bufferStackPos] = buffer;
            this.bufferPos[this.bufferStackPos] = -1;
            this.bufferLimit[this.bufferStackPos] = buffer.length;
            this.bufferData[this.bufferStackPos] = data;
        }

        private void popContext() {
            this.bufferStack[this.bufferStackPos] = null;
            this.bufferData[this.bufferStackPos] = null;
            --this.bufferStackPos;
        }

        private void handleProblem(int id, int startOffset) {
            if (this.callbackManager != null && this.problemFactory != null) {
                this.callbackManager.pushCallback(this.problemFactory.createProblem(id, startOffset, this.bufferPos[this.bufferStackPos == -1 ? 0 : this.bufferStackPos], this.lineNumber, this.fileName == null ? BaseScanner.EMPTY_STRING.toCharArray() : this.fileName, emptyCharArray, false, true));
            }
        }

        private boolean isValidTokenSeparator(char c, char c2) throws EvalException {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '^': 
                case '|': 
                case '~': {
                    return true;
                }
                case '=': {
                    return c2 == '=';
                }
            }
            return false;
        }

        private static class EvalException
        extends Exception {
            private static final long serialVersionUID = 0L;

            public EvalException(String msg) {
                super(msg);
            }
        }
    }
}

