/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractBuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class BuildOptionSettingsPage
extends BuildSettingsPage {
    private Map fieldsMap = new HashMap();
    private IOptionCategory clonedCategory;
    private IHoldsOptions optionHolder;
    private boolean isItResourceConfigPage;
    private Map fieldEditorsToParentMap = new HashMap();
    private AbstractBuildPropertyPage buildPropPage;

    public BuildOptionSettingsPage(AbstractBuildPropertyPage page, IConfiguration clonedConfig, IHoldsOptions optionHolder, IOptionCategory clonedCategory) {
        super(clonedConfig);
        this.clonedCategory = clonedCategory;
        this.optionHolder = optionHolder;
        this.isItResourceConfigPage = false;
        this.buildPropPage = page;
    }

    public BuildOptionSettingsPage(AbstractBuildPropertyPage page, IResourceConfiguration clonedResConfig, IHoldsOptions optionHolder, IOptionCategory clonedCategory) {
        super(clonedResConfig);
        this.clonedCategory = clonedCategory;
        this.optionHolder = optionHolder;
        this.isItResourceConfigPage = true;
        this.buildPropPage = page;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Object[][] options = this.isItResourceConfigPage ? this.clonedCategory.getOptions(this.clonedResConfig, this.optionHolder) : this.clonedCategory.getOptions(this.clonedConfig, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPreferenceStore().getOptionPrefName(opt);
            IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
            Object config = this.isItResourceConfigPage ? this.clonedResConfig : this.clonedConfig;
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) {
                try {
                    class TooltipBooleanFieldEditor
                    extends BooleanFieldEditor {
                        final /* synthetic */ BuildOptionSettingsPage this$0;

                        public TooltipBooleanFieldEditor(BuildOptionSettingsPage buildOptionSettingsPage, String name, String labelText, String tooltip, Composite parent) {
                            super(name, labelText, parent);
                            this.this$0 = buildOptionSettingsPage;
                            this.getChangeControl(parent).setToolTipText(tooltip);
                        }
                    }
                    Object fieldEditor;
                    Composite fieldEditorParent = this.getFieldEditorParent();
                    switch (opt.getValueType()) {
                        case 2: {
                            DirectoryFieldEditor stringField;
                            switch (opt.getBrowseType()) {
                                case 2: {
                                    stringField = new DirectoryFieldEditor(prefName, opt.getName(), fieldEditorParent);
                                    break;
                                }
                                case 1: {
                                    stringField = new FileFieldEditor(prefName, opt.getName(), fieldEditorParent);
                                    break;
                                }
                                case 0: {
                                    stringField = new StringFieldEditor(prefName, opt.getName(), fieldEditorParent);
                                    break;
                                }
                                default: {
                                    throw new BuildException(null);
                                }
                            }
                            stringField.getTextControl(fieldEditorParent).setToolTipText(opt.getToolTip());
                            stringField.getLabelControl(fieldEditorParent).setToolTipText(opt.getToolTip());
                            fieldEditor = stringField;
                            break;
                        }
                        case 0: {
                            fieldEditor = new TooltipBooleanFieldEditor(this, prefName, opt.getName(), opt.getToolTip(), fieldEditorParent);
                            break;
                        }
                        case 1: {
                            String selId = opt.getSelectedEnum();
                            String sel = opt.getEnumName(selId);
                            String[] enumNames = opt.getApplicableValues();
                            Vector<String> enumValidList = new Vector<String>();
                            int i = 0;
                            while (i < enumNames.length) {
                                if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                                    enumValidList.add(enumNames[i]);
                                }
                                ++i;
                            }
                            Object[] enumValidNames = new String[enumValidList.size()];
                            enumValidList.copyInto(enumValidNames);
                            fieldEditor = new BuildOptionComboFieldEditor(prefName, opt.getName(), opt.getToolTip(), (String[])enumValidNames, sel, fieldEditorParent);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            fieldEditor = new FileListControlFieldEditor(prefName, opt.getName(), opt.getToolTip(), fieldEditorParent, opt.getBrowseType());
                            break;
                        }
                        default: {
                            throw new BuildException(null);
                        }
                    }
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)fieldEditor, fieldEditorParent);
                    this.addField((FieldEditor)fieldEditor);
                    this.fieldsMap.put(prefName, fieldEditor);
                    this.fieldEditorsToParentMap.put(fieldEditor, fieldEditorParent);
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
    }

    public boolean isForCategory(IHoldsOptions optionHolder, IOptionCategory category) {
        return category != null && this.optionHolder == optionHolder && category.equals(this.clonedCategory);
    }

    public boolean performOk() {
        Object[][] clonedOptions;
        boolean ok = super.performOk();
        IResourceConfiguration realRcCfg = null;
        IConfiguration realCfg = null;
        if (this.isItResourceConfigPage) {
            realRcCfg = this.buildPropPage.getRealRcConfig(this.clonedResConfig);
            if (realRcCfg == null) {
                return false;
            }
            clonedOptions = this.clonedCategory.getOptions(this.clonedResConfig, this.optionHolder);
        } else {
            realCfg = this.buildPropPage.getRealConfig(this.clonedConfig);
            if (realCfg == null) {
                return false;
            }
            clonedOptions = this.clonedCategory.getOptions(this.clonedConfig, this.optionHolder);
        }
        int i = 0;
        while (i < clonedOptions.length) {
            IOption realOption;
            IHoldsOptions clonedHolder = (IHoldsOptions)clonedOptions[i][0];
            if (clonedHolder == null) break;
            IOption clonedOption = (IOption)clonedOptions[i][1];
            IHoldsOptions realHolder = this.buildPropPage.getRealHoldsOptions(clonedHolder);
            if (realHolder != null && (realOption = this.buildPropPage.getRealOption(clonedOption, clonedHolder)) != null) {
                try {
                    IOption setOption = null;
                    switch (clonedOption.getValueType()) {
                        case 0: {
                            boolean boolVal = clonedOption.getBooleanValue();
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                            break;
                        }
                        case 1: {
                            String enumVal = clonedOption.getStringValue();
                            String enumId = clonedOption.getEnumeratedId(enumVal);
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                            break;
                        }
                        case 2: {
                            String strVal = clonedOption.getStringValue();
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            String[] listVal = ((List)clonedOption.getValue()).toArray(new String[0]);
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                            break;
                        }
                    }
                    if (setOption == null) {
                        setOption = realOption;
                    }
                }
                catch (BuildException buildException) {
                }
                catch (ClassCastException classCastException) {}
            }
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        Object[][] options = this.isItResourceConfigPage ? this.clonedCategory.getOptions(this.clonedResConfig, this.optionHolder) : this.clonedCategory.getOptions(this.clonedConfig, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IOptionApplicability applicabilityCalculator;
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPreferenceStore().getOptionPrefName(opt);
            if (this.fieldsMap.containsKey(prefName) && (applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(prefName);
                Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
            }
            ++index;
        }
        Collection fieldsList = this.fieldsMap.values();
        Iterator iter = fieldsList.iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            editor.load();
        }
    }

    public void storeSettings() {
    }

    private void setFieldEditorEnablement(IHoldsOptions holder, IOption option, IOptionApplicability optionApplicability, FieldEditor fieldEditor, Composite parent) {
        if (optionApplicability == null) {
            return;
        }
        Object config = this.isItResourceConfigPage ? this.clonedResConfig : this.clonedConfig;
        if (!optionApplicability.isOptionEnabled((IBuildObject)config, holder, option)) {
            fieldEditor.setEnabled(false, parent);
        } else {
            fieldEditor.setEnabled(true, parent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        IOption changedOption = null;
        IHoldsOptions changedHolder = null;
        String id = null;
        if (source instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)source;
            id = fe.getPreferenceName();
            Object[] option = this.getToolSettingsPreferenceStore().getOption(id);
            if (option != null) {
                changedOption = (IOption)option[1];
                changedHolder = (IHoldsOptions)option[0];
                try {
                    switch (changedOption.getValueType()) {
                        case 2: {
                            if (fe instanceof StringFieldEditor) {
                                String val = ((StringFieldEditor)fe).getStringValue();
                                if (this.isItResourceConfigPage) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)this.clonedResConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)val);
                                    break;
                                }
                                ManagedBuildManager.setOption((IConfiguration)this.clonedConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)val);
                            }
                            break;
                        }
                        case 0: {
                            if (fe instanceof BooleanFieldEditor) {
                                boolean val = ((BooleanFieldEditor)fe).getBooleanValue();
                                if (this.isItResourceConfigPage) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)this.clonedResConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (boolean)val);
                                    break;
                                }
                                ManagedBuildManager.setOption((IConfiguration)this.clonedConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (boolean)val);
                            }
                            break;
                        }
                        case 1: {
                            if (fe instanceof BuildOptionComboFieldEditor) {
                                String name = ((BuildOptionComboFieldEditor)fe).getSelection();
                                String enumId = changedOption.getEnumeratedId(name);
                                if (this.isItResourceConfigPage) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)this.clonedResConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)(enumId != null && enumId.length() > 0 ? enumId : name));
                                    break;
                                }
                                ManagedBuildManager.setOption((IConfiguration)this.clonedConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)(enumId != null && enumId.length() > 0 ? enumId : name));
                            }
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (fe instanceof FileListControlFieldEditor) {
                                String[] val = ((FileListControlFieldEditor)fe).getStringListValue();
                                if (this.isItResourceConfigPage) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)this.clonedResConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (String[])val);
                                    break;
                                }
                                ManagedBuildManager.setOption((IConfiguration)this.clonedConfig, (IHoldsOptions)changedHolder, (IOption)changedOption, (String[])val);
                            }
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        Object[][] options = this.isItResourceConfigPage ? this.clonedCategory.getOptions(this.clonedResConfig, this.optionHolder) : this.clonedCategory.getOptions(this.clonedConfig, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IOptionApplicability applicabilityCalculator;
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPreferenceStore().getOptionPrefName(opt);
            if (this.fieldsMap.containsKey(prefName) && (applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(prefName);
                Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
            }
            ++index;
        }
        Iterator iter = this.fieldsMap.values().iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            if (id != null && id.equals(editor.getPreferenceName())) continue;
            editor.load();
        }
    }
}

