/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class PDOMSearchPatternQuery
extends PDOMSearchQuery {
    public static final int FIND_CLASS_STRUCT = 16;
    public static final int FIND_FUNCTION = 32;
    public static final int FIND_VARIABLE = 64;
    public static final int FIND_UNION = 256;
    public static final int FIND_METHOD = 512;
    public static final int FIND_FIELD = 1024;
    public static final int FIND_ENUM = 4096;
    public static final int FIND_ENUMERATOR = 8192;
    public static final int FIND_NAMESPACE = 16384;
    public static final int FIND_TYPEDEF = 65536;
    public static final int FIND_MACRO = 131072;
    public static final int FIND_ALL_TYPES = 227184;
    private String scopeDesc;
    private String patternStr;
    private Pattern pattern;

    public PDOMSearchPatternQuery(ICElement[] scope, String scopeDesc, Pattern pattern, String patternStr, boolean isCaseSensitive, int flags) {
        super(scope, flags);
        this.scopeDesc = scopeDesc;
        this.pattern = pattern;
        this.patternStr = patternStr;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            int i = 0;
            while (i < this.projects.length) {
                this.searchProject(this.projects[i], monitor);
                ++i;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchProject(ICProject project, IProgressMonitor monitor) throws CoreException {
        IPDOM pdom = CCorePlugin.getPDOMManager().getPDOM(project);
        try {
            pdom.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            IBinding[] bindings = pdom.findBindings(this.pattern);
            int i = 0;
            while (i < bindings.length) {
                PDOMBinding pdomBinding = (PDOMBinding)bindings[i];
                this.createMatches(pdomBinding.getLinkage().getLanguage(), (IBinding)pdomBinding);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            pdom.releaseReadLock();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        pdom.releaseReadLock();
    }

    public String getLabel() {
        return String.valueOf(super.getLabel()) + " " + this.patternStr + " in " + this.scopeDesc;
    }
}

