/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.opentype;

import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeDialog;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        Object[] elements = AllTypesCache.getAllTypes();
        if (elements.length == 0) {
            String title = OpenTypeMessages.getString("OpenTypeAction.notypes.title");
            String message = OpenTypeMessages.getString("OpenTypeAction.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        OpenTypeDialog dialog = new OpenTypeDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        ITypeReference location = info.getResolvedReference();
        if (location == null) {
            String title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            String message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorTypeNotFound", info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else if (!this.openTypeInEditor(location)) {
            String title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            String message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorOpenEditor", location.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected Shell getShell() {
        return CUIPlugin.getActiveWorkbenchShell();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openTypeInEditor(ITypeReference location) {
        ITranslationUnit unit = location.getTranslationUnit();
        IEditorPart editorPart = null;
        try {
            IPath path;
            if (unit != null) {
                editorPart = EditorUtility.openInEditor(unit);
            }
            if (editorPart == null && (path = location.getLocation()) != null) {
                FileStorage storage = new FileStorage(path);
                editorPart = EditorUtility.openInEditor(storage);
            }
            if (editorPart == null) return false;
            if (!(editorPart instanceof ITextEditor)) return false;
            ITextEditor editor = (ITextEditor)editorPart;
            if (!location.isLineNumber()) {
                editor.selectAndReveal(location.getOffset(), location.getLength());
                return true;
            }
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int startOffset = document.getLineOffset(location.getOffset() - 1);
                int length = document.getLineLength(location.getOffset() - 1);
                editor.selectAndReveal(startOffset, length);
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        catch (CModelException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

