/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildIOType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class BuildResource
implements IBuildResource {
    private List fDepArgs = new ArrayList();
    private BuildIOType fProducerArg;
    private boolean fNeedsRebuild;
    private boolean fIsRemoved;
    private IPath fLocation;
    private IPath fFullPath;
    private boolean fIsProjectRc;
    private BuildDescription fInfo;

    protected BuildResource(BuildDescription info, IResource rc) {
        this(info, info.calcResourceLocation(rc), rc.getFullPath());
    }

    protected BuildResource(BuildDescription info, IPath location, IPath fullPath) {
        this.fLocation = location;
        this.fInfo = info;
        this.fFullPath = fullPath;
        if (this.fFullPath != null) {
            this.fIsProjectRc = this.fFullPath.segment(0).equals(info.getProject().getName());
        }
        info.resourceCreated(this);
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("resource " + location + " created");
        }
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    public IPath getFullPath() {
        return this.fFullPath;
    }

    public IBuildIOType getProducerIOType() {
        return this.fProducerArg;
    }

    public IBuildIOType[] getDependentIOTypes() {
        return this.fDepArgs.toArray(new BuildIOType[this.fDepArgs.size()]);
    }

    public boolean needsRebuild() {
        return this.fNeedsRebuild;
    }

    public boolean isRemoved() {
        return this.fIsRemoved;
    }

    public void setRemoved(boolean removed) {
        if (DbgUtil.DEBUG && removed) {
            DbgUtil.trace("REMOVED state: resource " + DbgUtil.resourceName(this));
        }
        this.fIsRemoved = removed;
        if (this.fIsRemoved) {
            this.fNeedsRebuild = false;
        }
    }

    public void setRebuildState(boolean rebuild) {
        this.fNeedsRebuild = rebuild;
    }

    protected void addToArg(BuildIOType arg) {
        if (arg.isInput()) {
            this.fDepArgs.add(arg);
        } else if (this.fProducerArg == null) {
            this.fProducerArg = arg;
        } else {
            String err = "ProducerArgument not null!!!\n";
            if (DbgUtil.DEBUG) {
                err = String.valueOf(err) + "curent producer: " + DbgUtil.dumpStep(this.fProducerArg.getStep()) + "\n producer attempt: " + DbgUtil.dumpStep(arg.getStep());
            }
            throw new IllegalArgumentException(err);
        }
    }

    void removeFromArg(BuildIOType arg) {
        if (arg.isInput()) {
            this.fDepArgs.remove(arg);
        } else if (this.fProducerArg == arg) {
            this.fProducerArg = null;
        } else {
            throw new IllegalArgumentException("Resource is not produced by this arg!!!");
        }
    }

    public boolean isProjectResource() {
        return this.fIsProjectRc;
    }

    BuildIOType[][] clear() {
        BuildIOType[][] types = new BuildIOType[2][];
        types[0] = new BuildIOType[1];
        types[0][0] = this.fProducerArg;
        BuildIOType[] outs = (BuildIOType[])this.getDependentIOTypes();
        types[1] = outs;
        if (this.fProducerArg != null) {
            this.fProducerArg.removeResource(this);
        }
        int i = 0;
        while (i < outs.length) {
            outs[i].removeResource(this);
            ++i;
        }
        return types;
    }

    BuildIOType[][] remove() {
        BuildIOType[][] types = this.clear();
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("resource " + DbgUtil.resourceName(this) + " removed");
        }
        this.fInfo.resourceRemoved(this);
        this.fInfo = null;
        return types;
    }

    public IBuildDescription getBuildDescription() {
        return this.fInfo;
    }

    public IBuildStep[] getDependentSteps() {
        HashSet<IBuildStep> set = new HashSet<IBuildStep>();
        Iterator iter = this.fDepArgs.iterator();
        while (iter.hasNext()) {
            set.add(((BuildIOType)iter.next()).getStep());
        }
        return set.toArray(new BuildStep[set.size()]);
    }

    public IBuildStep getProducerStep() {
        if (this.fProducerArg != null) {
            return this.fProducerArg.getStep();
        }
        return null;
    }
}

